/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jsse.provider;

import java.io.IOException;
import java.math.BigInteger;
import java.security.Principal;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.jsse.BCSNIMatcher;
import org.bouncycastle.jsse.BCSNIServerName;
import org.bouncycastle.jsse.BCX509Key;
import org.bouncycastle.jsse.provider.ContextData;
import org.bouncycastle.jsse.provider.DummyX509KeyManager;
import org.bouncycastle.jsse.provider.JsseSecurityParameters;
import org.bouncycastle.jsse.provider.JsseSessionParameters;
import org.bouncycastle.jsse.provider.JsseUtils;
import org.bouncycastle.jsse.provider.NamedGroupInfo;
import org.bouncycastle.jsse.provider.PropertyUtils;
import org.bouncycastle.jsse.provider.ProvSSLConnection;
import org.bouncycastle.jsse.provider.ProvSSLContextSpi;
import org.bouncycastle.jsse.provider.ProvSSLParameters;
import org.bouncycastle.jsse.provider.ProvSSLSession;
import org.bouncycastle.jsse.provider.ProvSSLSessionContext;
import org.bouncycastle.jsse.provider.ProvTlsManager;
import org.bouncycastle.jsse.provider.ProvTlsPeer;
import org.bouncycastle.jsse.provider.SignatureSchemeInfo;
import org.bouncycastle.tls.Certificate;
import org.bouncycastle.tls.CertificateRequest;
import org.bouncycastle.tls.CertificateStatus;
import org.bouncycastle.tls.DefaultTlsServer;
import org.bouncycastle.tls.KeyExchangeAlgorithm;
import org.bouncycastle.tls.NamedGroup;
import org.bouncycastle.tls.ProtocolName;
import org.bouncycastle.tls.ProtocolVersion;
import org.bouncycastle.tls.SecurityParameters;
import org.bouncycastle.tls.SessionParameters;
import org.bouncycastle.tls.SignatureAndHashAlgorithm;
import org.bouncycastle.tls.TlsContext;
import org.bouncycastle.tls.TlsCredentials;
import org.bouncycastle.tls.TlsDHUtils;
import org.bouncycastle.tls.TlsExtensionsUtils;
import org.bouncycastle.tls.TlsFatalAlert;
import org.bouncycastle.tls.TlsSession;
import org.bouncycastle.tls.TlsUtils;
import org.bouncycastle.tls.crypto.DHGroup;
import org.bouncycastle.tls.crypto.TlsDHConfig;
import org.bouncycastle.tls.crypto.impl.jcajce.JcaTlsCrypto;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.encoders.Hex;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
class ProvTlsServer
extends DefaultTlsServer
implements ProvTlsPeer {
    private static final Logger LOG = Logger.getLogger(ProvTlsServer.class.getName());
    private static final String PROPERTY_DEFAULT_DHE_PARAMETERS = "jdk.tls.server.defaultDHEParameters";
    private static final int provEphemeralDHKeySize = PropertyUtils.getIntegerSystemProperty("jdk.tls.ephemeralDHKeySize", 2048, 1024, 8192);
    private static final DHGroup[] provServerDefaultDHEParameters = ProvTlsServer.getDefaultDHEParameters();
    private static final boolean provServerEnableCA = PropertyUtils.getBooleanSystemProperty("jdk.tls.server.enableCAExtension", true);
    private static final boolean provServerEnableSessionResumption = PropertyUtils.getBooleanSystemProperty("org.bouncycastle.jsse.server.enableSessionResumption", true);
    private static final boolean provServerEnableStatusRequest = false;
    private static final boolean provServerEnableTrustedCAKeys = PropertyUtils.getBooleanSystemProperty("org.bouncycastle.jsse.server.enableTrustedCAKeysExtension", false);
    private static final boolean provServerOmitSigAlgsCert = PropertyUtils.getBooleanSystemProperty("org.bouncycastle.jsse.server.omitSigAlgsCertExtension", true);
    protected final String serverID;
    protected final ProvTlsManager manager;
    protected final ProvSSLParameters sslParameters;
    protected final JsseSecurityParameters jsseSecurityParameters = new JsseSecurityParameters();
    protected ProvSSLSession sslSession = null;
    protected BCSNIServerName matchedSNIServerName = null;
    protected Set<String> keyManagerMissCache = null;
    protected TlsCredentials credentials = null;
    protected boolean handshakeComplete = false;

    private static DHGroup[] getDefaultDHEParameters() {
        int generator;
        int closeBrace;
        int modulus;
        int innerComma;
        int openBrace;
        String propertyValue = PropertyUtils.getStringSecurityProperty(PROPERTY_DEFAULT_DHE_PARAMETERS);
        if (null == propertyValue) {
            return null;
        }
        String input = JsseUtils.stripDoubleQuotes(JsseUtils.removeAllWhitespace(propertyValue));
        int limit = input.length();
        if (limit < 1) {
            return null;
        }
        ArrayList<DHGroup> dhGroups = new ArrayList<DHGroup>();
        int outerComma = -1;
        while ((openBrace = outerComma + 1) < limit && '{' == input.charAt(openBrace) && (innerComma = input.indexOf(44, modulus = openBrace + 1)) > modulus && (closeBrace = input.indexOf(125, generator = innerComma + 1)) > generator) {
            try {
                BigInteger p = ProvTlsServer.parseDHParameter(input, modulus, innerComma);
                BigInteger g = ProvTlsServer.parseDHParameter(input, generator, closeBrace);
                DHGroup dhGroup = TlsDHUtils.getStandardGroupForDHParameters(p, g);
                if (null != dhGroup) {
                    dhGroups.add(dhGroup);
                } else if (!p.isProbablePrime(120)) {
                    LOG.log(Level.WARNING, "Non-prime modulus ignored in security property [jdk.tls.server.defaultDHEParameters]: " + p.toString(16));
                } else {
                    dhGroups.add(new DHGroup(p, null, g, 0));
                }
            }
            catch (Exception e) {
                break;
            }
            outerComma = closeBrace + 1;
            if (outerComma >= limit) {
                DHGroup[] result = dhGroups.toArray(new DHGroup[dhGroups.size()]);
                java.util.Arrays.sort(result, new Comparator<DHGroup>(){

                    @Override
                    public int compare(DHGroup a, DHGroup b) {
                        return a.getP().bitLength() - b.getP().bitLength();
                    }
                });
                return result;
            }
            if (',' == input.charAt(outerComma)) continue;
        }
        LOG.log(Level.WARNING, "Invalid syntax for security property [jdk.tls.server.defaultDHEParameters]");
        return null;
    }

    private static BigInteger parseDHParameter(String s, int beginIndex, int endIndex) {
        return new BigInteger(s.substring(beginIndex, endIndex), 16);
    }

    ProvTlsServer(ProvTlsManager manager, ProvSSLParameters sslParameters) {
        super(manager.getContextData().getCrypto());
        this.serverID = JsseUtils.getPeerID("server", manager);
        this.manager = manager;
        this.sslParameters = sslParameters.copyForConnection();
    }

    @Override
    public String getID() {
        return this.serverID;
    }

    @Override
    public ProvSSLSession getSession() {
        return this.sslSession;
    }

    @Override
    public TlsContext getTlsContext() {
        return this.context;
    }

    @Override
    protected boolean allowCertificateStatus() {
        return false;
    }

    @Override
    protected boolean allowMultiCertStatus() {
        return false;
    }

    @Override
    protected boolean allowTrustedCAIndication() {
        return null != this.jsseSecurityParameters.trustedIssuers;
    }

    @Override
    protected String getDetailMessageNoCipherSuite() {
        StringBuilder sb = new StringBuilder(this.serverID);
        int[] offered = this.offeredCipherSuites;
        if (TlsUtils.isNullOrEmpty(offered)) {
            sb.append(" found no selectable cipher suite because none were offered.");
        } else {
            sb.append(" found no selectable cipher suite among the ");
            sb.append(offered.length);
            sb.append(" offered: ");
            ProvSSLContextSpi context = this.manager.getContextData().getContext();
            sb.append('[');
            JsseUtils.appendCipherSuiteDetail(sb, context, offered[0]);
            for (int i = 1; i < offered.length; ++i) {
                sb.append(", ");
                JsseUtils.appendCipherSuiteDetail(sb, context, offered[i]);
            }
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    protected int getMaximumNegotiableCurveBits() {
        NamedGroupInfo.DefaultedResult maxBitsResult = NamedGroupInfo.getMaximumBitsServerECDH(this.jsseSecurityParameters.namedGroups);
        int maxBits = maxBitsResult.getResult();
        return maxBits;
    }

    @Override
    protected int getMaximumNegotiableFiniteFieldBits() {
        NamedGroupInfo.DefaultedResult maxBitsResult = NamedGroupInfo.getMaximumBitsServerFFDHE(this.jsseSecurityParameters.namedGroups);
        int maxBits = maxBitsResult.getResult();
        if (maxBitsResult.isDefaulted() && !TlsUtils.isNullOrEmpty(provServerDefaultDHEParameters) && !this.manager.getContextData().getContext().isFips()) {
            DHGroup largest = provServerDefaultDHEParameters[provServerDefaultDHEParameters.length - 1];
            maxBits = Math.max(maxBits, largest.getP().bitLength());
        }
        return maxBits >= provEphemeralDHKeySize ? maxBits : 0;
    }

    @Override
    protected Vector<ProtocolName> getProtocolNames() {
        return JsseUtils.getProtocolNames(this.sslParameters.getApplicationProtocols());
    }

    @Override
    protected int[] getSupportedCipherSuites() {
        return this.manager.getContextData().getContext().getActiveCipherSuites(this.getCrypto(), this.sslParameters, this.getProtocolVersions());
    }

    @Override
    protected ProtocolVersion[] getSupportedVersions() {
        return this.manager.getContextData().getContext().getActiveProtocolVersions(this.sslParameters);
    }

    @Override
    protected boolean preferLocalCipherSuites() {
        return this.sslParameters.getUseCipherSuitesOrder();
    }

    @Override
    protected boolean selectCipherSuite(int cipherSuite) throws IOException {
        TlsCredentials cipherSuiteCredentials = null;
        int keyExchangeAlgorithm = TlsUtils.getKeyExchangeAlgorithm(cipherSuite);
        if (!KeyExchangeAlgorithm.isAnonymous(keyExchangeAlgorithm) && null == (cipherSuiteCredentials = this.selectCredentials(this.jsseSecurityParameters.trustedIssuers, keyExchangeAlgorithm))) {
            String cipherSuiteName = ProvSSLContextSpi.getCipherSuiteName(cipherSuite);
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(this.serverID + " found no credentials for cipher suite: " + cipherSuiteName);
            }
            return false;
        }
        boolean result = super.selectCipherSuite(cipherSuite);
        if (result) {
            this.credentials = cipherSuiteCredentials;
        }
        return result;
    }

    @Override
    public TlsDHConfig getDHConfig() throws IOException {
        int minimumFiniteFieldBits = TlsDHUtils.getMinimumFiniteFieldBits(this.selectedCipherSuite);
        minimumFiniteFieldBits = Math.max(minimumFiniteFieldBits, provEphemeralDHKeySize);
        NamedGroupInfo.DefaultedResult namedGroupResult = NamedGroupInfo.selectServerFFDHE(this.jsseSecurityParameters.namedGroups, minimumFiniteFieldBits);
        int namedGroup = namedGroupResult.getResult();
        if (namedGroupResult.isDefaulted() && !TlsUtils.isNullOrEmpty(provServerDefaultDHEParameters) && !this.manager.getContextData().getContext().isFips()) {
            for (DHGroup dhGroup : provServerDefaultDHEParameters) {
                int bits = dhGroup.getP().bitLength();
                if (bits < minimumFiniteFieldBits) continue;
                if (namedGroup >= 0 && bits > NamedGroup.getFiniteFieldBits(namedGroup)) break;
                return new TlsDHConfig(dhGroup);
            }
        }
        return TlsDHUtils.createNamedDHConfig(this.context, namedGroup);
    }

    @Override
    protected int selectDH(int minimumFiniteFieldBits) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected int selectDHDefault(int minimumFiniteFieldBits) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected int selectECDH(int minimumCurveBits) {
        return NamedGroupInfo.selectServerECDH(this.jsseSecurityParameters.namedGroups, minimumCurveBits).getResult();
    }

    @Override
    protected int selectECDHDefault(int minimumCurveBits) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected ProtocolName selectProtocolName() throws IOException {
        if (null == this.sslParameters.getEngineAPSelector() && null == this.sslParameters.getSocketAPSelector()) {
            return super.selectProtocolName();
        }
        Vector applicationProtocols = this.clientProtocolNames;
        List<String> protocols = JsseUtils.getProtocolNames(applicationProtocols);
        String protocol = this.manager.selectApplicationProtocol(Collections.unmodifiableList(protocols));
        if (null == protocol) {
            throw new TlsFatalAlert(120);
        }
        if (protocol.length() < 1) {
            return null;
        }
        if (!protocols.contains(protocol)) {
            throw new TlsFatalAlert(120);
        }
        return ProtocolName.asUtf8Encoding(protocol);
    }

    @Override
    protected boolean shouldSelectProtocolNameEarly() {
        return null == this.sslParameters.getEngineAPSelector() && null == this.sslParameters.getSocketAPSelector();
    }

    @Override
    public boolean allowLegacyResumption() {
        return JsseUtils.allowLegacyResumption();
    }

    @Override
    public int getMaxCertificateChainLength() {
        return JsseUtils.getMaxCertificateChainLength();
    }

    @Override
    public int getMaxHandshakeMessageSize() {
        return JsseUtils.getMaxHandshakeMessageSize();
    }

    @Override
    public synchronized boolean isHandshakeComplete() {
        return this.handshakeComplete;
    }

    @Override
    public TlsCredentials getCredentials() throws IOException {
        if (this.credentials == null) {
            throw new TlsFatalAlert(80);
        }
        return this.credentials;
    }

    @Override
    public CertificateRequest getCertificateRequest() throws IOException {
        if (!this.isClientAuthEnabled()) {
            return null;
        }
        ContextData contextData = this.manager.getContextData();
        ProtocolVersion negotiatedVersion = this.context.getServerVersion();
        Vector<SignatureAndHashAlgorithm> serverSigAlgs = this.jsseSecurityParameters.signatureSchemes.getLocalSignatureAndHashAlgorithms();
        Vector<X500Name> certificateAuthorities = null;
        if (provServerEnableCA) {
            certificateAuthorities = JsseUtils.getCertificateAuthorities(contextData.getX509TrustManager());
        }
        if (TlsUtils.isTLSv13(negotiatedVersion)) {
            byte[] certificateRequestContext = TlsUtils.EMPTY_BYTES;
            Vector<SignatureAndHashAlgorithm> serverSigAlgsCert = this.jsseSecurityParameters.signatureSchemes.getLocalSignatureAndHashAlgorithmsCert();
            if (serverSigAlgsCert == null && !provServerOmitSigAlgsCert) {
                serverSigAlgsCert = this.jsseSecurityParameters.signatureSchemes.getLocalSignatureAndHashAlgorithms();
            }
            return new CertificateRequest(certificateRequestContext, serverSigAlgs, serverSigAlgsCert, certificateAuthorities);
        }
        short[] certificateTypes = new short[]{64, 1, 2};
        return new CertificateRequest(certificateTypes, serverSigAlgs, certificateAuthorities);
    }

    @Override
    public CertificateStatus getCertificateStatus() throws IOException {
        return null;
    }

    @Override
    public JcaTlsCrypto getCrypto() {
        return this.manager.getContextData().getCrypto();
    }

    @Override
    public int[] getSupportedGroups() throws IOException {
        ContextData contextData = this.manager.getContextData();
        ProtocolVersion negotiatedVersion = this.context.getServerVersion();
        this.jsseSecurityParameters.namedGroups = contextData.getNamedGroupsServer(this.sslParameters, negotiatedVersion);
        return NamedGroupInfo.getSupportedGroupsLocalServer(this.jsseSecurityParameters.namedGroups);
    }

    @Override
    public int getSelectedCipherSuite() throws IOException {
        ContextData contextData = this.manager.getContextData();
        SecurityParameters securityParameters = this.context.getSecurityParametersHandshake();
        int[] clientSupportedGroups = securityParameters.getClientSupportedGroups();
        this.jsseSecurityParameters.namedGroups.notifyPeerData(clientSupportedGroups);
        ProtocolVersion negotiatedVersion = this.context.getServerVersion();
        this.jsseSecurityParameters.signatureSchemes = contextData.getSignatureSchemesServer(this.sslParameters, negotiatedVersion, this.jsseSecurityParameters.namedGroups);
        Vector clientSigAlgs = securityParameters.getClientSigAlgs();
        Vector clientSigAlgsCert = securityParameters.getClientSigAlgsCert();
        List<SignatureSchemeInfo> peerSigSchemes = contextData.getSignatureSchemes(clientSigAlgs);
        List<SignatureSchemeInfo> peerSigSchemesCert = null;
        if (clientSigAlgsCert != clientSigAlgs) {
            peerSigSchemesCert = contextData.getSignatureSchemes(clientSigAlgsCert);
        }
        this.jsseSecurityParameters.signatureSchemes.notifyPeerData(peerSigSchemes, peerSigSchemesCert);
        if (LOG.isLoggable(Level.FINEST)) {
            String title = this.serverID + " peer signature_algorithms";
            LOG.finest(JsseUtils.getSignatureAlgorithmsReport(title, peerSigSchemes));
            if (peerSigSchemesCert != null) {
                title = this.serverID + " peer signature_algorithms_cert";
                LOG.finest(JsseUtils.getSignatureAlgorithmsReport(title, peerSigSchemesCert));
            }
        }
        if (DummyX509KeyManager.INSTANCE == contextData.getX509KeyManager()) {
            throw new TlsFatalAlert(40);
        }
        this.keyManagerMissCache = new HashSet<String>();
        int selectedCipherSuite = super.getSelectedCipherSuite();
        this.keyManagerMissCache = null;
        String selectedCipherSuiteName = contextData.getContext().validateNegotiatedCipherSuite(this.sslParameters, selectedCipherSuite);
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine(this.serverID + " selected cipher suite: " + selectedCipherSuiteName);
        }
        return selectedCipherSuite;
    }

    @Override
    public Hashtable<Integer, byte[]> getServerExtensions() throws IOException {
        super.getServerExtensions();
        if (null != this.matchedSNIServerName) {
            TlsExtensionsUtils.addServerNameExtensionServer(this.serverExtensions);
        }
        Hashtable result = this.serverExtensions;
        return result;
    }

    @Override
    public TlsSession getSessionToResume(byte[] sessionID) {
        TlsSession sessionToResume;
        ProvSSLSession availableSSLSession;
        ProvSSLSessionContext sslSessionContext = this.manager.getContextData().getServerSessionContext();
        if (provServerEnableSessionResumption && null != (availableSSLSession = sslSessionContext.getSessionImpl(sessionID)) && this.isResumable(availableSSLSession, sessionToResume = availableSSLSession.getTlsSession())) {
            this.sslSession = availableSSLSession;
            return sessionToResume;
        }
        JsseUtils.checkSessionCreationEnabled(this.manager);
        return null;
    }

    @Override
    public byte[] getNewSessionID() {
        if (!provServerEnableSessionResumption || TlsUtils.isTLSv13(this.context)) {
            return null;
        }
        return this.context.getNonceGenerator().generateNonce(32);
    }

    @Override
    public void notifySession(TlsSession session) {
        boolean isResumed;
        byte[] sessionID = session.getSessionID();
        boolean bl = isResumed = null != this.sslSession && this.sslSession.getTlsSession() == session;
        if (isResumed) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this.serverID + " resumed session: " + Hex.toHexString((byte[])sessionID));
            }
        } else {
            this.sslSession = null;
            if (LOG.isLoggable(Level.FINE)) {
                if (TlsUtils.isNullOrEmpty(sessionID)) {
                    LOG.fine(this.serverID + " did not specify a session ID");
                } else {
                    LOG.fine(this.serverID + " specified new session: " + Hex.toHexString((byte[])sessionID));
                }
            }
            JsseUtils.checkSessionCreationEnabled(this.manager);
        }
        this.manager.notifyHandshakeSession(this.manager.getContextData().getServerSessionContext(), this.context.getSecurityParametersHandshake(), this.jsseSecurityParameters, this.sslSession);
    }

    @Override
    public void notifyAlertRaised(short alertLevel, short alertDescription, String message, Throwable cause) {
        Level level;
        Level level2 = alertLevel == 1 ? Level.FINE : (level = alertDescription == 80 ? Level.WARNING : Level.INFO);
        if (LOG.isLoggable(level)) {
            Object msg = JsseUtils.getAlertRaisedLogMessage(this.serverID, alertLevel, alertDescription);
            if (message != null) {
                msg = (String)msg + ": " + message;
            }
            LOG.log(level, (String)msg, cause);
        }
    }

    @Override
    public void notifyAlertReceived(short alertLevel, short alertDescription) {
        Level level;
        super.notifyAlertReceived(alertLevel, alertDescription);
        Level level2 = level = alertLevel == 1 ? Level.FINE : Level.INFO;
        if (LOG.isLoggable(level)) {
            String msg = JsseUtils.getAlertReceivedLogMessage(this.serverID, alertLevel, alertDescription);
            LOG.log(level, msg);
        }
    }

    @Override
    public ProtocolVersion getServerVersion() throws IOException {
        ProtocolVersion serverVersion = super.getServerVersion();
        String serverVersionName = this.manager.getContextData().getContext().validateNegotiatedProtocol(this.sslParameters, serverVersion);
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine(this.serverID + " selected protocol version: " + serverVersionName);
        }
        return serverVersion;
    }

    @Override
    public void notifyClientCertificate(Certificate clientCertificate) throws IOException {
        if (!this.isClientAuthEnabled()) {
            throw new TlsFatalAlert(80);
        }
        if (null == clientCertificate || clientCertificate.isEmpty()) {
            if (this.sslParameters.getNeedClientAuth()) {
                short alertDescription = TlsUtils.isTLSv13(this.context) ? (short)116 : 40;
                throw new TlsFatalAlert(alertDescription);
            }
        } else {
            X509Certificate[] chain = JsseUtils.getX509CertificateChain(this.getCrypto(), clientCertificate);
            this.manager.checkClientTrusted(chain, "TLS-client-auth");
        }
    }

    @Override
    public void notifyConnectionClosed() {
        super.notifyConnectionClosed();
        if (LOG.isLoggable(Level.INFO)) {
            LOG.info(this.serverID + " disconnected from " + JsseUtils.getPeerReport(this.manager));
        }
    }

    @Override
    public void notifyHandshakeBeginning() throws IOException {
        super.notifyHandshakeBeginning();
        if (LOG.isLoggable(Level.INFO)) {
            LOG.info(this.serverID + " accepting connection from " + JsseUtils.getPeerReport(this.manager));
        }
    }

    @Override
    public synchronized void notifyHandshakeComplete() throws IOException {
        super.notifyHandshakeComplete();
        this.handshakeComplete = true;
        if (LOG.isLoggable(Level.INFO)) {
            LOG.info(this.serverID + " established connection with " + JsseUtils.getPeerReport(this.manager));
        }
        TlsSession connectionTlsSession = this.context.getSession();
        if (null == this.sslSession || this.sslSession.getTlsSession() != connectionTlsSession) {
            ProvSSLSessionContext sslSessionContext = this.manager.getContextData().getServerSessionContext();
            String peerHost = this.manager.getPeerHost();
            int peerPort = this.manager.getPeerPort();
            JsseSessionParameters jsseSessionParameters = new JsseSessionParameters(this.sslParameters.getEndpointIdentificationAlgorithm(), this.matchedSNIServerName);
            boolean addToCache = provServerEnableSessionResumption && !TlsUtils.isTLSv13(this.context);
            this.sslSession = sslSessionContext.reportSession(peerHost, peerPort, connectionTlsSession, jsseSessionParameters, addToCache);
        }
        this.manager.notifyHandshakeComplete(new ProvSSLConnection(this));
    }

    @Override
    public void notifySecureRenegotiation(boolean secureRenegotiation) throws IOException {
        boolean allowLegacyHelloMessages;
        if (!secureRenegotiation && !(allowLegacyHelloMessages = PropertyUtils.getBooleanSystemProperty("sun.security.ssl.allowLegacyHelloMessages", true))) {
            throw new TlsFatalAlert(40);
        }
    }

    @Override
    public void processClientExtensions(Hashtable clientExtensions) throws IOException {
        super.processClientExtensions(clientExtensions);
        Vector serverNameList = this.context.getSecurityParametersHandshake().getClientServerNames();
        if (null != serverNameList) {
            Collection<BCSNIMatcher> sniMatchers = this.sslParameters.getSNIMatchers();
            if (null == sniMatchers || sniMatchers.isEmpty()) {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine(this.serverID + " ignored SNI (no matchers specified)");
                }
            } else {
                this.matchedSNIServerName = JsseUtils.findMatchingSNIServerName(serverNameList, sniMatchers);
                if (null == this.matchedSNIServerName) {
                    throw new TlsFatalAlert(112);
                }
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine(this.serverID + " accepted SNI: " + String.valueOf(this.matchedSNIServerName));
                }
            }
        }
        if (TlsUtils.isTLSv13(this.context)) {
            Vector certificateAuthorities = TlsExtensionsUtils.getCertificateAuthoritiesExtension(clientExtensions);
            this.jsseSecurityParameters.trustedIssuers = JsseUtils.toX500Principals(certificateAuthorities);
        } else if (provServerEnableTrustedCAKeys) {
            Vector trustedCAKeys = this.trustedCAKeys;
            this.jsseSecurityParameters.trustedIssuers = JsseUtils.getTrustedIssuers(trustedCAKeys);
        }
    }

    @Override
    public boolean requiresCloseNotify() {
        return JsseUtils.requireCloseNotify();
    }

    @Override
    public boolean requiresExtendedMasterSecret() {
        return !JsseUtils.allowLegacyMasterSecret();
    }

    @Override
    public boolean shouldUseExtendedMasterSecret() {
        return JsseUtils.useExtendedMasterSecret();
    }

    protected boolean isClientAuthEnabled() {
        return this.sslParameters.getNeedClientAuth() || this.sslParameters.getWantClientAuth();
    }

    protected boolean isResumable(ProvSSLSession provSSLSession, TlsSession tlsSession) {
        JsseSessionParameters jsseSessionParameters;
        String sessionEndpointID;
        if (null == tlsSession || !tlsSession.isResumable()) {
            return false;
        }
        SecurityParameters securityParameters = this.context.getSecurityParametersHandshake();
        ProtocolVersion negotiatedVersion = securityParameters.getNegotiatedVersion();
        if (TlsUtils.isTLSv13(negotiatedVersion)) {
            return false;
        }
        SessionParameters sessionParameters = tlsSession.exportSessionParameters();
        if (!(null != sessionParameters && negotiatedVersion.equals(sessionParameters.getNegotiatedVersion()) && Arrays.contains((int[])this.getCipherSuites(), (int)sessionParameters.getCipherSuite()) && Arrays.contains((int[])this.offeredCipherSuites, (int)sessionParameters.getCipherSuite()))) {
            return false;
        }
        if (this.sslParameters.getNeedClientAuth() && sessionParameters.getPeerCertificate() == null) {
            return false;
        }
        String connectionEndpointID = this.sslParameters.getEndpointIdentificationAlgorithm();
        if (null != connectionEndpointID && !connectionEndpointID.equalsIgnoreCase(sessionEndpointID = (jsseSessionParameters = provSSLSession.getJsseSessionParameters()).getEndpointIDAlgorithm())) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(this.serverID + ": Session not resumable - endpoint ID algorithm mismatch; connection: " + connectionEndpointID + ", session: " + sessionEndpointID);
            }
            return false;
        }
        BCSNIServerName connectionSNI = this.matchedSNIServerName;
        JsseSessionParameters jsseSessionParameters2 = provSSLSession.getJsseSessionParameters();
        BCSNIServerName sessionSNI = jsseSessionParameters2.getMatchedSNIServerName();
        if (!JsseUtils.equals(connectionSNI, sessionSNI)) {
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.finest(this.serverID + ": Session not resumable - SNI mismatch; connection: " + String.valueOf(connectionSNI) + ", session: " + String.valueOf(sessionSNI));
            }
            return false;
        }
        return true;
    }

    protected TlsCredentials selectCredentials(Principal[] issuers, int keyExchangeAlgorithm) throws IOException {
        switch (keyExchangeAlgorithm) {
            case 1: 
            case 3: 
            case 5: 
            case 17: 
            case 19: {
                if (1 == keyExchangeAlgorithm || !TlsUtils.isSignatureAlgorithmsExtensionAllowed(this.context.getServerVersion())) {
                    return this.selectServerCredentialsLegacy(issuers, keyExchangeAlgorithm);
                }
                return this.selectServerCredentials12(issuers, keyExchangeAlgorithm);
            }
            case 0: {
                byte[] certificateRequestContext = TlsUtils.EMPTY_BYTES;
                return this.selectServerCredentials13(issuers, certificateRequestContext);
            }
        }
        return null;
    }

    protected TlsCredentials selectServerCredentials12(Principal[] issuers, int keyExchangeAlgorithm) throws IOException {
        short legacySignatureAlgorithm = TlsUtils.getLegacySignatureAlgorithmServer(keyExchangeAlgorithm);
        SignatureSchemeInfo.PerConnection signatureSchemes = this.jsseSecurityParameters.signatureSchemes;
        LinkedHashMap<String, SignatureSchemeInfo> keyTypeMap = new LinkedHashMap<String, SignatureSchemeInfo>();
        for (SignatureSchemeInfo signatureSchemeInfo : signatureSchemes.getPeerSigSchemes()) {
            short signatureAlgorithm;
            String keyType;
            if (!TlsUtils.isValidSignatureSchemeForServerKeyExchange(signatureSchemeInfo.getSignatureScheme(), keyExchangeAlgorithm) || this.keyManagerMissCache.contains(keyType = legacySignatureAlgorithm == (signatureAlgorithm = signatureSchemeInfo.getSignatureAlgorithm()) ? JsseUtils.getKeyTypeLegacyServer(keyExchangeAlgorithm) : signatureSchemeInfo.getKeyType()) || keyTypeMap.containsKey(keyType) || !signatureSchemeInfo.isSupportedPre13() || !signatureSchemes.hasLocalSignatureScheme(signatureSchemeInfo)) continue;
            keyTypeMap.put(keyType, signatureSchemeInfo);
        }
        if (keyTypeMap.isEmpty()) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this.serverID + " (1.2) has no key types to try for KeyExchangeAlgorithm " + keyExchangeAlgorithm);
            }
            return null;
        }
        String[] keyTypes = keyTypeMap.keySet().toArray(TlsUtils.EMPTY_STRINGS);
        BCX509Key x509Key = this.manager.chooseServerKey(keyTypes, issuers);
        if (null == x509Key) {
            this.handleKeyManagerMisses(keyTypeMap, null);
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this.serverID + " (1.2) did not select any credentials for KeyExchangeAlgorithm " + keyExchangeAlgorithm);
            }
            return null;
        }
        String selectedKeyType = x509Key.getKeyType();
        this.handleKeyManagerMisses(keyTypeMap, selectedKeyType);
        SignatureSchemeInfo selectedSignatureSchemeInfo = keyTypeMap.get(selectedKeyType);
        if (null == selectedSignatureSchemeInfo) {
            throw new TlsFatalAlert(80, "Key manager returned invalid key type");
        }
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine(this.serverID + " (1.2) selected credentials for signature scheme '" + String.valueOf(selectedSignatureSchemeInfo) + "' (keyType '" + selectedKeyType + "'), with private key algorithm '" + JsseUtils.getPrivateKeyAlgorithm(x509Key.getPrivateKey()) + "'");
        }
        return JsseUtils.createCredentialedSigner(this.context, this.getCrypto(), x509Key, selectedSignatureSchemeInfo.getSignatureAndHashAlgorithm());
    }

    protected TlsCredentials selectServerCredentials13(Principal[] issuers, byte[] certificateRequestContext) throws IOException {
        SignatureSchemeInfo.PerConnection signatureSchemes = this.jsseSecurityParameters.signatureSchemes;
        LinkedHashMap<String, SignatureSchemeInfo> keyTypeMap = new LinkedHashMap<String, SignatureSchemeInfo>();
        for (SignatureSchemeInfo signatureSchemeInfo : signatureSchemes.getPeerSigSchemes()) {
            String keyType = signatureSchemeInfo.getKeyType13();
            if (this.keyManagerMissCache.contains(keyType) || keyTypeMap.containsKey(keyType) || !signatureSchemeInfo.isSupportedPost13() || !signatureSchemes.hasLocalSignatureScheme(signatureSchemeInfo)) continue;
            keyTypeMap.put(keyType, signatureSchemeInfo);
        }
        if (keyTypeMap.isEmpty()) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this.serverID + " (1.3) found no usable signature schemes");
            }
            return null;
        }
        String[] keyTypes = keyTypeMap.keySet().toArray(TlsUtils.EMPTY_STRINGS);
        BCX509Key x509Key = this.manager.chooseServerKey(keyTypes, issuers);
        if (null == x509Key) {
            this.handleKeyManagerMisses(keyTypeMap, null);
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this.serverID + " (1.3) did not select any credentials");
            }
            return null;
        }
        String selectedKeyType = x509Key.getKeyType();
        this.handleKeyManagerMisses(keyTypeMap, selectedKeyType);
        SignatureSchemeInfo selectedSignatureSchemeInfo = keyTypeMap.get(selectedKeyType);
        if (null == selectedSignatureSchemeInfo) {
            throw new TlsFatalAlert(80, "Key manager returned invalid key type");
        }
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine(this.serverID + " (1.3) selected credentials for signature scheme '" + String.valueOf(selectedSignatureSchemeInfo) + "' (keyType '" + selectedKeyType + "'), with private key algorithm '" + JsseUtils.getPrivateKeyAlgorithm(x509Key.getPrivateKey()) + "'");
        }
        return JsseUtils.createCredentialedSigner13(this.context, this.getCrypto(), x509Key, selectedSignatureSchemeInfo.getSignatureAndHashAlgorithm(), certificateRequestContext);
    }

    protected TlsCredentials selectServerCredentialsLegacy(Principal[] issuers, int keyExchangeAlgorithm) throws IOException {
        String keyType = JsseUtils.getKeyTypeLegacyServer(keyExchangeAlgorithm);
        if (this.keyManagerMissCache.contains(keyType)) {
            return null;
        }
        BCX509Key x509Key = this.manager.chooseServerKey(new String[]{keyType}, issuers);
        if (null == x509Key) {
            this.keyManagerMissCache.add(keyType);
            return null;
        }
        if (1 == keyExchangeAlgorithm) {
            return JsseUtils.createCredentialedDecryptor(this.getCrypto(), x509Key);
        }
        return JsseUtils.createCredentialedSigner(this.context, this.getCrypto(), x509Key, null);
    }

    private void handleKeyManagerMisses(LinkedHashMap<String, SignatureSchemeInfo> keyTypeMap, String selectedKeyType) {
        Map.Entry<String, SignatureSchemeInfo> entry;
        String keyType;
        Iterator<Map.Entry<String, SignatureSchemeInfo>> iterator = keyTypeMap.entrySet().iterator();
        while (iterator.hasNext() && !(keyType = (entry = iterator.next()).getKey()).equals(selectedKeyType)) {
            this.keyManagerMissCache.add(keyType);
            if (!LOG.isLoggable(Level.FINER)) continue;
            SignatureSchemeInfo signatureSchemeInfo = entry.getValue();
            LOG.finer(this.serverID + " found no credentials for signature scheme '" + String.valueOf(signatureSchemeInfo) + "' (keyType '" + keyType + "')");
        }
    }
}

