/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls.crypto.impl.bc;

import org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import org.bouncycastle.crypto.KeyGenerationParameters;
import org.bouncycastle.crypto.SecretWithEncapsulation;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.pqc.crypto.crystals.kyber.KyberKEMExtractor;
import org.bouncycastle.pqc.crypto.crystals.kyber.KyberKEMGenerator;
import org.bouncycastle.pqc.crypto.crystals.kyber.KyberKeyGenerationParameters;
import org.bouncycastle.pqc.crypto.crystals.kyber.KyberKeyPairGenerator;
import org.bouncycastle.pqc.crypto.crystals.kyber.KyberParameters;
import org.bouncycastle.pqc.crypto.crystals.kyber.KyberPrivateKeyParameters;
import org.bouncycastle.pqc.crypto.crystals.kyber.KyberPublicKeyParameters;
import org.bouncycastle.tls.crypto.TlsAgreement;
import org.bouncycastle.tls.crypto.TlsKemConfig;
import org.bouncycastle.tls.crypto.TlsKemDomain;
import org.bouncycastle.tls.crypto.impl.bc.BcTlsCrypto;
import org.bouncycastle.tls.crypto.impl.bc.BcTlsMLKem;
import org.bouncycastle.tls.crypto.impl.bc.BcTlsSecret;

public class BcTlsMLKemDomain
implements TlsKemDomain {
    protected final BcTlsCrypto crypto;
    protected final KyberParameters kyberParameters;
    protected final boolean isServer;

    protected static KyberParameters getKyberParameters(int namedGroup) {
        switch (namedGroup) {
            case 583: {
                return KyberParameters.kyber512;
            }
            case 584: 
            case 1896: {
                return KyberParameters.kyber768;
            }
            case 585: 
            case 4132: {
                return KyberParameters.kyber1024;
            }
        }
        return null;
    }

    public BcTlsMLKemDomain(BcTlsCrypto crypto, TlsKemConfig kemConfig) {
        this.crypto = crypto;
        this.kyberParameters = BcTlsMLKemDomain.getKyberParameters(kemConfig.getNamedGroup());
        this.isServer = kemConfig.isServer();
    }

    public BcTlsSecret adoptLocalSecret(byte[] secret) {
        return this.crypto.adoptLocalSecret(secret);
    }

    @Override
    public TlsAgreement createKem() {
        return new BcTlsMLKem(this);
    }

    public BcTlsSecret decapsulate(KyberPrivateKeyParameters privateKey, byte[] ciphertext) {
        KyberKEMExtractor kemExtract = new KyberKEMExtractor(privateKey);
        byte[] secret = kemExtract.extractSecret(ciphertext);
        return this.adoptLocalSecret(secret);
    }

    public KyberPublicKeyParameters decodePublicKey(byte[] encoding) {
        return new KyberPublicKeyParameters(this.kyberParameters, encoding);
    }

    public SecretWithEncapsulation encapsulate(KyberPublicKeyParameters publicKey) {
        KyberKEMGenerator kemGen = new KyberKEMGenerator(this.crypto.getSecureRandom());
        return kemGen.generateEncapsulated((AsymmetricKeyParameter)publicKey);
    }

    public byte[] encodePublicKey(KyberPublicKeyParameters publicKey) {
        return publicKey.getEncoded();
    }

    public AsymmetricCipherKeyPair generateKeyPair() {
        KyberKeyPairGenerator keyPairGenerator = new KyberKeyPairGenerator();
        keyPairGenerator.init((KeyGenerationParameters)new KyberKeyGenerationParameters(this.crypto.getSecureRandom(), this.kyberParameters));
        return keyPairGenerator.generateKeyPair();
    }

    public boolean isServer() {
        return this.isServer;
    }
}

