/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls;

import java.io.IOException;
import org.bouncycastle.tls.DTLSReplayWindow;
import org.bouncycastle.tls.TlsFatalAlert;
import org.bouncycastle.tls.crypto.TlsCipher;

class DTLSEpoch {
    private final DTLSReplayWindow replayWindow = new DTLSReplayWindow();
    private final int epoch;
    private final TlsCipher cipher;
    private final int recordHeaderLengthRead;
    private final int recordHeaderLengthWrite;
    private long sequenceNumber = 0L;

    DTLSEpoch(int epoch, TlsCipher cipher, int recordHeaderLengthRead, int recordHeaderLengthWrite) {
        if (epoch < 0) {
            throw new IllegalArgumentException("'epoch' must be >= 0");
        }
        if (cipher == null) {
            throw new IllegalArgumentException("'cipher' cannot be null");
        }
        this.epoch = epoch;
        this.cipher = cipher;
        this.recordHeaderLengthRead = recordHeaderLengthRead;
        this.recordHeaderLengthWrite = recordHeaderLengthWrite;
    }

    synchronized long allocateSequenceNumber() throws IOException {
        if (this.sequenceNumber >= 0x1000000000000L) {
            throw new TlsFatalAlert(80);
        }
        return this.sequenceNumber++;
    }

    TlsCipher getCipher() {
        return this.cipher;
    }

    int getEpoch() {
        return this.epoch;
    }

    int getRecordHeaderLengthRead() {
        return this.recordHeaderLengthRead;
    }

    int getRecordHeaderLengthWrite() {
        return this.recordHeaderLengthWrite;
    }

    DTLSReplayWindow getReplayWindow() {
        return this.replayWindow;
    }

    synchronized long getSequenceNumber() {
        return this.sequenceNumber;
    }

    synchronized void setSequenceNumber(long sequenceNumber) {
        this.sequenceNumber = sequenceNumber;
    }
}

