/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jsse.provider;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.security.Principal;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLSession;
import org.bouncycastle.jsse.BCApplicationProtocolSelector;
import org.bouncycastle.jsse.BCExtendedSSLSession;
import org.bouncycastle.jsse.BCSSLConnection;
import org.bouncycastle.jsse.BCSSLEngine;
import org.bouncycastle.jsse.BCSSLParameters;
import org.bouncycastle.jsse.BCX509Key;
import org.bouncycastle.jsse.provider.ContextData;
import org.bouncycastle.jsse.provider.JsseSecurityParameters;
import org.bouncycastle.jsse.provider.JsseUtils;
import org.bouncycastle.jsse.provider.ProvSSLConnection;
import org.bouncycastle.jsse.provider.ProvSSLParameters;
import org.bouncycastle.jsse.provider.ProvSSLSession;
import org.bouncycastle.jsse.provider.ProvSSLSessionContext;
import org.bouncycastle.jsse.provider.ProvSSLSessionHandshake;
import org.bouncycastle.jsse.provider.ProvSSLSessionResumed;
import org.bouncycastle.jsse.provider.ProvTlsClient;
import org.bouncycastle.jsse.provider.ProvTlsManager;
import org.bouncycastle.jsse.provider.ProvTlsPeer;
import org.bouncycastle.jsse.provider.ProvTlsServer;
import org.bouncycastle.jsse.provider.SSLParametersUtil;
import org.bouncycastle.tls.RecordPreview;
import org.bouncycastle.tls.SecurityParameters;
import org.bouncycastle.tls.TlsClientProtocol;
import org.bouncycastle.tls.TlsFatalAlert;
import org.bouncycastle.tls.TlsProtocol;
import org.bouncycastle.tls.TlsServerProtocol;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
class ProvSSLEngine
extends SSLEngine
implements BCSSLEngine,
ProvTlsManager {
    private static final Logger LOG = Logger.getLogger(ProvSSLEngine.class.getName());
    protected final ContextData contextData;
    protected final ProvSSLParameters sslParameters;
    protected boolean enableSessionCreation = true;
    protected boolean useClientMode = true;
    protected boolean useClientModeSet = false;
    protected boolean closedEarly = false;
    protected boolean initialHandshakeBegun = false;
    protected boolean returnedFinished = false;
    protected TlsProtocol protocol = null;
    protected ProvTlsPeer protocolPeer = null;
    protected ProvSSLConnection connection = null;
    protected ProvSSLSessionHandshake handshakeSession = null;
    protected SSLException deferredException = null;

    protected ProvSSLEngine(ContextData contextData) {
        this(contextData, null, -1);
    }

    protected ProvSSLEngine(ContextData contextData, String peerHost, int peerPort) {
        super(peerHost, peerPort);
        this.contextData = contextData;
        this.sslParameters = contextData.getContext().getDefaultSSLParameters(this.useClientMode);
    }

    @Override
    public ContextData getContextData() {
        return this.contextData;
    }

    @Override
    public synchronized void beginHandshake() throws SSLException {
        if (!this.useClientModeSet) {
            throw new IllegalStateException("Client/Server mode must be set before the handshake can begin");
        }
        if (this.closedEarly) {
            throw new SSLException("Connection is already closed");
        }
        if (this.initialHandshakeBegun) {
            throw new UnsupportedOperationException("Renegotiation not supported");
        }
        this.initialHandshakeBegun = true;
        try {
            if (this.useClientMode) {
                TlsClientProtocol clientProtocol = new TlsClientProtocol();
                this.protocol = clientProtocol;
                ProvTlsClient client = new ProvTlsClient(this, this.sslParameters);
                this.protocolPeer = client;
                clientProtocol.connect(client);
            } else {
                TlsServerProtocol serverProtocol = new TlsServerProtocol();
                this.protocol = serverProtocol;
                ProvTlsServer server = new ProvTlsServer(this, this.sslParameters);
                this.protocolPeer = server;
                serverProtocol.accept(server);
            }
        }
        catch (SSLException e) {
            throw e;
        }
        catch (IOException e) {
            throw new SSLException(e);
        }
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType) throws IOException {
        try {
            this.contextData.getX509TrustManager().checkClientTrusted((X509Certificate[])chain.clone(), authType, this);
        }
        catch (CertificateException e) {
            throw new TlsFatalAlert(46, (Throwable)e);
        }
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType) throws IOException {
        try {
            this.contextData.getX509TrustManager().checkServerTrusted((X509Certificate[])chain.clone(), authType, this);
        }
        catch (CertificateException e) {
            throw new TlsFatalAlert(46, (Throwable)e);
        }
    }

    @Override
    public BCX509Key chooseClientKey(String[] keyTypes, Principal[] issuers) {
        return this.getContextData().getX509KeyManager().chooseEngineClientKeyBC(keyTypes, JsseUtils.clone(issuers), this);
    }

    @Override
    public BCX509Key chooseServerKey(String[] keyTypes, Principal[] issuers) {
        return this.getContextData().getX509KeyManager().chooseEngineServerKeyBC(keyTypes, JsseUtils.clone(issuers), this);
    }

    @Override
    public synchronized void closeInbound() throws SSLException {
        if (!this.closedEarly) {
            if (null == this.protocol) {
                this.closedEarly = true;
            } else {
                try {
                    this.protocol.closeInput();
                }
                catch (IOException e) {
                    throw new SSLException(e);
                }
            }
        }
    }

    @Override
    public synchronized void closeOutbound() {
        if (!this.closedEarly) {
            if (null == this.protocol) {
                this.closedEarly = true;
            } else {
                try {
                    this.protocol.close();
                }
                catch (IOException e) {
                    LOG.log(Level.WARNING, "Failed to close outbound", e);
                }
            }
        }
    }

    @Override
    public synchronized String getApplicationProtocol() {
        return null == this.connection ? null : this.connection.getApplicationProtocol();
    }

    @Override
    public synchronized BCApplicationProtocolSelector<SSLEngine> getBCHandshakeApplicationProtocolSelector() {
        return this.sslParameters.getEngineAPSelector();
    }

    @Override
    public synchronized BCExtendedSSLSession getBCHandshakeSession() {
        return this.handshakeSession;
    }

    @Override
    public BCExtendedSSLSession getBCSession() {
        return this.getSessionImpl();
    }

    @Override
    public synchronized BCSSLConnection getConnection() {
        return this.connection;
    }

    @Override
    public synchronized Runnable getDelegatedTask() {
        return null;
    }

    @Override
    public synchronized String[] getEnabledCipherSuites() {
        return this.sslParameters.getCipherSuites();
    }

    @Override
    public synchronized String[] getEnabledProtocols() {
        return this.sslParameters.getProtocols();
    }

    @Override
    public synchronized boolean getEnableSessionCreation() {
        return this.enableSessionCreation;
    }

    @Override
    public synchronized String getHandshakeApplicationProtocol() {
        return null == this.handshakeSession ? null : this.handshakeSession.getApplicationProtocol();
    }

    @Override
    public synchronized SSLSession getHandshakeSession() {
        return null == this.handshakeSession ? null : this.handshakeSession.getExportSSLSession();
    }

    @Override
    public synchronized SSLEngineResult.HandshakeStatus getHandshakeStatus() {
        if (this.protocol != null) {
            if (this.protocol.getAvailableOutputBytes() > 0 || this.deferredException != null) {
                return SSLEngineResult.HandshakeStatus.NEED_WRAP;
            }
            if (this.protocol.isHandshaking()) {
                return SSLEngineResult.HandshakeStatus.NEED_UNWRAP;
            }
        }
        return SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING;
    }

    @Override
    public synchronized boolean getNeedClientAuth() {
        return this.sslParameters.getNeedClientAuth();
    }

    @Override
    public synchronized BCSSLParameters getParameters() {
        return SSLParametersUtil.getParameters(this.sslParameters);
    }

    @Override
    public SSLSession getSession() {
        return this.getSessionImpl().getExportSSLSession();
    }

    @Override
    public synchronized SSLParameters getSSLParameters() {
        return SSLParametersUtil.getSSLParameters(this.sslParameters);
    }

    @Override
    public synchronized String[] getSupportedCipherSuites() {
        return this.contextData.getContext().getSupportedCipherSuites();
    }

    @Override
    public synchronized String[] getSupportedProtocols() {
        return this.contextData.getContext().getSupportedProtocols();
    }

    @Override
    public int getTransportID() {
        return System.identityHashCode(this);
    }

    @Override
    public synchronized boolean getUseClientMode() {
        return this.useClientMode;
    }

    @Override
    public synchronized boolean getWantClientAuth() {
        return this.sslParameters.getWantClientAuth();
    }

    @Override
    public synchronized boolean isInboundDone() {
        return this.closedEarly || null != this.protocol && this.protocol.isClosed();
    }

    @Override
    public synchronized boolean isOutboundDone() {
        return this.closedEarly || null != this.protocol && this.protocol.isClosed() && this.protocol.getAvailableOutputBytes() < 1;
    }

    @Override
    public synchronized void setBCHandshakeApplicationProtocolSelector(BCApplicationProtocolSelector<SSLEngine> selector) {
        this.sslParameters.setEngineAPSelector(selector);
    }

    @Override
    public synchronized void setBCSessionToResume(BCExtendedSSLSession session) {
        if (null == session) {
            throw new NullPointerException("'session' cannot be null");
        }
        if (!(session instanceof ProvSSLSession)) {
            throw new IllegalArgumentException("Session-to-resume must be a session returned from 'getBCSession'");
        }
        if (this.initialHandshakeBegun) {
            throw new IllegalArgumentException("Session-to-resume cannot be set after the handshake has begun");
        }
        this.sslParameters.setSessionToResume((ProvSSLSession)session);
    }

    @Override
    public synchronized void setEnabledCipherSuites(String[] suites) {
        this.sslParameters.setCipherSuites(suites);
    }

    @Override
    public synchronized void setEnabledProtocols(String[] protocols) {
        this.sslParameters.setProtocols(protocols);
    }

    @Override
    public synchronized void setEnableSessionCreation(boolean flag) {
        this.enableSessionCreation = flag;
    }

    @Override
    public synchronized void setNeedClientAuth(boolean need) {
        this.sslParameters.setNeedClientAuth(need);
    }

    @Override
    public synchronized void setParameters(BCSSLParameters parameters) {
        SSLParametersUtil.setParameters(this.sslParameters, parameters);
    }

    @Override
    public synchronized void setSSLParameters(SSLParameters sslParameters) {
        SSLParametersUtil.setSSLParameters(this.sslParameters, sslParameters);
    }

    @Override
    public synchronized void setUseClientMode(boolean useClientMode) {
        if (this.initialHandshakeBegun) {
            throw new IllegalArgumentException("Client/Server mode cannot be changed after the handshake has begun");
        }
        if (this.useClientMode != useClientMode) {
            this.contextData.getContext().updateDefaultSSLParameters(this.sslParameters, useClientMode);
            this.useClientMode = useClientMode;
        }
        this.useClientModeSet = true;
    }

    @Override
    public synchronized void setWantClientAuth(boolean want) {
        this.sslParameters.setWantClientAuth(want);
    }

    @Override
    public synchronized SSLEngineResult unwrap(ByteBuffer src, ByteBuffer[] dsts, int offset, int length) throws SSLException {
        SSLEngineResult.HandshakeStatus initialHandshakeStatus = this.getHandshakeStatus();
        if (this.isInboundDone()) {
            return new SSLEngineResult(SSLEngineResult.Status.CLOSED, initialHandshakeStatus, 0, 0);
        }
        if (!this.initialHandshakeBegun) {
            this.beginHandshake();
        }
        switch (initialHandshakeStatus) {
            case NEED_UNWRAP: 
            case NOT_HANDSHAKING: {
                break;
            }
            default: {
                return new SSLEngineResult(SSLEngineResult.Status.OK, initialHandshakeStatus, 0, 0);
            }
        }
        int bytesConsumed = 0;
        try {
            RecordPreview preview = this.getRecordPreview(src);
            if (preview == null || src.remaining() < preview.getRecordSize()) {
                return new SSLEngineResult(SSLEngineResult.Status.BUFFER_UNDERFLOW, initialHandshakeStatus, 0, 0);
            }
            if (this.hasInsufficientSpace(dsts, offset, length, preview.getContentLimit())) {
                return new SSLEngineResult(SSLEngineResult.Status.BUFFER_OVERFLOW, initialHandshakeStatus, 0, 0);
            }
            bytesConsumed = preview.getRecordSize();
            byte[] record = new byte[bytesConsumed];
            src.get(record);
            this.protocol.offerInput(record, 0, record.length);
        }
        catch (IOException e) {
            if (initialHandshakeStatus != SSLEngineResult.HandshakeStatus.NEED_UNWRAP) {
                throw new SSLException(e);
            }
            this.deferredException = new SSLException(e);
            return new SSLEngineResult(SSLEngineResult.Status.OK, SSLEngineResult.HandshakeStatus.NEED_WRAP, bytesConsumed, 0);
        }
        int appDataAvailable = this.protocol.getAvailableInputBytes();
        int bytesProduced = 0;
        int dstIndex = 0;
        while (appDataAvailable > 0) {
            ByteBuffer dst = dsts[offset + dstIndex];
            int count = Math.min(dst.remaining(), appDataAvailable);
            if (count > 0) {
                int numRead = this.protocol.readInput(dst, count);
                assert (numRead == count);
                bytesProduced += count;
                appDataAvailable -= count;
            }
            ++dstIndex;
        }
        SSLEngineResult.HandshakeStatus resultHandshakeStatus = this.getHandshakeStatus();
        if (resultHandshakeStatus == SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING && !this.returnedFinished && this.protocolPeer.isHandshakeComplete()) {
            this.returnedFinished = true;
            resultHandshakeStatus = SSLEngineResult.HandshakeStatus.FINISHED;
        }
        return new SSLEngineResult(this.getStatus(), resultHandshakeStatus, bytesConsumed, bytesProduced);
    }

    @Override
    public synchronized SSLEngineResult wrap(ByteBuffer[] srcs, int offset, int length, ByteBuffer dst) throws SSLException {
        if (this.deferredException != null) {
            SSLException e = this.deferredException;
            this.deferredException = null;
            throw e;
        }
        if (this.closedEarly) {
            return new SSLEngineResult(SSLEngineResult.Status.CLOSED, SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING, 0, 0);
        }
        if (!this.initialHandshakeBegun) {
            this.beginHandshake();
        }
        int bytesProduced = 0;
        int outputAvailable = this.protocol.getAvailableOutputBytes();
        if (outputAvailable > 0) {
            int remaining = dst.remaining();
            if (remaining >= outputAvailable) {
                bytesProduced = outputAvailable;
            } else {
                bytesProduced = this.protocol.previewOutputRecord();
                assert (bytesProduced > 0);
                if (remaining < bytesProduced) {
                    return new SSLEngineResult(SSLEngineResult.Status.BUFFER_OVERFLOW, SSLEngineResult.HandshakeStatus.NEED_WRAP, 0, 0);
                }
            }
            int numRead = this.protocol.readOutput(dst, bytesProduced);
            assert (numRead == bytesProduced);
            if (bytesProduced < outputAvailable) {
                return new SSLEngineResult(SSLEngineResult.Status.OK, SSLEngineResult.HandshakeStatus.NEED_WRAP, 0, bytesProduced);
            }
        } else if (this.protocol.isConnected()) {
            try {
                int bytesConsumed = 0;
                int srcRemaining = this.getTotalRemaining(srcs, offset, length, this.protocol.getApplicationDataLimit());
                if (srcRemaining > 0) {
                    RecordPreview preview = this.protocol.previewOutputRecord(srcRemaining);
                    int srcLimit = preview.getContentLimit();
                    int dstLimit = preview.getRecordSize();
                    if (dst.remaining() < dstLimit) {
                        return new SSLEngineResult(SSLEngineResult.Status.BUFFER_OVERFLOW, SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING, 0, 0);
                    }
                    byte[] buffer = new byte[srcLimit];
                    for (int srcIndex = 0; srcIndex < length && bytesConsumed < srcLimit; ++srcIndex) {
                        ByteBuffer src = srcs[offset + srcIndex];
                        int count = Math.min(src.remaining(), srcLimit - bytesConsumed);
                        if (count <= 0) continue;
                        src.get(buffer, bytesConsumed, count);
                        bytesConsumed += count;
                    }
                    this.protocol.writeApplicationData(buffer, 0, bytesConsumed);
                    bytesProduced = this.protocol.getAvailableOutputBytes();
                    assert (bytesProduced <= dstLimit);
                    int numRead = this.protocol.readOutput(dst, bytesProduced);
                    assert (numRead == bytesProduced);
                }
                return new SSLEngineResult(this.getStatus(), SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING, bytesConsumed, bytesProduced);
            }
            catch (IOException e) {
                throw new SSLException(e);
            }
        }
        if (this.protocol.isHandshaking()) {
            return new SSLEngineResult(SSLEngineResult.Status.OK, SSLEngineResult.HandshakeStatus.NEED_UNWRAP, 0, bytesProduced);
        }
        SSLEngineResult.HandshakeStatus resultHandshakeStatus = SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING;
        if (!this.returnedFinished && this.protocolPeer.isHandshakeComplete()) {
            this.returnedFinished = true;
            resultHandshakeStatus = SSLEngineResult.HandshakeStatus.FINISHED;
        }
        return new SSLEngineResult(this.getStatus(), resultHandshakeStatus, 0, bytesProduced);
    }

    @Override
    public String getPeerHost() {
        return super.getPeerHost();
    }

    @Override
    public String getPeerHostSNI() {
        return super.getPeerHost();
    }

    @Override
    public int getPeerPort() {
        return super.getPeerPort();
    }

    @Override
    public synchronized void notifyHandshakeComplete(ProvSSLConnection connection) {
        if (null != this.handshakeSession) {
            if (!this.handshakeSession.isValid()) {
                connection.getSession().invalidate();
            }
            this.handshakeSession.getJsseSecurityParameters().clear();
        }
        this.handshakeSession = null;
        this.connection = connection;
    }

    @Override
    public synchronized void notifyHandshakeSession(ProvSSLSessionContext sslSessionContext, SecurityParameters securityParameters, JsseSecurityParameters jsseSecurityParameters, ProvSSLSession resumedSession) {
        String peerHost = this.getPeerHost();
        int peerPort = this.getPeerPort();
        this.handshakeSession = null != resumedSession ? new ProvSSLSessionResumed(sslSessionContext, peerHost, peerPort, securityParameters, jsseSecurityParameters, resumedSession.getTlsSession(), resumedSession.getJsseSessionParameters()) : new ProvSSLSessionHandshake(sslSessionContext, peerHost, peerPort, securityParameters, jsseSecurityParameters);
    }

    @Override
    public synchronized String selectApplicationProtocol(List<String> protocols) {
        return this.sslParameters.getEngineAPSelector().select(this, protocols);
    }

    ProvSSLSession getSessionImpl() {
        return null == this.connection ? ProvSSLSession.NULL_SESSION : this.connection.getSession();
    }

    private RecordPreview getRecordPreview(ByteBuffer src) throws IOException {
        if (src.remaining() < 5) {
            return null;
        }
        byte[] recordHeader = new byte[5];
        int position = src.position();
        src.get(recordHeader);
        src.position(position);
        return this.protocol.previewInputRecord(recordHeader);
    }

    private SSLEngineResult.Status getStatus() {
        return this.protocol.isClosed() ? SSLEngineResult.Status.CLOSED : SSLEngineResult.Status.OK;
    }

    private int getTotalRemaining(ByteBuffer[] bufs, int off, int len, int limit) {
        int result = 0;
        for (int i = 0; i < len; ++i) {
            ByteBuffer buf = bufs[off + i];
            int next = buf.remaining();
            if (next >= limit - result) {
                return limit;
            }
            result += next;
        }
        return result;
    }

    private boolean hasInsufficientSpace(ByteBuffer[] dsts, int off, int len, int amount) {
        return this.getTotalRemaining(dsts, off, len, amount) < amount;
    }
}

