/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls;

import java.io.IOException;
import java.util.Hashtable;
import java.util.Vector;
import org.bouncycastle.tls.AbstractTlsPeer;
import org.bouncycastle.tls.CertificateStatusRequest;
import org.bouncycastle.tls.DefaultTlsDHGroupVerifier;
import org.bouncycastle.tls.DefaultTlsSRPConfigVerifier;
import org.bouncycastle.tls.NewSessionTicket;
import org.bouncycastle.tls.OCSPStatusRequest;
import org.bouncycastle.tls.ProtocolVersion;
import org.bouncycastle.tls.SecurityParameters;
import org.bouncycastle.tls.TlsClient;
import org.bouncycastle.tls.TlsClientContext;
import org.bouncycastle.tls.TlsDHGroupVerifier;
import org.bouncycastle.tls.TlsECCUtils;
import org.bouncycastle.tls.TlsExtensionsUtils;
import org.bouncycastle.tls.TlsFatalAlert;
import org.bouncycastle.tls.TlsPSK;
import org.bouncycastle.tls.TlsPSKIdentity;
import org.bouncycastle.tls.TlsSRPConfigVerifier;
import org.bouncycastle.tls.TlsSRPIdentity;
import org.bouncycastle.tls.TlsSession;
import org.bouncycastle.tls.TlsUtils;
import org.bouncycastle.tls.crypto.TlsCrypto;
import org.bouncycastle.util.Integers;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public abstract class AbstractTlsClient
extends AbstractTlsPeer
implements TlsClient {
    protected TlsClientContext context;
    protected ProtocolVersion[] protocolVersions;
    protected int[] cipherSuites;
    protected Vector supportedGroups;
    protected Vector supportedSignatureAlgorithms;
    protected Vector supportedSignatureAlgorithmsCert;

    public AbstractTlsClient(TlsCrypto crypto) {
        super(crypto);
    }

    protected boolean allowUnexpectedServerExtension(Integer extensionType, byte[] extensionData) throws IOException {
        switch (extensionType) {
            case 10: {
                TlsExtensionsUtils.readSupportedGroupsExtension(extensionData);
                return true;
            }
            case 11: {
                TlsExtensionsUtils.readSupportedPointFormatsExtension(extensionData);
                return true;
            }
        }
        return false;
    }

    protected Vector getNamedGroupRoles() {
        Vector namedGroupRoles = TlsUtils.getNamedGroupRoles(this.getCipherSuites());
        Vector sigAlgs = this.supportedSignatureAlgorithms;
        Vector sigAlgsCert = this.supportedSignatureAlgorithmsCert;
        if (null == sigAlgs || TlsUtils.containsAnySignatureAlgorithm(sigAlgs, (short)3) || null != sigAlgsCert && TlsUtils.containsAnySignatureAlgorithm(sigAlgsCert, (short)3)) {
            TlsUtils.addToSet(namedGroupRoles, 3);
        }
        return namedGroupRoles;
    }

    protected void checkForUnexpectedServerExtension(Hashtable serverExtensions, Integer extensionType) throws IOException {
        byte[] extensionData = TlsUtils.getExtensionData(serverExtensions, extensionType);
        if (extensionData != null && !this.allowUnexpectedServerExtension(extensionType, extensionData)) {
            throw new TlsFatalAlert(47);
        }
    }

    protected byte[] getNewConnectionID() {
        return null;
    }

    @Override
    public TlsPSKIdentity getPSKIdentity() throws IOException {
        return null;
    }

    @Override
    public TlsSRPIdentity getSRPIdentity() throws IOException {
        return null;
    }

    @Override
    public TlsDHGroupVerifier getDHGroupVerifier() {
        return new DefaultTlsDHGroupVerifier();
    }

    @Override
    public TlsSRPConfigVerifier getSRPConfigVerifier() {
        return new DefaultTlsSRPConfigVerifier();
    }

    protected Vector getCertificateAuthorities() {
        return null;
    }

    protected Vector getProtocolNames() {
        return null;
    }

    protected CertificateStatusRequest getCertificateStatusRequest() {
        return new CertificateStatusRequest(1, new OCSPStatusRequest(null, null));
    }

    protected Vector getMultiCertStatusRequest() {
        return null;
    }

    protected Vector getSNIServerNames() {
        return null;
    }

    protected Vector getSupportedGroups(Vector namedGroupRoles) {
        TlsCrypto crypto = this.getCrypto();
        Vector supportedGroups = new Vector();
        if (namedGroupRoles.contains(Integers.valueOf((int)2))) {
            TlsUtils.addIfSupported(supportedGroups, crypto, new int[]{29, 30});
        }
        if (namedGroupRoles.contains(Integers.valueOf((int)2)) || namedGroupRoles.contains(Integers.valueOf((int)3))) {
            TlsUtils.addIfSupported(supportedGroups, crypto, new int[]{23, 24});
        }
        if (namedGroupRoles.contains(Integers.valueOf((int)1))) {
            TlsUtils.addIfSupported(supportedGroups, crypto, new int[]{256, 257, 258});
        }
        return supportedGroups;
    }

    protected Vector getSupportedSignatureAlgorithms() {
        return TlsUtils.getDefaultSupportedSignatureAlgorithms(this.context);
    }

    protected Vector getSupportedSignatureAlgorithmsCert() {
        return null;
    }

    protected Vector getTrustedCAIndication() {
        return null;
    }

    protected short[] getAllowedClientCertificateTypes() {
        return null;
    }

    protected short[] getAllowedServerCertificateTypes() {
        return null;
    }

    @Override
    public void init(TlsClientContext context) {
        this.context = context;
        this.protocolVersions = this.getSupportedVersions();
        this.cipherSuites = this.getSupportedCipherSuites();
    }

    @Override
    public ProtocolVersion[] getProtocolVersions() {
        return this.protocolVersions;
    }

    @Override
    public int[] getCipherSuites() {
        return this.cipherSuites;
    }

    @Override
    public void notifyHandshakeBeginning() throws IOException {
        super.notifyHandshakeBeginning();
        this.supportedGroups = null;
        this.supportedSignatureAlgorithms = null;
        this.supportedSignatureAlgorithmsCert = null;
    }

    @Override
    public TlsSession getSessionToResume() {
        return null;
    }

    @Override
    public Vector getExternalPSKs() {
        return null;
    }

    @Override
    public boolean isFallback() {
        return false;
    }

    @Override
    public Hashtable getClientExtensions() throws IOException {
        byte[] clientConnectionID;
        short[] serverCertTypes;
        short[] clientCertTypes;
        Vector namedGroupRoles;
        Vector supportedGroups;
        ProtocolVersion clientVersion;
        Vector certificateAuthorities;
        CertificateStatusRequest statusRequest;
        Vector sniServerNames;
        Hashtable clientExtensions = new Hashtable();
        boolean offeringTLSv13Plus = false;
        boolean offeringPreTLSv13 = false;
        boolean offeringDTLSv12 = false;
        ProtocolVersion[] supportedVersions = this.getProtocolVersions();
        for (int i = 0; i < supportedVersions.length; ++i) {
            ProtocolVersion supportedVersion = supportedVersions[i];
            if (TlsUtils.isTLSv13(supportedVersion)) {
                offeringTLSv13Plus = true;
            } else {
                offeringPreTLSv13 = true;
            }
            offeringDTLSv12 |= ProtocolVersion.DTLSv12.equals(supportedVersion);
        }
        Vector protocolNames = this.getProtocolNames();
        if (protocolNames != null) {
            TlsExtensionsUtils.addALPNExtensionClient(clientExtensions, protocolNames);
        }
        if ((sniServerNames = this.getSNIServerNames()) != null) {
            TlsExtensionsUtils.addServerNameExtensionClient(clientExtensions, sniServerNames);
        }
        if ((statusRequest = this.getCertificateStatusRequest()) != null) {
            TlsExtensionsUtils.addStatusRequestExtension(clientExtensions, statusRequest);
        }
        if (offeringTLSv13Plus && (certificateAuthorities = this.getCertificateAuthorities()) != null) {
            TlsExtensionsUtils.addCertificateAuthoritiesExtension(clientExtensions, certificateAuthorities);
        }
        if (offeringPreTLSv13) {
            Vector trustedCAKeys;
            TlsExtensionsUtils.addEncryptThenMACExtension(clientExtensions);
            Vector statusRequestV2 = this.getMultiCertStatusRequest();
            if (statusRequestV2 != null) {
                TlsExtensionsUtils.addStatusRequestV2Extension(clientExtensions, statusRequestV2);
            }
            if ((trustedCAKeys = this.getTrustedCAIndication()) != null) {
                TlsExtensionsUtils.addTrustedCAKeysExtensionClient(clientExtensions, trustedCAKeys);
            }
        }
        if (TlsUtils.isSignatureAlgorithmsExtensionAllowed(clientVersion = this.context.getClientVersion())) {
            Vector supportedSigAlgsCert;
            Vector supportedSigAlgs = this.getSupportedSignatureAlgorithms();
            if (null != supportedSigAlgs && !supportedSigAlgs.isEmpty()) {
                this.supportedSignatureAlgorithms = supportedSigAlgs;
                TlsExtensionsUtils.addSignatureAlgorithmsExtension(clientExtensions, supportedSigAlgs);
            }
            if (null != (supportedSigAlgsCert = this.getSupportedSignatureAlgorithmsCert()) && !supportedSigAlgsCert.isEmpty()) {
                this.supportedSignatureAlgorithmsCert = supportedSigAlgsCert;
                TlsExtensionsUtils.addSignatureAlgorithmsCertExtension(clientExtensions, supportedSigAlgsCert);
            }
        }
        if ((supportedGroups = this.getSupportedGroups(namedGroupRoles = this.getNamedGroupRoles())) != null && !supportedGroups.isEmpty()) {
            this.supportedGroups = supportedGroups;
            TlsExtensionsUtils.addSupportedGroupsExtension(clientExtensions, supportedGroups);
        }
        if (offeringPreTLSv13 && (namedGroupRoles.contains(Integers.valueOf((int)2)) || namedGroupRoles.contains(Integers.valueOf((int)3)))) {
            TlsExtensionsUtils.addSupportedPointFormatsExtension(clientExtensions, new short[]{0});
        }
        if ((clientCertTypes = this.getAllowedClientCertificateTypes()) != null && (clientCertTypes.length > 1 || clientCertTypes[0] != 0)) {
            TlsExtensionsUtils.addClientCertificateTypeExtensionClient(clientExtensions, clientCertTypes);
        }
        if ((serverCertTypes = this.getAllowedServerCertificateTypes()) != null && (serverCertTypes.length > 1 || serverCertTypes[0] != 0)) {
            TlsExtensionsUtils.addServerCertificateTypeExtensionClient(clientExtensions, serverCertTypes);
        }
        if (offeringDTLSv12 && (clientConnectionID = this.getNewConnectionID()) != null) {
            TlsExtensionsUtils.addConnectionIDExtension(clientExtensions, clientConnectionID);
        }
        return clientExtensions;
    }

    @Override
    public Vector getEarlyKeyShareGroups() {
        if (null == this.supportedGroups || this.supportedGroups.isEmpty()) {
            return null;
        }
        if (this.supportedGroups.contains(Integers.valueOf((int)29))) {
            return TlsUtils.vectorOfOne(Integers.valueOf((int)29));
        }
        if (this.supportedGroups.contains(Integers.valueOf((int)23))) {
            return TlsUtils.vectorOfOne(Integers.valueOf((int)23));
        }
        return TlsUtils.vectorOfOne(this.supportedGroups.elementAt(0));
    }

    @Override
    public void notifyServerVersion(ProtocolVersion serverVersion) throws IOException {
    }

    @Override
    public void notifySessionToResume(TlsSession session) {
    }

    @Override
    public void notifySessionID(byte[] sessionID) {
    }

    @Override
    public void notifySelectedCipherSuite(int selectedCipherSuite) {
    }

    @Override
    public void notifySelectedPSK(TlsPSK selectedPSK) throws IOException {
    }

    @Override
    public void processServerExtensions(Hashtable serverExtensions) throws IOException {
        if (null == serverExtensions) {
            return;
        }
        SecurityParameters securityParameters = this.context.getSecurityParametersHandshake();
        boolean isTLSv13 = TlsUtils.isTLSv13(securityParameters.getNegotiatedVersion());
        if (!isTLSv13) {
            this.checkForUnexpectedServerExtension(serverExtensions, TlsExtensionsUtils.EXT_signature_algorithms);
            this.checkForUnexpectedServerExtension(serverExtensions, TlsExtensionsUtils.EXT_signature_algorithms_cert);
            this.checkForUnexpectedServerExtension(serverExtensions, TlsExtensionsUtils.EXT_supported_groups);
            int selectedCipherSuite = securityParameters.getCipherSuite();
            if (TlsECCUtils.isECCCipherSuite(selectedCipherSuite)) {
                TlsExtensionsUtils.getSupportedPointFormatsExtension(serverExtensions);
            } else {
                this.checkForUnexpectedServerExtension(serverExtensions, TlsExtensionsUtils.EXT_ec_point_formats);
            }
            this.checkForUnexpectedServerExtension(serverExtensions, TlsExtensionsUtils.EXT_padding);
        }
    }

    @Override
    public void processServerSupplementalData(Vector serverSupplementalData) throws IOException {
        if (serverSupplementalData != null) {
            throw new TlsFatalAlert(10);
        }
    }

    @Override
    public Vector getClientSupplementalData() throws IOException {
        return null;
    }

    @Override
    public void notifyNewSessionTicket(NewSessionTicket newSessionTicket) throws IOException {
    }
}

