/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls.crypto.impl;

import java.io.IOException;
import org.bouncycastle.tls.ProtocolVersion;
import org.bouncycastle.tls.TlsFatalAlert;
import org.bouncycastle.tls.TlsUtils;
import org.bouncycastle.tls.crypto.TlsCipher;
import org.bouncycastle.tls.crypto.TlsCryptoParameters;
import org.bouncycastle.tls.crypto.TlsDecodeResult;
import org.bouncycastle.tls.crypto.TlsEncodeResult;
import org.bouncycastle.tls.crypto.TlsHMAC;
import org.bouncycastle.tls.crypto.impl.TlsImplUtils;
import org.bouncycastle.tls.crypto.impl.TlsSuiteHMac;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class TlsNullCipher
implements TlsCipher {
    protected final TlsCryptoParameters cryptoParams;
    protected final TlsSuiteHMac readMac;
    protected final TlsSuiteHMac writeMac;

    public TlsNullCipher(TlsCryptoParameters cryptoParams, TlsHMAC clientMac, TlsHMAC serverMac) throws IOException {
        if (TlsImplUtils.isTLSv13(cryptoParams)) {
            throw new TlsFatalAlert(80);
        }
        this.cryptoParams = cryptoParams;
        int key_block_size = clientMac.getMacLength() + serverMac.getMacLength();
        byte[] key_block = TlsImplUtils.calculateKeyBlock(cryptoParams, key_block_size);
        int offset = 0;
        clientMac.setKey(key_block, offset, clientMac.getMacLength());
        serverMac.setKey(key_block, offset += clientMac.getMacLength(), serverMac.getMacLength());
        if ((offset += serverMac.getMacLength()) != key_block_size) {
            throw new TlsFatalAlert(80);
        }
        if (cryptoParams.isServer()) {
            this.writeMac = new TlsSuiteHMac(cryptoParams, serverMac);
            this.readMac = new TlsSuiteHMac(cryptoParams, clientMac);
        } else {
            this.writeMac = new TlsSuiteHMac(cryptoParams, clientMac);
            this.readMac = new TlsSuiteHMac(cryptoParams, serverMac);
        }
    }

    @Override
    public int getCiphertextDecodeLimit(int plaintextLimit) {
        return plaintextLimit + this.writeMac.getSize();
    }

    @Override
    public int getCiphertextEncodeLimit(int plaintextLength, int plaintextLimit) {
        return plaintextLength + this.writeMac.getSize();
    }

    @Override
    public int getPlaintextLimit(int ciphertextLimit) {
        return ciphertextLimit - this.writeMac.getSize();
    }

    @Override
    public TlsEncodeResult encodePlaintext(long seqNo, short contentType, ProtocolVersion recordVersion, int headerAllocation, byte[] plaintext, int offset, int len) throws IOException {
        byte[] mac = this.writeMac.calculateMac(seqNo, contentType, plaintext, offset, len);
        byte[] ciphertext = new byte[headerAllocation + len + mac.length];
        System.arraycopy(plaintext, offset, ciphertext, headerAllocation, len);
        System.arraycopy(mac, 0, ciphertext, headerAllocation + len, mac.length);
        return new TlsEncodeResult(ciphertext, 0, ciphertext.length, contentType);
    }

    @Override
    public TlsDecodeResult decodeCiphertext(long seqNo, short recordType, ProtocolVersion recordVersion, byte[] ciphertext, int offset, int len) throws IOException {
        boolean badMac;
        int macSize = this.readMac.getSize();
        if (len < macSize) {
            throw new TlsFatalAlert(50);
        }
        int macInputLen = len - macSize;
        byte[] expectedMac = this.readMac.calculateMac(seqNo, recordType, ciphertext, offset, macInputLen);
        boolean bl = badMac = !TlsUtils.constantTimeAreEqual(macSize, expectedMac, 0, ciphertext, offset + macInputLen);
        if (badMac) {
            throw new TlsFatalAlert(20);
        }
        return new TlsDecodeResult(ciphertext, offset, macInputLen, recordType);
    }

    @Override
    public void rekeyDecoder() throws IOException {
        throw new TlsFatalAlert(80);
    }

    @Override
    public void rekeyEncoder() throws IOException {
        throw new TlsFatalAlert(80);
    }

    @Override
    public boolean usesOpaqueRecordType() {
        return false;
    }
}

