/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls.crypto.impl.jcajce;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.PublicKey;
import org.bouncycastle.asn1.edec.EdECObjectIdentifiers;
import org.bouncycastle.tls.TlsFatalAlert;
import org.bouncycastle.tls.crypto.TlsAgreement;
import org.bouncycastle.tls.crypto.TlsCryptoException;
import org.bouncycastle.tls.crypto.TlsECDomain;
import org.bouncycastle.tls.crypto.impl.jcajce.Exceptions;
import org.bouncycastle.tls.crypto.impl.jcajce.JcaTlsCrypto;
import org.bouncycastle.tls.crypto.impl.jcajce.JceTlsSecret;
import org.bouncycastle.tls.crypto.impl.jcajce.JceX25519;
import org.bouncycastle.tls.crypto.impl.jcajce.XDHUtil;
import org.bouncycastle.util.Arrays;

public class JceX25519Domain
implements TlsECDomain {
    protected final JcaTlsCrypto crypto;

    public JceX25519Domain(JcaTlsCrypto crypto) {
        this.crypto = crypto;
    }

    public JceTlsSecret calculateECDHAgreement(PrivateKey privateKey, PublicKey publicKey) throws IOException {
        try {
            byte[] secret = this.crypto.calculateKeyAgreement("X25519", privateKey, publicKey, "TlsPremasterSecret");
            if (secret == null || secret.length != 32) {
                throw new TlsCryptoException("invalid secret calculated");
            }
            if (Arrays.areAllZeroes((byte[])secret, (int)0, (int)secret.length)) {
                throw new TlsFatalAlert(40);
            }
            return this.crypto.adoptLocalSecret(secret);
        }
        catch (GeneralSecurityException e) {
            throw new TlsCryptoException("cannot calculate secret", e);
        }
    }

    public TlsAgreement createECDH() {
        return new JceX25519(this);
    }

    public PublicKey decodePublicKey(byte[] encoding) throws IOException {
        return XDHUtil.decodePublicKey(this.crypto, "X25519", EdECObjectIdentifiers.id_X25519, encoding);
    }

    public byte[] encodePublicKey(PublicKey publicKey) throws IOException {
        return XDHUtil.encodePublicKey(publicKey);
    }

    public KeyPair generateKeyPair() {
        try {
            KeyPairGenerator keyPairGenerator = this.crypto.getHelper().createKeyPairGenerator("X25519");
            keyPairGenerator.initialize(255, this.crypto.getSecureRandom());
            return keyPairGenerator.generateKeyPair();
        }
        catch (GeneralSecurityException e) {
            throw Exceptions.illegalStateException("unable to create key pair: " + e.getMessage(), e);
        }
    }
}

