/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls.crypto.impl.bc;

import org.bouncycastle.crypto.AsymmetricBlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.digests.NullDigest;
import org.bouncycastle.crypto.encodings.PKCS1Encoding;
import org.bouncycastle.crypto.engines.RSABlindedEngine;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.crypto.params.RSAKeyParameters;
import org.bouncycastle.crypto.signers.GenericSigner;
import org.bouncycastle.crypto.signers.RSADigestSigner;
import org.bouncycastle.tls.DigitallySigned;
import org.bouncycastle.tls.SignatureAndHashAlgorithm;
import org.bouncycastle.tls.TlsUtils;
import org.bouncycastle.tls.crypto.impl.bc.BcTlsCrypto;
import org.bouncycastle.tls.crypto.impl.bc.BcTlsVerifier;

public class BcTlsRSAVerifier
extends BcTlsVerifier {
    public BcTlsRSAVerifier(BcTlsCrypto crypto, RSAKeyParameters publicKey) {
        super(crypto, (AsymmetricKeyParameter)publicKey);
    }

    public boolean verifyRawSignature(DigitallySigned digitallySigned, byte[] hash) {
        GenericSigner signer;
        NullDigest nullDigest = new NullDigest();
        SignatureAndHashAlgorithm algorithm = digitallySigned.getAlgorithm();
        if (algorithm != null) {
            if (algorithm.getSignature() != 1) {
                throw new IllegalStateException("Invalid algorithm: " + algorithm);
            }
            signer = new RSADigestSigner((Digest)nullDigest, TlsUtils.getOIDForHashAlgorithm(algorithm.getHash()));
        } else {
            signer = new GenericSigner((AsymmetricBlockCipher)new PKCS1Encoding((AsymmetricBlockCipher)new RSABlindedEngine()), (Digest)nullDigest);
        }
        signer.init(false, (CipherParameters)this.publicKey);
        signer.update(hash, 0, hash.length);
        return signer.verifySignature(digitallySigned.getSignature());
    }
}

