/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls;

import java.io.IOException;
import java.io.InterruptedIOException;
import org.bouncycastle.tls.DTLSRecordCallback;
import org.bouncycastle.tls.DTLSRecordLayer;
import org.bouncycastle.tls.DatagramTransport;
import org.bouncycastle.tls.TlsFatalAlert;
import org.bouncycastle.tls.TlsFatalAlertReceived;

public class DTLSTransport
implements DatagramTransport {
    private final DTLSRecordLayer recordLayer;

    DTLSTransport(DTLSRecordLayer recordLayer) {
        this.recordLayer = recordLayer;
    }

    public int getReceiveLimit() throws IOException {
        return this.recordLayer.getReceiveLimit();
    }

    public int getSendLimit() throws IOException {
        return this.recordLayer.getSendLimit();
    }

    public int receive(byte[] buf, int off, int len, int waitMillis) throws IOException {
        return this.receive(buf, off, len, waitMillis, null);
    }

    public int receive(byte[] buf, int off, int len, int waitMillis, DTLSRecordCallback recordCallback) throws IOException {
        if (null == buf) {
            throw new NullPointerException("'buf' cannot be null");
        }
        if (off < 0 || off >= buf.length) {
            throw new IllegalArgumentException("'off' is an invalid offset: " + off);
        }
        if (len < 0 || len > buf.length - off) {
            throw new IllegalArgumentException("'len' is an invalid length: " + len);
        }
        if (waitMillis < 0) {
            throw new IllegalArgumentException("'waitMillis' cannot be negative");
        }
        try {
            return this.recordLayer.receive(buf, off, len, waitMillis, recordCallback);
        }
        catch (TlsFatalAlertReceived fatalAlertReceived) {
            throw fatalAlertReceived;
        }
        catch (TlsFatalAlert fatalAlert) {
            if (20 == fatalAlert.getAlertDescription()) {
                return -1;
            }
            this.recordLayer.fail(fatalAlert.getAlertDescription());
            throw fatalAlert;
        }
        catch (InterruptedIOException e) {
            throw e;
        }
        catch (IOException e) {
            this.recordLayer.fail((short)80);
            throw e;
        }
        catch (RuntimeException e) {
            this.recordLayer.fail((short)80);
            throw new TlsFatalAlert(80, (Throwable)e);
        }
    }

    public int receivePending(byte[] buf, int off, int len) throws IOException {
        return this.receivePending(buf, off, len, null);
    }

    public int receivePending(byte[] buf, int off, int len, DTLSRecordCallback recordCallback) throws IOException {
        if (null == buf) {
            throw new NullPointerException("'buf' cannot be null");
        }
        if (off < 0 || off >= buf.length) {
            throw new IllegalArgumentException("'off' is an invalid offset: " + off);
        }
        if (len < 0 || len > buf.length - off) {
            throw new IllegalArgumentException("'len' is an invalid length: " + len);
        }
        try {
            return this.recordLayer.receivePending(buf, off, len, recordCallback);
        }
        catch (TlsFatalAlertReceived fatalAlertReceived) {
            throw fatalAlertReceived;
        }
        catch (TlsFatalAlert fatalAlert) {
            if (20 == fatalAlert.getAlertDescription()) {
                return -1;
            }
            this.recordLayer.fail(fatalAlert.getAlertDescription());
            throw fatalAlert;
        }
        catch (InterruptedIOException e) {
            throw e;
        }
        catch (IOException e) {
            this.recordLayer.fail((short)80);
            throw e;
        }
        catch (RuntimeException e) {
            this.recordLayer.fail((short)80);
            throw new TlsFatalAlert(80, (Throwable)e);
        }
    }

    public void send(byte[] buf, int off, int len) throws IOException {
        if (null == buf) {
            throw new NullPointerException("'buf' cannot be null");
        }
        if (off < 0 || off >= buf.length) {
            throw new IllegalArgumentException("'off' is an invalid offset: " + off);
        }
        if (len < 0 || len > buf.length - off) {
            throw new IllegalArgumentException("'len' is an invalid length: " + len);
        }
        try {
            this.recordLayer.send(buf, off, len);
        }
        catch (TlsFatalAlert fatalAlert) {
            this.recordLayer.fail(fatalAlert.getAlertDescription());
            throw fatalAlert;
        }
        catch (InterruptedIOException e) {
            throw e;
        }
        catch (IOException e) {
            this.recordLayer.fail((short)80);
            throw e;
        }
        catch (RuntimeException e) {
            this.recordLayer.fail((short)80);
            throw new TlsFatalAlert(80, (Throwable)e);
        }
    }

    public void close() throws IOException {
        this.recordLayer.close();
    }
}

