/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls.crypto.impl.bc;

import java.io.IOException;
import java.math.BigInteger;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.crypto.AsymmetricBlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.DSA;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.Signer;
import org.bouncycastle.crypto.engines.RSAEngine;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.crypto.params.DHPublicKeyParameters;
import org.bouncycastle.crypto.params.DSAPublicKeyParameters;
import org.bouncycastle.crypto.params.ECPublicKeyParameters;
import org.bouncycastle.crypto.params.Ed25519PublicKeyParameters;
import org.bouncycastle.crypto.params.Ed448PublicKeyParameters;
import org.bouncycastle.crypto.params.RSAKeyParameters;
import org.bouncycastle.crypto.signers.DSADigestSigner;
import org.bouncycastle.crypto.signers.ECDSASigner;
import org.bouncycastle.crypto.signers.Ed25519Signer;
import org.bouncycastle.crypto.signers.Ed448Signer;
import org.bouncycastle.crypto.signers.PSSSigner;
import org.bouncycastle.crypto.signers.RSADigestSigner;
import org.bouncycastle.crypto.util.PublicKeyFactory;
import org.bouncycastle.pqc.crypto.mldsa.MLDSAPublicKeyParameters;
import org.bouncycastle.pqc.crypto.mldsa.MLDSASigner;
import org.bouncycastle.tls.SignatureScheme;
import org.bouncycastle.tls.TlsFatalAlert;
import org.bouncycastle.tls.TlsUtils;
import org.bouncycastle.tls.crypto.Tls13Verifier;
import org.bouncycastle.tls.crypto.TlsCertificate;
import org.bouncycastle.tls.crypto.TlsCryptoUtils;
import org.bouncycastle.tls.crypto.TlsEncryptor;
import org.bouncycastle.tls.crypto.TlsVerifier;
import org.bouncycastle.tls.crypto.impl.LegacyTls13Verifier;
import org.bouncycastle.tls.crypto.impl.PQCUtil;
import org.bouncycastle.tls.crypto.impl.RSAUtil;
import org.bouncycastle.tls.crypto.impl.bc.BcTls13Verifier;
import org.bouncycastle.tls.crypto.impl.bc.BcTlsCrypto;
import org.bouncycastle.tls.crypto.impl.bc.BcTlsDSAVerifier;
import org.bouncycastle.tls.crypto.impl.bc.BcTlsECDSAVerifier;
import org.bouncycastle.tls.crypto.impl.bc.BcTlsRSAEncryptor;
import org.bouncycastle.tls.crypto.impl.bc.BcTlsRSAPSSVerifier;
import org.bouncycastle.tls.crypto.impl.bc.BcTlsRSAVerifier;

public class BcTlsRawKeyCertificate
implements TlsCertificate {
    protected final BcTlsCrypto crypto;
    protected final SubjectPublicKeyInfo keyInfo;
    protected DHPublicKeyParameters pubKeyDH = null;
    protected ECPublicKeyParameters pubKeyEC = null;
    protected Ed25519PublicKeyParameters pubKeyEd25519 = null;
    protected Ed448PublicKeyParameters pubKeyEd448 = null;
    protected RSAKeyParameters pubKeyRSA = null;

    public BcTlsRawKeyCertificate(BcTlsCrypto crypto, byte[] keyInfo) {
        this(crypto, SubjectPublicKeyInfo.getInstance((Object)keyInfo));
    }

    public BcTlsRawKeyCertificate(BcTlsCrypto crypto, SubjectPublicKeyInfo keyInfo) {
        this.crypto = crypto;
        this.keyInfo = keyInfo;
    }

    public SubjectPublicKeyInfo getSubjectPublicKeyInfo() {
        return this.keyInfo;
    }

    public TlsEncryptor createEncryptor(int tlsCertificateRole) throws IOException {
        this.validateKeyUsage(32);
        switch (tlsCertificateRole) {
            case 3: {
                this.pubKeyRSA = this.getPubKeyRSA();
                return new BcTlsRSAEncryptor(this.crypto, this.pubKeyRSA);
            }
        }
        throw new TlsFatalAlert(80);
    }

    public TlsVerifier createVerifier(short signatureAlgorithm) throws IOException {
        switch (signatureAlgorithm) {
            case 7: 
            case 8: {
                int signatureScheme = SignatureScheme.from((short)8, signatureAlgorithm);
                Tls13Verifier tls13Verifier = this.createVerifier(signatureScheme);
                return new LegacyTls13Verifier(signatureScheme, tls13Verifier);
            }
        }
        this.validateKeyUsage(128);
        switch (signatureAlgorithm) {
            case 2: {
                return new BcTlsDSAVerifier(this.crypto, this.getPubKeyDSS());
            }
            case 3: {
                return new BcTlsECDSAVerifier(this.crypto, this.getPubKeyEC());
            }
            case 1: {
                this.validateRSA_PKCS1();
                return new BcTlsRSAVerifier(this.crypto, this.getPubKeyRSA());
            }
            case 9: 
            case 10: 
            case 11: {
                this.validateRSA_PSS_PSS(signatureAlgorithm);
                int signatureScheme = SignatureScheme.from((short)8, signatureAlgorithm);
                return new BcTlsRSAPSSVerifier(this.crypto, this.getPubKeyRSA(), signatureScheme);
            }
            case 4: 
            case 5: 
            case 6: {
                this.validateRSA_PSS_RSAE();
                int signatureScheme = SignatureScheme.from((short)8, signatureAlgorithm);
                return new BcTlsRSAPSSVerifier(this.crypto, this.getPubKeyRSA(), signatureScheme);
            }
        }
        throw new TlsFatalAlert(80);
    }

    public Tls13Verifier createVerifier(int signatureScheme) throws IOException {
        this.validateKeyUsage(128);
        switch (signatureScheme) {
            case 515: 
            case 1027: 
            case 1283: 
            case 1539: 
            case 2074: 
            case 2075: 
            case 2076: {
                int cryptoHashAlgorithm = SignatureScheme.getCryptoHashAlgorithm(signatureScheme);
                Digest digest = this.crypto.createDigest(cryptoHashAlgorithm);
                DSADigestSigner verifier = new DSADigestSigner((DSA)new ECDSASigner(), digest);
                verifier.init(false, (CipherParameters)this.getPubKeyEC());
                return new BcTls13Verifier((Signer)verifier);
            }
            case 2055: {
                Ed25519Signer verifier = new Ed25519Signer();
                verifier.init(false, (CipherParameters)this.getPubKeyEd25519());
                return new BcTls13Verifier((Signer)verifier);
            }
            case 2056: {
                Ed448Signer verifier = new Ed448Signer(TlsUtils.EMPTY_BYTES);
                verifier.init(false, (CipherParameters)this.getPubKeyEd448());
                return new BcTls13Verifier((Signer)verifier);
            }
            case 513: 
            case 1025: 
            case 1281: 
            case 1537: {
                this.validateRSA_PKCS1();
                int cryptoHashAlgorithm = SignatureScheme.getCryptoHashAlgorithm(signatureScheme);
                Digest digest = this.crypto.createDigest(cryptoHashAlgorithm);
                RSADigestSigner verifier = new RSADigestSigner(digest, TlsCryptoUtils.getOIDForHash(cryptoHashAlgorithm));
                verifier.init(false, (CipherParameters)this.getPubKeyRSA());
                return new BcTls13Verifier((Signer)verifier);
            }
            case 2057: 
            case 2058: 
            case 2059: {
                this.validateRSA_PSS_PSS(SignatureScheme.getSignatureAlgorithm(signatureScheme));
                int cryptoHashAlgorithm = SignatureScheme.getCryptoHashAlgorithm(signatureScheme);
                Digest digest = this.crypto.createDigest(cryptoHashAlgorithm);
                PSSSigner verifier = new PSSSigner((AsymmetricBlockCipher)new RSAEngine(), digest, digest.getDigestSize());
                verifier.init(false, (CipherParameters)this.getPubKeyRSA());
                return new BcTls13Verifier((Signer)verifier);
            }
            case 2052: 
            case 2053: 
            case 2054: {
                this.validateRSA_PSS_RSAE();
                int cryptoHashAlgorithm = SignatureScheme.getCryptoHashAlgorithm(signatureScheme);
                Digest digest = this.crypto.createDigest(cryptoHashAlgorithm);
                PSSSigner verifier = new PSSSigner((AsymmetricBlockCipher)new RSAEngine(), digest, digest.getDigestSize());
                verifier.init(false, (CipherParameters)this.getPubKeyRSA());
                return new BcTls13Verifier((Signer)verifier);
            }
            case 2308: 
            case 2309: 
            case 2310: {
                ASN1ObjectIdentifier mlDsaAlgOid = PQCUtil.getMLDSAObjectidentifier(signatureScheme);
                this.validateMLDSA(mlDsaAlgOid);
                MLDSAPublicKeyParameters publicKey = this.getPubKeyMLDSA();
                MLDSASigner verifier = new MLDSASigner();
                verifier.init(false, (CipherParameters)publicKey);
                return new BcTls13Verifier((Signer)verifier);
            }
        }
        throw new TlsFatalAlert(80);
    }

    public byte[] getEncoded() throws IOException {
        return this.keyInfo.getEncoded("DER");
    }

    public byte[] getExtension(ASN1ObjectIdentifier extensionOID) throws IOException {
        return null;
    }

    public BigInteger getSerialNumber() {
        return null;
    }

    public String getSigAlgOID() {
        return null;
    }

    public ASN1Encodable getSigAlgParams() {
        return null;
    }

    public short getLegacySignatureAlgorithm() throws IOException {
        AsymmetricKeyParameter publicKey = this.getPublicKey();
        if (publicKey.isPrivate()) {
            throw new TlsFatalAlert(80);
        }
        if (!this.supportsKeyUsage(128)) {
            return -1;
        }
        if (publicKey instanceof RSAKeyParameters) {
            return 1;
        }
        if (publicKey instanceof DSAPublicKeyParameters) {
            return 2;
        }
        if (publicKey instanceof ECPublicKeyParameters) {
            return 3;
        }
        return -1;
    }

    public DHPublicKeyParameters getPubKeyDH() throws IOException {
        try {
            return (DHPublicKeyParameters)this.getPublicKey();
        }
        catch (ClassCastException e) {
            throw new TlsFatalAlert(46, "Public key not DH", e);
        }
    }

    public DSAPublicKeyParameters getPubKeyDSS() throws IOException {
        try {
            return (DSAPublicKeyParameters)this.getPublicKey();
        }
        catch (ClassCastException e) {
            throw new TlsFatalAlert(46, "Public key not DSS", e);
        }
    }

    public ECPublicKeyParameters getPubKeyEC() throws IOException {
        try {
            return (ECPublicKeyParameters)this.getPublicKey();
        }
        catch (ClassCastException e) {
            throw new TlsFatalAlert(46, "Public key not EC", e);
        }
    }

    public Ed25519PublicKeyParameters getPubKeyEd25519() throws IOException {
        try {
            return (Ed25519PublicKeyParameters)this.getPublicKey();
        }
        catch (ClassCastException e) {
            throw new TlsFatalAlert(46, "Public key not Ed25519", e);
        }
    }

    public Ed448PublicKeyParameters getPubKeyEd448() throws IOException {
        try {
            return (Ed448PublicKeyParameters)this.getPublicKey();
        }
        catch (ClassCastException e) {
            throw new TlsFatalAlert(46, "Public key not Ed448", e);
        }
    }

    public MLDSAPublicKeyParameters getPubKeyMLDSA() throws IOException {
        try {
            return (MLDSAPublicKeyParameters)this.getPublicKey();
        }
        catch (ClassCastException e) {
            throw new TlsFatalAlert(46, "Public key not ML-DSA", e);
        }
    }

    public RSAKeyParameters getPubKeyRSA() throws IOException {
        try {
            return (RSAKeyParameters)this.getPublicKey();
        }
        catch (ClassCastException e) {
            throw new TlsFatalAlert(46, "Public key not RSA", e);
        }
    }

    public boolean supportsSignatureAlgorithm(short signatureAlgorithm) throws IOException {
        return this.supportsSignatureAlgorithm(signatureAlgorithm, 128);
    }

    public boolean supportsSignatureAlgorithmCA(short signatureAlgorithm) throws IOException {
        return this.supportsSignatureAlgorithm(signatureAlgorithm, 4);
    }

    public TlsCertificate checkUsageInRole(int tlsCertificateRole) throws IOException {
        switch (tlsCertificateRole) {
            case 1: {
                this.validateKeyUsage(8);
                this.pubKeyDH = this.getPubKeyDH();
                return this;
            }
            case 2: {
                this.validateKeyUsage(8);
                this.pubKeyEC = this.getPubKeyEC();
                return this;
            }
        }
        throw new TlsFatalAlert(80);
    }

    protected AsymmetricKeyParameter getPublicKey() throws IOException {
        try {
            return PublicKeyFactory.createKey((SubjectPublicKeyInfo)this.keyInfo);
        }
        catch (RuntimeException e) {
            throw new TlsFatalAlert(43, (Throwable)e);
        }
    }

    protected boolean supportsKeyUsage(int keyUsageBit) {
        return true;
    }

    protected boolean supportsMLDSA(ASN1ObjectIdentifier mlDsaAlgOid) {
        AlgorithmIdentifier pubKeyAlgID = this.keyInfo.getAlgorithm();
        return PQCUtil.supportsMLDSA(pubKeyAlgID, mlDsaAlgOid);
    }

    protected boolean supportsRSA_PKCS1() {
        AlgorithmIdentifier pubKeyAlgID = this.keyInfo.getAlgorithm();
        return RSAUtil.supportsPKCS1(pubKeyAlgID);
    }

    protected boolean supportsRSA_PSS_PSS(short signatureAlgorithm) {
        AlgorithmIdentifier pubKeyAlgID = this.keyInfo.getAlgorithm();
        return RSAUtil.supportsPSS_PSS(signatureAlgorithm, pubKeyAlgID);
    }

    protected boolean supportsRSA_PSS_RSAE() {
        AlgorithmIdentifier pubKeyAlgID = this.keyInfo.getAlgorithm();
        return RSAUtil.supportsPSS_RSAE(pubKeyAlgID);
    }

    protected boolean supportsSignatureAlgorithm(short signatureAlgorithm, int keyUsage) throws IOException {
        if (!this.supportsKeyUsage(keyUsage)) {
            return false;
        }
        AsymmetricKeyParameter publicKey = this.getPublicKey();
        switch (signatureAlgorithm) {
            case 1: {
                return this.supportsRSA_PKCS1() && publicKey instanceof RSAKeyParameters;
            }
            case 2: {
                return publicKey instanceof DSAPublicKeyParameters;
            }
            case 3: 
            case 26: 
            case 27: 
            case 28: {
                return publicKey instanceof ECPublicKeyParameters;
            }
            case 7: {
                return publicKey instanceof Ed25519PublicKeyParameters;
            }
            case 8: {
                return publicKey instanceof Ed448PublicKeyParameters;
            }
            case 4: 
            case 5: 
            case 6: {
                return this.supportsRSA_PSS_RSAE() && publicKey instanceof RSAKeyParameters;
            }
            case 9: 
            case 10: 
            case 11: {
                return this.supportsRSA_PSS_PSS(signatureAlgorithm) && publicKey instanceof RSAKeyParameters;
            }
        }
        return false;
    }

    public void validateKeyUsage(int keyUsageBit) throws IOException {
        if (!this.supportsKeyUsage(keyUsageBit)) {
            switch (keyUsageBit) {
                case 128: {
                    throw new TlsFatalAlert(46, "KeyUsage does not allow digital signatures");
                }
                case 8: {
                    throw new TlsFatalAlert(46, "KeyUsage does not allow key agreement");
                }
                case 32: {
                    throw new TlsFatalAlert(46, "KeyUsage does not allow key encipherment");
                }
            }
            throw new TlsFatalAlert(80);
        }
    }

    protected void validateMLDSA(ASN1ObjectIdentifier mlDsaAlgOid) throws IOException {
        if (!this.supportsMLDSA(mlDsaAlgOid)) {
            throw new TlsFatalAlert(46, "No support for ML-DSA signature scheme");
        }
    }

    protected void validateRSA_PKCS1() throws IOException {
        if (!this.supportsRSA_PKCS1()) {
            throw new TlsFatalAlert(46, "No support for rsa_pkcs1 signature schemes");
        }
    }

    protected void validateRSA_PSS_PSS(short signatureAlgorithm) throws IOException {
        if (!this.supportsRSA_PSS_PSS(signatureAlgorithm)) {
            throw new TlsFatalAlert(46, "No support for rsa_pss_pss signature schemes");
        }
    }

    protected void validateRSA_PSS_RSAE() throws IOException {
        if (!this.supportsRSA_PSS_RSAE()) {
            throw new TlsFatalAlert(46, "No support for rsa_pss_rsae signature schemes");
        }
    }
}

