/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls.crypto.impl.bc;

import java.io.IOException;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.InvalidCipherTextException;
import org.bouncycastle.crypto.modes.AEADBlockCipher;
import org.bouncycastle.crypto.params.AEADParameters;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.tls.TlsFatalAlert;
import org.bouncycastle.tls.crypto.impl.TlsAEADCipherImpl;
import org.bouncycastle.util.Arrays;

final class BcTlsAEADCipherImpl
implements TlsAEADCipherImpl {
    private final boolean isEncrypting;
    private final AEADBlockCipher cipher;
    private KeyParameter key;

    BcTlsAEADCipherImpl(AEADBlockCipher cipher, boolean isEncrypting) {
        this.cipher = cipher;
        this.isEncrypting = isEncrypting;
    }

    public void setKey(byte[] key, int keyOff, int keyLen) {
        this.key = new KeyParameter(key, keyOff, keyLen);
    }

    public void init(byte[] nonce, int macSize) {
        this.cipher.init(this.isEncrypting, (CipherParameters)new AEADParameters(this.key, macSize * 8, nonce, null));
    }

    public int getOutputSize(int inputLength) {
        return this.cipher.getOutputSize(inputLength);
    }

    public int doFinal(byte[] additionalData, byte[] input, int inputOffset, int inputLength, byte[] output, int outputOffset) throws IOException {
        if (!Arrays.isNullOrEmpty((byte[])additionalData)) {
            this.cipher.processAADBytes(additionalData, 0, additionalData.length);
        }
        int len = this.cipher.processBytes(input, inputOffset, inputLength, output, outputOffset);
        try {
            len += this.cipher.doFinal(output, outputOffset + len);
        }
        catch (InvalidCipherTextException e) {
            throw new TlsFatalAlert(20, (Throwable)e);
        }
        return len;
    }
}

