/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.crypto.picnic;

import org.bouncycastle.pqc.crypto.picnic.KMatricesWithPointer;
import org.bouncycastle.pqc.crypto.picnic.PicnicEngine;
import org.bouncycastle.pqc.crypto.picnic.Utils;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.Pack;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
class Tape {
    byte[][] tapes;
    int pos;
    int nTapes;
    private PicnicEngine engine;

    public Tape(PicnicEngine engine) {
        this.engine = engine;
        this.tapes = new byte[engine.numMPCParties][2 * engine.andSizeBytes];
        this.pos = 0;
        this.nTapes = engine.numMPCParties;
    }

    protected void setAuxBits(byte[] input) {
        int last = this.engine.numMPCParties - 1;
        int pos = 0;
        int n = this.engine.stateSizeBits;
        for (int j = 0; j < this.engine.numRounds; ++j) {
            for (int i = 0; i < n; ++i) {
                Utils.setBit(this.tapes[last], n + n * 2 * j + i, Utils.getBit(input, pos++));
            }
        }
    }

    protected void computeAuxTape(byte[] inputs) {
        int[] roundKey = new int[16];
        int[] x = new int[16];
        int[] y = new int[16];
        int[] key = new int[16];
        int[] key0 = new int[16];
        key0[this.engine.stateSizeWords - 1] = 0;
        this.tapesToParityBits(key0, this.engine.stateSizeBits);
        KMatricesWithPointer current = this.engine.lowmcConstants.KMatrixInv(this.engine);
        this.engine.matrix_mul(key, key0, current.getData(), current.getMatrixPointer());
        if (inputs != null) {
            Pack.intToLittleEndian(Arrays.copyOf(key, this.engine.stateSizeWords), inputs, 0);
        }
        for (int r = this.engine.numRounds; r > 0; --r) {
            current = this.engine.lowmcConstants.KMatrix(this.engine, r);
            this.engine.matrix_mul(roundKey, key, current.getData(), current.getMatrixPointer());
            this.engine.xor_array(x, x, roundKey, 0, this.engine.stateSizeWords);
            current = this.engine.lowmcConstants.LMatrixInv(this.engine, r - 1);
            this.engine.matrix_mul(y, x, current.getData(), current.getMatrixPointer());
            if (r == 1) {
                System.arraycopy(key0, 0, x, 0, key0.length);
            } else {
                this.pos = this.engine.stateSizeBits * 2 * (r - 1);
                this.tapesToParityBits(x, this.engine.stateSizeBits);
            }
            this.pos = this.engine.stateSizeBits * 2 * (r - 1) + this.engine.stateSizeBits;
            this.engine.aux_mpc_sbox(x, y, this);
        }
        this.pos = 0;
    }

    private void tapesToParityBits(int[] output, int outputBitLen) {
        for (int i = 0; i < outputBitLen; ++i) {
            Utils.setBitInWordArray(output, i, Utils.parity16(this.tapesToWord()));
        }
    }

    protected int tapesToWord() {
        int shares = 0;
        int arrayPos = this.pos >>> 3;
        int bitPos = this.pos & 7 ^ 7;
        int bitMask = 1 << bitPos;
        shares |= (this.tapes[0][arrayPos] & bitMask) << 7;
        shares |= (this.tapes[1][arrayPos] & bitMask) << 6;
        shares |= (this.tapes[2][arrayPos] & bitMask) << 5;
        shares |= (this.tapes[3][arrayPos] & bitMask) << 4;
        shares |= (this.tapes[4][arrayPos] & bitMask) << 3;
        shares |= (this.tapes[5][arrayPos] & bitMask) << 2;
        shares |= (this.tapes[6][arrayPos] & bitMask) << 1;
        shares |= (this.tapes[7][arrayPos] & bitMask) << 0;
        shares |= (this.tapes[8][arrayPos] & bitMask) << 15;
        shares |= (this.tapes[9][arrayPos] & bitMask) << 14;
        shares |= (this.tapes[10][arrayPos] & bitMask) << 13;
        shares |= (this.tapes[11][arrayPos] & bitMask) << 12;
        shares |= (this.tapes[12][arrayPos] & bitMask) << 11;
        shares |= (this.tapes[13][arrayPos] & bitMask) << 10;
        shares |= (this.tapes[14][arrayPos] & bitMask) << 9;
        ++this.pos;
        return (shares |= (this.tapes[15][arrayPos] & bitMask) << 8) >>> bitPos;
    }
}

