/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.engines;

import java.io.ByteArrayOutputStream;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.CryptoServicesRegistrar;
import org.bouncycastle.crypto.DataLengthException;
import org.bouncycastle.crypto.InvalidCipherTextException;
import org.bouncycastle.crypto.OutputLengthException;
import org.bouncycastle.crypto.constraints.DefaultServiceProperties;
import org.bouncycastle.crypto.engines.Utils;
import org.bouncycastle.crypto.modes.AEADCipher;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.ParametersWithIV;
import org.bouncycastle.util.Pack;

public class SparkleEngine
implements AEADCipher {
    private String algorithmName;
    private boolean forEncryption;
    private final int[] state;
    private final int[] k;
    private final int[] npub;
    private byte[] tag;
    private boolean initialised;
    private boolean encrypted;
    private boolean aadFinished;
    private final ByteArrayOutputStream aadData = new ByteArrayOutputStream();
    private final ByteArrayOutputStream message = new ByteArrayOutputStream();
    private final int SCHWAEMM_KEY_LEN;
    private final int SCHWAEMM_NONCE_LEN;
    private final int SPARKLE_STEPS_SLIM;
    private final int SPARKLE_STEPS_BIG;
    private final int KEY_WORDS;
    private final int KEY_BYTES;
    private final int TAG_WORDS;
    private final int TAG_BYTES;
    private final int STATE_BRANS;
    private final int STATE_WORDS;
    private final int RATE_WORDS;
    private final int RATE_BYTES;
    private final int CAP_WORDS;
    private final int _A0;
    private final int _A1;
    private final int _M2;
    private final int _M3;
    private static final int[] RCON = new int[]{-1209970334, -1083090816, 951376470, 844003128, -1156479509, 1333558103, -809524792, -1028445891};

    public SparkleEngine(SparkleParameters sparkleParameters) {
        int SPARKLE_CAPACITY;
        int SPARKLE_STATE;
        int SCHWAEMM_TAG_LEN;
        switch (sparkleParameters) {
            case SCHWAEMM128_128: {
                this.SCHWAEMM_KEY_LEN = 128;
                this.SCHWAEMM_NONCE_LEN = 128;
                SCHWAEMM_TAG_LEN = 128;
                SPARKLE_STATE = 256;
                SPARKLE_CAPACITY = 128;
                this.SPARKLE_STEPS_SLIM = 7;
                this.SPARKLE_STEPS_BIG = 10;
                this.algorithmName = "SCHWAEMM128-128";
                break;
            }
            case SCHWAEMM256_128: {
                this.SCHWAEMM_KEY_LEN = 128;
                this.SCHWAEMM_NONCE_LEN = 256;
                SCHWAEMM_TAG_LEN = 128;
                SPARKLE_STATE = 384;
                SPARKLE_CAPACITY = 128;
                this.SPARKLE_STEPS_SLIM = 7;
                this.SPARKLE_STEPS_BIG = 11;
                this.algorithmName = "SCHWAEMM256-128";
                break;
            }
            case SCHWAEMM192_192: {
                this.SCHWAEMM_KEY_LEN = 192;
                this.SCHWAEMM_NONCE_LEN = 192;
                SCHWAEMM_TAG_LEN = 192;
                SPARKLE_STATE = 384;
                SPARKLE_CAPACITY = 192;
                this.SPARKLE_STEPS_SLIM = 7;
                this.SPARKLE_STEPS_BIG = 11;
                this.algorithmName = "SCHWAEMM192-192";
                break;
            }
            case SCHWAEMM256_256: {
                this.SCHWAEMM_KEY_LEN = 256;
                this.SCHWAEMM_NONCE_LEN = 256;
                SCHWAEMM_TAG_LEN = 256;
                SPARKLE_STATE = 512;
                SPARKLE_CAPACITY = 256;
                this.SPARKLE_STEPS_SLIM = 8;
                this.SPARKLE_STEPS_BIG = 12;
                this.algorithmName = "SCHWAEMM256-256";
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid definition of SCHWAEMM instance");
            }
        }
        this.KEY_WORDS = this.SCHWAEMM_KEY_LEN >>> 5;
        this.KEY_BYTES = this.SCHWAEMM_KEY_LEN >>> 3;
        this.TAG_WORDS = SCHWAEMM_TAG_LEN >>> 5;
        this.TAG_BYTES = SCHWAEMM_TAG_LEN >>> 3;
        this.STATE_BRANS = SPARKLE_STATE >>> 6;
        this.STATE_WORDS = SPARKLE_STATE >>> 5;
        this.RATE_WORDS = this.SCHWAEMM_NONCE_LEN >>> 5;
        this.RATE_BYTES = this.SCHWAEMM_NONCE_LEN >>> 3;
        int CAP_BRANS = SPARKLE_CAPACITY >>> 6;
        this.CAP_WORDS = SPARKLE_CAPACITY >>> 5;
        this._A0 = 1 << CAP_BRANS << 24;
        this._A1 = (1 ^ 1 << CAP_BRANS) << 24;
        this._M2 = (2 ^ 1 << CAP_BRANS) << 24;
        this._M3 = (3 ^ 1 << CAP_BRANS) << 24;
        this.state = new int[this.STATE_WORDS];
        this.k = new int[this.KEY_WORDS];
        this.npub = new int[this.RATE_WORDS];
        this.initialised = false;
    }

    private int ROT(int x, int n) {
        return x >>> n | x << 32 - n;
    }

    private int ELL(int x) {
        return this.ROT(x ^ x << 16, 16);
    }

    void sparkle_opt(int[] state, int brans, int steps) {
        for (int i = 0; i < steps; ++i) {
            int y0;
            int x0;
            int j;
            state[1] = state[1] ^ RCON[i & 7];
            state[3] = state[3] ^ i;
            for (j = 0; j < 2 * brans; j += 2) {
                int rc = RCON[j >>> 1];
                int n = j;
                state[n] = state[n] + this.ROT(state[j + 1], 31);
                int n2 = j + 1;
                state[n2] = state[n2] ^ this.ROT(state[j], 24);
                int n3 = j;
                state[n3] = state[n3] ^ rc;
                int n4 = j;
                state[n4] = state[n4] + this.ROT(state[j + 1], 17);
                int n5 = j + 1;
                state[n5] = state[n5] ^ this.ROT(state[j], 17);
                int n6 = j;
                state[n6] = state[n6] ^ rc;
                int n7 = j;
                state[n7] = state[n7] + state[j + 1];
                int n8 = j + 1;
                state[n8] = state[n8] ^ this.ROT(state[j], 31);
                int n9 = j;
                state[n9] = state[n9] ^ rc;
                int n10 = j;
                state[n10] = state[n10] + this.ROT(state[j + 1], 24);
                int n11 = j + 1;
                state[n11] = state[n11] ^ this.ROT(state[j], 16);
                int n12 = j;
                state[n12] = state[n12] ^ rc;
            }
            int tmpx = x0 = state[0];
            int tmpy = y0 = state[1];
            for (j = 2; j < brans; j += 2) {
                tmpx ^= state[j];
                tmpy ^= state[j + 1];
            }
            tmpx = this.ELL(tmpx);
            tmpy = this.ELL(tmpy);
            for (j = 2; j < brans; j += 2) {
                state[j - 2] = state[j + brans] ^ state[j] ^ tmpy;
                state[j + brans] = state[j];
                state[j - 1] = state[j + brans + 1] ^ state[j + 1] ^ tmpx;
                state[j + brans + 1] = state[j + 1];
            }
            state[brans - 2] = state[brans] ^ x0 ^ tmpy;
            state[brans] = x0;
            state[brans - 1] = state[brans + 1] ^ y0 ^ tmpx;
            state[brans + 1] = y0;
        }
    }

    private int CAP_INDEX(int i) {
        if (this.RATE_WORDS > this.CAP_WORDS) {
            return i & this.CAP_WORDS - 1;
        }
        return i;
    }

    void ProcessAssocData(int[] state) {
        int tmp;
        int j;
        int i;
        int inlen = this.aadData.size();
        if (this.aadFinished || inlen == 0) {
            return;
        }
        this.aadFinished = true;
        byte[] in = this.aadData.toByteArray();
        int inOff = 0;
        int[] in32 = Pack.littleEndianToInt(in, inOff, in.length >>> 2);
        while (inlen > this.RATE_BYTES) {
            i = 0;
            j = this.RATE_WORDS / 2;
            while (i < this.RATE_WORDS / 2) {
                tmp = state[i];
                state[i] = state[j] ^ in32[i + (inOff >> 2)] ^ state[this.RATE_WORDS + i];
                int n = j;
                state[n] = state[n] ^ (tmp ^ in32[j + (inOff >> 2)] ^ state[this.RATE_WORDS + this.CAP_INDEX(j)]);
                ++i;
                ++j;
            }
            this.sparkle_opt(state, this.STATE_BRANS, this.SPARKLE_STEPS_SLIM);
            inlen -= this.RATE_BYTES;
            inOff += this.RATE_BYTES;
        }
        int n = this.STATE_WORDS - 1;
        state[n] = state[n] ^ (inlen < this.RATE_BYTES ? this._A0 : this._A1);
        int[] buffer = new int[this.RATE_WORDS];
        for (i = 0; i < inlen; ++i) {
            int n2 = i >>> 2;
            buffer[n2] = buffer[n2] | in[inOff++] << ((i & 3) << 3);
        }
        if (inlen < this.RATE_BYTES) {
            int n3 = i >>> 2;
            buffer[n3] = buffer[n3] | 128 << ((i & 3) << 3);
        }
        i = 0;
        j = this.RATE_WORDS / 2;
        while (i < this.RATE_WORDS / 2) {
            tmp = state[i];
            state[i] = state[j] ^ buffer[i] ^ state[this.RATE_WORDS + i];
            int n4 = j;
            state[n4] = state[n4] ^ (tmp ^ buffer[j] ^ state[this.RATE_WORDS + this.CAP_INDEX(j)]);
            ++i;
            ++j;
        }
        this.sparkle_opt(state, this.STATE_BRANS, this.SPARKLE_STEPS_BIG);
    }

    private int ProcessPlainText(int[] state, byte[] output, byte[] input, int inOff, int inlen) {
        int outOff = 0;
        int[] in32 = Pack.littleEndianToInt(input, inOff, input.length >>> 2);
        int[] out32 = new int[output.length >>> 2];
        int rv = 0;
        while (inlen > this.RATE_BYTES) {
            int i = 0;
            int j = this.RATE_WORDS / 2;
            while (i < this.RATE_WORDS / 2) {
                int tmp1 = state[i];
                int tmp2 = state[j];
                if (this.forEncryption) {
                    state[i] = state[j] ^ in32[i + (inOff >> 2)] ^ state[this.RATE_WORDS + i];
                    int n = j;
                    state[n] = state[n] ^ (tmp1 ^ in32[j + (inOff >> 2)] ^ state[this.RATE_WORDS + this.CAP_INDEX(j)]);
                } else {
                    int n = i;
                    state[n] = state[n] ^ (state[j] ^ in32[i + (inOff >> 2)] ^ state[this.RATE_WORDS + i]);
                    state[j] = tmp1 ^ in32[j + (inOff >> 2)] ^ state[this.RATE_WORDS + this.CAP_INDEX(j)];
                }
                out32[i] = in32[i] ^ tmp1;
                out32[j] = in32[j] ^ tmp2;
                ++i;
                ++j;
            }
            Pack.intToLittleEndian(out32, 0, this.RATE_WORDS, output, outOff);
            this.sparkle_opt(state, this.STATE_BRANS, this.SPARKLE_STEPS_SLIM);
            inlen -= this.RATE_BYTES;
            outOff += this.RATE_BYTES;
            inOff += this.RATE_BYTES;
            rv += this.RATE_BYTES;
            this.encrypted = true;
        }
        return rv;
    }

    @Override
    public void init(boolean forEncryption, CipherParameters params) throws IllegalArgumentException {
        this.forEncryption = forEncryption;
        if (!(params instanceof ParametersWithIV)) {
            throw new IllegalArgumentException(this.algorithmName + " init parameters must include an IV");
        }
        ParametersWithIV ivParams = (ParametersWithIV)params;
        byte[] iv = ivParams.getIV();
        if (iv == null || iv.length != this.RATE_BYTES) {
            throw new IllegalArgumentException(this.algorithmName + " requires exactly " + this.RATE_BYTES + " bytes of IV");
        }
        Pack.littleEndianToInt(iv, 0, this.npub, 0, this.RATE_WORDS);
        if (!(ivParams.getParameters() instanceof KeyParameter)) {
            throw new IllegalArgumentException(this.algorithmName + " init parameters must include a key");
        }
        KeyParameter key = (KeyParameter)ivParams.getParameters();
        byte[] key8 = key.getKey();
        if (key8.length != this.KEY_BYTES) {
            throw new IllegalArgumentException(this.algorithmName + " key must be " + this.KEY_BYTES + " bits long");
        }
        Pack.littleEndianToInt(key8, 0, this.k, 0, this.KEY_WORDS);
        CryptoServicesRegistrar.checkConstraints(new DefaultServiceProperties(this.getAlgorithmName(), 128, params, Utils.getPurpose(forEncryption)));
        this.initialised = true;
        this.reset();
    }

    @Override
    public String getAlgorithmName() {
        return this.algorithmName;
    }

    @Override
    public void processAADByte(byte input) {
        if (this.encrypted) {
            throw new IllegalArgumentException(this.algorithmName + ": AAD cannot be added after reading a full block(" + this.getBlockSize() + " bytes) of input for " + (this.forEncryption ? "encryption" : "decryption"));
        }
        this.aadData.write(input);
    }

    @Override
    public void processAADBytes(byte[] input, int inOff, int len) {
        if (this.encrypted) {
            throw new IllegalArgumentException(this.algorithmName + ": AAD cannot be added after reading a full block(" + this.getBlockSize() + " bytes) of input for " + (this.forEncryption ? "encryption" : "decryption"));
        }
        if (inOff + len > input.length) {
            throw new DataLengthException(this.algorithmName + " input buffer too short");
        }
        this.aadData.write(input, inOff, len);
    }

    @Override
    public int processByte(byte input, byte[] output, int outOff) throws DataLengthException {
        return this.processBytes(new byte[]{input}, 0, 1, output, outOff);
    }

    @Override
    public int processBytes(byte[] input, int inOff, int len, byte[] output, int outOff) throws DataLengthException {
        if (!this.initialised) {
            throw new IllegalArgumentException(this.algorithmName + " Need call init function before encryption/decryption");
        }
        if (inOff + len > input.length) {
            throw new DataLengthException(this.algorithmName + " input buffer too short");
        }
        this.message.write(input, inOff, len);
        len = 0;
        if (this.forEncryption && this.message.size() > this.getBlockSize() || !this.forEncryption && this.message.size() - this.TAG_BYTES > this.getBlockSize()) {
            len = this.message.size() - (this.forEncryption ? 0 : this.TAG_BYTES);
            if (len / this.RATE_BYTES * this.RATE_BYTES + outOff > output.length) {
                throw new OutputLengthException(this.algorithmName + " output buffer is too short");
            }
            byte[] m = this.message.toByteArray();
            this.ProcessAssocData(this.state);
            if (len != 0) {
                len = this.ProcessPlainText(this.state, output, m, 0, len);
            }
            this.message.reset();
            this.message.write(m, len, m.length - len);
        }
        return len;
    }

    @Override
    public int doFinal(byte[] output, int outOff) throws IllegalStateException, InvalidCipherTextException {
        int i;
        if (!this.initialised) {
            throw new IllegalArgumentException(this.algorithmName + " needs call init function before dofinal");
        }
        int inlen = this.message.size() - (this.forEncryption ? 0 : this.TAG_BYTES);
        if (this.forEncryption && inlen + this.TAG_BYTES + outOff > output.length || !this.forEncryption && inlen + outOff > output.length) {
            throw new OutputLengthException("output buffer is too short");
        }
        this.ProcessAssocData(this.state);
        byte[] input = this.message.toByteArray();
        int inOff = 0;
        if (this.encrypted || inlen != 0) {
            int n = this.STATE_WORDS - 1;
            this.state[n] = this.state[n] ^ (inlen < this.RATE_BYTES ? this._M2 : this._M3);
            int[] buffer = new int[this.RATE_WORDS];
            for (i = 0; i < inlen; ++i) {
                int n2 = i >>> 2;
                buffer[n2] = buffer[n2] | (input[inOff++] & 0xFF) << ((i & 3) << 3);
            }
            if (inlen < this.RATE_BYTES) {
                if (!this.forEncryption) {
                    int tmp = (i & 3) << 3;
                    int n3 = i >>> 2;
                    buffer[n3] = buffer[n3] | this.state[i >>> 2] >>> tmp << tmp;
                    tmp = (i >>> 2) + 1;
                    System.arraycopy(this.state, tmp, buffer, tmp, this.RATE_WORDS - tmp);
                }
                int n4 = i >>> 2;
                buffer[n4] = buffer[n4] ^ 128 << ((i & 3) << 3);
            }
            i = 0;
            int j = this.RATE_WORDS / 2;
            while (i < this.RATE_WORDS / 2) {
                int tmp1 = this.state[i];
                int tmp2 = this.state[j];
                if (this.forEncryption) {
                    this.state[i] = this.state[j] ^ buffer[i] ^ this.state[this.RATE_WORDS + i];
                    int n5 = j;
                    this.state[n5] = this.state[n5] ^ (tmp1 ^ buffer[j] ^ this.state[this.RATE_WORDS + this.CAP_INDEX(j)]);
                } else {
                    int n6 = i;
                    this.state[n6] = this.state[n6] ^ (this.state[j] ^ buffer[i] ^ this.state[this.RATE_WORDS + i]);
                    this.state[j] = tmp1 ^ buffer[j] ^ this.state[this.RATE_WORDS + this.CAP_INDEX(j)];
                }
                int n7 = i++;
                buffer[n7] = buffer[n7] ^ tmp1;
                int n8 = j++;
                buffer[n8] = buffer[n8] ^ tmp2;
            }
            for (i = 0; i < inlen; ++i) {
                output[outOff++] = (byte)(buffer[i >>> 2] >>> ((i & 3) << 3));
            }
            this.sparkle_opt(this.state, this.STATE_BRANS, this.SPARKLE_STEPS_BIG);
        }
        for (i = 0; i < this.KEY_WORDS; ++i) {
            int n = this.RATE_WORDS + i;
            this.state[n] = this.state[n] ^ this.k[i];
        }
        this.tag = new byte[this.TAG_BYTES];
        Pack.intToLittleEndian(this.state, this.RATE_WORDS, this.TAG_WORDS, this.tag, 0);
        if (this.forEncryption) {
            System.arraycopy(this.tag, 0, output, outOff, this.TAG_BYTES);
            inlen += this.TAG_BYTES;
        } else {
            for (i = 0; i < this.TAG_BYTES; ++i) {
                if (this.tag[i] == input[inlen + i]) continue;
                throw new IllegalArgumentException(this.algorithmName + " mac does not match");
            }
        }
        this.reset(false);
        return inlen;
    }

    @Override
    public byte[] getMac() {
        return this.tag;
    }

    @Override
    public int getUpdateOutputSize(int len) {
        return len;
    }

    @Override
    public int getOutputSize(int len) {
        return len + this.TAG_BYTES;
    }

    @Override
    public void reset() {
        if (!this.initialised) {
            throw new IllegalArgumentException(this.algorithmName + " needs call init function before reset");
        }
        this.reset(true);
    }

    private void reset(boolean clearMac) {
        if (clearMac) {
            this.tag = null;
        }
        System.arraycopy(this.npub, 0, this.state, 0, this.RATE_WORDS);
        System.arraycopy(this.k, 0, this.state, this.RATE_WORDS, this.KEY_WORDS);
        this.sparkle_opt(this.state, this.STATE_BRANS, this.SPARKLE_STEPS_BIG);
        this.aadData.reset();
        this.message.reset();
        this.encrypted = false;
        this.aadFinished = false;
    }

    public int getBlockSize() {
        return this.RATE_BYTES;
    }

    public int getKeyBytesSize() {
        return this.KEY_BYTES;
    }

    public int getIVBytesSize() {
        return this.RATE_BYTES;
    }

    public static enum SparkleParameters {
        SCHWAEMM128_128,
        SCHWAEMM256_128,
        SCHWAEMM192_192,
        SCHWAEMM256_256;

    }
}

