/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.crypto.picnic;

import java.util.logging.Logger;
import org.bouncycastle.pqc.crypto.picnic.PicnicEngine;
import org.bouncycastle.pqc.crypto.picnic.Utils;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.Pack;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
class Tree {
    private static final Logger LOG = Logger.getLogger(Tree.class.getName());
    private static final int MAX_SEED_SIZE_BYTES = 32;
    private final int MAX_AUX_BYTES;
    private int depth;
    byte[][] nodes;
    private int dataSize;
    private boolean[] haveNode;
    private boolean[] exists;
    private int numNodes;
    private int numLeaves;
    private PicnicEngine engine;

    protected byte[][] getLeaves() {
        return this.nodes;
    }

    protected int getLeavesOffset() {
        return this.numNodes - this.numLeaves;
    }

    public Tree(PicnicEngine engine, int numLeaves, int dataSize) {
        int i;
        this.engine = engine;
        this.MAX_AUX_BYTES = (1144 + 256) / 8 + 1;
        this.depth = Utils.ceil_log2(numLeaves) + 1;
        this.numNodes = (1 << this.depth) - 1 - ((1 << this.depth - 1) - numLeaves);
        this.numLeaves = numLeaves;
        this.dataSize = dataSize;
        this.nodes = new byte[this.numNodes][dataSize];
        for (i = 0; i < this.numNodes; ++i) {
            this.nodes[i] = new byte[dataSize];
        }
        this.haveNode = new boolean[this.numNodes];
        this.exists = new boolean[this.numNodes];
        Arrays.fill(this.exists, this.numNodes - this.numLeaves, this.numNodes, true);
        for (i = this.numNodes - this.numLeaves; i > 0; --i) {
            if (!this.exists(2 * i + 1) && !this.exists(2 * i + 2)) continue;
            this.exists[i] = true;
        }
        this.exists[0] = true;
    }

    protected void buildMerkleTree(byte[][] leafData, byte[] salt) {
        int i;
        int firstLeaf = this.numNodes - this.numLeaves;
        for (i = 0; i < this.numLeaves; ++i) {
            if (leafData[i] == null) continue;
            System.arraycopy(leafData[i], 0, this.nodes[firstLeaf + i], 0, this.dataSize);
            this.haveNode[firstLeaf + i] = true;
        }
        for (i = this.numNodes; i > 0; --i) {
            this.computeParentHash(i, salt);
        }
    }

    protected int verifyMerkleTree(byte[][] leafData, byte[] salt) {
        int i;
        int firstLeaf = this.numNodes - this.numLeaves;
        for (i = 0; i < this.numLeaves; ++i) {
            if (leafData[i] == null) continue;
            if (this.haveNode[firstLeaf + i]) {
                return -1;
            }
            if (leafData[i] == null) continue;
            System.arraycopy(leafData[i], 0, this.nodes[firstLeaf + i], 0, this.dataSize);
            this.haveNode[firstLeaf + i] = true;
        }
        for (i = this.numNodes; i > 0; --i) {
            this.computeParentHash(i, salt);
        }
        if (!this.haveNode[0]) {
            return -1;
        }
        return 0;
    }

    protected int reconstructSeeds(int[] hideList, int hideListSize, byte[] input, int inputLen, byte[] salt, int repIndex) {
        int ret = 0;
        int inLen = inputLen;
        int[] revealedSize = new int[]{0};
        int[] revealed = this.getRevealedNodes(hideList, hideListSize, revealedSize);
        for (int i = 0; i < revealedSize[0]; ++i) {
            if ((inLen -= this.engine.seedSizeBytes) < 0) {
                return -1;
            }
            System.arraycopy(input, i * this.engine.seedSizeBytes, this.nodes[revealed[i]], 0, this.engine.seedSizeBytes);
            this.haveNode[revealed[i]] = true;
        }
        this.expandSeeds(salt, repIndex);
        return ret;
    }

    protected byte[] openMerkleTree(int[] missingLeaves, int missingLeavesSize, int[] outputSizeBytes) {
        byte[] output;
        int[] revealedSize = new int[1];
        int[] revealed = this.getRevealedMerkleNodes(missingLeaves, missingLeavesSize, revealedSize);
        outputSizeBytes[0] = revealedSize[0] * this.dataSize;
        byte[] outputBase = output = new byte[outputSizeBytes[0]];
        for (int i = 0; i < revealedSize[0]; ++i) {
            System.arraycopy(this.nodes[revealed[i]], 0, output, i * this.dataSize, this.dataSize);
        }
        return outputBase;
    }

    private int[] getRevealedNodes(int[] hideList, int hideListSize, int[] outputSize) {
        int pathLen = this.depth - 1;
        int[][] pathSets = new int[pathLen][hideListSize];
        for (int i = 0; i < hideListSize; ++i) {
            int node;
            int pos = 0;
            pathSets[pos][i] = node = hideList[i] + (this.numNodes - this.numLeaves);
            ++pos;
            while ((node = this.getParent(node)) != 0) {
                pathSets[pos][i] = node;
                ++pos;
            }
        }
        int[] revealed = new int[this.numLeaves];
        int revealedPos = 0;
        for (int d = 0; d < pathLen; ++d) {
            for (int i = 0; i < hideListSize; ++i) {
                int sibling;
                if (!this.hasSibling(pathSets[d][i]) || this.contains(pathSets[d], hideListSize, sibling = this.getSibling(pathSets[d][i]))) continue;
                while (!this.hasRightChild(sibling) && !this.isLeafNode(sibling)) {
                    sibling = 2 * sibling + 1;
                }
                if (this.contains(revealed, revealedPos, sibling)) continue;
                revealed[revealedPos] = sibling;
                ++revealedPos;
            }
        }
        outputSize[0] = revealedPos;
        return revealed;
    }

    private int getSibling(int node) {
        if (this.isLeftChild(node)) {
            if (node + 1 < this.numNodes) {
                return node + 1;
            }
            LOG.fine("getSibling: request for node with not sibling");
            return 0;
        }
        return node - 1;
    }

    private boolean isLeafNode(int node) {
        return 2 * node + 1 >= this.numNodes;
    }

    private boolean hasSibling(int node) {
        if (!this.exists(node)) {
            return false;
        }
        return !this.isLeftChild(node) || this.exists(node + 1);
    }

    protected int revealSeedsSize(int[] hideList, int hideListSize) {
        int[] numNodesRevealed = new int[]{0};
        int[] revealed = this.getRevealedNodes(hideList, hideListSize, numNodesRevealed);
        return numNodesRevealed[0] * this.engine.seedSizeBytes;
    }

    protected int revealSeeds(int[] hideList, int hideListSize, byte[] output, int outputSize) {
        int[] revealedSize = new int[]{0};
        int outLen = outputSize;
        int[] revealed = this.getRevealedNodes(hideList, hideListSize, revealedSize);
        for (int i = 0; i < revealedSize[0]; ++i) {
            if ((outLen -= this.engine.seedSizeBytes) < 0) {
                LOG.fine("Insufficient sized buffer provided to revealSeeds");
                return 0;
            }
            System.arraycopy(this.nodes[revealed[i]], 0, output, i * this.engine.seedSizeBytes, this.engine.seedSizeBytes);
        }
        return output.length - outLen;
    }

    protected int openMerkleTreeSize(int[] missingLeaves, int missingLeavesSize) {
        int[] revealedSize = new int[1];
        int[] revealed = this.getRevealedMerkleNodes(missingLeaves, missingLeavesSize, revealedSize);
        return revealedSize[0] * this.engine.digestSizeBytes;
    }

    private int[] getRevealedMerkleNodes(int[] missingLeaves, int missingLeavesSize, int[] outputSize) {
        int lastNonLeaf;
        int firstLeaf = this.numNodes - this.numLeaves;
        boolean[] missingNodes = new boolean[this.numNodes];
        for (int i = 0; i < missingLeavesSize; ++i) {
            missingNodes[firstLeaf + missingLeaves[i]] = true;
        }
        for (int i = lastNonLeaf = this.getParent(this.numNodes - 1); i > 0; --i) {
            if (!this.exists(i)) continue;
            if (this.exists(2 * i + 2)) {
                if (!missingNodes[2 * i + 1] || !missingNodes[2 * i + 2]) continue;
                missingNodes[i] = true;
                continue;
            }
            if (!missingNodes[2 * i + 1]) continue;
            missingNodes[i] = true;
        }
        int[] revealed = new int[this.numLeaves];
        int pos = 0;
        block2: for (int i = 0; i < missingLeavesSize; ++i) {
            int node = missingLeaves[i] + firstLeaf;
            do {
                if (missingNodes[this.getParent(node)]) continue;
                if (this.contains(revealed, pos, node)) continue block2;
                revealed[pos] = node;
                ++pos;
                continue block2;
            } while ((node = this.getParent(node)) != 0);
        }
        outputSize[0] = pos;
        return revealed;
    }

    private boolean contains(int[] list, int len, int value) {
        for (int i = 0; i < len; ++i) {
            if (list[i] != value) continue;
            return true;
        }
        return false;
    }

    private void computeParentHash(int child, byte[] salt) {
        if (!this.exists(child)) {
            return;
        }
        int parent = this.getParent(child);
        if (this.haveNode[parent]) {
            return;
        }
        if (!this.haveNode[2 * parent + 1]) {
            return;
        }
        if (this.exists(2 * parent + 2) && !this.haveNode[2 * parent + 2]) {
            return;
        }
        this.engine.digest.update((byte)3);
        this.engine.digest.update(this.nodes[2 * parent + 1], 0, this.engine.digestSizeBytes);
        if (this.hasRightChild(parent)) {
            this.engine.digest.update(this.nodes[2 * parent + 2], 0, this.engine.digestSizeBytes);
        }
        this.engine.digest.update(salt, 0, 32);
        this.engine.digest.update(Pack.intToLittleEndian(parent), 0, 2);
        this.engine.digest.doFinal(this.nodes[parent], 0, this.engine.digestSizeBytes);
        this.haveNode[parent] = true;
    }

    protected byte[] getLeaf(int leafIndex) {
        int firstLeaf = this.numNodes - this.numLeaves;
        return this.nodes[firstLeaf + leafIndex];
    }

    protected int addMerkleNodes(int[] missingLeaves, int missingLeavesSize, byte[] input, int inputSize) {
        int intLen = inputSize;
        int[] revealedSize = new int[]{0};
        int[] revealed = this.getRevealedMerkleNodes(missingLeaves, missingLeavesSize, revealedSize);
        for (int i = 0; i < revealedSize[0]; ++i) {
            if ((intLen -= this.dataSize) < 0) {
                return -1;
            }
            System.arraycopy(input, i * this.dataSize, this.nodes[revealed[i]], 0, this.dataSize);
            this.haveNode[revealed[i]] = true;
        }
        if (intLen != 0) {
            return -1;
        }
        return 0;
    }

    protected void generateSeeds(byte[] rootSeed, byte[] salt, int repIndex) {
        this.nodes[0] = rootSeed;
        this.haveNode[0] = true;
        this.expandSeeds(salt, repIndex);
    }

    private void expandSeeds(byte[] salt, int repIndex) {
        byte[] tmp = new byte[64];
        int lastNonLeaf = this.getParent(this.numNodes - 1);
        for (int i = 0; i <= lastNonLeaf; ++i) {
            if (!this.haveNode[i]) continue;
            this.hashSeed(tmp, this.nodes[i], salt, (byte)1, repIndex, i);
            if (!this.haveNode[2 * i + 1]) {
                System.arraycopy(tmp, 0, this.nodes[2 * i + 1], 0, this.engine.seedSizeBytes);
                this.haveNode[2 * i + 1] = true;
            }
            if (!this.exists(2 * i + 2) || this.haveNode[2 * i + 2]) continue;
            System.arraycopy(tmp, this.engine.seedSizeBytes, this.nodes[2 * i + 2], 0, this.engine.seedSizeBytes);
            this.haveNode[2 * i + 2] = true;
        }
    }

    private void hashSeed(byte[] digest_arr, byte[] inputSeed, byte[] salt, byte hashPrefix, int repIndex, int nodeIndex) {
        this.engine.digest.update(hashPrefix);
        this.engine.digest.update(inputSeed, 0, this.engine.seedSizeBytes);
        this.engine.digest.update(salt, 0, 32);
        this.engine.digest.update(Pack.shortToLittleEndian((short)(repIndex & 0xFFFF)), 0, 2);
        this.engine.digest.update(Pack.shortToLittleEndian((short)(nodeIndex & 0xFFFF)), 0, 2);
        this.engine.digest.doFinal(digest_arr, 0, 2 * this.engine.seedSizeBytes);
    }

    private boolean isLeftChild(int node) {
        return node % 2 == 1;
    }

    private boolean hasRightChild(int node) {
        return 2 * node + 2 < this.numNodes && this.exists(node);
    }

    boolean hasLeftChild(Tree tree, int node) {
        return 2 * node + 1 < this.numNodes;
    }

    private int getParent(int node) {
        if (this.isLeftChild(node)) {
            return (node - 1) / 2;
        }
        return (node - 2) / 2;
    }

    private boolean exists(int i) {
        if (i >= this.numNodes) {
            return false;
        }
        return this.exists[i];
    }
}

