/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.util;

import java.math.BigInteger;
import org.bouncycastle.util.Arrays;

class SSHBuffer {
    private final byte[] buffer;
    private int pos = 0;

    public SSHBuffer(byte[] magic, byte[] buffer) {
        this.buffer = buffer;
        for (int i = 0; i != magic.length; ++i) {
            if (magic[i] == buffer[i]) continue;
            throw new IllegalArgumentException("magic-number incorrect");
        }
        this.pos += magic.length;
    }

    public SSHBuffer(byte[] buffer) {
        this.buffer = buffer;
    }

    public int readU32() {
        if (this.pos + 4 > this.buffer.length) {
            throw new IllegalArgumentException("4 bytes for U32 exceeds buffer.");
        }
        int i = (this.buffer[this.pos++] & 0xFF) << 24;
        i |= (this.buffer[this.pos++] & 0xFF) << 16;
        i |= (this.buffer[this.pos++] & 0xFF) << 8;
        return i |= this.buffer[this.pos++] & 0xFF;
    }

    public byte[] readString() {
        int len = this.readU32();
        if (len == 0) {
            return new byte[0];
        }
        if (this.pos + len > this.buffer.length) {
            throw new IllegalArgumentException("not enough data for string");
        }
        return Arrays.copyOfRange(this.buffer, this.pos, this.pos += len);
    }

    public byte[] readPaddedString() {
        int len = this.readU32();
        if (len == 0) {
            return new byte[0];
        }
        if (this.pos + len > this.buffer.length) {
            throw new IllegalArgumentException("not enough data for string");
        }
        return Arrays.copyOfRange(this.buffer, this.pos, this.pos += len - (this.buffer[this.pos + len - 1] & 0xFF));
    }

    public BigInteger positiveBigNum() {
        int len = this.readU32();
        if (this.pos + len > this.buffer.length) {
            throw new IllegalArgumentException("not enough data for big num");
        }
        byte[] d = new byte[len];
        System.arraycopy(this.buffer, this.pos, d, 0, d.length);
        this.pos += len;
        return new BigInteger(1, d);
    }

    public byte[] getBuffer() {
        return Arrays.clone(this.buffer);
    }

    public boolean hasRemaining() {
        return this.pos < this.buffer.length;
    }
}

