/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.crypto.picnic;

import org.bouncycastle.pqc.crypto.picnic.PicnicEngine;
import org.bouncycastle.pqc.crypto.picnic.Utils;

class Signature {
    byte[] challengeBits;
    byte[] salt = new byte[32];
    Proof[] proofs;

    Signature(PicnicEngine engine) {
        this.challengeBits = new byte[Utils.numBytes(engine.numMPCRounds * 2)];
        this.proofs = new Proof[engine.numMPCRounds];
        for (int i = 0; i < this.proofs.length; ++i) {
            this.proofs[i] = new Proof(engine);
        }
    }

    public static class Proof {
        byte[] seed1;
        byte[] seed2;
        int[] inputShare;
        byte[] communicatedBits;
        byte[] view3Commitment;
        byte[] view3UnruhG;

        Proof(PicnicEngine engine) {
            this.seed1 = new byte[engine.seedSizeBytes];
            this.seed2 = new byte[engine.seedSizeBytes];
            this.inputShare = new int[engine.stateSizeBytes];
            this.communicatedBits = new byte[engine.andSizeBytes];
            this.view3Commitment = new byte[engine.digestSizeBytes];
            this.view3UnruhG = (byte[])(engine.UnruhGWithInputBytes > 0 ? new byte[engine.UnruhGWithInputBytes] : null);
        }
    }
}

