/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.crypto.bike;

import org.bouncycastle.crypto.Xof;
import org.bouncycastle.util.Pack;

class BIKERandomGenerator {
    BIKERandomGenerator() {
    }

    private static int bitScanReverse(int t) {
        int res = 0;
        while (t != 0) {
            t >>= 1;
            ++res;
        }
        return res;
    }

    private static int GetRandomInMod(int mod, Xof digest) {
        int mask = BIKERandomGenerator.maskNumber(BIKERandomGenerator.bitScanReverse(mod));
        int res = -1;
        do {
            res = BIKERandomGenerator.getRandomNumber(digest);
        } while ((res &= mask) >= mod);
        return res;
    }

    private static void generateRandomArray(byte[] res, int mod, int weight, Xof digest) {
        int index = 0;
        while (index < weight) {
            int tmp = BIKERandomGenerator.GetRandomInMod(mod, digest);
            if (BIKERandomGenerator.checkBit(res, tmp) != 0) continue;
            BIKERandomGenerator.setBit(res, tmp);
            ++index;
        }
    }

    private static int checkBit(byte[] a, int position) {
        int index = position / 8;
        int pos = position % 8;
        return a[index] >> pos & 1;
    }

    private static void setBit(byte[] a, int position) {
        int index = position / 8;
        int pos = position % 8;
        int n = index;
        a[n] = (byte)(a[n] | 1 << pos);
    }

    static byte[] generateRandomByteArray(int mod, int size, int weight, Xof digest) {
        byte[] res = new byte[size];
        BIKERandomGenerator.generateRandomArray(res, mod, weight, digest);
        return res;
    }

    private static int maskNumber(int n) {
        return (1 << n) - 1;
    }

    private static int getRandomNumber(Xof digest) {
        byte[] out = new byte[4];
        digest.doOutput(out, 0, out.length);
        int tmp = Pack.littleEndianToInt(out, 0);
        return tmp;
    }
}

