/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.tls;

import java.io.IOException;
import org.bouncycastle.crypto.modes.AEADBlockCipher;
import org.bouncycastle.crypto.params.AEADParameters;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.tls.TlsCipher;
import org.bouncycastle.crypto.tls.TlsContext;
import org.bouncycastle.crypto.tls.TlsFatalAlert;
import org.bouncycastle.crypto.tls.TlsUtils;
import org.bouncycastle.util.Arrays;

public class TlsAEADCipher
implements TlsCipher {
    public static final int NONCE_RFC5288 = 1;
    static final int NONCE_DRAFT_CHACHA20_POLY1305 = 2;
    protected TlsContext context;
    protected int macSize;
    protected int record_iv_length;
    protected AEADBlockCipher encryptCipher;
    protected AEADBlockCipher decryptCipher;
    protected byte[] encryptImplicitNonce;
    protected byte[] decryptImplicitNonce;
    protected int nonceMode;

    public TlsAEADCipher(TlsContext context, AEADBlockCipher clientWriteCipher, AEADBlockCipher serverWriteCipher, int cipherKeySize, int macSize) throws IOException {
        this(context, clientWriteCipher, serverWriteCipher, cipherKeySize, macSize, 1);
    }

    /*
     * WARNING - void declaration
     */
    TlsAEADCipher(TlsContext context, AEADBlockCipher clientWriteCipher, AEADBlockCipher serverWriteCipher, int cipherKeySize, int macSize, int nonceMode) throws IOException {
        KeyParameter decryptKey;
        KeyParameter encryptKey;
        void var7_7;
        if (!TlsUtils.isTLSv12(context)) {
            throw new TlsFatalAlert(80);
        }
        this.nonceMode = nonceMode;
        switch (nonceMode) {
            case 1: {
                int fixed_iv_length = 4;
                this.record_iv_length = 8;
                break;
            }
            case 2: {
                int fixed_iv_length = 12;
                this.record_iv_length = 0;
                break;
            }
            default: {
                throw new TlsFatalAlert(80);
            }
        }
        this.context = context;
        this.macSize = macSize;
        int key_block_size = 2 * cipherKeySize + 2 * var7_7;
        byte[] key_block = TlsUtils.calculateKeyBlock(context, key_block_size);
        int offset = 0;
        KeyParameter client_write_key = new KeyParameter(key_block, offset, cipherKeySize);
        KeyParameter server_write_key = new KeyParameter(key_block, offset += cipherKeySize, cipherKeySize);
        byte[] client_write_IV = Arrays.copyOfRange(key_block, offset += cipherKeySize, offset + var7_7);
        byte[] server_write_IV = Arrays.copyOfRange(key_block, offset += var7_7, offset + var7_7);
        if ((offset += var7_7) != key_block_size) {
            throw new TlsFatalAlert(80);
        }
        if (context.isServer()) {
            this.encryptCipher = serverWriteCipher;
            this.decryptCipher = clientWriteCipher;
            this.encryptImplicitNonce = server_write_IV;
            this.decryptImplicitNonce = client_write_IV;
            encryptKey = server_write_key;
            decryptKey = client_write_key;
        } else {
            this.encryptCipher = clientWriteCipher;
            this.decryptCipher = serverWriteCipher;
            this.encryptImplicitNonce = client_write_IV;
            this.decryptImplicitNonce = server_write_IV;
            encryptKey = client_write_key;
            decryptKey = server_write_key;
        }
        byte[] dummyNonce = new byte[var7_7 + this.record_iv_length];
        this.encryptCipher.init(true, new AEADParameters(encryptKey, 8 * macSize, dummyNonce));
        this.decryptCipher.init(false, new AEADParameters(decryptKey, 8 * macSize, dummyNonce));
    }

    public int getPlaintextLimit(int ciphertextLimit) {
        return ciphertextLimit - this.macSize - this.record_iv_length;
    }

    public byte[] encodePlaintext(long seqNo, short type, byte[] plaintext, int offset, int len) throws IOException {
        byte[] nonce = new byte[this.encryptImplicitNonce.length + this.record_iv_length];
        switch (this.nonceMode) {
            case 1: {
                System.arraycopy(this.encryptImplicitNonce, 0, nonce, 0, this.encryptImplicitNonce.length);
                TlsUtils.writeUint64(seqNo, nonce, this.encryptImplicitNonce.length);
                break;
            }
            case 2: {
                TlsUtils.writeUint64(seqNo, nonce, nonce.length - 8);
                for (int i = 0; i < this.encryptImplicitNonce.length; ++i) {
                    int n = i;
                    nonce[n] = (byte)(nonce[n] ^ this.encryptImplicitNonce[i]);
                }
                break;
            }
            default: {
                throw new TlsFatalAlert(80);
            }
        }
        int plaintextOffset = offset;
        int plaintextLength = len;
        int ciphertextLength = this.encryptCipher.getOutputSize(plaintextLength);
        byte[] output = new byte[this.record_iv_length + ciphertextLength];
        if (this.record_iv_length != 0) {
            System.arraycopy(nonce, nonce.length - this.record_iv_length, output, 0, this.record_iv_length);
        }
        int outputPos = this.record_iv_length;
        byte[] additionalData = this.getAdditionalData(seqNo, type, plaintextLength);
        AEADParameters parameters = new AEADParameters(null, 8 * this.macSize, nonce, additionalData);
        try {
            this.encryptCipher.init(true, parameters);
            outputPos += this.encryptCipher.processBytes(plaintext, plaintextOffset, plaintextLength, output, outputPos);
            outputPos += this.encryptCipher.doFinal(output, outputPos);
        }
        catch (Exception e) {
            throw new TlsFatalAlert(80, (Throwable)e);
        }
        if (outputPos != output.length) {
            throw new TlsFatalAlert(80);
        }
        return output;
    }

    public byte[] decodeCiphertext(long seqNo, short type, byte[] ciphertext, int offset, int len) throws IOException {
        if (this.getPlaintextLimit(len) < 0) {
            throw new TlsFatalAlert(50);
        }
        byte[] nonce = new byte[this.decryptImplicitNonce.length + this.record_iv_length];
        switch (this.nonceMode) {
            case 1: {
                System.arraycopy(this.decryptImplicitNonce, 0, nonce, 0, this.decryptImplicitNonce.length);
                System.arraycopy(ciphertext, offset, nonce, nonce.length - this.record_iv_length, this.record_iv_length);
                break;
            }
            case 2: {
                TlsUtils.writeUint64(seqNo, nonce, nonce.length - 8);
                for (int i = 0; i < this.decryptImplicitNonce.length; ++i) {
                    int n = i;
                    nonce[n] = (byte)(nonce[n] ^ this.decryptImplicitNonce[i]);
                }
                break;
            }
            default: {
                throw new TlsFatalAlert(80);
            }
        }
        int ciphertextOffset = offset + this.record_iv_length;
        int ciphertextLength = len - this.record_iv_length;
        int plaintextLength = this.decryptCipher.getOutputSize(ciphertextLength);
        byte[] output = new byte[plaintextLength];
        int outputPos = 0;
        byte[] additionalData = this.getAdditionalData(seqNo, type, plaintextLength);
        AEADParameters parameters = new AEADParameters(null, 8 * this.macSize, nonce, additionalData);
        try {
            this.decryptCipher.init(false, parameters);
            outputPos += this.decryptCipher.processBytes(ciphertext, ciphertextOffset, ciphertextLength, output, outputPos);
            outputPos += this.decryptCipher.doFinal(output, outputPos);
        }
        catch (Exception e) {
            throw new TlsFatalAlert(20, (Throwable)e);
        }
        if (outputPos != output.length) {
            throw new TlsFatalAlert(80);
        }
        return output;
    }

    protected byte[] getAdditionalData(long seqNo, short type, int len) throws IOException {
        byte[] additional_data = new byte[13];
        TlsUtils.writeUint64(seqNo, additional_data, 0);
        TlsUtils.writeUint8(type, additional_data, 8);
        TlsUtils.writeVersion(this.context.getServerVersion(), additional_data, 9);
        TlsUtils.writeUint16(len, additional_data, 11);
        return additional_data;
    }
}

