/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.x509;

import java.security.cert.CertStore;
import java.security.cert.CertStoreException;
import java.security.cert.PKIXParameters;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.bouncycastle.jce.provider.AnnotatedException;
import org.bouncycastle.util.Selector;
import org.bouncycastle.util.StoreException;
import org.bouncycastle.x509.X509CRLStoreSelector;
import org.bouncycastle.x509.X509Store;

abstract class PKIXCRLUtil {
    PKIXCRLUtil() {
    }

    static Set findCRLs(X509CRLStoreSelector crlselect, PKIXParameters paramsPKIX) throws AnnotatedException {
        HashSet completeSet = new HashSet();
        try {
            PKIXCRLUtil.findCRLs(completeSet, crlselect, paramsPKIX.getCertStores());
        }
        catch (AnnotatedException e) {
            throw new AnnotatedException("Exception obtaining complete CRLs.", e);
        }
        return completeSet;
    }

    private static void findCRLs(Set crls, X509CRLStoreSelector crlSelect, List crlStores) throws AnnotatedException {
        AnnotatedException lastException = null;
        boolean foundValidStore = false;
        for (Object obj : crlStores) {
            Object store;
            if (obj instanceof X509Store) {
                store = (X509Store)obj;
                try {
                    crls.addAll(((X509Store)store).getMatches((Selector)crlSelect));
                    foundValidStore = true;
                }
                catch (StoreException e) {
                    lastException = new AnnotatedException("Exception searching in X.509 CRL store.", e);
                }
                continue;
            }
            store = (CertStore)obj;
            try {
                crls.addAll(((CertStore)store).getCRLs(crlSelect));
                foundValidStore = true;
            }
            catch (CertStoreException e) {
                lastException = new AnnotatedException("Exception searching in X.509 CRL store.", e);
            }
        }
        if (!foundValidStore && lastException != null) {
            throw lastException;
        }
    }
}

