/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.crypto.mldsa;

import org.bouncycastle.pqc.crypto.mldsa.MLDSAEngine;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
class Rounding {
    Rounding() {
    }

    static void power2RoundAll(int[] c0, int[] c1) {
        int d = 13;
        int n = 256;
        int u = (1 << d - 1) - 1;
        int v = -1 << d;
        for (int i = 0; i < n; ++i) {
            int a = c0[i];
            int t = a + u;
            int r1 = a - (t & v);
            c0[i] = t >> d;
            c1[i] = r1;
        }
    }

    public static int[] decompose(int a, int gamma2) {
        int a1 = a + 127 >> 7;
        if (gamma2 == 261888) {
            a1 = a1 * 1025 + 0x200000 >> 22;
            a1 &= 0xF;
        } else if (gamma2 == 95232) {
            a1 = a1 * 11275 + 0x800000 >> 24;
            a1 ^= 43 - a1 >> 31 & a1;
        } else {
            throw new RuntimeException("Wrong Gamma2!");
        }
        int a0 = a - a1 * 2 * gamma2;
        a0 -= 0x3FF000 - a0 >> 31 & 0x7FE001;
        return new int[]{a0, a1};
    }

    public static int makeHint(int a0, int a1, MLDSAEngine engine) {
        int g2 = engine.getDilithiumGamma2();
        int q = 8380417;
        if (a0 <= g2 || a0 > q - g2 || a0 == q - g2 && a1 == 0) {
            return 0;
        }
        return 1;
    }

    public static int useHint(int a, int hint, int gamma2) {
        int[] intArray = Rounding.decompose(a, gamma2);
        int a0 = intArray[0];
        int a1 = intArray[1];
        if (hint == 0) {
            return a1;
        }
        if (gamma2 == 261888) {
            if (a0 > 0) {
                return a1 + 1 & 0xF;
            }
            return a1 - 1 & 0xF;
        }
        if (gamma2 == 95232) {
            if (a0 > 0) {
                return a1 == 43 ? 0 : a1 + 1;
            }
            return a1 == 0 ? 43 : a1 - 1;
        }
        throw new RuntimeException("Wrong Gamma2!");
    }
}

