/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jcajce.provider.asymmetric.mldsa;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.SignatureException;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.DataLengthException;
import org.bouncycastle.jcajce.MLDSAProxyPrivateKey;
import org.bouncycastle.jcajce.interfaces.MLDSAPublicKey;
import org.bouncycastle.jcajce.provider.asymmetric.mldsa.BCMLDSAPrivateKey;
import org.bouncycastle.jcajce.provider.asymmetric.mldsa.BCMLDSAPublicKey;
import org.bouncycastle.jcajce.provider.asymmetric.util.BaseDeterministicOrRandomSignature;
import org.bouncycastle.jcajce.spec.MLDSAParameterSpec;
import org.bouncycastle.pqc.crypto.mldsa.MLDSAParameters;
import org.bouncycastle.pqc.crypto.mldsa.MLDSAPublicKeyParameters;
import org.bouncycastle.pqc.crypto.mldsa.MLDSASigner;
import org.bouncycastle.pqc.crypto.util.PublicKeyFactory;

public class SignatureSpi
extends BaseDeterministicOrRandomSignature {
    protected MLDSASigner signer;
    protected MLDSAParameters parameters;

    protected SignatureSpi(MLDSASigner signer) {
        super("MLDSA");
        this.signer = signer;
        this.parameters = null;
    }

    protected SignatureSpi(MLDSASigner signer, MLDSAParameters parameters) {
        super(MLDSAParameterSpec.fromName(parameters.getName()).getName());
        this.signer = signer;
        this.parameters = parameters;
    }

    @Override
    protected void verifyInit(PublicKey publicKey) throws InvalidKeyException {
        String canonicalAlg;
        if (publicKey instanceof BCMLDSAPublicKey) {
            BCMLDSAPublicKey key = (BCMLDSAPublicKey)publicKey;
            this.keyParams = key.getKeyParams();
        } else {
            try {
                SubjectPublicKeyInfo pubKeyInfo = SubjectPublicKeyInfo.getInstance(publicKey.getEncoded());
                this.keyParams = PublicKeyFactory.createKey(pubKeyInfo);
                publicKey = new BCMLDSAPublicKey((MLDSAPublicKeyParameters)this.keyParams);
            }
            catch (Exception e) {
                throw new InvalidKeyException("unknown public key passed to ML-DSA");
            }
        }
        if (this.parameters != null && !(canonicalAlg = MLDSAParameterSpec.fromName(this.parameters.getName()).getName()).equals(publicKey.getAlgorithm())) {
            throw new InvalidKeyException("signature configured for " + canonicalAlg);
        }
    }

    @Override
    protected void signInit(PrivateKey privateKey, SecureRandom random) throws InvalidKeyException {
        this.appRandom = random;
        if (privateKey instanceof BCMLDSAPrivateKey) {
            String canonicalAlg;
            BCMLDSAPrivateKey key = (BCMLDSAPrivateKey)privateKey;
            this.keyParams = key.getKeyParams();
            if (this.parameters != null && !(canonicalAlg = MLDSAParameterSpec.fromName(this.parameters.getName()).getName()).equals(key.getAlgorithm())) {
                throw new InvalidKeyException("signature configured for " + canonicalAlg);
            }
        } else if (privateKey instanceof MLDSAProxyPrivateKey && this instanceof MLDSACalcMu) {
            String canonicalAlg;
            MLDSAProxyPrivateKey pKey = (MLDSAProxyPrivateKey)privateKey;
            MLDSAPublicKey key = pKey.getPublicKey();
            try {
                this.keyParams = PublicKeyFactory.createKey(key.getEncoded());
            }
            catch (IOException e) {
                throw new InvalidKeyException(e.getMessage());
            }
            if (this.parameters != null && !(canonicalAlg = MLDSAParameterSpec.fromName(this.parameters.getName()).getName()).equals(key.getAlgorithm())) {
                throw new InvalidKeyException("signature configured for " + canonicalAlg);
            }
        } else {
            throw new InvalidKeyException("unknown private key passed to ML-DSA");
        }
    }

    @Override
    protected void updateEngine(byte b) throws SignatureException {
        this.signer.update(b);
    }

    @Override
    protected void updateEngine(byte[] b, int off, int len) throws SignatureException {
        this.signer.update(b, off, len);
    }

    @Override
    protected byte[] engineSign() throws SignatureException {
        try {
            return this.signer.generateSignature();
        }
        catch (Exception e) {
            throw new SignatureException(e.toString());
        }
    }

    @Override
    protected boolean engineVerify(byte[] sigBytes) throws SignatureException {
        return this.signer.verifySignature(sigBytes);
    }

    @Override
    protected void reInitialize(boolean forSigning, CipherParameters params) {
        this.signer.init(forSigning, params);
    }

    public static class MLDSA
    extends SignatureSpi {
        public MLDSA() {
            super(new MLDSASigner());
        }
    }

    public static class MLDSA44
    extends SignatureSpi {
        public MLDSA44() {
            super(new MLDSASigner(), MLDSAParameters.ml_dsa_44);
        }
    }

    public static class MLDSA65
    extends SignatureSpi {
        public MLDSA65() {
            super(new MLDSASigner(), MLDSAParameters.ml_dsa_65);
        }
    }

    public static class MLDSA87
    extends SignatureSpi {
        public MLDSA87() throws NoSuchAlgorithmException {
            super(new MLDSASigner(), MLDSAParameters.ml_dsa_87);
        }
    }

    public static class MLDSACalcMu
    extends SignatureSpi {
        public MLDSACalcMu() {
            super(new MLDSASigner());
        }

        @Override
        protected byte[] engineSign() throws SignatureException {
            try {
                return this.signer.generateMu();
            }
            catch (Exception e) {
                throw new SignatureException(e.toString());
            }
        }

        @Override
        protected boolean engineVerify(byte[] sigBytes) throws SignatureException {
            return this.signer.verifyMu(sigBytes);
        }
    }

    public static class MLDSAExtMu
    extends SignatureSpi {
        private ByteArrayOutputStream bOut = new ByteArrayOutputStream(64);

        public MLDSAExtMu() {
            super(new MLDSASigner());
        }

        @Override
        protected void updateEngine(byte b) throws SignatureException {
            this.bOut.write(b);
        }

        @Override
        protected void updateEngine(byte[] b, int off, int len) throws SignatureException {
            this.bOut.write(b, off, len);
        }

        @Override
        protected byte[] engineSign() throws SignatureException {
            try {
                byte[] mu = this.bOut.toByteArray();
                this.bOut.reset();
                return this.signer.generateMuSignature(mu);
            }
            catch (DataLengthException e) {
                throw new SignatureException(e.getMessage());
            }
            catch (Exception e) {
                throw new SignatureException(e.toString());
            }
        }

        @Override
        protected boolean engineVerify(byte[] sigBytes) throws SignatureException {
            byte[] mu = this.bOut.toByteArray();
            this.bOut.reset();
            try {
                return this.signer.verifyMuSignature(mu, sigBytes);
            }
            catch (DataLengthException e) {
                throw new SignatureException(e.getMessage());
            }
        }
    }
}

