/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.engines;

import org.bouncycastle.crypto.digests.PhotonBeetleDigest;
import org.bouncycastle.crypto.engines.AEADBaseEngine;
import org.bouncycastle.util.Bytes;

public class PhotonBeetleEngine
extends AEADBaseEngine {
    private boolean input_empty;
    private byte[] K;
    private byte[] N;
    private byte[] state;
    private final int RATE_INBYTES_HALF;
    private final int STATE_INBYTES;
    private final int LAST_THREE_BITS_OFFSET;
    private static final int D = 8;
    private static final byte[][] RC = new byte[][]{{1, 3, 7, 14, 13, 11, 6, 12, 9, 2, 5, 10}, {0, 2, 6, 15, 12, 10, 7, 13, 8, 3, 4, 11}, {2, 0, 4, 13, 14, 8, 5, 15, 10, 1, 6, 9}, {6, 4, 0, 9, 10, 12, 1, 11, 14, 5, 2, 13}, {14, 12, 8, 1, 2, 4, 9, 3, 6, 13, 10, 5}, {15, 13, 9, 0, 3, 5, 8, 2, 7, 12, 11, 4}, {13, 15, 11, 2, 1, 7, 10, 0, 5, 14, 9, 6}, {9, 11, 15, 6, 5, 3, 14, 4, 1, 10, 13, 2}};
    private static final byte[][] MixColMatrix = new byte[][]{{2, 4, 2, 11, 2, 8, 5, 6}, {12, 9, 8, 13, 7, 7, 5, 2}, {4, 4, 13, 13, 9, 4, 13, 9}, {1, 6, 5, 1, 12, 13, 15, 14}, {15, 12, 9, 13, 14, 5, 14, 13}, {9, 14, 5, 15, 4, 12, 9, 6}, {12, 2, 2, 10, 3, 1, 1, 14}, {15, 1, 13, 10, 5, 10, 2, 3}};
    private static final byte[] sbox = new byte[]{12, 5, 6, 11, 9, 0, 10, 13, 3, 14, 15, 8, 4, 7, 1, 2};

    public PhotonBeetleEngine(PhotonBeetleParameters pbp) {
        this.MAC_SIZE = 16;
        this.IV_SIZE = 16;
        this.KEY_SIZE = 16;
        int CAPACITY_INBITS = 0;
        int RATE_INBITS = 0;
        switch (pbp.ordinal()) {
            case 0: {
                RATE_INBITS = 32;
                CAPACITY_INBITS = 224;
                break;
            }
            case 1: {
                RATE_INBITS = 128;
                CAPACITY_INBITS = 128;
            }
        }
        this.AADBufferSize = this.BlockSize = RATE_INBITS + 7 >>> 3;
        this.RATE_INBYTES_HALF = this.BlockSize >>> 1;
        int STATE_INBITS = RATE_INBITS + CAPACITY_INBITS;
        this.STATE_INBYTES = STATE_INBITS + 7 >>> 3;
        this.LAST_THREE_BITS_OFFSET = STATE_INBITS - (this.STATE_INBYTES - 1 << 3) - 3;
        this.algorithmName = "Photon-Beetle AEAD";
        this.state = new byte[this.STATE_INBYTES];
        this.setInnerMembers(AEADBaseEngine.ProcessingBufferType.Buffered, AEADBaseEngine.AADOperatorType.Counter, AEADBaseEngine.DataOperatorType.Counter);
    }

    @Override
    protected void init(byte[] key, byte[] iv) throws IllegalArgumentException {
        this.K = key;
        this.N = iv;
    }

    @Override
    protected void processBufferAAD(byte[] input, int inOff) {
        PhotonBeetleEngine.photonPermutation(this.state);
        Bytes.xorTo(this.BlockSize, input, inOff, this.state);
    }

    @Override
    protected void finishAAD(AEADBaseEngine.State nextState, boolean isDoFinal) {
        this.finishAAD3(nextState, isDoFinal);
    }

    @Override
    protected void processFinalAAD() {
        int aadLen = this.aadOperator.getLen();
        if (aadLen != 0) {
            if (this.m_aadPos != 0) {
                PhotonBeetleEngine.photonPermutation(this.state);
                Bytes.xorTo(this.m_aadPos, this.m_aad, this.state);
                if (this.m_aadPos < this.BlockSize) {
                    int n = this.m_aadPos;
                    this.state[n] = (byte)(this.state[n] ^ 1);
                }
            }
            int n = this.STATE_INBYTES - 1;
            this.state[n] = (byte)(this.state[n] ^ this.select(this.dataOperator.getLen() - (this.forEncryption ? 0 : this.MAC_SIZE) > 0, aadLen % this.BlockSize == 0, (byte)3, (byte)4) << this.LAST_THREE_BITS_OFFSET);
        }
    }

    @Override
    protected void processBufferEncrypt(byte[] input, int inOff, byte[] output, int outOff) {
        this.rhoohr(output, outOff, input, inOff, this.BlockSize);
        Bytes.xorTo(this.BlockSize, input, inOff, this.state);
    }

    @Override
    protected void processBufferDecrypt(byte[] input, int inOff, byte[] output, int outOff) {
        this.rhoohr(output, outOff, input, inOff, this.BlockSize);
        Bytes.xorTo(this.BlockSize, output, outOff, this.state);
    }

    @Override
    protected void processFinalBlock(byte[] output, int outOff) {
        int len = this.dataOperator.getLen() - (this.forEncryption ? 0 : this.MAC_SIZE);
        int bufferLen = this.m_bufPos;
        int aadLen = this.aadOperator.getLen();
        if (aadLen != 0 || len != 0) {
            this.input_empty = false;
        }
        byte c1 = this.select(aadLen != 0, len % this.BlockSize == 0, (byte)5, (byte)6);
        if (len != 0) {
            if (bufferLen != 0) {
                this.rhoohr(output, outOff, this.m_buf, 0, bufferLen);
                if (this.forEncryption) {
                    Bytes.xorTo(bufferLen, this.m_buf, this.state);
                } else {
                    Bytes.xorTo(bufferLen, output, outOff, this.state);
                }
                if (bufferLen < this.BlockSize) {
                    int n = bufferLen;
                    this.state[n] = (byte)(this.state[n] ^ 1);
                }
            }
            int n = this.STATE_INBYTES - 1;
            this.state[n] = (byte)(this.state[n] ^ c1 << this.LAST_THREE_BITS_OFFSET);
        } else if (this.input_empty) {
            int n = this.STATE_INBYTES - 1;
            this.state[n] = (byte)(this.state[n] ^ 1 << this.LAST_THREE_BITS_OFFSET);
        }
        PhotonBeetleEngine.photonPermutation(this.state);
        System.arraycopy(this.state, 0, this.mac, 0, this.MAC_SIZE);
    }

    @Override
    protected void reset(boolean clearMac) {
        super.reset(clearMac);
        this.input_empty = true;
        System.arraycopy(this.K, 0, this.state, 0, this.K.length);
        System.arraycopy(this.N, 0, this.state, this.K.length, this.N.length);
    }

    private static void photonPermutation(byte[] state) {
        int i;
        int dq = 3;
        int dr = 7;
        int DSquare = 64;
        byte[][] state_2d = new byte[8][8];
        for (i = 0; i < DSquare; ++i) {
            state_2d[i >>> dq][i & dr] = (byte)((state[i >> 1] & 0xFF) >>> 4 * (i & 1) & 0xF);
        }
        int ROUND = 12;
        for (int round = 0; round < ROUND; ++round) {
            int j;
            for (i = 0; i < 8; ++i) {
                byte[] byArray = state_2d[i];
                byArray[0] = (byte)(byArray[0] ^ RC[i][round]);
            }
            for (i = 0; i < 8; ++i) {
                for (j = 0; j < 8; ++j) {
                    state_2d[i][j] = sbox[state_2d[i][j]];
                }
            }
            for (i = 1; i < 8; ++i) {
                System.arraycopy(state_2d[i], 0, state, 0, 8);
                System.arraycopy(state, i, state_2d[i], 0, 8 - i);
                System.arraycopy(state, 0, state_2d[i], 8 - i, i);
            }
            for (j = 0; j < 8; ++j) {
                for (i = 0; i < 8; ++i) {
                    int sum = 0;
                    for (int k = 0; k < 8; ++k) {
                        byte x = MixColMatrix[i][k];
                        byte b = state_2d[k][j];
                        sum ^= x * (b & 1);
                        sum ^= x * (b & 2);
                        sum ^= x * (b & 4);
                        sum ^= x * (b & 8);
                    }
                    int t0 = sum >>> 4;
                    sum = sum & 0xF ^ t0 ^ t0 << 1;
                    int t1 = sum >>> 4;
                    sum = sum & 0xF ^ t1 ^ t1 << 1;
                    state[i] = (byte)sum;
                }
                for (i = 0; i < 8; ++i) {
                    state_2d[i][j] = state[i];
                }
            }
        }
        for (i = 0; i < DSquare; i += 2) {
            state[i >>> 1] = (byte)(state_2d[i >>> dq][i & dr] & 0xF | (state_2d[i >>> dq][i + 1 & dr] & 0xF) << 4);
        }
    }

    private byte select(boolean condition1, boolean condition2, byte option3, byte option4) {
        if (condition1 && condition2) {
            return 1;
        }
        if (condition1) {
            return 2;
        }
        if (condition2) {
            return option3;
        }
        return option4;
    }

    private void rhoohr(byte[] ciphertext, int outOff, byte[] plaintext, int inOff, int DBlen_inbytes) {
        int i;
        PhotonBeetleEngine.photonPermutation(this.state);
        byte[] OuterState_part1_ROTR1 = new byte[8];
        int loop_end = Math.min(DBlen_inbytes, this.RATE_INBYTES_HALF);
        for (i = 0; i < this.RATE_INBYTES_HALF - 1; ++i) {
            OuterState_part1_ROTR1[i] = (byte)((this.state[i] & 0xFF) >>> 1 | (this.state[i + 1] & 1) << 7);
        }
        OuterState_part1_ROTR1[this.RATE_INBYTES_HALF - 1] = (byte)((this.state[i] & 0xFF) >>> 1 | (this.state[0] & 1) << 7);
        Bytes.xor(loop_end, this.state, this.RATE_INBYTES_HALF, plaintext, inOff, ciphertext, outOff);
        Bytes.xor(DBlen_inbytes - loop_end, OuterState_part1_ROTR1, loop_end - this.RATE_INBYTES_HALF, plaintext, inOff + loop_end, ciphertext, outOff + loop_end);
    }

    public static void photonPermutation(PhotonBeetleDigest.Friend friend, byte[] state) {
        if (null == friend) {
            throw new NullPointerException("This method is only for use by PhotonBeetleDigest");
        }
        PhotonBeetleEngine.photonPermutation(state);
    }

    public static enum PhotonBeetleParameters {
        pb32,
        pb128;

    }
}

