/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.crypto.mldsa;

import org.bouncycastle.crypto.digests.SHAKEDigest;
import org.bouncycastle.pqc.crypto.mldsa.MLDSAEngine;
import org.bouncycastle.pqc.crypto.mldsa.Ntt;
import org.bouncycastle.pqc.crypto.mldsa.PolyVecL;
import org.bouncycastle.pqc.crypto.mldsa.Reduce;
import org.bouncycastle.pqc.crypto.mldsa.Rounding;
import org.bouncycastle.pqc.crypto.mldsa.Symmetric;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
class Poly {
    private static final int DilithiumN = 256;
    private final int polyUniformNBlocks;
    private int[] coeffs = new int[256];
    private final MLDSAEngine engine;
    private final Symmetric symmetric;

    public Poly(MLDSAEngine engine) {
        this.engine = engine;
        this.symmetric = engine.GetSymmetric();
        this.polyUniformNBlocks = (768 + this.symmetric.stream128BlockBytes - 1) / this.symmetric.stream128BlockBytes;
    }

    void copyTo(Poly z) {
        System.arraycopy(this.coeffs, 0, z.coeffs, 0, 256);
    }

    public int getCoeffIndex(int i) {
        return this.coeffs[i];
    }

    public int[] getCoeffs() {
        return this.coeffs;
    }

    public void setCoeffIndex(int i, int val) {
        this.coeffs[i] = val;
    }

    public void setCoeffs(int[] coeffs) {
        this.coeffs = coeffs;
    }

    public void uniformBlocks(byte[] seed, short nonce) {
        int buflen = this.polyUniformNBlocks * this.symmetric.stream128BlockBytes;
        byte[] buf = new byte[buflen + 2];
        this.symmetric.stream128init(seed, nonce);
        this.symmetric.stream128squeezeBlocks(buf, 0, buflen);
        for (int ctr = Poly.rejectUniform(this, 0, 256, buf, buflen); ctr < 256; ctr += Poly.rejectUniform(this, ctr, 256 - ctr, buf, buflen)) {
            int off = buflen % 3;
            for (int i = 0; i < off; ++i) {
                buf[i] = buf[buflen - off + i];
            }
            this.symmetric.stream128squeezeBlocks(buf, off, this.symmetric.stream128BlockBytes);
            buflen = this.symmetric.stream128BlockBytes + off;
        }
    }

    private static int rejectUniform(Poly outputPoly, int coeffOff, int len, byte[] inpBuf, int buflen) {
        int pos = 0;
        int ctr = 0;
        while (ctr < len && pos + 3 <= buflen) {
            int t = inpBuf[pos++] & 0xFF;
            t |= (inpBuf[pos++] & 0xFF) << 8;
            t |= (inpBuf[pos++] & 0xFF) << 16;
            if ((t &= 0x7FFFFF) >= 8380417) continue;
            outputPoly.setCoeffIndex(coeffOff + ctr, t);
            ++ctr;
        }
        return ctr;
    }

    public void uniformEta(byte[] seed, short nonce) {
        int polyUniformEtaNBlocks;
        int eta = this.engine.getDilithiumEta();
        if (this.engine.getDilithiumEta() == 2) {
            polyUniformEtaNBlocks = (136 + this.symmetric.stream256BlockBytes - 1) / this.symmetric.stream256BlockBytes;
        } else if (this.engine.getDilithiumEta() == 4) {
            polyUniformEtaNBlocks = (227 + this.symmetric.stream256BlockBytes - 1) / this.symmetric.stream256BlockBytes;
        } else {
            throw new RuntimeException("Wrong Dilithium Eta!");
        }
        int buflen = polyUniformEtaNBlocks * this.symmetric.stream256BlockBytes;
        byte[] buf = new byte[buflen];
        this.symmetric.stream256init(seed, nonce);
        this.symmetric.stream256squeezeBlocks(buf, 0, buflen);
        for (int ctr = Poly.rejectEta(this, 0, 256, buf, buflen, eta); ctr < 256; ctr += Poly.rejectEta(this, ctr, 256 - ctr, buf, this.symmetric.stream256BlockBytes, eta)) {
            this.symmetric.stream256squeezeBlocks(buf, 0, this.symmetric.stream256BlockBytes);
        }
    }

    private static int rejectEta(Poly outputPoly, int coeffOff, int len, byte[] buf, int buflen, int eta) {
        int pos = 0;
        int ctr = 0;
        while (ctr < len && pos < buflen) {
            int t0 = buf[pos] & 0xFF & 0xF;
            int t1 = (buf[pos++] & 0xFF) >> 4;
            if (eta == 2) {
                if (t0 < 15) {
                    t0 -= (205 * t0 >> 10) * 5;
                    outputPoly.setCoeffIndex(coeffOff + ctr, 2 - t0);
                    ++ctr;
                }
                if (t1 >= 15 || ctr >= len) continue;
                t1 -= (205 * t1 >> 10) * 5;
                outputPoly.setCoeffIndex(coeffOff + ctr, 2 - t1);
                ++ctr;
                continue;
            }
            if (eta != 4) continue;
            if (t0 < 9) {
                outputPoly.setCoeffIndex(coeffOff + ctr, 4 - t0);
                ++ctr;
            }
            if (t1 >= 9 || ctr >= len) continue;
            outputPoly.setCoeffIndex(coeffOff + ctr, 4 - t1);
            ++ctr;
        }
        return ctr;
    }

    public void polyNtt() {
        this.setCoeffs(Ntt.ntt(this.coeffs));
    }

    public void pointwiseMontgomery(Poly v, Poly w) {
        for (int i = 0; i < 256; ++i) {
            this.setCoeffIndex(i, Reduce.montgomeryReduce((long)v.getCoeffIndex(i) * (long)w.getCoeffIndex(i)));
        }
    }

    public void pointwiseAccountMontgomery(PolyVecL u, PolyVecL v) {
        Poly t = new Poly(this.engine);
        this.pointwiseMontgomery(u.getVectorIndex(0), v.getVectorIndex(0));
        for (int i = 1; i < this.engine.getDilithiumL(); ++i) {
            t.pointwiseMontgomery(u.getVectorIndex(i), v.getVectorIndex(i));
            this.addPoly(t);
        }
    }

    public void addPoly(Poly a) {
        for (int i = 0; i < 256; ++i) {
            this.setCoeffIndex(i, this.getCoeffIndex(i) + a.getCoeffIndex(i));
        }
    }

    public void reduce() {
        for (int i = 0; i < 256; ++i) {
            this.setCoeffIndex(i, Reduce.reduce32(this.getCoeffIndex(i)));
        }
    }

    public void invNttToMont() {
        this.setCoeffs(Ntt.invNttToMont(this.getCoeffs()));
    }

    public void conditionalAddQ() {
        for (int i = 0; i < 256; ++i) {
            this.setCoeffIndex(i, Reduce.conditionalAddQ(this.getCoeffIndex(i)));
        }
    }

    public void power2Round(Poly a) {
        Rounding.power2RoundAll(this.coeffs, a.coeffs);
    }

    public byte[] polyt1Pack() {
        byte[] out = new byte[320];
        for (int i = 0; i < 64; ++i) {
            out[5 * i + 0] = (byte)(this.coeffs[4 * i + 0] >> 0);
            out[5 * i + 1] = (byte)(this.coeffs[4 * i + 0] >> 8 | this.coeffs[4 * i + 1] << 2);
            out[5 * i + 2] = (byte)(this.coeffs[4 * i + 1] >> 6 | this.coeffs[4 * i + 2] << 4);
            out[5 * i + 3] = (byte)(this.coeffs[4 * i + 2] >> 4 | this.coeffs[4 * i + 3] << 6);
            out[5 * i + 4] = (byte)(this.coeffs[4 * i + 3] >> 2);
        }
        return out;
    }

    public void polyt1Unpack(byte[] a) {
        for (int i = 0; i < 64; ++i) {
            this.setCoeffIndex(4 * i + 0, ((a[5 * i + 0] & 0xFF) >> 0 | (a[5 * i + 1] & 0xFF) << 8) & 0x3FF);
            this.setCoeffIndex(4 * i + 1, ((a[5 * i + 1] & 0xFF) >> 2 | (a[5 * i + 2] & 0xFF) << 6) & 0x3FF);
            this.setCoeffIndex(4 * i + 2, ((a[5 * i + 2] & 0xFF) >> 4 | (a[5 * i + 3] & 0xFF) << 4) & 0x3FF);
            this.setCoeffIndex(4 * i + 3, ((a[5 * i + 3] & 0xFF) >> 6 | (a[5 * i + 4] & 0xFF) << 2) & 0x3FF);
        }
    }

    public byte[] polyEtaPack(byte[] out, int outOff) {
        byte[] t = new byte[8];
        if (this.engine.getDilithiumEta() == 2) {
            for (int i = 0; i < 32; ++i) {
                t[0] = (byte)(this.engine.getDilithiumEta() - this.getCoeffIndex(8 * i + 0));
                t[1] = (byte)(this.engine.getDilithiumEta() - this.getCoeffIndex(8 * i + 1));
                t[2] = (byte)(this.engine.getDilithiumEta() - this.getCoeffIndex(8 * i + 2));
                t[3] = (byte)(this.engine.getDilithiumEta() - this.getCoeffIndex(8 * i + 3));
                t[4] = (byte)(this.engine.getDilithiumEta() - this.getCoeffIndex(8 * i + 4));
                t[5] = (byte)(this.engine.getDilithiumEta() - this.getCoeffIndex(8 * i + 5));
                t[6] = (byte)(this.engine.getDilithiumEta() - this.getCoeffIndex(8 * i + 6));
                t[7] = (byte)(this.engine.getDilithiumEta() - this.getCoeffIndex(8 * i + 7));
                out[outOff + 3 * i + 0] = (byte)(t[0] >> 0 | t[1] << 3 | t[2] << 6);
                out[outOff + 3 * i + 1] = (byte)(t[2] >> 2 | t[3] << 1 | t[4] << 4 | t[5] << 7);
                out[outOff + 3 * i + 2] = (byte)(t[5] >> 1 | t[6] << 2 | t[7] << 5);
            }
        } else if (this.engine.getDilithiumEta() == 4) {
            for (int i = 0; i < 128; ++i) {
                t[0] = (byte)(this.engine.getDilithiumEta() - this.getCoeffIndex(2 * i + 0));
                t[1] = (byte)(this.engine.getDilithiumEta() - this.getCoeffIndex(2 * i + 1));
                out[outOff + i] = (byte)(t[0] | t[1] << 4);
            }
        } else {
            throw new RuntimeException("Eta needs to be 2 or 4!");
        }
        return out;
    }

    public void polyEtaUnpack(byte[] a, int aOff) {
        block3: {
            int eta;
            block2: {
                eta = this.engine.getDilithiumEta();
                if (this.engine.getDilithiumEta() != 2) break block2;
                for (int i = 0; i < 32; ++i) {
                    int base = aOff + 3 * i;
                    this.setCoeffIndex(8 * i + 0, (a[base + 0] & 0xFF) >> 0 & 7);
                    this.setCoeffIndex(8 * i + 1, (a[base + 0] & 0xFF) >> 3 & 7);
                    this.setCoeffIndex(8 * i + 2, (a[base + 0] & 0xFF) >> 6 | (a[base + 1] & 0xFF) << 2 & 7);
                    this.setCoeffIndex(8 * i + 3, (a[base + 1] & 0xFF) >> 1 & 7);
                    this.setCoeffIndex(8 * i + 4, (a[base + 1] & 0xFF) >> 4 & 7);
                    this.setCoeffIndex(8 * i + 5, (a[base + 1] & 0xFF) >> 7 | (a[base + 2] & 0xFF) << 1 & 7);
                    this.setCoeffIndex(8 * i + 6, (a[base + 2] & 0xFF) >> 2 & 7);
                    this.setCoeffIndex(8 * i + 7, (a[base + 2] & 0xFF) >> 5 & 7);
                    this.setCoeffIndex(8 * i + 0, eta - this.getCoeffIndex(8 * i + 0));
                    this.setCoeffIndex(8 * i + 1, eta - this.getCoeffIndex(8 * i + 1));
                    this.setCoeffIndex(8 * i + 2, eta - this.getCoeffIndex(8 * i + 2));
                    this.setCoeffIndex(8 * i + 3, eta - this.getCoeffIndex(8 * i + 3));
                    this.setCoeffIndex(8 * i + 4, eta - this.getCoeffIndex(8 * i + 4));
                    this.setCoeffIndex(8 * i + 5, eta - this.getCoeffIndex(8 * i + 5));
                    this.setCoeffIndex(8 * i + 6, eta - this.getCoeffIndex(8 * i + 6));
                    this.setCoeffIndex(8 * i + 7, eta - this.getCoeffIndex(8 * i + 7));
                }
                break block3;
            }
            if (this.engine.getDilithiumEta() != 4) break block3;
            for (int i = 0; i < 128; ++i) {
                this.setCoeffIndex(2 * i + 0, a[aOff + i] & 0xF);
                this.setCoeffIndex(2 * i + 1, (a[aOff + i] & 0xFF) >> 4);
                this.setCoeffIndex(2 * i + 0, eta - this.getCoeffIndex(2 * i + 0));
                this.setCoeffIndex(2 * i + 1, eta - this.getCoeffIndex(2 * i + 1));
            }
        }
    }

    public byte[] polyt0Pack(byte[] out, int outOff) {
        int[] t = new int[8];
        for (int i = 0; i < 32; ++i) {
            t[0] = 4096 - this.getCoeffIndex(8 * i + 0);
            t[1] = 4096 - this.getCoeffIndex(8 * i + 1);
            t[2] = 4096 - this.getCoeffIndex(8 * i + 2);
            t[3] = 4096 - this.getCoeffIndex(8 * i + 3);
            t[4] = 4096 - this.getCoeffIndex(8 * i + 4);
            t[5] = 4096 - this.getCoeffIndex(8 * i + 5);
            t[6] = 4096 - this.getCoeffIndex(8 * i + 6);
            t[7] = 4096 - this.getCoeffIndex(8 * i + 7);
            int base = outOff + 13 * i;
            out[base + 0] = (byte)t[0];
            out[base + 1] = (byte)(t[0] >> 8);
            out[base + 1] = (byte)(out[base + 1] | (byte)(t[1] << 5));
            out[base + 2] = (byte)(t[1] >> 3);
            out[base + 3] = (byte)(t[1] >> 11);
            out[base + 3] = (byte)(out[base + 3] | (byte)(t[2] << 2));
            out[base + 4] = (byte)(t[2] >> 6);
            out[base + 4] = (byte)(out[base + 4] | (byte)(t[3] << 7));
            out[base + 5] = (byte)(t[3] >> 1);
            out[base + 6] = (byte)(t[3] >> 9);
            out[base + 6] = (byte)(out[base + 6] | (byte)(t[4] << 4));
            out[base + 7] = (byte)(t[4] >> 4);
            out[base + 8] = (byte)(t[4] >> 12);
            out[base + 8] = (byte)(out[base + 8] | (byte)(t[5] << 1));
            out[base + 9] = (byte)(t[5] >> 7);
            out[base + 9] = (byte)(out[base + 9] | (byte)(t[6] << 6));
            out[base + 10] = (byte)(t[6] >> 2);
            out[base + 11] = (byte)(t[6] >> 10);
            out[base + 11] = (byte)(out[base + 11] | (byte)(t[7] << 3));
            out[base + 12] = (byte)(t[7] >> 5);
        }
        return out;
    }

    public void polyt0Unpack(byte[] a, int aOff) {
        for (int i = 0; i < 32; ++i) {
            int base = aOff + 13 * i;
            this.setCoeffIndex(8 * i + 0, (a[base + 0] & 0xFF | (a[base + 1] & 0xFF) << 8) & 0x1FFF);
            this.setCoeffIndex(8 * i + 1, ((a[base + 1] & 0xFF) >> 5 | (a[base + 2] & 0xFF) << 3 | (a[base + 3] & 0xFF) << 11) & 0x1FFF);
            this.setCoeffIndex(8 * i + 2, ((a[base + 3] & 0xFF) >> 2 | (a[base + 4] & 0xFF) << 6) & 0x1FFF);
            this.setCoeffIndex(8 * i + 3, ((a[base + 4] & 0xFF) >> 7 | (a[base + 5] & 0xFF) << 1 | (a[base + 6] & 0xFF) << 9) & 0x1FFF);
            this.setCoeffIndex(8 * i + 4, ((a[base + 6] & 0xFF) >> 4 | (a[base + 7] & 0xFF) << 4 | (a[base + 8] & 0xFF) << 12) & 0x1FFF);
            this.setCoeffIndex(8 * i + 5, ((a[base + 8] & 0xFF) >> 1 | (a[base + 9] & 0xFF) << 7) & 0x1FFF);
            this.setCoeffIndex(8 * i + 6, ((a[base + 9] & 0xFF) >> 6 | (a[base + 10] & 0xFF) << 2 | (a[base + 11] & 0xFF) << 10) & 0x1FFF);
            this.setCoeffIndex(8 * i + 7, ((a[base + 11] & 0xFF) >> 3 | (a[base + 12] & 0xFF) << 5) & 0x1FFF);
            this.setCoeffIndex(8 * i + 0, 4096 - this.getCoeffIndex(8 * i + 0));
            this.setCoeffIndex(8 * i + 1, 4096 - this.getCoeffIndex(8 * i + 1));
            this.setCoeffIndex(8 * i + 2, 4096 - this.getCoeffIndex(8 * i + 2));
            this.setCoeffIndex(8 * i + 3, 4096 - this.getCoeffIndex(8 * i + 3));
            this.setCoeffIndex(8 * i + 4, 4096 - this.getCoeffIndex(8 * i + 4));
            this.setCoeffIndex(8 * i + 5, 4096 - this.getCoeffIndex(8 * i + 5));
            this.setCoeffIndex(8 * i + 6, 4096 - this.getCoeffIndex(8 * i + 6));
            this.setCoeffIndex(8 * i + 7, 4096 - this.getCoeffIndex(8 * i + 7));
        }
    }

    public void uniformGamma1(byte[] seed, short nonce) {
        byte[] buf = new byte[this.engine.getPolyUniformGamma1NBlocks() * this.symmetric.stream256BlockBytes];
        this.symmetric.stream256init(seed, nonce);
        this.symmetric.stream256squeezeBlocks(buf, 0, this.engine.getPolyUniformGamma1NBlocks() * this.symmetric.stream256BlockBytes);
        this.unpackZ(buf);
    }

    private void unpackZ(byte[] a) {
        int gamma1 = this.engine.getDilithiumGamma1();
        if (gamma1 == 131072) {
            for (int i = 0; i < 64; ++i) {
                this.setCoeffIndex(4 * i + 0, (a[9 * i + 0] & 0xFF | (a[9 * i + 1] & 0xFF) << 8 | (a[9 * i + 2] & 0xFF) << 16) & 0x3FFFF);
                this.setCoeffIndex(4 * i + 1, ((a[9 * i + 2] & 0xFF) >> 2 | (a[9 * i + 3] & 0xFF) << 6 | (a[9 * i + 4] & 0xFF) << 14) & 0x3FFFF);
                this.setCoeffIndex(4 * i + 2, ((a[9 * i + 4] & 0xFF) >> 4 | (a[9 * i + 5] & 0xFF) << 4 | (a[9 * i + 6] & 0xFF) << 12) & 0x3FFFF);
                this.setCoeffIndex(4 * i + 3, ((a[9 * i + 6] & 0xFF) >> 6 | (a[9 * i + 7] & 0xFF) << 2 | (a[9 * i + 8] & 0xFF) << 10) & 0x3FFFF);
                this.setCoeffIndex(4 * i + 0, gamma1 - this.getCoeffIndex(4 * i + 0));
                this.setCoeffIndex(4 * i + 1, gamma1 - this.getCoeffIndex(4 * i + 1));
                this.setCoeffIndex(4 * i + 2, gamma1 - this.getCoeffIndex(4 * i + 2));
                this.setCoeffIndex(4 * i + 3, gamma1 - this.getCoeffIndex(4 * i + 3));
            }
        } else if (gamma1 == 524288) {
            for (int i = 0; i < 128; ++i) {
                this.setCoeffIndex(2 * i + 0, (a[5 * i + 0] & 0xFF | (a[5 * i + 1] & 0xFF) << 8 | (a[5 * i + 2] & 0xFF) << 16) & 0xFFFFF);
                this.setCoeffIndex(2 * i + 1, ((a[5 * i + 2] & 0xFF) >> 4 | (a[5 * i + 3] & 0xFF) << 4 | (a[5 * i + 4] & 0xFF) << 12) & 0xFFFFF);
                this.setCoeffIndex(2 * i + 0, gamma1 - this.getCoeffIndex(2 * i + 0));
                this.setCoeffIndex(2 * i + 1, gamma1 - this.getCoeffIndex(2 * i + 1));
            }
        } else {
            throw new RuntimeException("Wrong Dilithiumn Gamma1!");
        }
    }

    public void decompose(Poly a) {
        int gamma2 = this.engine.getDilithiumGamma2();
        for (int i = 0; i < 256; ++i) {
            int[] decomp = Rounding.decompose(this.getCoeffIndex(i), gamma2);
            this.setCoeffIndex(i, decomp[1]);
            a.setCoeffIndex(i, decomp[0]);
        }
    }

    void packW1(byte[] r, int rOff) {
        block3: {
            block2: {
                int gamma2 = this.engine.getDilithiumGamma2();
                if (gamma2 != 95232) break block2;
                for (int i = 0; i < 64; ++i) {
                    r[rOff + 3 * i + 0] = (byte)((byte)this.getCoeffIndex(4 * i + 0) | this.getCoeffIndex(4 * i + 1) << 6);
                    r[rOff + 3 * i + 1] = (byte)((byte)(this.getCoeffIndex(4 * i + 1) >> 2) | this.getCoeffIndex(4 * i + 2) << 4);
                    r[rOff + 3 * i + 2] = (byte)((byte)(this.getCoeffIndex(4 * i + 2) >> 4) | this.getCoeffIndex(4 * i + 3) << 2);
                }
                break block3;
            }
            if (this.engine.getDilithiumGamma2() != 261888) break block3;
            for (int i = 0; i < 128; ++i) {
                r[rOff + i] = (byte)(this.getCoeffIndex(2 * i + 0) | this.getCoeffIndex(2 * i + 1) << 4);
            }
        }
    }

    public void challenge(byte[] seed, int seedOff, int seedLen) {
        int i;
        int b = 0;
        byte[] buf = new byte[this.symmetric.stream256BlockBytes];
        SHAKEDigest shake256Digest = new SHAKEDigest(256);
        shake256Digest.update(seed, seedOff, seedLen);
        shake256Digest.doOutput(buf, 0, this.symmetric.stream256BlockBytes);
        long signs = 0L;
        for (i = 0; i < 8; ++i) {
            signs |= (long)(buf[i] & 0xFF) << 8 * i;
        }
        int pos = 8;
        for (i = 0; i < 256; ++i) {
            this.setCoeffIndex(i, 0);
        }
        for (i = 256 - this.engine.getDilithiumTau(); i < 256; ++i) {
            do {
                if (pos < this.symmetric.stream256BlockBytes) continue;
                shake256Digest.doOutput(buf, 0, this.symmetric.stream256BlockBytes);
                pos = 0;
            } while ((b = buf[pos++] & 0xFF) > i);
            this.setCoeffIndex(i, this.getCoeffIndex(b));
            this.setCoeffIndex(b, (int)(1L - 2L * (signs & 1L)));
            signs >>= 1;
        }
    }

    public boolean checkNorm(int B) {
        if (B > 1047552) {
            return true;
        }
        for (int i = 0; i < 256; ++i) {
            int t = this.getCoeffIndex(i) >> 31;
            t = this.getCoeffIndex(i) - (t & 2 * this.getCoeffIndex(i));
            if (t < B) continue;
            return true;
        }
        return false;
    }

    public void subtract(Poly inpPoly) {
        for (int i = 0; i < 256; ++i) {
            this.setCoeffIndex(i, this.getCoeffIndex(i) - inpPoly.getCoeffIndex(i));
        }
    }

    public int polyMakeHint(Poly a0, Poly a1) {
        int s = 0;
        for (int i = 0; i < 256; ++i) {
            this.setCoeffIndex(i, Rounding.makeHint(a0.getCoeffIndex(i), a1.getCoeffIndex(i), this.engine));
            s += this.getCoeffIndex(i);
        }
        return s;
    }

    public void polyUseHint(Poly a, Poly h) {
        for (int i = 0; i < 256; ++i) {
            this.setCoeffIndex(i, Rounding.useHint(a.getCoeffIndex(i), h.getCoeffIndex(i), this.engine.getDilithiumGamma2()));
        }
    }

    public void zPack(byte[] z, int zOff) {
        int gamma1 = this.engine.getDilithiumGamma1();
        if (gamma1 == 131072) {
            for (int i = 0; i < 64; ++i) {
                int t0 = gamma1 - this.getCoeffIndex(4 * i + 0);
                int t1 = gamma1 - this.getCoeffIndex(4 * i + 1);
                int t2 = gamma1 - this.getCoeffIndex(4 * i + 2);
                int t3 = gamma1 - this.getCoeffIndex(4 * i + 3);
                z[zOff + 9 * i + 0] = (byte)t0;
                z[zOff + 9 * i + 1] = (byte)(t0 >> 8);
                z[zOff + 9 * i + 2] = (byte)((byte)(t0 >> 16) | t1 << 2);
                z[zOff + 9 * i + 3] = (byte)(t1 >> 6);
                z[zOff + 9 * i + 4] = (byte)((byte)(t1 >> 14) | t2 << 4);
                z[zOff + 9 * i + 5] = (byte)(t2 >> 4);
                z[zOff + 9 * i + 6] = (byte)((byte)(t2 >> 12) | t3 << 6);
                z[zOff + 9 * i + 7] = (byte)(t3 >> 2);
                z[zOff + 9 * i + 8] = (byte)(t3 >> 10);
            }
        } else if (gamma1 == 524288) {
            for (int i = 0; i < 128; ++i) {
                int t0 = gamma1 - this.getCoeffIndex(2 * i + 0);
                int t1 = gamma1 - this.getCoeffIndex(2 * i + 1);
                z[zOff + 5 * i + 0] = (byte)t0;
                z[zOff + 5 * i + 1] = (byte)(t0 >> 8);
                z[zOff + 5 * i + 2] = (byte)((byte)(t0 >> 16) | t1 << 4);
                z[zOff + 5 * i + 3] = (byte)(t1 >> 4);
                z[zOff + 5 * i + 4] = (byte)(t1 >> 12);
            }
        } else {
            throw new RuntimeException("Wrong Dilithium Gamma1!");
        }
    }

    void zUnpack(byte[] a) {
        if (this.engine.getDilithiumGamma1() == 131072) {
            for (int i = 0; i < 64; ++i) {
                this.setCoeffIndex(4 * i + 0, (a[9 * i + 0] & 0xFF | (a[9 * i + 1] & 0xFF) << 8 | (a[9 * i + 2] & 0xFF) << 16) & 0x3FFFF);
                this.setCoeffIndex(4 * i + 1, ((a[9 * i + 2] & 0xFF) >>> 2 | (a[9 * i + 3] & 0xFF) << 6 | (a[9 * i + 4] & 0xFF) << 14) & 0x3FFFF);
                this.setCoeffIndex(4 * i + 2, ((a[9 * i + 4] & 0xFF) >>> 4 | (a[9 * i + 5] & 0xFF) << 4 | (a[9 * i + 6] & 0xFF) << 12) & 0x3FFFF);
                this.setCoeffIndex(4 * i + 3, ((a[9 * i + 6] & 0xFF) >>> 6 | (a[9 * i + 7] & 0xFF) << 2 | (a[9 * i + 8] & 0xFF) << 10) & 0x3FFFF);
                this.setCoeffIndex(4 * i + 0, this.engine.getDilithiumGamma1() - this.getCoeffIndex(4 * i + 0));
                this.setCoeffIndex(4 * i + 1, this.engine.getDilithiumGamma1() - this.getCoeffIndex(4 * i + 1));
                this.setCoeffIndex(4 * i + 2, this.engine.getDilithiumGamma1() - this.getCoeffIndex(4 * i + 2));
                this.setCoeffIndex(4 * i + 3, this.engine.getDilithiumGamma1() - this.getCoeffIndex(4 * i + 3));
            }
        } else if (this.engine.getDilithiumGamma1() == 524288) {
            for (int i = 0; i < 128; ++i) {
                this.setCoeffIndex(2 * i + 0, (a[5 * i + 0] & 0xFF | (a[5 * i + 1] & 0xFF) << 8 | (a[5 * i + 2] & 0xFF) << 16) & 0xFFFFF);
                this.setCoeffIndex(2 * i + 1, ((a[5 * i + 2] & 0xFF) >>> 4 | (a[5 * i + 3] & 0xFF) << 4 | (a[5 * i + 4] & 0xFF) << 12) & 0xFFFFF);
                this.setCoeffIndex(2 * i + 0, this.engine.getDilithiumGamma1() - this.getCoeffIndex(2 * i + 0));
                this.setCoeffIndex(2 * i + 1, this.engine.getDilithiumGamma1() - this.getCoeffIndex(2 * i + 1));
            }
        } else {
            throw new RuntimeException("Wrong Dilithium Gamma1!");
        }
    }

    public void shiftLeft() {
        for (int i = 0; i < 256; ++i) {
            this.setCoeffIndex(i, this.getCoeffIndex(i) << 13);
        }
    }

    public String toString() {
        StringBuilder out = new StringBuilder();
        out.append("[");
        for (int i = 0; i < this.coeffs.length; ++i) {
            out.append(this.coeffs[i]);
            if (i == this.coeffs.length - 1) continue;
            out.append(", ");
        }
        out.append("]");
        return out.toString();
    }
}

