/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jcajce.provider.asymmetric.compositesignatures;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bouncycastle.asn1.ASN1BitString;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERBitString;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.bc.BCObjectIdentifiers;
import org.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.asn1.sec.SECObjectIdentifiers;
import org.bouncycastle.asn1.teletrust.TeleTrusTObjectIdentifiers;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.asn1.x9.X962Parameters;
import org.bouncycastle.asn1.x9.X9ObjectIdentifiers;
import org.bouncycastle.internal.asn1.edec.EdECObjectIdentifiers;
import org.bouncycastle.internal.asn1.misc.MiscObjectIdentifiers;
import org.bouncycastle.jcajce.CompositePrivateKey;
import org.bouncycastle.jcajce.CompositePublicKey;
import org.bouncycastle.jcajce.provider.asymmetric.compositesignatures.CompositeIndex;
import org.bouncycastle.jcajce.provider.asymmetric.util.BaseKeyFactorySpi;
import org.bouncycastle.jcajce.provider.util.AsymmetricKeyInfoConverter;
import org.bouncycastle.jcajce.util.BCJcaJceHelper;
import org.bouncycastle.jcajce.util.JcaJceHelper;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.Exceptions;

public class KeyFactorySpi
extends BaseKeyFactorySpi
implements AsymmetricKeyInfoConverter {
    private static final AlgorithmIdentifier mlDsa44 = new AlgorithmIdentifier(NISTObjectIdentifiers.id_ml_dsa_44);
    private static final AlgorithmIdentifier mlDsa65 = new AlgorithmIdentifier(NISTObjectIdentifiers.id_ml_dsa_65);
    private static final AlgorithmIdentifier mlDsa87 = new AlgorithmIdentifier(NISTObjectIdentifiers.id_ml_dsa_87);
    private static final AlgorithmIdentifier falcon512Identifier = new AlgorithmIdentifier(BCObjectIdentifiers.falcon_512);
    private static final AlgorithmIdentifier ed25519 = new AlgorithmIdentifier(EdECObjectIdentifiers.id_Ed25519);
    private static final AlgorithmIdentifier ecDsaP256 = new AlgorithmIdentifier(X9ObjectIdentifiers.id_ecPublicKey, new X962Parameters(SECObjectIdentifiers.secp256r1));
    private static final AlgorithmIdentifier ecDsaBrainpoolP256r1 = new AlgorithmIdentifier(X9ObjectIdentifiers.id_ecPublicKey, new X962Parameters(TeleTrusTObjectIdentifiers.brainpoolP256r1));
    private static final AlgorithmIdentifier rsa = new AlgorithmIdentifier(PKCSObjectIdentifiers.rsaEncryption);
    private static final AlgorithmIdentifier ed448 = new AlgorithmIdentifier(EdECObjectIdentifiers.id_Ed448);
    private static final AlgorithmIdentifier ecDsaP384 = new AlgorithmIdentifier(X9ObjectIdentifiers.id_ecPublicKey, new X962Parameters(SECObjectIdentifiers.secp384r1));
    private static final AlgorithmIdentifier ecDsaP521 = new AlgorithmIdentifier(X9ObjectIdentifiers.id_ecPublicKey, new X962Parameters(SECObjectIdentifiers.secp521r1));
    private static final AlgorithmIdentifier ecDsaBrainpoolP384r1 = new AlgorithmIdentifier(X9ObjectIdentifiers.id_ecPublicKey, new X962Parameters(TeleTrusTObjectIdentifiers.brainpoolP384r1));
    private static Map<ASN1ObjectIdentifier, AlgorithmIdentifier[]> pairings = new HashMap<ASN1ObjectIdentifier, AlgorithmIdentifier[]>();
    private static Map<ASN1ObjectIdentifier, int[]> componentKeySizes = new HashMap<ASN1ObjectIdentifier, int[]>();
    private JcaJceHelper helper;

    public KeyFactorySpi() {
        this(null);
    }

    public KeyFactorySpi(JcaJceHelper helper) {
        this.helper = helper;
    }

    @Override
    protected Key engineTranslateKey(Key key) throws InvalidKeyException {
        if (this.helper == null) {
            this.helper = new BCJcaJceHelper();
        }
        try {
            if (key instanceof PrivateKey) {
                return this.generatePrivate(PrivateKeyInfo.getInstance(key.getEncoded()));
            }
            if (key instanceof PublicKey) {
                return this.generatePublic(SubjectPublicKeyInfo.getInstance(key.getEncoded()));
            }
        }
        catch (IOException e) {
            throw new InvalidKeyException("Key could not be parsed: " + e.getMessage());
        }
        throw new InvalidKeyException("Key not recognized");
    }

    @Override
    public PrivateKey generatePrivate(PrivateKeyInfo keyInfo) throws IOException {
        ASN1ObjectIdentifier keyIdentifier;
        if (this.helper == null) {
            this.helper = new BCJcaJceHelper();
        }
        if (MiscObjectIdentifiers.id_alg_composite.equals(keyIdentifier = keyInfo.getPrivateKeyAlgorithm().getAlgorithm()) || MiscObjectIdentifiers.id_composite_key.equals(keyIdentifier)) {
            ASN1Sequence seq = DERSequence.getInstance(keyInfo.parsePrivateKey());
            PrivateKey[] privKeys = new PrivateKey[seq.size()];
            for (int i = 0; i != seq.size(); ++i) {
                ASN1Sequence kSeq = ASN1Sequence.getInstance(seq.getObjectAt(i));
                PrivateKeyInfo privInfo = PrivateKeyInfo.getInstance(kSeq);
                try {
                    privKeys[i] = this.helper.createKeyFactory(privInfo.getPrivateKeyAlgorithm().getAlgorithm().getId()).generatePrivate(new PKCS8EncodedKeySpec(privInfo.getEncoded()));
                    continue;
                }
                catch (Exception e) {
                    throw new IOException("cannot decode generic composite: " + e.getMessage(), e);
                }
            }
            return new CompositePrivateKey(privKeys);
        }
        try {
            byte[] data;
            List<KeyFactory> factories = this.getKeyFactoriesFromIdentifier(keyIdentifier);
            ASN1EncodableVector v = new ASN1EncodableVector();
            try {
                data = DEROctetString.getInstance(keyInfo.parsePrivateKey()).getOctets();
            }
            catch (Exception e) {
                data = keyInfo.getPrivateKey().getOctets();
            }
            v.add(new DEROctetString(Arrays.copyOfRange(data, 0, 32)));
            v.add(new DEROctetString(Arrays.copyOfRange(data, 32, data.length)));
            DERSequence seq = new DERSequence(v);
            PrivateKey[] privateKeys = new PrivateKey[seq.size()];
            AlgorithmIdentifier[] algIds = pairings.get(keyIdentifier);
            for (int i = 0; i < seq.size(); ++i) {
                if (seq.getObjectAt(i) instanceof ASN1OctetString) {
                    v = new ASN1EncodableVector(3);
                    v.add(keyInfo.getVersion());
                    v.add(algIds[i]);
                    v.add(seq.getObjectAt(i));
                    PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(PrivateKeyInfo.getInstance(new DERSequence(v)).getEncoded());
                    privateKeys[i] = factories.get(i).generatePrivate(keySpec);
                    continue;
                }
                ASN1Sequence keySeq = ASN1Sequence.getInstance(seq.getObjectAt(i));
                PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(PrivateKeyInfo.getInstance(keySeq).getEncoded());
                privateKeys[i] = factories.get(i).generatePrivate(keySpec);
            }
            return new CompositePrivateKey(keyIdentifier, privateKeys);
        }
        catch (GeneralSecurityException e) {
            throw Exceptions.ioException(e.getMessage(), e);
        }
    }

    @Override
    public PublicKey generatePublic(SubjectPublicKeyInfo keyInfo) throws IOException {
        if (this.helper == null) {
            this.helper = new BCJcaJceHelper();
        }
        ASN1ObjectIdentifier keyIdentifier = keyInfo.getAlgorithm().getAlgorithm();
        ASN1Sequence seq = null;
        Object componentKeys = new byte[2][];
        try {
            seq = DERSequence.getInstance(keyInfo.getPublicKeyData().getBytes());
        }
        catch (Exception e) {
            componentKeys = this.split(keyIdentifier, keyInfo.getPublicKeyData());
        }
        if (MiscObjectIdentifiers.id_alg_composite.equals(keyIdentifier) || MiscObjectIdentifiers.id_composite_key.equals(keyIdentifier)) {
            ASN1Sequence keySeq = ASN1Sequence.getInstance(keyInfo.getPublicKeyData().getBytes());
            PublicKey[] pubKeys = new PublicKey[keySeq.size()];
            for (int i = 0; i != keySeq.size(); ++i) {
                SubjectPublicKeyInfo pubInfo = SubjectPublicKeyInfo.getInstance(keySeq.getObjectAt(i));
                try {
                    pubKeys[i] = this.helper.createKeyFactory(pubInfo.getAlgorithm().getAlgorithm().getId()).generatePublic(new X509EncodedKeySpec(pubInfo.getEncoded()));
                    continue;
                }
                catch (Exception e) {
                    throw new IOException("cannot decode generic composite: " + e.getMessage(), e);
                }
            }
            return new CompositePublicKey(pubKeys);
        }
        try {
            int numKeys = seq == null ? ((byte[][])componentKeys).length : seq.size();
            List<KeyFactory> factories = this.getKeyFactoriesFromIdentifier(keyIdentifier);
            ASN1BitString[] componentBitStrings = new ASN1BitString[numKeys];
            for (int i = 0; i < numKeys; ++i) {
                if (seq != null) {
                    if (seq.getObjectAt(i) instanceof DEROctetString) {
                        componentBitStrings[i] = new DERBitString(((DEROctetString)seq.getObjectAt(i)).getOctets());
                        continue;
                    }
                    componentBitStrings[i] = (DERBitString)seq.getObjectAt(i);
                    continue;
                }
                componentBitStrings[i] = new DERBitString(componentKeys[i]);
            }
            X509EncodedKeySpec[] x509EncodedKeySpecs = this.getKeysSpecs(keyIdentifier, componentBitStrings);
            PublicKey[] publicKeys = new PublicKey[numKeys];
            for (int i = 0; i < numKeys; ++i) {
                publicKeys[i] = factories.get(i).generatePublic(x509EncodedKeySpecs[i]);
            }
            return new CompositePublicKey(keyIdentifier, publicKeys);
        }
        catch (GeneralSecurityException e) {
            throw Exceptions.ioException(e.getMessage(), e);
        }
    }

    byte[][] split(ASN1ObjectIdentifier algorithm, ASN1BitString publicKeyData) {
        int[] sizes = componentKeySizes.get(algorithm);
        byte[] keyData = publicKeyData.getOctets();
        byte[][] components = new byte[][]{new byte[sizes[0]], new byte[keyData.length - sizes[0]]};
        System.arraycopy(keyData, 0, components[0], 0, sizes[0]);
        System.arraycopy(keyData, sizes[0], components[1], 0, components[1].length);
        return components;
    }

    private List<KeyFactory> getKeyFactoriesFromIdentifier(ASN1ObjectIdentifier algorithmIdentifier) throws NoSuchAlgorithmException, NoSuchProviderException {
        ArrayList<KeyFactory> factories = new ArrayList<KeyFactory>();
        ArrayList algorithmNames = new ArrayList();
        String[] pairings = CompositeIndex.getPairing(algorithmIdentifier);
        if (pairings == null) {
            throw new NoSuchAlgorithmException("Cannot create KeyFactories. Unsupported algorithm identifier.");
        }
        factories.add(this.helper.createKeyFactory(CompositeIndex.getBaseName(pairings[0])));
        factories.add(this.helper.createKeyFactory(CompositeIndex.getBaseName(pairings[1])));
        return Collections.unmodifiableList(factories);
    }

    private X509EncodedKeySpec[] getKeysSpecs(ASN1ObjectIdentifier algorithmIdentifier, ASN1BitString[] subjectPublicKeys) throws IOException {
        X509EncodedKeySpec[] specs = new X509EncodedKeySpec[subjectPublicKeys.length];
        SubjectPublicKeyInfo[] keyInfos = new SubjectPublicKeyInfo[subjectPublicKeys.length];
        AlgorithmIdentifier[] algIds = pairings.get(algorithmIdentifier);
        if (algIds == null) {
            throw new IOException("Cannot create key specs. Unsupported algorithm identifier.");
        }
        keyInfos[0] = new SubjectPublicKeyInfo(algIds[0], subjectPublicKeys[0]);
        keyInfos[1] = new SubjectPublicKeyInfo(algIds[1], subjectPublicKeys[1]);
        specs[0] = new X509EncodedKeySpec(keyInfos[0].getEncoded());
        specs[1] = new X509EncodedKeySpec(keyInfos[1].getEncoded());
        return specs;
    }

    static {
        pairings.put(MiscObjectIdentifiers.id_MLDSA65_RSA3072_PSS_SHA256, new AlgorithmIdentifier[]{mlDsa65, rsa});
        pairings.put(MiscObjectIdentifiers.id_MLDSA65_RSA3072_PKCS15_SHA256, new AlgorithmIdentifier[]{mlDsa65, rsa});
        pairings.put(MiscObjectIdentifiers.id_MLDSA65_ECDSA_brainpoolP256r1_SHA256, new AlgorithmIdentifier[]{mlDsa65, ecDsaBrainpoolP256r1});
        pairings.put(MiscObjectIdentifiers.id_MLDSA87_Ed448_SHA512, new AlgorithmIdentifier[]{mlDsa87, ed448});
        pairings.put(MiscObjectIdentifiers.id_MLDSA44_RSA2048_PSS_SHA256, new AlgorithmIdentifier[]{mlDsa44, rsa});
        pairings.put(MiscObjectIdentifiers.id_MLDSA44_RSA2048_PKCS15_SHA256, new AlgorithmIdentifier[]{mlDsa44, rsa});
        pairings.put(MiscObjectIdentifiers.id_MLDSA44_Ed25519_SHA512, new AlgorithmIdentifier[]{mlDsa44, ed25519});
        pairings.put(MiscObjectIdentifiers.id_MLDSA44_ECDSA_P256_SHA256, new AlgorithmIdentifier[]{mlDsa44, ecDsaP256});
        pairings.put(MiscObjectIdentifiers.id_MLDSA65_RSA3072_PSS_SHA512, new AlgorithmIdentifier[]{mlDsa65, rsa});
        pairings.put(MiscObjectIdentifiers.id_MLDSA65_RSA3072_PKCS15_SHA512, new AlgorithmIdentifier[]{mlDsa65, rsa});
        pairings.put(MiscObjectIdentifiers.id_MLDSA65_RSA4096_PSS_SHA512, new AlgorithmIdentifier[]{mlDsa65, rsa});
        pairings.put(MiscObjectIdentifiers.id_MLDSA65_RSA4096_PKCS15_SHA512, new AlgorithmIdentifier[]{mlDsa65, rsa});
        pairings.put(MiscObjectIdentifiers.id_MLDSA65_ECDSA_P256_SHA512, new AlgorithmIdentifier[]{mlDsa65, ecDsaP256});
        pairings.put(MiscObjectIdentifiers.id_MLDSA65_ECDSA_P384_SHA512, new AlgorithmIdentifier[]{mlDsa65, ecDsaP384});
        pairings.put(MiscObjectIdentifiers.id_MLDSA65_ECDSA_brainpoolP256r1_SHA512, new AlgorithmIdentifier[]{mlDsa65, ecDsaBrainpoolP256r1});
        pairings.put(MiscObjectIdentifiers.id_MLDSA65_Ed25519_SHA512, new AlgorithmIdentifier[]{mlDsa65, ed25519});
        pairings.put(MiscObjectIdentifiers.id_MLDSA87_ECDSA_P384_SHA512, new AlgorithmIdentifier[]{mlDsa87, ecDsaP384});
        pairings.put(MiscObjectIdentifiers.id_MLDSA87_ECDSA_brainpoolP384r1_SHA512, new AlgorithmIdentifier[]{mlDsa87, ecDsaBrainpoolP384r1});
        pairings.put(MiscObjectIdentifiers.id_MLDSA87_Ed448_SHAKE256, new AlgorithmIdentifier[]{mlDsa87, ed448});
        pairings.put(MiscObjectIdentifiers.id_MLDSA87_RSA4096_PSS_SHA512, new AlgorithmIdentifier[]{mlDsa87, rsa});
        pairings.put(MiscObjectIdentifiers.id_MLDSA87_ECDSA_P521_SHA512, new AlgorithmIdentifier[]{mlDsa87, ecDsaP521});
        pairings.put(MiscObjectIdentifiers.id_MLDSA87_RSA3072_PSS_SHA512, new AlgorithmIdentifier[]{mlDsa87, rsa});
        componentKeySizes.put(MiscObjectIdentifiers.id_MLDSA65_RSA3072_PSS_SHA256, new int[]{1952, 256});
        componentKeySizes.put(MiscObjectIdentifiers.id_MLDSA65_RSA3072_PKCS15_SHA256, new int[]{1952, 256});
        componentKeySizes.put(MiscObjectIdentifiers.id_MLDSA65_ECDSA_brainpoolP256r1_SHA256, new int[]{1952, 76});
        componentKeySizes.put(MiscObjectIdentifiers.id_MLDSA87_Ed448_SHA512, new int[]{2592, 57});
        componentKeySizes.put(MiscObjectIdentifiers.id_MLDSA44_RSA2048_PSS_SHA256, new int[]{1312, 268});
        componentKeySizes.put(MiscObjectIdentifiers.id_MLDSA44_RSA2048_PKCS15_SHA256, new int[]{1312, 284});
        componentKeySizes.put(MiscObjectIdentifiers.id_MLDSA44_Ed25519_SHA512, new int[]{1312, 32});
        componentKeySizes.put(MiscObjectIdentifiers.id_MLDSA44_ECDSA_P256_SHA256, new int[]{1312, 76});
        componentKeySizes.put(MiscObjectIdentifiers.id_MLDSA65_RSA3072_PSS_SHA512, new int[]{1952, 256});
        componentKeySizes.put(MiscObjectIdentifiers.id_MLDSA65_RSA3072_PKCS15_SHA512, new int[]{1952, 256});
        componentKeySizes.put(MiscObjectIdentifiers.id_MLDSA65_RSA4096_PSS_SHA512, new int[]{1952, 542});
        componentKeySizes.put(MiscObjectIdentifiers.id_MLDSA65_RSA4096_PKCS15_SHA512, new int[]{1952, 542});
        componentKeySizes.put(MiscObjectIdentifiers.id_MLDSA65_ECDSA_P256_SHA512, new int[]{1952, 76});
        componentKeySizes.put(MiscObjectIdentifiers.id_MLDSA65_ECDSA_P384_SHA512, new int[]{1952, 87});
        componentKeySizes.put(MiscObjectIdentifiers.id_MLDSA65_ECDSA_brainpoolP256r1_SHA512, new int[]{1952, 76});
        componentKeySizes.put(MiscObjectIdentifiers.id_MLDSA65_Ed25519_SHA512, new int[]{1952, 32});
        componentKeySizes.put(MiscObjectIdentifiers.id_MLDSA87_ECDSA_P384_SHA512, new int[]{2592, 87});
        componentKeySizes.put(MiscObjectIdentifiers.id_MLDSA87_ECDSA_brainpoolP384r1_SHA512, new int[]{2592, 87});
        componentKeySizes.put(MiscObjectIdentifiers.id_MLDSA87_Ed448_SHAKE256, new int[]{2592, 57});
        componentKeySizes.put(MiscObjectIdentifiers.id_MLDSA87_RSA4096_PSS_SHA512, new int[]{2592, 542});
        componentKeySizes.put(MiscObjectIdentifiers.id_MLDSA87_RSA3072_PSS_SHA512, new int[]{2592, 256});
        componentKeySizes.put(MiscObjectIdentifiers.id_MLDSA87_ECDSA_P521_SHA512, new int[]{2592, 93});
    }
}

