/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.engines;

import org.bouncycastle.crypto.engines.AEADBaseEngine;
import org.bouncycastle.crypto.engines.AsconBaseEngine;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.Pack;

public class AsconAEAD128
extends AsconBaseEngine {
    public AsconAEAD128() {
        this.BlockSize = 16;
        this.AADBufferSize = 16;
        this.MAC_SIZE = 16;
        this.IV_SIZE = 16;
        this.KEY_SIZE = 16;
        this.ASCON_IV = 17594342703105L;
        this.algorithmName = "Ascon-AEAD128";
        this.nr = 8;
        this.dsep = Long.MIN_VALUE;
        this.macSizeLowerBound = 4;
        this.setInnerMembers(AEADBaseEngine.ProcessingBufferType.Immediate, AEADBaseEngine.AADOperatorType.DataLimit, AEADBaseEngine.DataOperatorType.DataLimit);
        this.dataLimitCounter.init(54);
        this.decryptionFailureCounter = new AEADBaseEngine.DecryptionFailureCounter();
    }

    @Override
    protected long pad(int i) {
        return 1L << (i << 3);
    }

    @Override
    protected long loadBytes(byte[] in, int inOff) {
        return Pack.littleEndianToLong(in, inOff);
    }

    @Override
    protected void setBytes(long n, byte[] bs, int off) {
        Pack.longToLittleEndian(n, bs, off);
    }

    @Override
    protected void ascon_aeadinit() {
        this.p.set(this.ASCON_IV, this.K0, this.K1, this.N0, this.N1);
        this.p.p(12);
        this.p.x3 ^= this.K0;
        this.p.x4 ^= this.K1;
    }

    @Override
    protected void processFinalAAD() {
        if (this.m_aadPos == this.BlockSize) {
            this.p.x0 ^= this.loadBytes(this.m_aad, 0);
            this.p.x1 ^= this.loadBytes(this.m_aad, 8);
            this.m_aadPos -= this.BlockSize;
            this.p.p(this.nr);
        }
        Arrays.fill(this.m_aad, this.m_aadPos, this.AADBufferSize, (byte)0);
        if (this.m_aadPos >= 8) {
            this.p.x0 ^= Pack.littleEndianToLong(this.m_aad, 0);
            this.p.x1 ^= Pack.littleEndianToLong(this.m_aad, 8) ^ this.pad(this.m_aadPos);
        } else {
            this.p.x0 ^= Pack.littleEndianToLong(this.m_aad, 0) ^ this.pad(this.m_aadPos);
        }
    }

    @Override
    protected void processFinalDecrypt(byte[] input, int inLen, byte[] output, int outOff) {
        if (inLen >= 8) {
            long c0 = Pack.littleEndianToLong(input, 0);
            long c1 = Pack.littleEndianToLong(input, 8, inLen -= 8);
            Pack.longToLittleEndian(this.p.x0 ^ c0, output, outOff);
            Pack.longToLittleEndian(this.p.x1 ^ c1, output, outOff + 8, inLen);
            this.p.x0 = c0;
            this.p.x1 &= -(1L << (inLen << 3));
            this.p.x1 |= c1;
            this.p.x1 ^= this.pad(inLen);
        } else {
            if (inLen != 0) {
                long c0 = Pack.littleEndianToLong(input, 0, inLen);
                Pack.longToLittleEndian(this.p.x0 ^ c0, output, outOff, inLen);
                this.p.x0 &= -(1L << (inLen << 3));
                this.p.x0 |= c0;
            }
            this.p.x0 ^= this.pad(inLen);
        }
        this.finishData(AEADBaseEngine.State.DecFinal);
    }

    @Override
    protected void processFinalEncrypt(byte[] input, int inLen, byte[] output, int outOff) {
        if (inLen >= 8) {
            this.p.x0 ^= Pack.littleEndianToLong(input, 0);
            this.p.x1 ^= Pack.littleEndianToLong(input, 8, inLen -= 8);
            Pack.longToLittleEndian(this.p.x0, output, outOff);
            Pack.longToLittleEndian(this.p.x1, output, outOff + 8);
            this.p.x1 ^= this.pad(inLen);
        } else {
            if (inLen != 0) {
                this.p.x0 ^= Pack.littleEndianToLong(input, 0, inLen);
                Pack.longToLittleEndian(this.p.x0, output, outOff, inLen);
            }
            this.p.x0 ^= this.pad(inLen);
        }
        this.finishData(AEADBaseEngine.State.EncFinal);
    }

    private void finishData(AEADBaseEngine.State nextState) {
        this.p.x2 ^= this.K0;
        this.p.x3 ^= this.K1;
        this.p.p(12);
        this.p.x3 ^= this.K0;
        this.p.x4 ^= this.K1;
        this.m_state = nextState;
    }

    @Override
    protected void init(byte[] key, byte[] iv) throws IllegalArgumentException {
        int lambda = (this.MAC_SIZE << 3) - 32;
        long K0 = Pack.littleEndianToLong(key, 0);
        long K1 = Pack.littleEndianToLong(key, 8);
        this.decryptionFailureCounter.init(lambda);
        if (this.K0 != K0 || this.K1 != K1) {
            this.dataLimitCounter.reset();
            this.decryptionFailureCounter.reset();
            this.K0 = K0;
            this.K1 = K1;
        }
        this.N0 = Pack.littleEndianToLong(iv, 0);
        this.N1 = Pack.littleEndianToLong(iv, 8);
    }

    @Override
    public String getAlgorithmVersion() {
        return "v1.3";
    }
}

