/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.legacy.crypto.gemss;

import org.bouncycastle.pqc.legacy.crypto.gemss.Pointer;

abstract class Mul_GF2x {
    Mul_GF2x() {
    }

    public abstract void mul_gf2x(Pointer var1, Pointer var2, Pointer var3);

    public abstract void sqr_gf2x(long[] var1, long[] var2, int var3);

    public abstract void mul_gf2x_xor(Pointer var1, Pointer var2, Pointer var3);

    private static long SQR32_NO_SIMD_GF2X(long A) {
        A = (A ^ A << 16) & 0xFFFF0000FFFFL;
        A = (A ^ A << 8) & 0xFF00FF00FF00FFL;
        A = (A ^ A << 4) & 0xF0F0F0F0F0F0F0FL;
        A = (A ^ A << 2) & 0x3333333333333333L;
        return (A ^ A << 1) & 0x5555555555555555L;
    }

    private static long SQR64LOW_NO_SIMD_GF2X(long A) {
        A = (A & 0xFFFFFFFFL ^ A << 16) & 0xFFFF0000FFFFL;
        A = (A ^ A << 8) & 0xFF00FF00FF00FFL;
        A = (A ^ A << 4) & 0xF0F0F0F0F0F0F0FL;
        A = (A ^ A << 2) & 0x3333333333333333L;
        return (A ^ A << 1) & 0x5555555555555555L;
    }

    private static void SQR64_NO_SIMD_GF2X(long[] C, int c_cp, long A) {
        C[c_cp + 1] = Mul_GF2x.SQR32_NO_SIMD_GF2X(A >>> 32);
        C[c_cp] = Mul_GF2x.SQR64LOW_NO_SIMD_GF2X(A);
    }

    private static void SQR128_NO_SIMD_GF2X(long[] C, int c_cp, long[] A, int a_cp) {
        Mul_GF2x.SQR64_NO_SIMD_GF2X(C, c_cp + 2, A[a_cp + 1]);
        Mul_GF2x.SQR64_NO_SIMD_GF2X(C, c_cp, A[a_cp]);
    }

    private static void SQR256_NO_SIMD_GF2X(long[] C, int c_cp, long[] A, int a_cp) {
        Mul_GF2x.SQR128_NO_SIMD_GF2X(C, c_cp + 4, A, a_cp + 2);
        Mul_GF2x.SQR128_NO_SIMD_GF2X(C, c_cp, A, a_cp);
    }

    private static long MUL32_NO_SIMD_GF2X(long a, long b) {
        long tmp = -(b & 1L) & a;
        tmp ^= (-(b >>> 1 & 1L) & a) << 1;
        tmp ^= (-(b >>> 2 & 1L) & a) << 2;
        tmp ^= (-(b >>> 3 & 1L) & a) << 3;
        tmp ^= (-(b >>> 4 & 1L) & a) << 4;
        tmp ^= (-(b >>> 5 & 1L) & a) << 5;
        tmp ^= (-(b >>> 6 & 1L) & a) << 6;
        tmp ^= (-(b >>> 7 & 1L) & a) << 7;
        tmp ^= (-(b >>> 8 & 1L) & a) << 8;
        tmp ^= (-(b >>> 9 & 1L) & a) << 9;
        tmp ^= (-(b >>> 10 & 1L) & a) << 10;
        tmp ^= (-(b >>> 11 & 1L) & a) << 11;
        tmp ^= (-(b >>> 12 & 1L) & a) << 12;
        tmp ^= (-(b >>> 13 & 1L) & a) << 13;
        tmp ^= (-(b >>> 14 & 1L) & a) << 14;
        tmp ^= (-(b >>> 15 & 1L) & a) << 15;
        tmp ^= (-(b >>> 16 & 1L) & a) << 16;
        tmp ^= (-(b >>> 17 & 1L) & a) << 17;
        tmp ^= (-(b >>> 18 & 1L) & a) << 18;
        tmp ^= (-(b >>> 19 & 1L) & a) << 19;
        tmp ^= (-(b >>> 20 & 1L) & a) << 20;
        tmp ^= (-(b >>> 21 & 1L) & a) << 21;
        tmp ^= (-(b >>> 22 & 1L) & a) << 22;
        tmp ^= (-(b >>> 23 & 1L) & a) << 23;
        tmp ^= (-(b >>> 24 & 1L) & a) << 24;
        tmp ^= (-(b >>> 25 & 1L) & a) << 25;
        tmp ^= (-(b >>> 26 & 1L) & a) << 26;
        tmp ^= (-(b >>> 27 & 1L) & a) << 27;
        tmp ^= (-(b >>> 28 & 1L) & a) << 28;
        tmp ^= (-(b >>> 29 & 1L) & a) << 29;
        tmp ^= (-(b >>> 30 & 1L) & a) << 30;
        return tmp ^= (-(b >>> 31 & 1L) & a) << 31;
    }

    private static void MUL64_NO_SIMD_GF2X(long[] C, int c_cp, long A, long B) {
        long c0 = -(B & 1L) & A;
        long tmp = -(B >>> 63) & A;
        c0 ^= tmp << 63;
        long c1 = tmp >>> 1;
        tmp = -(B >>> 1 & 1L) & A;
        c0 ^= tmp << 1;
        c1 ^= tmp >>> 63;
        tmp = -(B >>> 2 & 1L) & A;
        c0 ^= tmp << 2;
        c1 ^= tmp >>> 62;
        tmp = -(B >>> 3 & 1L) & A;
        c0 ^= tmp << 3;
        c1 ^= tmp >>> 61;
        tmp = -(B >>> 4 & 1L) & A;
        c0 ^= tmp << 4;
        c1 ^= tmp >>> 60;
        tmp = -(B >>> 5 & 1L) & A;
        c0 ^= tmp << 5;
        c1 ^= tmp >>> 59;
        tmp = -(B >>> 6 & 1L) & A;
        c0 ^= tmp << 6;
        c1 ^= tmp >>> 58;
        tmp = -(B >>> 7 & 1L) & A;
        c0 ^= tmp << 7;
        c1 ^= tmp >>> 57;
        tmp = -(B >>> 8 & 1L) & A;
        c0 ^= tmp << 8;
        c1 ^= tmp >>> 56;
        tmp = -(B >>> 9 & 1L) & A;
        c0 ^= tmp << 9;
        c1 ^= tmp >>> 55;
        tmp = -(B >>> 10 & 1L) & A;
        c0 ^= tmp << 10;
        c1 ^= tmp >>> 54;
        tmp = -(B >>> 11 & 1L) & A;
        c0 ^= tmp << 11;
        c1 ^= tmp >>> 53;
        tmp = -(B >>> 12 & 1L) & A;
        c0 ^= tmp << 12;
        c1 ^= tmp >>> 52;
        tmp = -(B >>> 13 & 1L) & A;
        c0 ^= tmp << 13;
        c1 ^= tmp >>> 51;
        tmp = -(B >>> 14 & 1L) & A;
        c0 ^= tmp << 14;
        c1 ^= tmp >>> 50;
        tmp = -(B >>> 15 & 1L) & A;
        c0 ^= tmp << 15;
        c1 ^= tmp >>> 49;
        tmp = -(B >>> 16 & 1L) & A;
        c0 ^= tmp << 16;
        c1 ^= tmp >>> 48;
        tmp = -(B >>> 17 & 1L) & A;
        c0 ^= tmp << 17;
        c1 ^= tmp >>> 47;
        tmp = -(B >>> 18 & 1L) & A;
        c0 ^= tmp << 18;
        c1 ^= tmp >>> 46;
        tmp = -(B >>> 19 & 1L) & A;
        c0 ^= tmp << 19;
        c1 ^= tmp >>> 45;
        tmp = -(B >>> 20 & 1L) & A;
        c0 ^= tmp << 20;
        c1 ^= tmp >>> 44;
        tmp = -(B >>> 21 & 1L) & A;
        c0 ^= tmp << 21;
        c1 ^= tmp >>> 43;
        tmp = -(B >>> 22 & 1L) & A;
        c0 ^= tmp << 22;
        c1 ^= tmp >>> 42;
        tmp = -(B >>> 23 & 1L) & A;
        c0 ^= tmp << 23;
        c1 ^= tmp >>> 41;
        tmp = -(B >>> 24 & 1L) & A;
        c0 ^= tmp << 24;
        c1 ^= tmp >>> 40;
        tmp = -(B >>> 25 & 1L) & A;
        c0 ^= tmp << 25;
        c1 ^= tmp >>> 39;
        tmp = -(B >>> 26 & 1L) & A;
        c0 ^= tmp << 26;
        c1 ^= tmp >>> 38;
        tmp = -(B >>> 27 & 1L) & A;
        c0 ^= tmp << 27;
        c1 ^= tmp >>> 37;
        tmp = -(B >>> 28 & 1L) & A;
        c0 ^= tmp << 28;
        c1 ^= tmp >>> 36;
        tmp = -(B >>> 29 & 1L) & A;
        c0 ^= tmp << 29;
        c1 ^= tmp >>> 35;
        tmp = -(B >>> 30 & 1L) & A;
        c0 ^= tmp << 30;
        c1 ^= tmp >>> 34;
        tmp = -(B >>> 31 & 1L) & A;
        c0 ^= tmp << 31;
        c1 ^= tmp >>> 33;
        tmp = -(B >>> 32 & 1L) & A;
        c0 ^= tmp << 32;
        c1 ^= tmp >>> 32;
        tmp = -(B >>> 33 & 1L) & A;
        c0 ^= tmp << 33;
        c1 ^= tmp >>> 31;
        tmp = -(B >>> 34 & 1L) & A;
        c0 ^= tmp << 34;
        c1 ^= tmp >>> 30;
        tmp = -(B >>> 35 & 1L) & A;
        c0 ^= tmp << 35;
        c1 ^= tmp >>> 29;
        tmp = -(B >>> 36 & 1L) & A;
        c0 ^= tmp << 36;
        c1 ^= tmp >>> 28;
        tmp = -(B >>> 37 & 1L) & A;
        c0 ^= tmp << 37;
        c1 ^= tmp >>> 27;
        tmp = -(B >>> 38 & 1L) & A;
        c0 ^= tmp << 38;
        c1 ^= tmp >>> 26;
        tmp = -(B >>> 39 & 1L) & A;
        c0 ^= tmp << 39;
        c1 ^= tmp >>> 25;
        tmp = -(B >>> 40 & 1L) & A;
        c0 ^= tmp << 40;
        c1 ^= tmp >>> 24;
        tmp = -(B >>> 41 & 1L) & A;
        c0 ^= tmp << 41;
        c1 ^= tmp >>> 23;
        tmp = -(B >>> 42 & 1L) & A;
        c0 ^= tmp << 42;
        c1 ^= tmp >>> 22;
        tmp = -(B >>> 43 & 1L) & A;
        c0 ^= tmp << 43;
        c1 ^= tmp >>> 21;
        tmp = -(B >>> 44 & 1L) & A;
        c0 ^= tmp << 44;
        c1 ^= tmp >>> 20;
        tmp = -(B >>> 45 & 1L) & A;
        c0 ^= tmp << 45;
        c1 ^= tmp >>> 19;
        tmp = -(B >>> 46 & 1L) & A;
        c0 ^= tmp << 46;
        c1 ^= tmp >>> 18;
        tmp = -(B >>> 47 & 1L) & A;
        c0 ^= tmp << 47;
        c1 ^= tmp >>> 17;
        tmp = -(B >>> 48 & 1L) & A;
        c0 ^= tmp << 48;
        c1 ^= tmp >>> 16;
        tmp = -(B >>> 49 & 1L) & A;
        c0 ^= tmp << 49;
        c1 ^= tmp >>> 15;
        tmp = -(B >>> 50 & 1L) & A;
        c0 ^= tmp << 50;
        c1 ^= tmp >>> 14;
        tmp = -(B >>> 51 & 1L) & A;
        c0 ^= tmp << 51;
        c1 ^= tmp >>> 13;
        tmp = -(B >>> 52 & 1L) & A;
        c0 ^= tmp << 52;
        c1 ^= tmp >>> 12;
        tmp = -(B >>> 53 & 1L) & A;
        c0 ^= tmp << 53;
        c1 ^= tmp >>> 11;
        tmp = -(B >>> 54 & 1L) & A;
        c0 ^= tmp << 54;
        c1 ^= tmp >>> 10;
        tmp = -(B >>> 55 & 1L) & A;
        c0 ^= tmp << 55;
        c1 ^= tmp >>> 9;
        tmp = -(B >>> 56 & 1L) & A;
        c0 ^= tmp << 56;
        c1 ^= tmp >>> 8;
        tmp = -(B >>> 57 & 1L) & A;
        c0 ^= tmp << 57;
        c1 ^= tmp >>> 7;
        tmp = -(B >>> 58 & 1L) & A;
        c0 ^= tmp << 58;
        c1 ^= tmp >>> 6;
        tmp = -(B >>> 59 & 1L) & A;
        c0 ^= tmp << 59;
        c1 ^= tmp >>> 5;
        tmp = -(B >>> 60 & 1L) & A;
        c0 ^= tmp << 60;
        c1 ^= tmp >>> 4;
        tmp = -(B >>> 61 & 1L) & A;
        c0 ^= tmp << 61;
        c1 ^= tmp >>> 3;
        tmp = -(B >>> 62 & 1L) & A;
        C[c_cp] = c0 ^ tmp << 62;
        C[c_cp + 1] = c1 ^ tmp >>> 2;
    }

    private static void MUL64_NO_SIMD_GF2X_XOR(long[] C, int c_cp, long A, long B) {
        long c0 = -(B & 1L) & A;
        long tmp = -(B >>> 63) & A;
        c0 ^= tmp << 63;
        long c1 = tmp >>> 1;
        tmp = -(B >>> 1 & 1L) & A;
        c0 ^= tmp << 1;
        c1 ^= tmp >>> 63;
        tmp = -(B >>> 2 & 1L) & A;
        c0 ^= tmp << 2;
        c1 ^= tmp >>> 62;
        tmp = -(B >>> 3 & 1L) & A;
        c0 ^= tmp << 3;
        c1 ^= tmp >>> 61;
        tmp = -(B >>> 4 & 1L) & A;
        c0 ^= tmp << 4;
        c1 ^= tmp >>> 60;
        tmp = -(B >>> 5 & 1L) & A;
        c0 ^= tmp << 5;
        c1 ^= tmp >>> 59;
        tmp = -(B >>> 6 & 1L) & A;
        c0 ^= tmp << 6;
        c1 ^= tmp >>> 58;
        tmp = -(B >>> 7 & 1L) & A;
        c0 ^= tmp << 7;
        c1 ^= tmp >>> 57;
        tmp = -(B >>> 8 & 1L) & A;
        c0 ^= tmp << 8;
        c1 ^= tmp >>> 56;
        tmp = -(B >>> 9 & 1L) & A;
        c0 ^= tmp << 9;
        c1 ^= tmp >>> 55;
        tmp = -(B >>> 10 & 1L) & A;
        c0 ^= tmp << 10;
        c1 ^= tmp >>> 54;
        tmp = -(B >>> 11 & 1L) & A;
        c0 ^= tmp << 11;
        c1 ^= tmp >>> 53;
        tmp = -(B >>> 12 & 1L) & A;
        c0 ^= tmp << 12;
        c1 ^= tmp >>> 52;
        tmp = -(B >>> 13 & 1L) & A;
        c0 ^= tmp << 13;
        c1 ^= tmp >>> 51;
        tmp = -(B >>> 14 & 1L) & A;
        c0 ^= tmp << 14;
        c1 ^= tmp >>> 50;
        tmp = -(B >>> 15 & 1L) & A;
        c0 ^= tmp << 15;
        c1 ^= tmp >>> 49;
        tmp = -(B >>> 16 & 1L) & A;
        c0 ^= tmp << 16;
        c1 ^= tmp >>> 48;
        tmp = -(B >>> 17 & 1L) & A;
        c0 ^= tmp << 17;
        c1 ^= tmp >>> 47;
        tmp = -(B >>> 18 & 1L) & A;
        c0 ^= tmp << 18;
        c1 ^= tmp >>> 46;
        tmp = -(B >>> 19 & 1L) & A;
        c0 ^= tmp << 19;
        c1 ^= tmp >>> 45;
        tmp = -(B >>> 20 & 1L) & A;
        c0 ^= tmp << 20;
        c1 ^= tmp >>> 44;
        tmp = -(B >>> 21 & 1L) & A;
        c0 ^= tmp << 21;
        c1 ^= tmp >>> 43;
        tmp = -(B >>> 22 & 1L) & A;
        c0 ^= tmp << 22;
        c1 ^= tmp >>> 42;
        tmp = -(B >>> 23 & 1L) & A;
        c0 ^= tmp << 23;
        c1 ^= tmp >>> 41;
        tmp = -(B >>> 24 & 1L) & A;
        c0 ^= tmp << 24;
        c1 ^= tmp >>> 40;
        tmp = -(B >>> 25 & 1L) & A;
        c0 ^= tmp << 25;
        c1 ^= tmp >>> 39;
        tmp = -(B >>> 26 & 1L) & A;
        c0 ^= tmp << 26;
        c1 ^= tmp >>> 38;
        tmp = -(B >>> 27 & 1L) & A;
        c0 ^= tmp << 27;
        c1 ^= tmp >>> 37;
        tmp = -(B >>> 28 & 1L) & A;
        c0 ^= tmp << 28;
        c1 ^= tmp >>> 36;
        tmp = -(B >>> 29 & 1L) & A;
        c0 ^= tmp << 29;
        c1 ^= tmp >>> 35;
        tmp = -(B >>> 30 & 1L) & A;
        c0 ^= tmp << 30;
        c1 ^= tmp >>> 34;
        tmp = -(B >>> 31 & 1L) & A;
        c0 ^= tmp << 31;
        c1 ^= tmp >>> 33;
        tmp = -(B >>> 32 & 1L) & A;
        c0 ^= tmp << 32;
        c1 ^= tmp >>> 32;
        tmp = -(B >>> 33 & 1L) & A;
        c0 ^= tmp << 33;
        c1 ^= tmp >>> 31;
        tmp = -(B >>> 34 & 1L) & A;
        c0 ^= tmp << 34;
        c1 ^= tmp >>> 30;
        tmp = -(B >>> 35 & 1L) & A;
        c0 ^= tmp << 35;
        c1 ^= tmp >>> 29;
        tmp = -(B >>> 36 & 1L) & A;
        c0 ^= tmp << 36;
        c1 ^= tmp >>> 28;
        tmp = -(B >>> 37 & 1L) & A;
        c0 ^= tmp << 37;
        c1 ^= tmp >>> 27;
        tmp = -(B >>> 38 & 1L) & A;
        c0 ^= tmp << 38;
        c1 ^= tmp >>> 26;
        tmp = -(B >>> 39 & 1L) & A;
        c0 ^= tmp << 39;
        c1 ^= tmp >>> 25;
        tmp = -(B >>> 40 & 1L) & A;
        c0 ^= tmp << 40;
        c1 ^= tmp >>> 24;
        tmp = -(B >>> 41 & 1L) & A;
        c0 ^= tmp << 41;
        c1 ^= tmp >>> 23;
        tmp = -(B >>> 42 & 1L) & A;
        c0 ^= tmp << 42;
        c1 ^= tmp >>> 22;
        tmp = -(B >>> 43 & 1L) & A;
        c0 ^= tmp << 43;
        c1 ^= tmp >>> 21;
        tmp = -(B >>> 44 & 1L) & A;
        c0 ^= tmp << 44;
        c1 ^= tmp >>> 20;
        tmp = -(B >>> 45 & 1L) & A;
        c0 ^= tmp << 45;
        c1 ^= tmp >>> 19;
        tmp = -(B >>> 46 & 1L) & A;
        c0 ^= tmp << 46;
        c1 ^= tmp >>> 18;
        tmp = -(B >>> 47 & 1L) & A;
        c0 ^= tmp << 47;
        c1 ^= tmp >>> 17;
        tmp = -(B >>> 48 & 1L) & A;
        c0 ^= tmp << 48;
        c1 ^= tmp >>> 16;
        tmp = -(B >>> 49 & 1L) & A;
        c0 ^= tmp << 49;
        c1 ^= tmp >>> 15;
        tmp = -(B >>> 50 & 1L) & A;
        c0 ^= tmp << 50;
        c1 ^= tmp >>> 14;
        tmp = -(B >>> 51 & 1L) & A;
        c0 ^= tmp << 51;
        c1 ^= tmp >>> 13;
        tmp = -(B >>> 52 & 1L) & A;
        c0 ^= tmp << 52;
        c1 ^= tmp >>> 12;
        tmp = -(B >>> 53 & 1L) & A;
        c0 ^= tmp << 53;
        c1 ^= tmp >>> 11;
        tmp = -(B >>> 54 & 1L) & A;
        c0 ^= tmp << 54;
        c1 ^= tmp >>> 10;
        tmp = -(B >>> 55 & 1L) & A;
        c0 ^= tmp << 55;
        c1 ^= tmp >>> 9;
        tmp = -(B >>> 56 & 1L) & A;
        c0 ^= tmp << 56;
        c1 ^= tmp >>> 8;
        tmp = -(B >>> 57 & 1L) & A;
        c0 ^= tmp << 57;
        c1 ^= tmp >>> 7;
        tmp = -(B >>> 58 & 1L) & A;
        c0 ^= tmp << 58;
        c1 ^= tmp >>> 6;
        tmp = -(B >>> 59 & 1L) & A;
        c0 ^= tmp << 59;
        c1 ^= tmp >>> 5;
        tmp = -(B >>> 60 & 1L) & A;
        c0 ^= tmp << 60;
        c1 ^= tmp >>> 4;
        tmp = -(B >>> 61 & 1L) & A;
        c0 ^= tmp << 61;
        c1 ^= tmp >>> 3;
        tmp = -(B >>> 62 & 1L) & A;
        int n = c_cp;
        C[n] = C[n] ^ (c0 ^ tmp << 62);
        int n2 = c_cp + 1;
        C[n2] = C[n2] ^ (c1 ^ tmp >>> 2);
    }

    private static void mul128_no_simd_gf2x(long[] C, int c_cp, long[] A, int a_cp, long[] B, int b_cp) {
        Mul_GF2x.MUL64_NO_SIMD_GF2X(C, c_cp, A[a_cp], B[b_cp]);
        Mul_GF2x.MUL64_NO_SIMD_GF2X(C, c_cp + 2, A[a_cp + 1], B[b_cp + 1]);
        int n = c_cp + 2;
        C[n] = C[n] ^ C[c_cp + 1];
        C[c_cp + 1] = C[c_cp] ^ C[c_cp + 2];
        int n2 = c_cp + 2;
        C[n2] = C[n2] ^ C[c_cp + 3];
        Mul_GF2x.MUL64_NO_SIMD_GF2X_XOR(C, c_cp + 1, A[a_cp] ^ A[a_cp + 1], B[b_cp] ^ B[b_cp + 1]);
    }

    private static void mul128_no_simd_gf2x(long[] C, int c_cp, long a0, long a1, long b0, long b1) {
        Mul_GF2x.MUL64_NO_SIMD_GF2X(C, c_cp, a0, b0);
        Mul_GF2x.MUL64_NO_SIMD_GF2X(C, c_cp + 2, a1, b1);
        int n = c_cp + 2;
        C[n] = C[n] ^ C[c_cp + 1];
        C[c_cp + 1] = C[c_cp] ^ C[c_cp + 2];
        int n2 = c_cp + 2;
        C[n2] = C[n2] ^ C[c_cp + 3];
        Mul_GF2x.MUL64_NO_SIMD_GF2X_XOR(C, c_cp + 1, a0 ^ a1, b0 ^ b1);
    }

    private static void mul128_no_simd_gf2x_xor(long[] C, int c_cp, long a0, long a1, long b0, long b1, long[] RESERVED_BUF) {
        Mul_GF2x.MUL64_NO_SIMD_GF2X(RESERVED_BUF, 0, a0, b0);
        Mul_GF2x.MUL64_NO_SIMD_GF2X(RESERVED_BUF, 2, a1, b1);
        int n = c_cp;
        C[n] = C[n] ^ RESERVED_BUF[0];
        RESERVED_BUF[2] = RESERVED_BUF[2] ^ RESERVED_BUF[1];
        int n2 = c_cp + 1;
        C[n2] = C[n2] ^ (RESERVED_BUF[0] ^ RESERVED_BUF[2]);
        int n3 = c_cp + 2;
        C[n3] = C[n3] ^ (RESERVED_BUF[2] ^ RESERVED_BUF[3]);
        int n4 = c_cp + 3;
        C[n4] = C[n4] ^ RESERVED_BUF[3];
        Mul_GF2x.MUL64_NO_SIMD_GF2X_XOR(C, c_cp + 1, a0 ^ a1, b0 ^ b1);
    }

    public static void mul192_no_simd_gf2x(long[] C, int c_cp, long[] A, int a_cp, long[] B, int b_cp) {
        Mul_GF2x.MUL64_NO_SIMD_GF2X(C, c_cp, A[a_cp], B[b_cp]);
        Mul_GF2x.MUL64_NO_SIMD_GF2X(C, c_cp + 4, A[a_cp + 2], B[b_cp + 2]);
        Mul_GF2x.MUL64_NO_SIMD_GF2X(C, c_cp + 2, A[a_cp + 1], B[b_cp + 1]);
        int n = c_cp + 1;
        C[n] = C[n] ^ C[c_cp + 2];
        int n2 = c_cp + 3;
        C[n2] = C[n2] ^ C[c_cp + 4];
        C[c_cp + 4] = C[c_cp + 3] ^ C[c_cp + 5];
        C[c_cp + 2] = C[c_cp + 3] ^ C[c_cp + 1] ^ C[c_cp];
        C[c_cp + 3] = C[c_cp + 1] ^ C[c_cp + 4];
        int n3 = c_cp + 1;
        C[n3] = C[n3] ^ C[c_cp];
        Mul_GF2x.MUL64_NO_SIMD_GF2X_XOR(C, c_cp + 1, A[a_cp] ^ A[a_cp + 1], B[b_cp] ^ B[b_cp + 1]);
        Mul_GF2x.MUL64_NO_SIMD_GF2X_XOR(C, c_cp + 3, A[a_cp + 1] ^ A[a_cp + 2], B[b_cp + 1] ^ B[b_cp + 2]);
        Mul_GF2x.MUL64_NO_SIMD_GF2X_XOR(C, c_cp + 2, A[a_cp] ^ A[a_cp + 2], B[b_cp] ^ B[b_cp + 2]);
    }

    public static void mul192_no_simd_gf2x_xor(long[] C, int c_cp, long[] A, int a_cp, long[] B, int b_cp, long[] Buffer2) {
        Mul_GF2x.MUL64_NO_SIMD_GF2X(Buffer2, 0, A[a_cp], B[b_cp]);
        Mul_GF2x.MUL64_NO_SIMD_GF2X(Buffer2, 4, A[a_cp + 2], B[b_cp + 2]);
        Mul_GF2x.MUL64_NO_SIMD_GF2X(Buffer2, 2, A[a_cp + 1], B[b_cp + 1]);
        int n = c_cp;
        C[n] = C[n] ^ Buffer2[0];
        Buffer2[1] = Buffer2[1] ^ Buffer2[2];
        Buffer2[3] = Buffer2[3] ^ Buffer2[4];
        Buffer2[4] = Buffer2[3] ^ Buffer2[5];
        Buffer2[0] = Buffer2[0] ^ Buffer2[1];
        int n2 = c_cp + 1;
        C[n2] = C[n2] ^ Buffer2[0];
        int n3 = c_cp + 2;
        C[n3] = C[n3] ^ (Buffer2[3] ^ Buffer2[0]);
        int n4 = c_cp + 3;
        C[n4] = C[n4] ^ (Buffer2[1] ^ Buffer2[4]);
        int n5 = c_cp + 4;
        C[n5] = C[n5] ^ Buffer2[4];
        int n6 = c_cp + 5;
        C[n6] = C[n6] ^ Buffer2[5];
        Mul_GF2x.MUL64_NO_SIMD_GF2X_XOR(C, c_cp + 1, A[a_cp] ^ A[a_cp + 1], B[b_cp] ^ B[b_cp + 1]);
        Mul_GF2x.MUL64_NO_SIMD_GF2X_XOR(C, c_cp + 3, A[a_cp + 1] ^ A[a_cp + 2], B[b_cp + 1] ^ B[b_cp + 2]);
        Mul_GF2x.MUL64_NO_SIMD_GF2X_XOR(C, c_cp + 2, A[a_cp] ^ A[a_cp + 2], B[b_cp] ^ B[b_cp + 2]);
    }

    private static void mul288_no_simd_gf2x(long[] C, int c_cp, long[] A, int a_cp, long[] B, int b_cp, long[] RESERVED_BUF) {
        Mul_GF2x.mul128_no_simd_gf2x(C, c_cp, A[a_cp], A[a_cp + 1], B[b_cp], B[b_cp + 1]);
        Mul_GF2x.MUL64_NO_SIMD_GF2X(C, c_cp + 4, A[a_cp + 2], B[b_cp + 2]);
        Mul_GF2x.MUL64_NO_SIMD_GF2X(C, c_cp + 7, A[a_cp + 3], B[b_cp + 3]);
        int n = c_cp + 7;
        C[n] = C[n] ^ C[c_cp + 5];
        int n2 = c_cp + 8;
        C[n2] = C[n2] ^ Mul_GF2x.MUL32_NO_SIMD_GF2X(A[a_cp + 4], B[b_cp + 4]);
        C[c_cp + 5] = C[c_cp + 7] ^ C[c_cp + 4];
        int n3 = c_cp + 7;
        C[n3] = C[n3] ^ C[c_cp + 8];
        C[c_cp + 6] = C[c_cp + 7] ^ C[c_cp + 4];
        Mul_GF2x.MUL64_NO_SIMD_GF2X_XOR(C, c_cp + 5, A[a_cp + 2] ^ A[a_cp + 3], B[b_cp + 2] ^ B[b_cp + 3]);
        Mul_GF2x.MUL64_NO_SIMD_GF2X_XOR(C, c_cp + 7, A[a_cp + 3] ^ A[a_cp + 4], B[b_cp + 3] ^ B[b_cp + 4]);
        Mul_GF2x.MUL64_NO_SIMD_GF2X_XOR(C, c_cp + 6, A[a_cp + 2] ^ A[a_cp + 4], B[b_cp + 2] ^ B[b_cp + 4]);
        int n4 = c_cp + 4;
        C[n4] = C[n4] ^ C[c_cp + 2];
        int n5 = c_cp + 5;
        C[n5] = C[n5] ^ C[c_cp + 3];
        long AA0 = A[a_cp] ^ A[a_cp + 2];
        long AA1 = A[a_cp + 1] ^ A[a_cp + 3];
        long BB0 = B[b_cp] ^ B[b_cp + 2];
        long BB1 = B[b_cp + 1] ^ B[b_cp + 3];
        Mul_GF2x.MUL64_NO_SIMD_GF2X(RESERVED_BUF, 0, AA0, BB0);
        Mul_GF2x.MUL64_NO_SIMD_GF2X(RESERVED_BUF, 2, AA1, BB1);
        RESERVED_BUF[2] = RESERVED_BUF[2] ^ RESERVED_BUF[1];
        RESERVED_BUF[3] = RESERVED_BUF[3] ^ Mul_GF2x.MUL32_NO_SIMD_GF2X(A[a_cp + 4], B[b_cp + 4]);
        C[c_cp + 2] = C[c_cp + 4] ^ C[c_cp] ^ RESERVED_BUF[0];
        C[c_cp + 3] = C[c_cp + 5] ^ C[c_cp + 1] ^ RESERVED_BUF[2] ^ RESERVED_BUF[0];
        RESERVED_BUF[2] = RESERVED_BUF[2] ^ RESERVED_BUF[3];
        int n6 = c_cp + 4;
        C[n6] = C[n6] ^ (C[c_cp + 6] ^ RESERVED_BUF[2] ^ RESERVED_BUF[0]);
        int n7 = c_cp + 5;
        C[n7] = C[n7] ^ (C[c_cp + 7] ^ RESERVED_BUF[2]);
        int n8 = c_cp + 6;
        C[n8] = C[n8] ^ (C[c_cp + 8] ^ RESERVED_BUF[3]);
        Mul_GF2x.MUL64_NO_SIMD_GF2X_XOR(C, c_cp + 3, AA0 ^ AA1, BB0 ^ BB1);
        Mul_GF2x.MUL64_NO_SIMD_GF2X_XOR(C, c_cp + 5, AA1 ^ A[a_cp + 4], BB1 ^ B[b_cp + 4]);
        Mul_GF2x.MUL64_NO_SIMD_GF2X_XOR(C, c_cp + 4, AA0 ^ A[a_cp + 4], BB0 ^ B[b_cp + 4]);
    }

    private static void mul288_no_simd_gf2x_xor(long[] C, int c_cp, long[] A, int a_cp, long[] B, int b_cp, long[] Buffer2) {
        Mul_GF2x.mul128_no_simd_gf2x(Buffer2, 0, A[a_cp], A[a_cp + 1], B[b_cp], B[b_cp + 1]);
        Mul_GF2x.MUL64_NO_SIMD_GF2X(Buffer2, 4, A[a_cp + 2], B[b_cp + 2]);
        Mul_GF2x.MUL64_NO_SIMD_GF2X(Buffer2, 7, A[a_cp + 3], B[b_cp + 3]);
        Buffer2[7] = Buffer2[7] ^ Buffer2[5];
        Buffer2[8] = Buffer2[8] ^ Mul_GF2x.MUL32_NO_SIMD_GF2X(A[a_cp + 4], B[b_cp + 4]);
        Buffer2[5] = Buffer2[7] ^ Buffer2[4];
        Buffer2[7] = Buffer2[7] ^ Buffer2[8];
        Buffer2[6] = Buffer2[7] ^ Buffer2[4];
        Buffer2[4] = Buffer2[4] ^ Buffer2[2];
        Buffer2[5] = Buffer2[5] ^ Buffer2[3];
        int n = c_cp;
        C[n] = C[n] ^ Buffer2[0];
        int n2 = c_cp + 1;
        C[n2] = C[n2] ^ Buffer2[1];
        int n3 = c_cp + 2;
        C[n3] = C[n3] ^ (Buffer2[4] ^ Buffer2[0]);
        Mul_GF2x.MUL64_NO_SIMD_GF2X_XOR(Buffer2, 5, A[a_cp + 2] ^ A[a_cp + 3], B[b_cp + 2] ^ B[b_cp + 3]);
        Mul_GF2x.MUL64_NO_SIMD_GF2X_XOR(Buffer2, 7, A[a_cp + 3] ^ A[a_cp + 4], B[b_cp + 3] ^ B[b_cp + 4]);
        Mul_GF2x.MUL64_NO_SIMD_GF2X_XOR(Buffer2, 6, A[a_cp + 2] ^ A[a_cp + 4], B[b_cp + 2] ^ B[b_cp + 4]);
        int n4 = c_cp + 3;
        C[n4] = C[n4] ^ (Buffer2[5] ^ Buffer2[1]);
        int n5 = c_cp + 4;
        C[n5] = C[n5] ^ (Buffer2[4] ^ Buffer2[6]);
        int n6 = c_cp + 5;
        C[n6] = C[n6] ^ (Buffer2[5] ^ Buffer2[7]);
        int n7 = c_cp + 6;
        C[n7] = C[n7] ^ (Buffer2[6] ^ Buffer2[8]);
        int n8 = c_cp + 7;
        C[n8] = C[n8] ^ Buffer2[7];
        int n9 = c_cp + 8;
        C[n9] = C[n9] ^ Buffer2[8];
        long AA0 = A[a_cp] ^ A[a_cp + 2];
        long AA1 = A[a_cp + 1] ^ A[a_cp + 3];
        long BB0 = B[b_cp] ^ B[b_cp + 2];
        long BB1 = B[b_cp + 1] ^ B[b_cp + 3];
        Mul_GF2x.MUL64_NO_SIMD_GF2X(Buffer2, 0, AA0, BB0);
        Mul_GF2x.MUL64_NO_SIMD_GF2X(Buffer2, 2, AA1, BB1);
        Buffer2[2] = Buffer2[2] ^ Buffer2[1];
        Buffer2[3] = Buffer2[3] ^ Mul_GF2x.MUL32_NO_SIMD_GF2X(A[a_cp + 4], B[b_cp + 4]);
        int n10 = c_cp + 2;
        C[n10] = C[n10] ^ Buffer2[0];
        int n11 = c_cp + 3;
        C[n11] = C[n11] ^ (Buffer2[2] ^ Buffer2[0]);
        Buffer2[2] = Buffer2[2] ^ Buffer2[3];
        int n12 = c_cp + 4;
        C[n12] = C[n12] ^ (Buffer2[2] ^ Buffer2[0]);
        int n13 = c_cp + 5;
        C[n13] = C[n13] ^ Buffer2[2];
        int n14 = c_cp + 6;
        C[n14] = C[n14] ^ Buffer2[3];
        Mul_GF2x.MUL64_NO_SIMD_GF2X_XOR(C, c_cp + 3, AA0 ^ AA1, BB0 ^ BB1);
        Mul_GF2x.MUL64_NO_SIMD_GF2X_XOR(C, c_cp + 5, AA1 ^ A[a_cp + 4], BB1 ^ B[b_cp + 4]);
        Mul_GF2x.MUL64_NO_SIMD_GF2X_XOR(C, c_cp + 4, AA0 ^ A[a_cp + 4], BB0 ^ B[b_cp + 4]);
    }

    private static void mul384_no_simd_gf2x(long[] C, long[] A, int a_cp, long[] B, int b_cp, long[] Buffer2) {
        Mul_GF2x.mul192_no_simd_gf2x(C, 0, A, a_cp, B, b_cp);
        Mul_GF2x.mul192_no_simd_gf2x(C, 6, A, a_cp + 3, B, b_cp + 3);
        long AA0 = A[a_cp] ^ A[a_cp + 3];
        long AA1 = A[a_cp + 1] ^ A[a_cp + 4];
        long AA2 = A[a_cp + 2] ^ A[a_cp + 5];
        long BB0 = B[b_cp] ^ B[b_cp + 3];
        long BB1 = B[b_cp + 1] ^ B[b_cp + 4];
        long BB2 = B[b_cp + 2] ^ B[b_cp + 5];
        C[6] = C[6] ^ C[3];
        C[7] = C[7] ^ C[4];
        C[8] = C[8] ^ C[5];
        Mul_GF2x.MUL64_NO_SIMD_GF2X(Buffer2, 0, AA0, BB0);
        Mul_GF2x.MUL64_NO_SIMD_GF2X(Buffer2, 4, AA2, BB2);
        Mul_GF2x.MUL64_NO_SIMD_GF2X(Buffer2, 2, AA1, BB1);
        C[3] = C[6] ^ C[0] ^ Buffer2[0];
        Buffer2[1] = Buffer2[1] ^ Buffer2[2];
        Buffer2[0] = Buffer2[0] ^ Buffer2[1];
        Buffer2[3] = Buffer2[3] ^ Buffer2[4];
        Buffer2[4] = Buffer2[3] ^ Buffer2[5];
        C[5] = C[8] ^ C[2] ^ Buffer2[3] ^ Buffer2[0];
        C[6] = C[6] ^ (C[9] ^ Buffer2[1] ^ Buffer2[4]);
        C[4] = C[7] ^ C[1] ^ Buffer2[0];
        C[7] = C[7] ^ (C[10] ^ Buffer2[4]);
        C[8] = C[8] ^ (C[11] ^ Buffer2[5]);
        Mul_GF2x.MUL64_NO_SIMD_GF2X_XOR(C, 4, AA0 ^ AA1, BB0 ^ BB1);
        Mul_GF2x.MUL64_NO_SIMD_GF2X_XOR(C, 6, AA1 ^ AA2, BB1 ^ BB2);
        Mul_GF2x.MUL64_NO_SIMD_GF2X_XOR(C, 5, AA0 ^ AA2, BB0 ^ BB2);
    }

    private static void mul384_no_simd_gf2x_xor(long[] C, long[] A, int a_cp, long[] B, int b_cp, long[] Buffer2) {
        Mul_GF2x.mul192_no_simd_gf2x(Buffer2, 0, A, a_cp, B, b_cp);
        Mul_GF2x.mul192_no_simd_gf2x(Buffer2, 6, A, a_cp + 3, B, b_cp + 3);
        long AA0 = A[a_cp] ^ A[a_cp + 3];
        long AA1 = A[a_cp + 1] ^ A[a_cp + 4];
        long AA2 = A[a_cp + 2] ^ A[a_cp + 5];
        long BB0 = B[b_cp] ^ B[b_cp + 3];
        long BB1 = B[b_cp + 1] ^ B[b_cp + 4];
        long BB2 = B[b_cp + 2] ^ B[b_cp + 5];
        Buffer2[6] = Buffer2[6] ^ Buffer2[3];
        Buffer2[7] = Buffer2[7] ^ Buffer2[4];
        Buffer2[8] = Buffer2[8] ^ Buffer2[5];
        C[0] = C[0] ^ Buffer2[0];
        C[1] = C[1] ^ Buffer2[1];
        C[2] = C[2] ^ Buffer2[2];
        C[3] = C[3] ^ (Buffer2[6] ^ Buffer2[0]);
        C[5] = C[5] ^ (Buffer2[8] ^ Buffer2[2]);
        C[6] = C[6] ^ (Buffer2[6] ^ Buffer2[9]);
        C[4] = C[4] ^ (Buffer2[7] ^ Buffer2[1]);
        C[7] = C[7] ^ (Buffer2[7] ^ Buffer2[10]);
        C[8] = C[8] ^ (Buffer2[8] ^ Buffer2[11]);
        C[9] = C[9] ^ Buffer2[9];
        C[10] = C[10] ^ Buffer2[10];
        C[11] = C[11] ^ Buffer2[11];
        Mul_GF2x.MUL64_NO_SIMD_GF2X(Buffer2, 0, AA0, BB0);
        Mul_GF2x.MUL64_NO_SIMD_GF2X(Buffer2, 4, AA2, BB2);
        Mul_GF2x.MUL64_NO_SIMD_GF2X(Buffer2, 2, AA1, BB1);
        C[3] = C[3] ^ Buffer2[0];
        Buffer2[1] = Buffer2[1] ^ Buffer2[2];
        Buffer2[0] = Buffer2[0] ^ Buffer2[1];
        Buffer2[3] = Buffer2[3] ^ Buffer2[4];
        Buffer2[4] = Buffer2[3] ^ Buffer2[5];
        C[5] = C[5] ^ (Buffer2[3] ^ Buffer2[0]);
        C[6] = C[6] ^ (Buffer2[1] ^ Buffer2[4]);
        C[4] = C[4] ^ Buffer2[0];
        C[7] = C[7] ^ Buffer2[4];
        C[8] = C[8] ^ Buffer2[5];
        Mul_GF2x.MUL64_NO_SIMD_GF2X_XOR(C, 4, AA0 ^ AA1, BB0 ^ BB1);
        Mul_GF2x.MUL64_NO_SIMD_GF2X_XOR(C, 6, AA1 ^ AA2, BB1 ^ BB2);
        Mul_GF2x.MUL64_NO_SIMD_GF2X_XOR(C, 5, AA0 ^ AA2, BB0 ^ BB2);
    }

    private static void mul416_no_simd_gf2x(long[] C, long[] A, int a_cp, long[] B, int b_cp, long[] RESERVED_BUF) {
        Mul_GF2x.mul192_no_simd_gf2x(C, 0, A, a_cp, B, b_cp);
        Mul_GF2x.mul128_no_simd_gf2x(C, 6, A[a_cp + 3], A[a_cp + 4], B[b_cp + 3], B[b_cp + 4]);
        Mul_GF2x.MUL64_NO_SIMD_GF2X(C, 10, A[a_cp + 5], B[b_cp + 5]);
        C[12] = Mul_GF2x.MUL32_NO_SIMD_GF2X(A[a_cp + 6], B[b_cp + 6]) ^ C[11];
        C[11] = C[10] ^ C[12];
        Mul_GF2x.MUL64_NO_SIMD_GF2X_XOR(C, 11, A[a_cp + 5] ^ A[a_cp + 6], B[b_cp + 5] ^ B[b_cp + 6]);
        C[8] = C[8] ^ C[10];
        C[11] = C[11] ^ C[9];
        C[10] = C[8] ^ C[12];
        C[8] = C[8] ^ C[6];
        C[9] = C[11] ^ C[7];
        Mul_GF2x.mul128_no_simd_gf2x_xor(C, 8, A[a_cp + 3] ^ A[a_cp + 5], A[a_cp + 4] ^ A[a_cp + 6], B[b_cp + 3] ^ B[b_cp + 5], B[b_cp + 4] ^ B[b_cp + 6], RESERVED_BUF);
        long AA0 = A[a_cp] ^ A[a_cp + 3];
        long AA1 = A[a_cp + 1] ^ A[a_cp + 4];
        long AA2 = A[a_cp + 2] ^ A[a_cp + 5];
        long AA3 = A[a_cp + 6];
        long BB0 = B[b_cp] ^ B[b_cp + 3];
        long BB1 = B[b_cp + 1] ^ B[b_cp + 4];
        long BB2 = B[b_cp + 2] ^ B[b_cp + 5];
        long BB3 = B[b_cp + 6];
        C[6] = C[6] ^ C[3];
        C[7] = C[7] ^ C[4];
        C[8] = C[8] ^ C[5];
        Mul_GF2x.mul128_no_simd_gf2x(RESERVED_BUF, 0, AA0, AA1, BB0, BB1);
        Mul_GF2x.MUL64_NO_SIMD_GF2X(RESERVED_BUF, 4, AA2, BB2);
        RESERVED_BUF[6] = Mul_GF2x.MUL32_NO_SIMD_GF2X(AA3, BB3) ^ RESERVED_BUF[5];
        RESERVED_BUF[5] = RESERVED_BUF[4] ^ RESERVED_BUF[6];
        Mul_GF2x.MUL64_NO_SIMD_GF2X_XOR(RESERVED_BUF, 5, AA2 ^ AA3, BB2 ^ BB3);
        C[3] = C[6] ^ C[0] ^ RESERVED_BUF[0];
        C[4] = C[7] ^ C[1] ^ RESERVED_BUF[1];
        RESERVED_BUF[2] = RESERVED_BUF[2] ^ RESERVED_BUF[4];
        RESERVED_BUF[3] = RESERVED_BUF[3] ^ RESERVED_BUF[5];
        C[5] = C[8] ^ C[2] ^ RESERVED_BUF[2] ^ RESERVED_BUF[0];
        C[6] = C[6] ^ (C[9] ^ RESERVED_BUF[3] ^ RESERVED_BUF[1]);
        C[7] = C[7] ^ (C[10] ^ RESERVED_BUF[2] ^ RESERVED_BUF[6]);
        C[8] = C[8] ^ (C[11] ^ RESERVED_BUF[3]);
        C[9] = C[9] ^ (C[12] ^ RESERVED_BUF[6]);
        Mul_GF2x.mul128_no_simd_gf2x_xor(C, 5, AA0 ^ AA2, AA1 ^ AA3, BB0 ^ BB2, BB1 ^ BB3, RESERVED_BUF);
    }

    private static void mul416_no_simd_gf2x_xor(long[] C, long[] A, int a_cp, long[] B, int b_cp, long[] Buffer2, long[] Buffer22) {
        Mul_GF2x.mul192_no_simd_gf2x(Buffer2, 0, A, a_cp, B, b_cp);
        Mul_GF2x.mul128_no_simd_gf2x(Buffer2, 6, A[a_cp + 3], A[a_cp + 4], B[b_cp + 3], B[b_cp + 4]);
        Mul_GF2x.MUL64_NO_SIMD_GF2X(Buffer2, 10, A[a_cp + 5], B[b_cp + 5]);
        Buffer2[12] = Mul_GF2x.MUL32_NO_SIMD_GF2X(A[a_cp + 6], B[b_cp + 6]) ^ Buffer2[11];
        Buffer2[11] = Buffer2[10] ^ Buffer2[12];
        Mul_GF2x.MUL64_NO_SIMD_GF2X_XOR(Buffer2, 11, A[a_cp + 5] ^ A[a_cp + 6], B[b_cp + 5] ^ B[b_cp + 6]);
        Buffer2[8] = Buffer2[8] ^ Buffer2[10];
        Buffer2[11] = Buffer2[11] ^ Buffer2[9];
        Buffer2[10] = Buffer2[8] ^ Buffer2[12];
        Buffer2[8] = Buffer2[8] ^ Buffer2[6];
        Buffer2[9] = Buffer2[11] ^ Buffer2[7];
        Buffer2[6] = Buffer2[6] ^ Buffer2[3];
        Buffer2[7] = Buffer2[7] ^ Buffer2[4];
        Buffer2[8] = Buffer2[8] ^ Buffer2[5];
        Mul_GF2x.mul128_no_simd_gf2x_xor(Buffer2, 8, A[a_cp + 3] ^ A[a_cp + 5], A[a_cp + 4] ^ A[a_cp + 6], B[b_cp + 3] ^ B[b_cp + 5], B[b_cp + 4] ^ B[b_cp + 6], Buffer22);
        C[0] = C[0] ^ Buffer2[0];
        C[1] = C[1] ^ Buffer2[1];
        C[2] = C[2] ^ Buffer2[2];
        C[3] = C[3] ^ (Buffer2[6] ^ Buffer2[0]);
        C[4] = C[4] ^ (Buffer2[7] ^ Buffer2[1]);
        C[5] = C[5] ^ (Buffer2[8] ^ Buffer2[2]);
        C[6] = C[6] ^ (Buffer2[6] ^ Buffer2[9]);
        C[7] = C[7] ^ (Buffer2[7] ^ Buffer2[10]);
        C[8] = C[8] ^ (Buffer2[8] ^ Buffer2[11]);
        C[9] = C[9] ^ (Buffer2[9] ^ Buffer2[12]);
        C[10] = C[10] ^ Buffer2[10];
        C[11] = C[11] ^ Buffer2[11];
        C[12] = C[12] ^ Buffer2[12];
        long AA0 = A[a_cp] ^ A[a_cp + 3];
        long AA1 = A[a_cp + 1] ^ A[a_cp + 4];
        long AA2 = A[a_cp + 2] ^ A[a_cp + 5];
        long AA3 = A[a_cp + 6];
        long BB0 = B[b_cp] ^ B[b_cp + 3];
        long BB1 = B[b_cp + 1] ^ B[b_cp + 4];
        long BB2 = B[b_cp + 2] ^ B[b_cp + 5];
        long BB3 = B[b_cp + 6];
        Mul_GF2x.mul128_no_simd_gf2x(Buffer2, 0, AA0, AA1, BB0, BB1);
        Mul_GF2x.MUL64_NO_SIMD_GF2X(Buffer2, 4, AA2, BB2);
        Buffer2[6] = Mul_GF2x.MUL32_NO_SIMD_GF2X(AA3, BB3) ^ Buffer2[5];
        Buffer2[5] = Buffer2[4] ^ Buffer2[6];
        Mul_GF2x.MUL64_NO_SIMD_GF2X_XOR(Buffer2, 5, AA2 ^ AA3, BB2 ^ BB3);
        C[3] = C[3] ^ Buffer2[0];
        C[4] = C[4] ^ Buffer2[1];
        Buffer2[2] = Buffer2[2] ^ Buffer2[4];
        Buffer2[3] = Buffer2[3] ^ Buffer2[5];
        C[5] = C[5] ^ (Buffer2[2] ^ Buffer2[0]);
        C[6] = C[6] ^ (Buffer2[3] ^ Buffer2[1]);
        C[7] = C[7] ^ (Buffer2[2] ^ Buffer2[6]);
        C[8] = C[8] ^ Buffer2[3];
        C[9] = C[9] ^ Buffer2[6];
        Mul_GF2x.mul128_no_simd_gf2x_xor(C, 5, AA0 ^ AA2, AA1 ^ AA3, BB0 ^ BB2, BB1 ^ BB3, Buffer2);
    }

    private static void mul544_no_simd_gf2x(long[] C, long[] A, int a_cp, long[] B, int b_cp, long[] AA, long[] BB, long[] RESERVED_BUF9) {
        Mul_GF2x.mul128_no_simd_gf2x(C, 0, A[a_cp], A[a_cp + 1], B[b_cp], B[b_cp + 1]);
        Mul_GF2x.mul128_no_simd_gf2x(C, 4, A[a_cp + 2], A[a_cp + 3], B[b_cp + 2], B[b_cp + 3]);
        C[4] = C[4] ^ C[2];
        C[5] = C[5] ^ C[3];
        C[2] = C[4] ^ C[0];
        C[3] = C[5] ^ C[1];
        C[4] = C[4] ^ C[6];
        C[5] = C[5] ^ C[7];
        Mul_GF2x.mul128_no_simd_gf2x_xor(C, 2, A[a_cp] ^ A[a_cp + 2], A[a_cp + 1] ^ A[a_cp + 3], B[b_cp] ^ B[b_cp + 2], B[b_cp + 1] ^ B[b_cp + 3], RESERVED_BUF9);
        Mul_GF2x.mul288_no_simd_gf2x(C, 8, A, a_cp + 4, B, b_cp + 4, RESERVED_BUF9);
        C[8] = C[8] ^ C[4];
        C[9] = C[9] ^ C[5];
        C[10] = C[10] ^ C[6];
        C[11] = C[11] ^ C[7];
        C[4] = C[8] ^ C[0];
        C[5] = C[9] ^ C[1];
        C[6] = C[10] ^ C[2];
        C[7] = C[11] ^ C[3];
        C[8] = C[8] ^ C[12];
        C[9] = C[9] ^ C[13];
        C[10] = C[10] ^ C[14];
        C[11] = C[11] ^ C[15];
        C[12] = C[12] ^ C[16];
        AA[0] = A[a_cp] ^ A[a_cp + 4];
        AA[1] = A[a_cp + 1] ^ A[a_cp + 5];
        AA[2] = A[a_cp + 2] ^ A[a_cp + 6];
        AA[3] = A[a_cp + 3] ^ A[a_cp + 7];
        AA[4] = A[a_cp + 8];
        BB[0] = B[b_cp] ^ B[b_cp + 4];
        BB[1] = B[b_cp + 1] ^ B[b_cp + 5];
        BB[2] = B[b_cp + 2] ^ B[b_cp + 6];
        BB[3] = B[b_cp + 3] ^ B[b_cp + 7];
        BB[4] = B[b_cp + 8];
        Mul_GF2x.mul288_no_simd_gf2x_xor(C, 4, AA, 0, BB, 0, RESERVED_BUF9);
    }

    private static void mul544_no_simd_gf2x_xor(long[] C, long[] A, int a_cp, long[] B, int b_cp, long[] AA, long[] BB, long[] Buffer2, long[] Buffer22) {
        Mul_GF2x.mul128_no_simd_gf2x(Buffer2, 0, A[a_cp], A[a_cp + 1], B[b_cp], B[b_cp + 1]);
        Mul_GF2x.mul128_no_simd_gf2x(Buffer2, 4, A[a_cp + 2], A[a_cp + 3], B[b_cp + 2], B[b_cp + 3]);
        Buffer2[4] = Buffer2[4] ^ Buffer2[2];
        Buffer2[5] = Buffer2[5] ^ Buffer2[3];
        Buffer2[2] = Buffer2[4] ^ Buffer2[0];
        Buffer2[3] = Buffer2[5] ^ Buffer2[1];
        Buffer2[4] = Buffer2[4] ^ Buffer2[6];
        Buffer2[5] = Buffer2[5] ^ Buffer2[7];
        Mul_GF2x.mul128_no_simd_gf2x_xor(Buffer2, 2, A[a_cp] ^ A[a_cp + 2], A[a_cp + 1] ^ A[a_cp + 3], B[b_cp] ^ B[b_cp + 2], B[b_cp + 1] ^ B[b_cp + 3], Buffer22);
        Mul_GF2x.mul288_no_simd_gf2x(Buffer2, 8, A, a_cp + 4, B, b_cp + 4, Buffer22);
        Buffer2[8] = Buffer2[8] ^ Buffer2[4];
        Buffer2[9] = Buffer2[9] ^ Buffer2[5];
        Buffer2[10] = Buffer2[10] ^ Buffer2[6];
        Buffer2[11] = Buffer2[11] ^ Buffer2[7];
        C[0] = C[0] ^ Buffer2[0];
        C[1] = C[1] ^ Buffer2[1];
        C[2] = C[2] ^ Buffer2[2];
        C[3] = C[3] ^ Buffer2[3];
        C[4] = C[4] ^ (Buffer2[8] ^ Buffer2[0]);
        C[5] = C[5] ^ (Buffer2[9] ^ Buffer2[1]);
        C[6] = C[6] ^ (Buffer2[10] ^ Buffer2[2]);
        C[7] = C[7] ^ (Buffer2[11] ^ Buffer2[3]);
        C[8] = C[8] ^ (Buffer2[8] ^ Buffer2[12]);
        C[9] = C[9] ^ (Buffer2[9] ^ Buffer2[13]);
        C[10] = C[10] ^ (Buffer2[10] ^ Buffer2[14]);
        C[11] = C[11] ^ (Buffer2[11] ^ Buffer2[15]);
        C[12] = C[12] ^ (Buffer2[12] ^ Buffer2[16]);
        C[13] = C[13] ^ Buffer2[13];
        C[14] = C[14] ^ Buffer2[14];
        C[15] = C[15] ^ Buffer2[15];
        C[16] = C[16] ^ Buffer2[16];
        AA[0] = A[a_cp] ^ A[a_cp + 4];
        AA[1] = A[a_cp + 1] ^ A[a_cp + 5];
        AA[2] = A[a_cp + 2] ^ A[a_cp + 6];
        AA[3] = A[a_cp + 3] ^ A[a_cp + 7];
        AA[4] = A[a_cp + 8];
        BB[0] = B[b_cp] ^ B[b_cp + 4];
        BB[1] = B[b_cp + 1] ^ B[b_cp + 5];
        BB[2] = B[b_cp + 2] ^ B[b_cp + 6];
        BB[3] = B[b_cp + 3] ^ B[b_cp + 7];
        BB[4] = B[b_cp + 8];
        Mul_GF2x.mul288_no_simd_gf2x_xor(C, 4, AA, 0, BB, 0, Buffer2);
    }

    public static class Mul12
    extends Mul_GF2x {
        private long[] Buffer = new long[12];

        @Override
        public void mul_gf2x(Pointer C, Pointer A, Pointer B) {
            Mul_GF2x.mul384_no_simd_gf2x(C.array, A.array, A.cp, B.array, B.cp, this.Buffer);
        }

        @Override
        public void sqr_gf2x(long[] res, long[] A, int a_cp) {
            Mul_GF2x.SQR128_NO_SIMD_GF2X(res, 8, A, a_cp + 4);
            Mul_GF2x.SQR256_NO_SIMD_GF2X(res, 0, A, a_cp);
        }

        @Override
        public void mul_gf2x_xor(Pointer res, Pointer A, Pointer B) {
            Mul_GF2x.mul384_no_simd_gf2x_xor(res.array, A.array, A.cp, B.array, B.cp, this.Buffer);
        }
    }

    public static class Mul13
    extends Mul_GF2x {
        private long[] Buffer = new long[13];
        private long[] Buffer2 = new long[4];

        @Override
        public void mul_gf2x(Pointer C, Pointer A, Pointer B) {
            Mul_GF2x.mul416_no_simd_gf2x(C.array, A.array, A.cp, B.array, B.cp, this.Buffer);
        }

        @Override
        public void sqr_gf2x(long[] res, long[] A, int a_cp) {
            res[12] = Mul_GF2x.SQR32_NO_SIMD_GF2X(A[a_cp + 6]);
            Mul_GF2x.SQR128_NO_SIMD_GF2X(res, 8, A, a_cp + 4);
            Mul_GF2x.SQR256_NO_SIMD_GF2X(res, 0, A, a_cp);
        }

        @Override
        public void mul_gf2x_xor(Pointer res, Pointer A, Pointer B) {
            Mul_GF2x.mul416_no_simd_gf2x_xor(res.array, A.array, A.cp, B.array, B.cp, this.Buffer, this.Buffer2);
        }
    }

    public static class Mul17
    extends Mul_GF2x {
        private long[] AA = new long[5];
        private long[] BB = new long[5];
        private long[] Buffer1 = new long[17];
        private long[] Buffer2 = new long[4];

        @Override
        public void mul_gf2x(Pointer C, Pointer A, Pointer B) {
            Mul_GF2x.mul544_no_simd_gf2x(C.array, A.array, A.cp, B.array, B.cp, this.AA, this.BB, this.Buffer1);
        }

        @Override
        public void sqr_gf2x(long[] res, long[] A, int a_cp) {
            res[16] = Mul_GF2x.SQR32_NO_SIMD_GF2X(A[a_cp + 8]);
            Mul_GF2x.SQR256_NO_SIMD_GF2X(res, 8, A, a_cp + 4);
            Mul_GF2x.SQR256_NO_SIMD_GF2X(res, 0, A, a_cp);
        }

        @Override
        public void mul_gf2x_xor(Pointer res, Pointer A, Pointer B) {
            Mul_GF2x.mul544_no_simd_gf2x_xor(res.array, A.array, A.cp, B.array, B.cp, this.AA, this.BB, this.Buffer1, this.Buffer2);
        }
    }

    public static class Mul6
    extends Mul_GF2x {
        private long[] Buffer = new long[6];

        @Override
        public void mul_gf2x(Pointer C, Pointer A, Pointer B) {
            Mul6.mul192_no_simd_gf2x(C.array, 0, A.array, A.cp, B.array, B.cp);
        }

        @Override
        public void sqr_gf2x(long[] res, long[] A, int a_cp) {
            Mul_GF2x.SQR64_NO_SIMD_GF2X(res, 4, A[a_cp + 2]);
            Mul_GF2x.SQR128_NO_SIMD_GF2X(res, 0, A, a_cp);
        }

        @Override
        public void mul_gf2x_xor(Pointer res, Pointer A, Pointer B) {
            Mul6.mul192_no_simd_gf2x_xor(res.array, res.cp, A.array, A.cp, B.array, B.cp, this.Buffer);
        }
    }

    public static class Mul9
    extends Mul_GF2x {
        private long[] Buffer = new long[9];

        @Override
        public void mul_gf2x(Pointer C, Pointer A, Pointer B) {
            Mul_GF2x.mul288_no_simd_gf2x(C.array, 0, A.array, A.cp, B.array, B.cp, this.Buffer);
        }

        @Override
        public void sqr_gf2x(long[] res, long[] A, int a_cp) {
            res[8] = Mul_GF2x.SQR32_NO_SIMD_GF2X(A[a_cp + 4]);
            Mul_GF2x.SQR256_NO_SIMD_GF2X(res, 0, A, a_cp);
        }

        @Override
        public void mul_gf2x_xor(Pointer res, Pointer A, Pointer B) {
            Mul_GF2x.mul288_no_simd_gf2x_xor(res.array, res.cp, A.array, A.cp, B.array, B.cp, this.Buffer);
        }
    }
}

