/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.crypto.cmce;

import org.bouncycastle.pqc.crypto.cmce.BENES;
import org.bouncycastle.pqc.crypto.cmce.Utils;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
class BENES12
extends BENES {
    public BENES12(int n, int t, int m) {
        super(n, t, m);
    }

    static void layerBenes(long[] data, long[] bits, int lgs) {
        int bit_ptr = 0;
        int s = 1 << lgs;
        for (int i = 0; i < 64; i += s * 2) {
            for (int j = i; j < i + s; ++j) {
                long d = data[j + 0] ^ data[j + s];
                int n = bit_ptr++;
                int n2 = j + 0;
                data[n2] = data[n2] ^ (d &= bits[n]);
                int n3 = j + s;
                data[n3] = data[n3] ^ d;
            }
        }
    }

    private void apply_benes(byte[] r, byte[] bits, int rev) {
        int low;
        int cond_ptr;
        int inc;
        int i;
        long[] bs = new long[64];
        long[] cond = new long[64];
        for (i = 0; i < 64; ++i) {
            bs[i] = Utils.load8(r, i * 8);
        }
        if (rev == 0) {
            inc = 256;
            cond_ptr = this.SYS_T * 2 + 40;
        } else {
            inc = -256;
            cond_ptr = this.SYS_T * 2 + 40 + (2 * this.GFBITS - 2) * 256;
        }
        BENES12.transpose_64x64(bs, bs);
        for (low = 0; low <= 5; ++low) {
            for (i = 0; i < 64; ++i) {
                cond[i] = Utils.load4(bits, cond_ptr + i * 4);
            }
            BENES12.transpose_64x64(cond, cond);
            BENES12.layerBenes(bs, cond, low);
            cond_ptr += inc;
        }
        BENES12.transpose_64x64(bs, bs);
        for (low = 0; low <= 5; ++low) {
            for (i = 0; i < 32; ++i) {
                cond[i] = Utils.load8(bits, cond_ptr + i * 8);
            }
            BENES12.layerBenes(bs, cond, low);
            cond_ptr += inc;
        }
        for (low = 4; low >= 0; --low) {
            for (i = 0; i < 32; ++i) {
                cond[i] = Utils.load8(bits, cond_ptr + i * 8);
            }
            BENES12.layerBenes(bs, cond, low);
            cond_ptr += inc;
        }
        BENES12.transpose_64x64(bs, bs);
        for (low = 5; low >= 0; --low) {
            for (i = 0; i < 64; ++i) {
                cond[i] = Utils.load4(bits, cond_ptr + i * 4);
            }
            BENES12.transpose_64x64(cond, cond);
            BENES12.layerBenes(bs, cond, low);
            cond_ptr += inc;
        }
        BENES12.transpose_64x64(bs, bs);
        for (i = 0; i < 64; ++i) {
            Utils.store8(r, i * 8, bs[i]);
        }
    }

    @Override
    public void support_gen(short[] s, byte[] c) {
        int j;
        int i;
        byte[][] L = new byte[this.GFBITS][(1 << this.GFBITS) / 8];
        for (i = 0; i < this.GFBITS; ++i) {
            for (j = 0; j < (1 << this.GFBITS) / 8; ++j) {
                L[i][j] = 0;
            }
        }
        for (i = 0; i < 1 << this.GFBITS; ++i) {
            short a = Utils.bitrev((short)i, this.GFBITS);
            for (j = 0; j < this.GFBITS; ++j) {
                byte[] byArray = L[j];
                int n = i / 8;
                byArray[n] = (byte)(byArray[n] | (a >> j & 1) << i % 8);
            }
        }
        for (int j2 = 0; j2 < this.GFBITS; ++j2) {
            this.apply_benes(L[j2], c, 0);
        }
        for (i = 0; i < this.SYS_N; ++i) {
            s[i] = 0;
            for (j = this.GFBITS - 1; j >= 0; --j) {
                int n = i;
                s[n] = (short)(s[n] << 1);
                int n2 = i;
                s[n2] = (short)(s[n2] | L[j][i / 8] >> i % 8 & 1);
            }
        }
    }
}

