/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1;

import java.io.IOException;
import org.bouncycastle.asn1.ASN1ApplicationSpecificParser;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1Exception;
import org.bouncycastle.asn1.ASN1OutputStream;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.ASN1TaggedObjectParser;
import org.bouncycastle.asn1.DERApplicationSpecific;
import org.bouncycastle.asn1.DLApplicationSpecific;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public abstract class ASN1ApplicationSpecific
extends ASN1TaggedObject
implements ASN1ApplicationSpecificParser {
    final ASN1TaggedObject taggedObject;

    public static ASN1ApplicationSpecific getInstance(Object obj) {
        if (obj == null || obj instanceof ASN1ApplicationSpecific) {
            return (ASN1ApplicationSpecific)obj;
        }
        if (obj instanceof byte[]) {
            try {
                return ASN1ApplicationSpecific.getInstance(ASN1Primitive.fromByteArray((byte[])obj));
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Failed to construct object from byte[]: " + e.getMessage());
            }
        }
        throw new IllegalArgumentException("unknown object in getInstance: " + obj.getClass().getName());
    }

    ASN1ApplicationSpecific(ASN1TaggedObject taggedObject) {
        super(taggedObject.explicitness, ASN1ApplicationSpecific.checkTagClass(taggedObject.tagClass), taggedObject.tagNo, taggedObject.obj);
        this.taggedObject = taggedObject;
    }

    public int getApplicationTag() {
        return this.taggedObject.getTagNo();
    }

    @Override
    public byte[] getContents() {
        return this.taggedObject.getContents();
    }

    public ASN1Primitive getEnclosedObject() throws IOException {
        return this.taggedObject.getBaseObject().toASN1Primitive();
    }

    public ASN1Primitive getObject(int tagNo) throws IOException {
        return this.taggedObject.getBaseUniversal(false, tagNo);
    }

    @Override
    public ASN1Encodable getObjectParser(int tag, boolean isExplicit) throws IOException {
        throw new ASN1Exception("this method only valid for CONTEXT_SPECIFIC tags");
    }

    @Override
    public ASN1Encodable parseBaseUniversal(boolean declaredExplicit, int baseTagNo) throws IOException {
        return this.taggedObject.parseBaseUniversal(declaredExplicit, baseTagNo);
    }

    @Override
    public ASN1Encodable parseExplicitBaseObject() throws IOException {
        return this.taggedObject.parseExplicitBaseObject();
    }

    @Override
    public ASN1TaggedObjectParser parseExplicitBaseTagged() throws IOException {
        return this.taggedObject.parseExplicitBaseTagged();
    }

    @Override
    public ASN1TaggedObjectParser parseImplicitBaseTagged(int baseTagClass, int baseTagNo) throws IOException {
        return this.taggedObject.parseImplicitBaseTagged(baseTagClass, baseTagNo);
    }

    public boolean hasApplicationTag(int tagNo) {
        return this.tagNo == tagNo;
    }

    @Override
    public boolean hasContextTag(int tagNo) {
        return false;
    }

    public ASN1TaggedObject getTaggedObject() {
        return this.taggedObject;
    }

    @Override
    public boolean isConstructed() {
        return this.taggedObject.isConstructed();
    }

    @Override
    public ASN1Encodable readObject() throws IOException {
        return this.parseExplicitBaseObject();
    }

    @Override
    boolean encodeConstructed() {
        return this.taggedObject.encodeConstructed();
    }

    @Override
    int encodedLength(boolean withTag) throws IOException {
        return this.taggedObject.encodedLength(withTag);
    }

    @Override
    void encode(ASN1OutputStream out, boolean withTag) throws IOException {
        this.taggedObject.encode(out, withTag);
    }

    @Override
    String getASN1Encoding() {
        return this.taggedObject.getASN1Encoding();
    }

    @Override
    ASN1Sequence rebuildConstructed(ASN1Primitive primitive) {
        return this.taggedObject.rebuildConstructed(primitive);
    }

    @Override
    ASN1TaggedObject replaceTag(int tagClass, int tagNo) {
        return this.taggedObject.replaceTag(tagClass, tagNo);
    }

    @Override
    ASN1Primitive toDERObject() {
        return new DERApplicationSpecific((ASN1TaggedObject)this.taggedObject.toDERObject());
    }

    @Override
    ASN1Primitive toDLObject() {
        return new DLApplicationSpecific((ASN1TaggedObject)this.taggedObject.toDLObject());
    }

    private static int checkTagClass(int tagClass) {
        if (64 != tagClass) {
            throw new IllegalArgumentException();
        }
        return tagClass;
    }
}

