/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.crypto.picnic;

import org.bouncycastle.util.Integers;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
class Utils {
    Utils() {
    }

    protected static int numBytes(int numBits) {
        return numBits == 0 ? 0 : (numBits - 1) / 8 + 1;
    }

    protected static int ceil_log2(int x) {
        if (x == 0) {
            return 0;
        }
        return 32 - Utils.nlz(x - 1);
    }

    private static int nlz(int x) {
        if (x == 0) {
            return 32;
        }
        int n = 1;
        if (x >>> 16 == 0) {
            n += 16;
            x <<= 16;
        }
        if (x >>> 24 == 0) {
            n += 8;
            x <<= 8;
        }
        if (x >>> 28 == 0) {
            n += 4;
            x <<= 4;
        }
        if (x >>> 30 == 0) {
            n += 2;
            x <<= 2;
        }
        return n -= x >>> 31;
    }

    protected static int parity(byte[] data, int len) {
        byte x = data[0];
        for (int i = 1; i < len; ++i) {
            x = (byte)(x ^ data[i]);
        }
        return Integers.bitCount(x & 0xFF) & 1;
    }

    protected static int parity16(int x) {
        return Integers.bitCount(x & 0xFFFF) & 1;
    }

    protected static int parity32(int x) {
        return Integers.bitCount(x) & 1;
    }

    protected static void setBitInWordArray(int[] array, int bitNumber, int val) {
        Utils.setBit(array, bitNumber, val);
    }

    protected static int getBitFromWordArray(int[] array, int bitNumber) {
        return Utils.getBit(array, bitNumber);
    }

    protected static byte getBit(byte[] array, int bitNumber) {
        int arrayPos = bitNumber >>> 3;
        int bitPos = bitNumber & 7 ^ 7;
        return (byte)(array[arrayPos] >>> bitPos & 1);
    }

    protected static int getBit(int word, int bitNumber) {
        int bitPos = bitNumber ^ 7;
        return word >>> bitPos & 1;
    }

    protected static int getBit(int[] array, int bitNumber) {
        int arrayPos = bitNumber >>> 5;
        int bitPos = bitNumber & 0x1F ^ 7;
        return array[arrayPos] >>> bitPos & 1;
    }

    protected static void setBit(byte[] array, int bitNumber, byte val) {
        int arrayPos = bitNumber >>> 3;
        int bitPos = bitNumber & 7 ^ 7;
        int t = array[arrayPos];
        t &= ~(1 << bitPos);
        array[arrayPos] = (byte)(t |= val << bitPos);
    }

    protected static int setBit(int word, int bitNumber, int bit) {
        int bitPos = bitNumber ^ 7;
        word &= ~(1 << bitPos);
        return word |= bit << bitPos;
    }

    protected static void setBit(int[] array, int bitNumber, int val) {
        int arrayPos = bitNumber >>> 5;
        int bitPos = bitNumber & 0x1F ^ 7;
        int t = array[arrayPos];
        t &= ~(1 << bitPos);
        array[arrayPos] = t |= val << bitPos;
    }
}

