/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.jcajce.provider.falcon;

import java.io.ByteArrayOutputStream;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.SignatureException;
import java.security.spec.AlgorithmParameterSpec;
import org.bouncycastle.crypto.params.ParametersWithRandom;
import org.bouncycastle.pqc.crypto.falcon.FalconPrivateKeyParameters;
import org.bouncycastle.pqc.crypto.falcon.FalconPublicKeyParameters;
import org.bouncycastle.pqc.crypto.falcon.FalconSigner;
import org.bouncycastle.pqc.jcajce.provider.falcon.BCFalconPrivateKey;
import org.bouncycastle.pqc.jcajce.provider.falcon.BCFalconPublicKey;

public class SignatureSpi
extends Signature {
    private ByteArrayOutputStream bOut = new ByteArrayOutputStream();
    private FalconSigner signer;
    private SecureRandom random;

    protected SignatureSpi(FalconSigner signer) {
        super("Falcon");
        this.signer = signer;
    }

    @Override
    protected void engineInitVerify(PublicKey publicKey) throws InvalidKeyException {
        if (!(publicKey instanceof BCFalconPublicKey)) {
            throw new InvalidKeyException("unknown public key passed to Falcon");
        }
        BCFalconPublicKey key = (BCFalconPublicKey)publicKey;
        FalconPublicKeyParameters param = key.getKeyParams();
        this.signer.init(false, param);
    }

    @Override
    protected void engineInitSign(PrivateKey privateKey, SecureRandom random) throws InvalidKeyException {
        this.random = random;
        this.engineInitSign(privateKey);
    }

    @Override
    protected void engineInitSign(PrivateKey privateKey) throws InvalidKeyException {
        if (privateKey instanceof BCFalconPrivateKey) {
            BCFalconPrivateKey key = (BCFalconPrivateKey)privateKey;
            FalconPrivateKeyParameters param = key.getKeyParams();
            if (this.random != null) {
                this.signer.init(true, new ParametersWithRandom(param, this.random));
            } else {
                this.signer.init(true, param);
            }
        } else {
            throw new InvalidKeyException("unknown private key passed to Falcon");
        }
    }

    @Override
    protected void engineUpdate(byte b) throws SignatureException {
        this.bOut.write(b);
    }

    @Override
    protected void engineUpdate(byte[] b, int off, int len) throws SignatureException {
        this.bOut.write(b, off, len);
    }

    @Override
    protected byte[] engineSign() throws SignatureException {
        try {
            byte[] message = this.bOut.toByteArray();
            this.bOut.reset();
            return this.signer.generateSignature(message);
        }
        catch (Exception e) {
            throw new SignatureException(e.toString());
        }
    }

    @Override
    protected boolean engineVerify(byte[] sigBytes) throws SignatureException {
        byte[] message = this.bOut.toByteArray();
        this.bOut.reset();
        return this.signer.verifySignature(message, sigBytes);
    }

    @Override
    protected void engineSetParameter(AlgorithmParameterSpec params) {
        throw new UnsupportedOperationException("engineSetParameter unsupported");
    }

    @Override
    protected void engineSetParameter(String param, Object value) {
        throw new UnsupportedOperationException("engineSetParameter unsupported");
    }

    @Override
    protected Object engineGetParameter(String param) {
        throw new UnsupportedOperationException("engineSetParameter unsupported");
    }

    public static class Base
    extends SignatureSpi {
        public Base() throws NoSuchAlgorithmException {
            super(new FalconSigner());
        }
    }
}

