/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.crypto.picnic;

import java.security.SecureRandom;
import java.util.logging.Logger;
import org.bouncycastle.crypto.Xof;
import org.bouncycastle.crypto.digests.SHAKEDigest;
import org.bouncycastle.pqc.crypto.picnic.KMatricesWithPointer;
import org.bouncycastle.pqc.crypto.picnic.LowmcConstants;
import org.bouncycastle.pqc.crypto.picnic.Msg;
import org.bouncycastle.pqc.crypto.picnic.Signature;
import org.bouncycastle.pqc.crypto.picnic.Signature2;
import org.bouncycastle.pqc.crypto.picnic.Tape;
import org.bouncycastle.pqc.crypto.picnic.Tree;
import org.bouncycastle.pqc.crypto.picnic.Utils;
import org.bouncycastle.pqc.crypto.picnic.View;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.Pack;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
class PicnicEngine {
    private static final Logger LOG = Logger.getLogger(PicnicEngine.class.getName());
    protected static final int saltSizeBytes = 32;
    private static final int MAX_DIGEST_SIZE = 64;
    private static final int WORD_SIZE_BITS = 32;
    private static final int LOWMC_MAX_STATE_SIZE = 64;
    protected static final int LOWMC_MAX_WORDS = 16;
    protected static final int LOWMC_MAX_KEY_BITS = 256;
    protected static final int LOWMC_MAX_AND_GATES = 1144;
    private static final int MAX_AUX_BYTES = 176;
    private static final int PICNIC_MAX_LOWMC_BLOCK_SIZE = 32;
    private static final int PICNIC_MAX_PUBLICKEY_SIZE = 65;
    private static final int PICNIC_MAX_PRIVATEKEY_SIZE = 98;
    private static final int PICNIC_MAX_SIGNATURE_SIZE = 209522;
    private static final int TRANSFORM_FS = 0;
    private static final int TRANSFORM_UR = 1;
    private static final int TRANSFORM_INVALID = 255;
    private final int CRYPTO_SECRETKEYBYTES;
    private final int CRYPTO_PUBLICKEYBYTES;
    private final int CRYPTO_BYTES;
    protected final int numRounds;
    protected final int numSboxes;
    protected final int stateSizeBits;
    protected final int stateSizeBytes;
    protected final int stateSizeWords;
    protected final int andSizeBytes;
    protected final int UnruhGWithoutInputBytes;
    protected final int UnruhGWithInputBytes;
    protected final int numMPCRounds;
    protected final int numOpenedRounds;
    protected final int numMPCParties;
    protected final int seedSizeBytes;
    protected final int digestSizeBytes;
    protected final int pqSecurityLevel;
    protected final Xof digest;
    private final int transform;
    private final int parameters;
    private int signatureLength;

    public int getSecretKeySize() {
        return this.CRYPTO_SECRETKEYBYTES;
    }

    public int getPublicKeySize() {
        return this.CRYPTO_PUBLICKEYBYTES;
    }

    public int getSignatureSize(int messageLength) {
        return this.CRYPTO_BYTES + messageLength;
    }

    public int getTrueSignatureSize() {
        return this.signatureLength;
    }

    PicnicEngine(int picnicParams) {
        this.parameters = picnicParams;
        switch (this.parameters) {
            case 1: 
            case 2: {
                this.pqSecurityLevel = 64;
                this.stateSizeBits = 128;
                this.numMPCRounds = 219;
                this.numMPCParties = 3;
                this.numSboxes = 10;
                this.numRounds = 20;
                this.digestSizeBytes = 32;
                this.numOpenedRounds = 0;
                break;
            }
            case 3: 
            case 4: {
                this.pqSecurityLevel = 96;
                this.stateSizeBits = 192;
                this.numMPCRounds = 329;
                this.numMPCParties = 3;
                this.numSboxes = 10;
                this.numRounds = 30;
                this.digestSizeBytes = 48;
                this.numOpenedRounds = 0;
                break;
            }
            case 5: 
            case 6: {
                this.pqSecurityLevel = 128;
                this.stateSizeBits = 256;
                this.numMPCRounds = 438;
                this.numMPCParties = 3;
                this.numSboxes = 10;
                this.numRounds = 38;
                this.digestSizeBytes = 64;
                this.numOpenedRounds = 0;
                break;
            }
            case 7: {
                this.pqSecurityLevel = 64;
                this.stateSizeBits = 129;
                this.numMPCRounds = 250;
                this.numOpenedRounds = 36;
                this.numMPCParties = 16;
                this.numSboxes = 43;
                this.numRounds = 4;
                this.digestSizeBytes = 32;
                break;
            }
            case 8: {
                this.pqSecurityLevel = 96;
                this.stateSizeBits = 192;
                this.numMPCRounds = 419;
                this.numOpenedRounds = 52;
                this.numMPCParties = 16;
                this.numSboxes = 64;
                this.numRounds = 4;
                this.digestSizeBytes = 48;
                break;
            }
            case 9: {
                this.pqSecurityLevel = 128;
                this.stateSizeBits = 255;
                this.numMPCRounds = 601;
                this.numOpenedRounds = 68;
                this.numMPCParties = 16;
                this.numSboxes = 85;
                this.numRounds = 4;
                this.digestSizeBytes = 64;
                break;
            }
            case 10: {
                this.pqSecurityLevel = 64;
                this.stateSizeBits = 129;
                this.numMPCRounds = 219;
                this.numMPCParties = 3;
                this.numSboxes = 43;
                this.numRounds = 4;
                this.digestSizeBytes = 32;
                this.numOpenedRounds = 0;
                break;
            }
            case 11: {
                this.pqSecurityLevel = 96;
                this.stateSizeBits = 192;
                this.numMPCRounds = 329;
                this.numMPCParties = 3;
                this.numSboxes = 64;
                this.numRounds = 4;
                this.digestSizeBytes = 48;
                this.numOpenedRounds = 0;
                break;
            }
            case 12: {
                this.pqSecurityLevel = 128;
                this.stateSizeBits = 255;
                this.numMPCRounds = 438;
                this.numMPCParties = 3;
                this.numSboxes = 85;
                this.numRounds = 4;
                this.digestSizeBytes = 64;
                this.numOpenedRounds = 0;
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown parameter set " + this.parameters);
            }
        }
        switch (this.parameters) {
            case 1: {
                this.CRYPTO_SECRETKEYBYTES = 49;
                this.CRYPTO_PUBLICKEYBYTES = 33;
                this.CRYPTO_BYTES = 34036;
                break;
            }
            case 2: {
                this.CRYPTO_SECRETKEYBYTES = 49;
                this.CRYPTO_PUBLICKEYBYTES = 33;
                this.CRYPTO_BYTES = 53965;
                break;
            }
            case 3: {
                this.CRYPTO_SECRETKEYBYTES = 73;
                this.CRYPTO_PUBLICKEYBYTES = 49;
                this.CRYPTO_BYTES = 76784;
                break;
            }
            case 4: {
                this.CRYPTO_SECRETKEYBYTES = 73;
                this.CRYPTO_PUBLICKEYBYTES = 49;
                this.CRYPTO_BYTES = 121857;
                break;
            }
            case 5: {
                this.CRYPTO_SECRETKEYBYTES = 97;
                this.CRYPTO_PUBLICKEYBYTES = 65;
                this.CRYPTO_BYTES = 132876;
                break;
            }
            case 6: {
                this.CRYPTO_SECRETKEYBYTES = 97;
                this.CRYPTO_PUBLICKEYBYTES = 65;
                this.CRYPTO_BYTES = 209526;
                break;
            }
            case 7: {
                this.CRYPTO_SECRETKEYBYTES = 52;
                this.CRYPTO_PUBLICKEYBYTES = 35;
                this.CRYPTO_BYTES = 14612;
                break;
            }
            case 8: {
                this.CRYPTO_SECRETKEYBYTES = 73;
                this.CRYPTO_PUBLICKEYBYTES = 49;
                this.CRYPTO_BYTES = 35028;
                break;
            }
            case 9: {
                this.CRYPTO_SECRETKEYBYTES = 97;
                this.CRYPTO_PUBLICKEYBYTES = 65;
                this.CRYPTO_BYTES = 61028;
                break;
            }
            case 10: {
                this.CRYPTO_SECRETKEYBYTES = 52;
                this.CRYPTO_PUBLICKEYBYTES = 35;
                this.CRYPTO_BYTES = 32061;
                break;
            }
            case 11: {
                this.CRYPTO_SECRETKEYBYTES = 73;
                this.CRYPTO_PUBLICKEYBYTES = 49;
                this.CRYPTO_BYTES = 71179;
                break;
            }
            case 12: {
                this.CRYPTO_SECRETKEYBYTES = 97;
                this.CRYPTO_PUBLICKEYBYTES = 65;
                this.CRYPTO_BYTES = 126286;
                break;
            }
            default: {
                this.CRYPTO_SECRETKEYBYTES = -1;
                this.CRYPTO_PUBLICKEYBYTES = -1;
                this.CRYPTO_BYTES = -1;
            }
        }
        this.andSizeBytes = Utils.numBytes(this.numSboxes * 3 * this.numRounds);
        this.stateSizeBytes = Utils.numBytes(this.stateSizeBits);
        this.seedSizeBytes = Utils.numBytes(2 * this.pqSecurityLevel);
        this.stateSizeWords = (this.stateSizeBits + 32 - 1) / 32;
        switch (this.parameters) {
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                this.transform = 0;
                break;
            }
            case 2: 
            case 4: 
            case 6: {
                this.transform = 1;
                break;
            }
            default: {
                this.transform = 255;
            }
        }
        if (this.transform == 1) {
            this.UnruhGWithoutInputBytes = this.seedSizeBytes + this.andSizeBytes;
            this.UnruhGWithInputBytes = this.UnruhGWithoutInputBytes + this.stateSizeBytes;
        } else {
            this.UnruhGWithoutInputBytes = 0;
            this.UnruhGWithInputBytes = 0;
        }
        this.digest = this.stateSizeBits == 128 || this.stateSizeBits == 129 ? new SHAKEDigest(128) : new SHAKEDigest(256);
    }

    public boolean crypto_sign_open(byte[] m, byte[] sm, byte[] pk) {
        int sigLen = Pack.littleEndianToInt(sm, 0);
        byte[] m_from_sm = Arrays.copyOfRange(sm, 4, 4 + m.length);
        int ret = this.picnic_verify(pk, m_from_sm, sm, sigLen);
        if (ret == -1) {
            return false;
        }
        System.arraycopy(sm, 4, m, 0, m.length);
        return true;
    }

    private int picnic_verify(byte[] pk, byte[] message, byte[] signature, int sigLen) {
        byte[] plaintext_bytes = new byte[32];
        byte[] ciphertext_bytes = new byte[32];
        this.picnic_read_public_key(ciphertext_bytes, plaintext_bytes, pk);
        int[] ciphertext = new int[this.stateSizeWords];
        int[] plaintext = new int[this.stateSizeWords];
        Pack.littleEndianToInt(plaintext_bytes, 0, plaintext);
        Pack.littleEndianToInt(ciphertext_bytes, 0, ciphertext);
        if (PicnicEngine.is_picnic3(this.parameters)) {
            Signature2 sig = new Signature2(this);
            this.deserializeSignature2(sig, signature, sigLen, message.length + 4);
            return this.verify_picnic3(sig, ciphertext, plaintext, message);
        }
        Signature sig = new Signature(this);
        int ret = this.deserializeSignature(sig, signature, sigLen, message.length + 4);
        if (ret != 0) {
            LOG.fine("Error couldn't deserialize signature!");
            return -1;
        }
        return this.verify(sig, ciphertext, plaintext, message);
    }

    private int verify(Signature sig, int[] pubKey, int[] plaintext, byte[] message) {
        byte[][][] as = new byte[this.numMPCRounds][this.numMPCParties][this.digestSizeBytes];
        byte[][][] gs = new byte[this.numMPCRounds][3][this.UnruhGWithInputBytes];
        int[][][] viewOutputs = new int[this.numMPCRounds][3][this.stateSizeBytes];
        Signature.Proof[] proofs = sig.proofs;
        byte[] received_challengebits = sig.challengeBits;
        int status = 0;
        byte[] computed_challengebits = null;
        byte[] tmp = new byte[Math.max(6 * this.stateSizeBytes, this.stateSizeBytes + this.andSizeBytes)];
        Tape tape = new Tape(this);
        View[] view1s = new View[this.numMPCRounds];
        View[] view2s = new View[this.numMPCRounds];
        for (int i = 0; i < this.numMPCRounds; ++i) {
            view1s[i] = new View(this);
            view2s[i] = new View(this);
            this.verifyProof(proofs[i], view1s[i], view2s[i], this.getChallenge(received_challengebits, i), sig.salt, i, tmp, plaintext, tape);
            int challenge = this.getChallenge(received_challengebits, i);
            this.Commit(proofs[i].seed1, 0, view1s[i], as[i][challenge]);
            this.Commit(proofs[i].seed2, 0, view2s[i], as[i][(challenge + 1) % 3]);
            System.arraycopy(proofs[i].view3Commitment, 0, as[i][(challenge + 2) % 3], 0, this.digestSizeBytes);
            if (this.transform == 1) {
                this.G(challenge, proofs[i].seed1, 0, view1s[i], gs[i][challenge]);
                this.G((challenge + 1) % 3, proofs[i].seed2, 0, view2s[i], gs[i][(challenge + 1) % 3]);
                int view3UnruhLength = challenge == 0 ? this.UnruhGWithInputBytes : this.UnruhGWithoutInputBytes;
                System.arraycopy(proofs[i].view3UnruhG, 0, gs[i][(challenge + 2) % 3], 0, view3UnruhLength);
            }
            viewOutputs[i][challenge] = view1s[i].outputShare;
            viewOutputs[i][(challenge + 1) % 3] = view2s[i].outputShare;
            int[] view3Output = new int[this.stateSizeWords];
            this.xor_three(view3Output, view1s[i].outputShare, view2s[i].outputShare, pubKey, this.stateSizeBytes);
            viewOutputs[i][(challenge + 2) % 3] = view3Output;
        }
        computed_challengebits = new byte[Utils.numBytes(2 * this.numMPCRounds)];
        this.H3(pubKey, plaintext, viewOutputs, as, computed_challengebits, sig.salt, message, gs);
        if (!PicnicEngine.subarrayEquals(received_challengebits, computed_challengebits, Utils.numBytes(2 * this.numMPCRounds))) {
            LOG.fine("Invalid signature. Did not verify");
            status = -1;
        }
        return status;
    }

    boolean verifyProof(Signature.Proof proof, View view1, View view2, int challenge, byte[] salt, int roundNumber, byte[] tmp, int[] plaintext, Tape tape) {
        System.arraycopy(proof.communicatedBits, 0, view2.communicatedBits, 0, this.andSizeBytes);
        tape.pos = 0;
        boolean status = false;
        switch (challenge) {
            case 0: {
                status = this.createRandomTape(proof.seed1, 0, salt, roundNumber, 0, tmp, this.stateSizeBytes + this.andSizeBytes);
                Pack.littleEndianToInt(tmp, 0, view1.inputShare);
                System.arraycopy(tmp, this.stateSizeBytes, tape.tapes[0], 0, this.andSizeBytes);
                boolean bl = status = status && this.createRandomTape(proof.seed2, 0, salt, roundNumber, 1, tmp, this.stateSizeBytes + this.andSizeBytes);
                if (!status) break;
                Pack.littleEndianToInt(tmp, 0, view2.inputShare);
                System.arraycopy(tmp, this.stateSizeBytes, tape.tapes[1], 0, this.andSizeBytes);
                break;
            }
            case 1: {
                status = this.createRandomTape(proof.seed1, 0, salt, roundNumber, 1, tmp, this.stateSizeBytes + this.andSizeBytes);
                Pack.littleEndianToInt(tmp, 0, view1.inputShare);
                System.arraycopy(tmp, this.stateSizeBytes, tape.tapes[0], 0, this.andSizeBytes);
                boolean bl = status = status && this.createRandomTape(proof.seed2, 0, salt, roundNumber, 2, tape.tapes[1], this.andSizeBytes);
                if (!status) break;
                System.arraycopy(proof.inputShare, 0, view2.inputShare, 0, this.stateSizeBytes);
                break;
            }
            case 2: {
                status = this.createRandomTape(proof.seed1, 0, salt, roundNumber, 2, tape.tapes[0], this.andSizeBytes);
                System.arraycopy(proof.inputShare, 0, view1.inputShare, 0, this.stateSizeBytes);
                boolean bl = status = status && this.createRandomTape(proof.seed2, 0, salt, roundNumber, 0, tmp, this.stateSizeBytes + this.andSizeBytes);
                if (!status) break;
                Pack.littleEndianToInt(tmp, 0, view2.inputShare);
                System.arraycopy(tmp, this.stateSizeBytes, tape.tapes[1], 0, this.andSizeBytes);
                break;
            }
            default: {
                LOG.fine("Invalid Challenge!");
            }
        }
        if (!status) {
            LOG.fine("Failed to generate random tapes, signature verification will fail (but signature may actually be valid)");
            return false;
        }
        byte[] view_bytes = new byte[this.stateSizeBytes * 4];
        Pack.intToLittleEndian(view1.inputShare, view_bytes, 0);
        Arrays.fill(view_bytes, this.stateSizeBytes, view_bytes.length, (byte)0);
        this.zeroTrailingBits(view_bytes, this.stateSizeBits);
        Pack.littleEndianToInt(view_bytes, 0, view1.inputShare);
        Pack.intToLittleEndian(view2.inputShare, view_bytes, 0);
        Arrays.fill(view_bytes, this.stateSizeBytes, view_bytes.length, (byte)0);
        this.zeroTrailingBits(view_bytes, this.stateSizeBits);
        Pack.littleEndianToInt(view_bytes, 0, view2.inputShare);
        int[] tmp_ints = Pack.littleEndianToInt(tmp, 0, tmp.length / 4);
        this.mpc_LowMC_verify(view1, view2, tape, tmp_ints, plaintext, challenge);
        return true;
    }

    void mpc_LowMC_verify(View view1, View view2, Tape tapes, int[] tmp, int[] plaintext, int challenge) {
        Arrays.fill(tmp, 0, tmp.length, 0);
        this.mpc_xor_constant_verify(tmp, plaintext, 0, this.stateSizeWords, challenge);
        KMatricesWithPointer current = LowmcConstants.KMatrix(this, 0);
        this.matrix_mul_offset(tmp, 0, view1.inputShare, 0, current.getData(), current.getMatrixPointer());
        this.matrix_mul_offset(tmp, this.stateSizeWords, view2.inputShare, 0, current.getData(), current.getMatrixPointer());
        this.mpc_xor(tmp, tmp, this.stateSizeWords, 2);
        for (int r = 1; r <= this.numRounds; ++r) {
            current = LowmcConstants.KMatrix(this, r);
            this.matrix_mul_offset(tmp, 0, view1.inputShare, 0, current.getData(), current.getMatrixPointer());
            this.matrix_mul_offset(tmp, this.stateSizeWords, view2.inputShare, 0, current.getData(), current.getMatrixPointer());
            this.mpc_substitution_verify(tmp, tapes, view1, view2);
            current = LowmcConstants.LMatrix(this, r - 1);
            this.mpc_matrix_mul(tmp, 2 * this.stateSizeWords, tmp, 2 * this.stateSizeWords, current.getData(), current.getMatrixPointer(), 2);
            current = LowmcConstants.RConstant(this, r - 1);
            this.mpc_xor_constant_verify(tmp, current.getData(), current.getMatrixPointer(), this.stateSizeWords, challenge);
            this.mpc_xor(tmp, tmp, this.stateSizeWords, 2);
        }
        System.arraycopy(tmp, 2 * this.stateSizeWords, view1.outputShare, 0, this.stateSizeWords);
        System.arraycopy(tmp, 3 * this.stateSizeWords, view2.outputShare, 0, this.stateSizeWords);
    }

    void mpc_substitution_verify(int[] state, Tape rand, View view1, View view2) {
        int[] a = new int[2];
        int[] b = new int[2];
        int[] c = new int[2];
        int[] ab = new int[2];
        int[] bc = new int[2];
        int[] ca = new int[2];
        for (int i = 0; i < this.numSboxes * 3; i += 3) {
            int stateOffset;
            int j;
            for (j = 0; j < 2; ++j) {
                stateOffset = (2 + j) * this.stateSizeWords * 32;
                a[j] = Utils.getBitFromWordArray(state, stateOffset + i + 2);
                b[j] = Utils.getBitFromWordArray(state, stateOffset + i + 1);
                c[j] = Utils.getBitFromWordArray(state, stateOffset + i);
            }
            this.mpc_AND_verify(a, b, ab, rand, view1, view2);
            this.mpc_AND_verify(b, c, bc, rand, view1, view2);
            this.mpc_AND_verify(c, a, ca, rand, view1, view2);
            for (j = 0; j < 2; ++j) {
                stateOffset = (2 + j) * this.stateSizeWords * 32;
                Utils.setBitInWordArray(state, stateOffset + i + 2, a[j] ^ bc[j]);
                Utils.setBitInWordArray(state, stateOffset + i + 1, a[j] ^ b[j] ^ ca[j]);
                Utils.setBitInWordArray(state, stateOffset + i, a[j] ^ b[j] ^ c[j] ^ ab[j]);
            }
        }
    }

    void mpc_AND_verify(int[] in1, int[] in2, int[] out, Tape rand, View view1, View view2) {
        int[] r = new int[]{Utils.getBit(rand.tapes[0], rand.pos), Utils.getBit(rand.tapes[1], rand.pos)};
        out[0] = in1[0] & in2[1] ^ in1[1] & in2[0] ^ in1[0] & in2[0] ^ r[0] ^ r[1];
        Utils.setBit(view1.communicatedBits, rand.pos, (byte)(out[0] & 0xFF));
        out[1] = Utils.getBit(view2.communicatedBits, rand.pos);
        ++rand.pos;
    }

    private void mpc_xor_constant_verify(int[] state, int[] in, int inOffset, int length, int challenge) {
        int offset = 0;
        if (challenge == 0) {
            offset = 2 * this.stateSizeWords;
        } else if (challenge == 2) {
            offset = 3 * this.stateSizeWords;
        } else {
            return;
        }
        for (int i = 0; i < length; ++i) {
            state[i + offset] = state[i + offset] ^ in[i + inOffset];
        }
    }

    private int deserializeSignature(Signature sig, byte[] sigBytes, int sigBytesLen, int sigBytesOffset) {
        Signature.Proof[] proofs = sig.proofs;
        byte[] challengeBits = sig.challengeBits;
        if (sigBytesLen < Utils.numBytes(2 * this.numMPCRounds)) {
            return -1;
        }
        int inputShareSize = this.computeInputShareSize(sigBytes, this.stateSizeBytes);
        int bytesExpected = Utils.numBytes(2 * this.numMPCRounds) + 32 + this.numMPCRounds * (2 * this.seedSizeBytes + this.andSizeBytes + this.digestSizeBytes) + inputShareSize;
        if (this.transform == 1) {
            bytesExpected += this.UnruhGWithoutInputBytes * this.numMPCRounds;
        }
        if (sigBytesLen < bytesExpected) {
            return -1;
        }
        System.arraycopy(sigBytes, sigBytesOffset, challengeBits, 0, Utils.numBytes(2 * this.numMPCRounds));
        sigBytesOffset += Utils.numBytes(2 * this.numMPCRounds);
        if (!this.isChallengeValid(challengeBits)) {
            return -1;
        }
        System.arraycopy(sigBytes, sigBytesOffset, sig.salt, 0, 32);
        sigBytesOffset += 32;
        for (int i = 0; i < this.numMPCRounds; ++i) {
            int challenge = this.getChallenge(challengeBits, i);
            System.arraycopy(sigBytes, sigBytesOffset, proofs[i].view3Commitment, 0, this.digestSizeBytes);
            sigBytesOffset += this.digestSizeBytes;
            if (this.transform == 1) {
                int view3UnruhLength = challenge == 0 ? this.UnruhGWithInputBytes : this.UnruhGWithoutInputBytes;
                System.arraycopy(sigBytes, sigBytesOffset, proofs[i].view3UnruhG, 0, view3UnruhLength);
                sigBytesOffset += view3UnruhLength;
            }
            System.arraycopy(sigBytes, sigBytesOffset, proofs[i].communicatedBits, 0, this.andSizeBytes);
            System.arraycopy(sigBytes, sigBytesOffset += this.andSizeBytes, proofs[i].seed1, 0, this.seedSizeBytes);
            System.arraycopy(sigBytes, sigBytesOffset += this.seedSizeBytes, proofs[i].seed2, 0, this.seedSizeBytes);
            sigBytesOffset += this.seedSizeBytes;
            if (challenge != 1 && challenge != 2) continue;
            Pack.littleEndianToInt(sigBytes, sigBytesOffset, proofs[i].inputShare, 0, this.stateSizeBytes / 4);
            if (this.stateSizeBits == 129) {
                proofs[i].inputShare[this.stateSizeWords - 1] = sigBytes[sigBytesOffset + this.stateSizeBytes - 1] & 0xFF;
            }
            sigBytesOffset += this.stateSizeBytes;
            if (this.arePaddingBitsZero(Pack.intToLittleEndian(proofs[i].inputShare), this.stateSizeBits)) continue;
            return -1;
        }
        return 0;
    }

    private boolean isChallengeValid(byte[] challengeBits) {
        for (int i = 0; i < this.numMPCRounds; ++i) {
            int challenge = this.getChallenge(challengeBits, i);
            if (challenge <= 2) continue;
            return false;
        }
        return true;
    }

    private int computeInputShareSize(byte[] challengeBits, int stateSizeBytes) {
        int inputShareSize = 0;
        for (int i = 0; i < this.numMPCRounds; ++i) {
            int challenge = this.getChallenge(challengeBits, i);
            if (challenge != 1 && challenge != 2) continue;
            inputShareSize += stateSizeBytes;
        }
        return inputShareSize;
    }

    private int picnic_read_public_key(byte[] ciphertext, byte[] plaintext, byte[] pk) {
        System.arraycopy(pk, 1, ciphertext, 0, this.stateSizeBytes);
        System.arraycopy(pk, 1 + this.stateSizeBytes, plaintext, 0, this.stateSizeBytes);
        return 0;
    }

    private int verify_picnic3(Signature2 sig, int[] pubKey, int[] plaintext, byte[] message) {
        int t;
        byte[][][] C = new byte[this.numMPCRounds][this.numMPCParties][this.digestSizeBytes];
        byte[][] Ch = new byte[this.numMPCRounds][this.digestSizeBytes];
        byte[][] Cv = new byte[this.numMPCRounds][this.digestSizeBytes];
        Msg[] msgs = new Msg[this.numMPCRounds];
        Tree treeCv = new Tree(this, this.numMPCRounds, this.digestSizeBytes);
        byte[] challengeHash = new byte[64];
        Tree[] seeds = new Tree[this.numMPCRounds];
        Tape[] tapes = new Tape[this.numMPCRounds];
        Tree iSeedsTree = new Tree(this, this.numMPCRounds, this.seedSizeBytes);
        int ret = iSeedsTree.reconstructSeeds(sig.challengeC, this.numOpenedRounds, sig.iSeedInfo, sig.iSeedInfoLen, sig.salt, 0);
        if (ret != 0) {
            return -1;
        }
        for (int t2 = 0; t2 < this.numMPCRounds; ++t2) {
            if (!this.contains(sig.challengeC, this.numOpenedRounds, t2)) {
                seeds[t2] = new Tree(this, this.numMPCParties, this.seedSizeBytes);
                seeds[t2].generateSeeds(iSeedsTree.getLeaf(t2), sig.salt, t2);
                continue;
            }
            seeds[t2] = new Tree(this, this.numMPCParties, this.seedSizeBytes);
            int P_index = PicnicEngine.indexOf(sig.challengeC, this.numOpenedRounds, t2);
            int[] hideList = new int[]{sig.challengeP[P_index]};
            ret = seeds[t2].reconstructSeeds(hideList, 1, sig.proofs[t2].seedInfo, sig.proofs[t2].seedInfoLen, sig.salt, t2);
            if (ret == 0) continue;
            LOG.fine("Failed to reconstruct seeds for round " + t2);
            return -1;
        }
        int last = this.numMPCParties - 1;
        byte[] auxBits = new byte[176];
        for (t = 0; t < this.numMPCRounds; ++t) {
            tapes[t] = new Tape(this);
            this.createRandomTapes(tapes[t], seeds[t].getLeaves(), seeds[t].getLeavesOffset(), sig.salt, t);
            if (!this.contains(sig.challengeC, this.numOpenedRounds, t)) {
                tapes[t].computeAuxTape(null);
                for (int j = 0; j < last; ++j) {
                    this.commit(C[t][j], seeds[t].getLeaf(j), null, sig.salt, t, j);
                }
                this.getAuxBits(auxBits, tapes[t]);
                this.commit(C[t][last], seeds[t].getLeaf(last), auxBits, sig.salt, t, last);
                continue;
            }
            int unopened = sig.challengeP[PicnicEngine.indexOf(sig.challengeC, this.numOpenedRounds, t)];
            for (int j = 0; j < last; ++j) {
                if (j == unopened) continue;
                this.commit(C[t][j], seeds[t].getLeaf(j), null, sig.salt, t, j);
            }
            if (last != unopened) {
                this.commit(C[t][last], seeds[t].getLeaf(last), sig.proofs[t].aux, sig.salt, t, last);
            }
            System.arraycopy(sig.proofs[t].C, 0, C[t][unopened], 0, this.digestSizeBytes);
        }
        for (t = 0; t < this.numMPCRounds; ++t) {
            this.commit_h(Ch[t], C[t]);
        }
        int[] tmp_shares = new int[this.stateSizeBits];
        for (int t3 = 0; t3 < this.numMPCRounds; ++t3) {
            msgs[t3] = new Msg(this);
            if (this.contains(sig.challengeC, this.numOpenedRounds, t3)) {
                int unopened = sig.challengeP[PicnicEngine.indexOf(sig.challengeC, this.numOpenedRounds, t3)];
                int tapeLengthBytes = 2 * this.andSizeBytes;
                if (unopened != last) {
                    tapes[t3].setAuxBits(sig.proofs[t3].aux);
                }
                System.arraycopy(sig.proofs[t3].msgs, 0, msgs[t3].msgs[unopened], 0, this.andSizeBytes);
                Arrays.fill(tapes[t3].tapes[unopened], (byte)0);
                msgs[t3].unopened = unopened;
                byte[] input_bytes = new byte[this.stateSizeWords * 4];
                System.arraycopy(sig.proofs[t3].input, 0, input_bytes, 0, sig.proofs[t3].input.length);
                int[] temp = new int[this.stateSizeWords];
                Pack.littleEndianToInt(input_bytes, 0, temp, 0, this.stateSizeWords);
                int rv = this.simulateOnline(temp, tapes[t3], tmp_shares, msgs[t3], plaintext, pubKey);
                if (rv != 0) {
                    LOG.fine("MPC simulation failed for round " + t3 + ", signature invalid");
                    return -1;
                }
                this.commit_v(Cv[t3], sig.proofs[t3].input, msgs[t3]);
                continue;
            }
            Cv[t3] = null;
        }
        int missingLeavesSize = this.numMPCRounds - this.numOpenedRounds;
        int[] missingLeaves = this.getMissingLeavesList(sig.challengeC);
        ret = treeCv.addMerkleNodes(missingLeaves, missingLeavesSize, sig.cvInfo, sig.cvInfoLen);
        if (ret != 0) {
            return -1;
        }
        ret = treeCv.verifyMerkleTree(Cv, sig.salt);
        if (ret != 0) {
            return -1;
        }
        this.HCP(challengeHash, null, null, Ch, treeCv.nodes[0], sig.salt, pubKey, plaintext, message);
        if (!PicnicEngine.subarrayEquals(sig.challengeHash, challengeHash, this.digestSizeBytes)) {
            LOG.fine("Challenge does not match, signature invalid");
            return -1;
        }
        return ret;
    }

    private int deserializeSignature2(Signature2 sig, byte[] sigBytes, int sigLen, int sigBytesOffset) {
        int P_t;
        int t;
        int bytesRequired = this.digestSizeBytes + 32;
        if (sigBytes.length < bytesRequired) {
            return -1;
        }
        System.arraycopy(sigBytes, sigBytesOffset, sig.challengeHash, 0, this.digestSizeBytes);
        System.arraycopy(sigBytes, sigBytesOffset += this.digestSizeBytes, sig.salt, 0, 32);
        sigBytesOffset += 32;
        this.expandChallengeHash(sig.challengeHash, sig.challengeC, sig.challengeP);
        Tree tree = new Tree(this, this.numMPCRounds, this.seedSizeBytes);
        sig.iSeedInfoLen = tree.revealSeedsSize(sig.challengeC, this.numOpenedRounds);
        bytesRequired += sig.iSeedInfoLen;
        int missingLeavesSize = this.numMPCRounds - this.numOpenedRounds;
        int[] missingLeaves = this.getMissingLeavesList(sig.challengeC);
        tree = new Tree(this, this.numMPCRounds, this.digestSizeBytes);
        sig.cvInfoLen = tree.openMerkleTreeSize(missingLeaves, missingLeavesSize);
        bytesRequired += sig.cvInfoLen;
        int[] hideList = new int[1];
        tree = new Tree(this, this.numMPCParties, this.seedSizeBytes);
        int seedInfoLen = tree.revealSeedsSize(hideList, 1);
        for (t = 0; t < this.numMPCRounds; ++t) {
            if (!this.contains(sig.challengeC, this.numOpenedRounds, t)) continue;
            P_t = sig.challengeP[PicnicEngine.indexOf(sig.challengeC, this.numOpenedRounds, t)];
            if (P_t != this.numMPCParties - 1) {
                bytesRequired += this.andSizeBytes;
            }
            bytesRequired += seedInfoLen;
            bytesRequired += this.stateSizeBytes;
            bytesRequired += this.andSizeBytes;
            bytesRequired += this.digestSizeBytes;
        }
        if (sigLen != bytesRequired) {
            LOG.fine("sigBytesLen = " + sigBytes.length + ", expected bytesRequired = " + bytesRequired);
            return -1;
        }
        sig.iSeedInfo = new byte[sig.iSeedInfoLen];
        System.arraycopy(sigBytes, sigBytesOffset, sig.iSeedInfo, 0, sig.iSeedInfoLen);
        sig.cvInfo = new byte[sig.cvInfoLen];
        System.arraycopy(sigBytes, sigBytesOffset += sig.iSeedInfoLen, sig.cvInfo, 0, sig.cvInfoLen);
        sigBytesOffset += sig.cvInfoLen;
        for (t = 0; t < this.numMPCRounds; ++t) {
            if (!this.contains(sig.challengeC, this.numOpenedRounds, t)) continue;
            sig.proofs[t] = new Signature2.Proof2(this);
            sig.proofs[t].seedInfoLen = seedInfoLen;
            sig.proofs[t].seedInfo = new byte[sig.proofs[t].seedInfoLen];
            System.arraycopy(sigBytes, sigBytesOffset, sig.proofs[t].seedInfo, 0, sig.proofs[t].seedInfoLen);
            sigBytesOffset += sig.proofs[t].seedInfoLen;
            P_t = sig.challengeP[PicnicEngine.indexOf(sig.challengeC, this.numOpenedRounds, t)];
            if (P_t != this.numMPCParties - 1) {
                System.arraycopy(sigBytes, sigBytesOffset, sig.proofs[t].aux, 0, this.andSizeBytes);
                sigBytesOffset += this.andSizeBytes;
                if (!this.arePaddingBitsZero(sig.proofs[t].aux, 3 * this.numRounds * this.numSboxes)) {
                    LOG.fine("failed while deserializing aux bits");
                    return -1;
                }
            }
            System.arraycopy(sigBytes, sigBytesOffset, sig.proofs[t].input, 0, this.stateSizeBytes);
            int msgsByteLength = this.andSizeBytes;
            System.arraycopy(sigBytes, sigBytesOffset += this.stateSizeBytes, sig.proofs[t].msgs, 0, msgsByteLength);
            sigBytesOffset += msgsByteLength;
            int msgsBitLength = 3 * this.numRounds * this.numSboxes;
            if (!this.arePaddingBitsZero(sig.proofs[t].msgs, msgsBitLength)) {
                LOG.fine("failed while deserializing msgs bits");
                return -1;
            }
            System.arraycopy(sigBytes, sigBytesOffset, sig.proofs[t].C, 0, this.digestSizeBytes);
            sigBytesOffset += this.digestSizeBytes;
        }
        return 0;
    }

    private boolean arePaddingBitsZero(byte[] data, int bitLength) {
        int byteLength = Utils.numBytes(bitLength);
        for (int i = bitLength; i < byteLength * 8; ++i) {
            byte bit_i = Utils.getBit(data, i);
            if (bit_i == 0) continue;
            return false;
        }
        return true;
    }

    public void crypto_sign(byte[] sm, byte[] m, byte[] sk) {
        boolean ret = this.picnic_sign(sk, m, sm);
        if (!ret) {
            return;
        }
        System.arraycopy(m, 0, sm, 4, m.length);
    }

    private boolean picnic_sign(byte[] sk, byte[] message, byte[] signature) {
        byte[] data_bytes = new byte[32];
        System.arraycopy(sk, 1, data_bytes, 0, this.stateSizeBytes);
        byte[] ciphertext_bytes = new byte[32];
        System.arraycopy(sk, 1 + this.stateSizeBytes, ciphertext_bytes, 0, this.stateSizeBytes);
        byte[] plaintext_bytes = new byte[32];
        System.arraycopy(sk, 1 + 2 * this.stateSizeBytes, plaintext_bytes, 0, this.stateSizeBytes);
        int[] data = new int[this.stateSizeWords];
        int[] ciphertext = new int[this.stateSizeWords];
        int[] plaintext = new int[this.stateSizeWords];
        Pack.littleEndianToInt(data_bytes, 0, data);
        Pack.littleEndianToInt(plaintext_bytes, 0, plaintext);
        Pack.littleEndianToInt(ciphertext_bytes, 0, ciphertext);
        if (!PicnicEngine.is_picnic3(this.parameters)) {
            Signature sig = new Signature(this);
            int ret = this.sign_picnic1(data, ciphertext, plaintext, message, sig);
            if (ret != 0) {
                LOG.fine("Failed to create signature");
                return false;
            }
            int len = this.serializeSignature(sig, signature, message.length + 4);
            if (len == -1) {
                LOG.fine("Failed to serialize signature");
                return false;
            }
            this.signatureLength = len;
            Pack.intToLittleEndian(len, signature, 0);
            return true;
        }
        Signature2 sig = new Signature2(this);
        boolean ret = this.sign_picnic3(data, ciphertext, plaintext, message, sig);
        if (!ret) {
            LOG.fine("Failed to create signature");
            return false;
        }
        int len = this.serializeSignature2(sig, signature, message.length + 4);
        if (len == -1) {
            LOG.fine("Failed to serialize signature");
            return false;
        }
        this.signatureLength = len;
        Pack.intToLittleEndian(len, signature, 0);
        return true;
    }

    int serializeSignature(Signature sig, byte[] sigBytes, int sigOffset) {
        Signature.Proof[] proofs = sig.proofs;
        byte[] challengeBits = sig.challengeBits;
        int bytesRequired = Utils.numBytes(2 * this.numMPCRounds) + 32 + this.numMPCRounds * (2 * this.seedSizeBytes + this.stateSizeBytes + this.andSizeBytes + this.digestSizeBytes);
        if (this.transform == 1) {
            bytesRequired += this.UnruhGWithoutInputBytes * this.numMPCRounds;
        }
        if (this.CRYPTO_BYTES < bytesRequired) {
            return -1;
        }
        int sigByteIndex = sigOffset;
        System.arraycopy(challengeBits, 0, sigBytes, sigByteIndex, Utils.numBytes(2 * this.numMPCRounds));
        System.arraycopy(sig.salt, 0, sigBytes, sigByteIndex += Utils.numBytes(2 * this.numMPCRounds), 32);
        sigByteIndex += 32;
        for (int i = 0; i < this.numMPCRounds; ++i) {
            int challenge = this.getChallenge(challengeBits, i);
            System.arraycopy(proofs[i].view3Commitment, 0, sigBytes, sigByteIndex, this.digestSizeBytes);
            sigByteIndex += this.digestSizeBytes;
            if (this.transform == 1) {
                int view3UnruhLength = challenge == 0 ? this.UnruhGWithInputBytes : this.UnruhGWithoutInputBytes;
                System.arraycopy(proofs[i].view3UnruhG, 0, sigBytes, sigByteIndex, view3UnruhLength);
                sigByteIndex += view3UnruhLength;
            }
            System.arraycopy(proofs[i].communicatedBits, 0, sigBytes, sigByteIndex, this.andSizeBytes);
            System.arraycopy(proofs[i].seed1, 0, sigBytes, sigByteIndex += this.andSizeBytes, this.seedSizeBytes);
            System.arraycopy(proofs[i].seed2, 0, sigBytes, sigByteIndex += this.seedSizeBytes, this.seedSizeBytes);
            sigByteIndex += this.seedSizeBytes;
            if (challenge != 1 && challenge != 2) continue;
            Pack.intToLittleEndian(proofs[i].inputShare, 0, this.stateSizeWords, sigBytes, sigByteIndex);
            sigByteIndex += this.stateSizeBytes;
        }
        return sigByteIndex - sigOffset;
    }

    int getChallenge(byte[] challenge, int round) {
        return Utils.getBit(challenge, 2 * round + 1) << 1 | Utils.getBit(challenge, 2 * round);
    }

    private int serializeSignature2(Signature2 sig, byte[] sigBytes, int sigOffset) {
        int bytesRequired = this.digestSizeBytes + 32;
        bytesRequired += sig.iSeedInfoLen;
        bytesRequired += sig.cvInfoLen;
        for (int t = 0; t < this.numMPCRounds; ++t) {
            if (!this.contains(sig.challengeC, this.numOpenedRounds, t)) continue;
            int P_t = sig.challengeP[PicnicEngine.indexOf(sig.challengeC, this.numOpenedRounds, t)];
            bytesRequired += sig.proofs[t].seedInfoLen;
            if (P_t != this.numMPCParties - 1) {
                bytesRequired += this.andSizeBytes;
            }
            bytesRequired += this.stateSizeBytes;
            bytesRequired += this.andSizeBytes;
            bytesRequired += this.digestSizeBytes;
        }
        if (sigBytes.length < bytesRequired) {
            return -1;
        }
        int sigByteIndex = sigOffset;
        System.arraycopy(sig.challengeHash, 0, sigBytes, sigByteIndex, this.digestSizeBytes);
        System.arraycopy(sig.salt, 0, sigBytes, sigByteIndex += this.digestSizeBytes, 32);
        System.arraycopy(sig.iSeedInfo, 0, sigBytes, sigByteIndex += 32, sig.iSeedInfoLen);
        System.arraycopy(sig.cvInfo, 0, sigBytes, sigByteIndex += sig.iSeedInfoLen, sig.cvInfoLen);
        sigByteIndex += sig.cvInfoLen;
        for (int t = 0; t < this.numMPCRounds; ++t) {
            if (!this.contains(sig.challengeC, this.numOpenedRounds, t)) continue;
            System.arraycopy(sig.proofs[t].seedInfo, 0, sigBytes, sigByteIndex, sig.proofs[t].seedInfoLen);
            sigByteIndex += sig.proofs[t].seedInfoLen;
            int P_t = sig.challengeP[PicnicEngine.indexOf(sig.challengeC, this.numOpenedRounds, t)];
            if (P_t != this.numMPCParties - 1) {
                System.arraycopy(sig.proofs[t].aux, 0, sigBytes, sigByteIndex, this.andSizeBytes);
                sigByteIndex += this.andSizeBytes;
            }
            System.arraycopy(sig.proofs[t].input, 0, sigBytes, sigByteIndex, this.stateSizeBytes);
            System.arraycopy(sig.proofs[t].msgs, 0, sigBytes, sigByteIndex += this.stateSizeBytes, this.andSizeBytes);
            System.arraycopy(sig.proofs[t].C, 0, sigBytes, sigByteIndex += this.andSizeBytes, this.digestSizeBytes);
            sigByteIndex += this.digestSizeBytes;
        }
        return sigByteIndex - sigOffset;
    }

    private int sign_picnic1(int[] privateKey, int[] pubKey, int[] plaintext, byte[] message, Signature sig) {
        int i;
        View[][] views = new View[this.numMPCRounds][3];
        byte[][][] as = new byte[this.numMPCRounds][this.numMPCParties][this.digestSizeBytes];
        byte[][][] gs = new byte[this.numMPCRounds][3][this.UnruhGWithInputBytes];
        byte[] seeds = this.computeSeeds(privateKey, pubKey, plaintext, message);
        int seedLen = this.numMPCParties * this.seedSizeBytes;
        System.arraycopy(seeds, seedLen * this.numMPCRounds, sig.salt, 0, 32);
        Tape tape = new Tape(this);
        byte[] tmp = new byte[Math.max(9 * this.stateSizeBytes, this.stateSizeBytes + this.andSizeBytes)];
        byte[] view_byte = new byte[this.stateSizeBytes * 4];
        for (int k = 0; k < this.numMPCRounds; ++k) {
            boolean status;
            views[k][0] = new View(this);
            views[k][1] = new View(this);
            views[k][2] = new View(this);
            for (int j = 0; j < 2; ++j) {
                status = this.createRandomTape(seeds, seedLen * k + j * this.seedSizeBytes, sig.salt, k, j, tmp, this.stateSizeBytes + this.andSizeBytes);
                if (!status) {
                    LOG.fine("createRandomTape failed");
                    return -1;
                }
                System.arraycopy(tmp, 0, view_byte, 0, this.stateSizeBytes);
                this.zeroTrailingBits(view_byte, this.stateSizeBits);
                Pack.littleEndianToInt(view_byte, 0, views[k][j].inputShare);
                System.arraycopy(tmp, this.stateSizeBytes, tape.tapes[j], 0, this.andSizeBytes);
            }
            status = this.createRandomTape(seeds, seedLen * k + 2 * this.seedSizeBytes, sig.salt, k, 2, tape.tapes[2], this.andSizeBytes);
            if (!status) {
                LOG.fine("createRandomTape failed");
                return -1;
            }
            this.xor_three(views[k][2].inputShare, privateKey, views[k][0].inputShare, views[k][1].inputShare, this.stateSizeBytes);
            tape.pos = 0;
            int[] tmp_int = Pack.littleEndianToInt(tmp, 0, tmp.length / 4);
            this.mpc_LowMC(tape, views[k], plaintext, tmp_int);
            Pack.intToLittleEndian(tmp_int, tmp, 0);
            int[] temp = new int[16];
            this.xor_three(temp, views[k][0].outputShare, views[k][1].outputShare, views[k][2].outputShare, this.stateSizeBytes);
            if (!PicnicEngine.subarrayEquals(temp, pubKey, this.stateSizeWords)) {
                LOG.fine("Simulation failed; output does not match public key (round = " + k + ")");
                return -1;
            }
            this.Commit(seeds, seedLen * k + 0 * this.seedSizeBytes, views[k][0], as[k][0]);
            this.Commit(seeds, seedLen * k + 1 * this.seedSizeBytes, views[k][1], as[k][1]);
            this.Commit(seeds, seedLen * k + 2 * this.seedSizeBytes, views[k][2], as[k][2]);
            if (this.transform != 1) continue;
            this.G(0, seeds, seedLen * k + 0 * this.seedSizeBytes, views[k][0], gs[k][0]);
            this.G(1, seeds, seedLen * k + 1 * this.seedSizeBytes, views[k][1], gs[k][1]);
            this.G(2, seeds, seedLen * k + 2 * this.seedSizeBytes, views[k][2], gs[k][2]);
        }
        int[][][] viewOutputs = new int[this.numMPCRounds][3][this.stateSizeBytes];
        for (i = 0; i < this.numMPCRounds; ++i) {
            for (int j = 0; j < 3; ++j) {
                viewOutputs[i][j] = views[i][j].outputShare;
            }
        }
        this.H3(pubKey, plaintext, viewOutputs, as, sig.challengeBits, sig.salt, message, gs);
        for (i = 0; i < this.numMPCRounds; ++i) {
            Signature.Proof proof = sig.proofs[i];
            this.prove(proof, this.getChallenge(sig.challengeBits, i), seeds, seedLen * i, views[i], as[i], this.transform != 1 ? (byte[][])null : gs[i]);
        }
        return 0;
    }

    void prove(Signature.Proof proof, int challenge, byte[] seeds, int seedsOffset, View[] views, byte[][] commitments, byte[][] gs) {
        if (challenge == 0) {
            System.arraycopy(seeds, seedsOffset + 0 * this.seedSizeBytes, proof.seed1, 0, this.seedSizeBytes);
            System.arraycopy(seeds, seedsOffset + 1 * this.seedSizeBytes, proof.seed2, 0, this.seedSizeBytes);
        } else if (challenge == 1) {
            System.arraycopy(seeds, seedsOffset + 1 * this.seedSizeBytes, proof.seed1, 0, this.seedSizeBytes);
            System.arraycopy(seeds, seedsOffset + 2 * this.seedSizeBytes, proof.seed2, 0, this.seedSizeBytes);
        } else if (challenge == 2) {
            System.arraycopy(seeds, seedsOffset + 2 * this.seedSizeBytes, proof.seed1, 0, this.seedSizeBytes);
            System.arraycopy(seeds, seedsOffset + 0 * this.seedSizeBytes, proof.seed2, 0, this.seedSizeBytes);
        } else {
            LOG.fine("Invalid challenge");
        }
        if (challenge == 1 || challenge == 2) {
            System.arraycopy(views[2].inputShare, 0, proof.inputShare, 0, this.stateSizeBytes);
        }
        System.arraycopy(views[(challenge + 1) % 3].communicatedBits, 0, proof.communicatedBits, 0, this.andSizeBytes);
        System.arraycopy(commitments[(challenge + 2) % 3], 0, proof.view3Commitment, 0, this.digestSizeBytes);
        if (this.transform == 1) {
            int view3UnruhLength = challenge == 0 ? this.UnruhGWithInputBytes : this.UnruhGWithoutInputBytes;
            System.arraycopy(gs[(challenge + 2) % 3], 0, proof.view3UnruhG, 0, view3UnruhLength);
        }
    }

    void H3(int[] circuitOutput, int[] plaintext, int[][][] viewOutputs, byte[][][] as, byte[] challengeBits, byte[] salt, byte[] message, byte[][][] gs) {
        int j;
        int i;
        byte[] hash = new byte[this.digestSizeBytes];
        challengeBits[Utils.numBytes((int)(this.numMPCRounds * 2)) - 1] = 0;
        this.digest.update((byte)1);
        for (i = 0; i < this.numMPCRounds; ++i) {
            for (j = 0; j < 3; ++j) {
                this.digest.update(Pack.intToLittleEndian(viewOutputs[i][j]), 0, this.stateSizeBytes);
            }
        }
        for (i = 0; i < this.numMPCRounds; ++i) {
            for (j = 0; j < 3; ++j) {
                this.digest.update(as[i][j], 0, this.digestSizeBytes);
            }
        }
        if (this.transform == 1) {
            for (i = 0; i < this.numMPCRounds; ++i) {
                for (j = 0; j < 3; ++j) {
                    int view3UnruhLength = j == 2 ? this.UnruhGWithInputBytes : this.UnruhGWithoutInputBytes;
                    this.digest.update(gs[i][j], 0, view3UnruhLength);
                }
            }
        }
        this.digest.update(Pack.intToLittleEndian(circuitOutput), 0, this.stateSizeBytes);
        this.digest.update(Pack.intToLittleEndian(plaintext), 0, this.stateSizeBytes);
        this.digest.update(salt, 0, 32);
        this.digest.update(message, 0, message.length);
        this.digest.doFinal(hash, 0, this.digestSizeBytes);
        int round = 0;
        boolean isNotDone = true;
        while (isNotDone) {
            for (int i2 = 0; i2 < this.digestSizeBytes; ++i2) {
                byte one_byte = hash[i2];
                for (int j2 = 0; j2 < 8; j2 += 2) {
                    int bitPair = one_byte >>> 6 - j2 & 3;
                    if (bitPair >= 3) continue;
                    this.setChallenge(challengeBits, round, bitPair);
                    if (++round != this.numMPCRounds) continue;
                    isNotDone = false;
                    break;
                }
                if (!isNotDone) break;
            }
            if (!isNotDone) break;
            this.digest.update((byte)1);
            this.digest.update(hash, 0, this.digestSizeBytes);
            this.digest.doFinal(hash, 0, this.digestSizeBytes);
        }
    }

    private void setChallenge(byte[] challenge, int round, int trit) {
        Utils.setBit(challenge, 2 * round, (byte)(trit & 1));
        Utils.setBit(challenge, 2 * round + 1, (byte)(trit >>> 1 & 1));
    }

    private void G(int viewNumber, byte[] seed, int seedOffset, View view, byte[] output) {
        int outputBytes = this.seedSizeBytes + this.andSizeBytes;
        this.digest.update((byte)5);
        this.digest.update(seed, seedOffset, this.seedSizeBytes);
        this.digest.doFinal(output, 0, this.digestSizeBytes);
        this.digest.update(output, 0, this.digestSizeBytes);
        if (viewNumber == 2) {
            this.digest.update(Pack.intToLittleEndian(view.inputShare), 0, this.stateSizeBytes);
            outputBytes += this.stateSizeBytes;
        }
        this.digest.update(view.communicatedBits, 0, this.andSizeBytes);
        this.digest.update(Pack.intToLittleEndian(outputBytes), 0, 2);
        this.digest.doFinal(output, 0, outputBytes);
    }

    private void mpc_LowMC(Tape tapes, View[] views, int[] plaintext, int[] slab) {
        Arrays.fill(slab, 0, slab.length, 0);
        this.mpc_xor_constant(slab, 3 * this.stateSizeWords, plaintext, 0, this.stateSizeWords);
        KMatricesWithPointer current = LowmcConstants.KMatrix(this, 0);
        for (int player = 0; player < 3; ++player) {
            this.matrix_mul_offset(slab, player * this.stateSizeWords, views[player].inputShare, 0, current.getData(), current.getMatrixPointer());
        }
        this.mpc_xor(slab, slab, this.stateSizeWords, 3);
        for (int r = 1; r <= this.numRounds; ++r) {
            current = LowmcConstants.KMatrix(this, r);
            for (int player = 0; player < 3; ++player) {
                this.matrix_mul_offset(slab, player * this.stateSizeWords, views[player].inputShare, 0, current.getData(), current.getMatrixPointer());
            }
            this.mpc_substitution(slab, tapes, views);
            current = LowmcConstants.LMatrix(this, r - 1);
            this.mpc_matrix_mul(slab, 3 * this.stateSizeWords, slab, 3 * this.stateSizeWords, current.getData(), current.getMatrixPointer(), 3);
            current = LowmcConstants.RConstant(this, r - 1);
            this.mpc_xor_constant(slab, 3 * this.stateSizeWords, current.getData(), current.getMatrixPointer(), this.stateSizeWords);
            this.mpc_xor(slab, slab, this.stateSizeWords, 3);
        }
        for (int i = 0; i < 3; ++i) {
            System.arraycopy(slab, (3 + i) * this.stateSizeWords, views[i].outputShare, 0, this.stateSizeWords);
        }
    }

    private void Commit(byte[] seed, int seedOffset, View view, byte[] hash) {
        this.digest.update((byte)4);
        this.digest.update(seed, seedOffset, this.seedSizeBytes);
        this.digest.doFinal(hash, 0, this.digestSizeBytes);
        this.digest.update((byte)0);
        this.digest.update(hash, 0, this.digestSizeBytes);
        this.digest.update(Pack.intToLittleEndian(view.inputShare), 0, this.stateSizeBytes);
        this.digest.update(view.communicatedBits, 0, this.andSizeBytes);
        this.digest.update(Pack.intToLittleEndian(view.outputShare), 0, this.stateSizeBytes);
        this.digest.doFinal(hash, 0, this.digestSizeBytes);
    }

    private void mpc_substitution(int[] state, Tape rand, View[] views) {
        int[] a = new int[3];
        int[] b = new int[3];
        int[] c = new int[3];
        int[] ab = new int[3];
        int[] bc = new int[3];
        int[] ca = new int[3];
        for (int i = 0; i < this.numSboxes * 3; i += 3) {
            int stateOffset;
            int j;
            for (j = 0; j < 3; ++j) {
                stateOffset = (3 + j) * this.stateSizeWords * 32;
                a[j] = Utils.getBitFromWordArray(state, stateOffset + i + 2);
                b[j] = Utils.getBitFromWordArray(state, stateOffset + i + 1);
                c[j] = Utils.getBitFromWordArray(state, stateOffset + i);
            }
            this.mpc_AND(a, b, ab, rand, views);
            this.mpc_AND(b, c, bc, rand, views);
            this.mpc_AND(c, a, ca, rand, views);
            for (j = 0; j < 3; ++j) {
                stateOffset = (3 + j) * this.stateSizeWords * 32;
                Utils.setBitInWordArray(state, stateOffset + i + 2, a[j] ^ bc[j]);
                Utils.setBitInWordArray(state, stateOffset + i + 1, a[j] ^ b[j] ^ ca[j]);
                Utils.setBitInWordArray(state, stateOffset + i, a[j] ^ b[j] ^ c[j] ^ ab[j]);
            }
        }
    }

    private void mpc_AND(int[] in1, int[] in2, int[] out, Tape rand, View[] views) {
        int[] r = new int[]{Utils.getBit(rand.tapes[0], rand.pos), Utils.getBit(rand.tapes[1], rand.pos), Utils.getBit(rand.tapes[2], rand.pos)};
        for (int i = 0; i < 3; ++i) {
            out[i] = in1[i] & in2[(i + 1) % 3] ^ in1[(i + 1) % 3] & in2[i] ^ in1[i] & in2[i] ^ r[i] ^ r[(i + 1) % 3];
            Utils.setBit(views[i].communicatedBits, rand.pos, (byte)(out[i] & 0xFF));
        }
        ++rand.pos;
    }

    private void mpc_xor(int[] state, int[] in, int len, int players) {
        for (int player = 0; player < players; ++player) {
            for (int i = 0; i < len; ++i) {
                state[i + (players + player) * this.stateSizeWords] = state[i + (players + player) * this.stateSizeWords] ^ in[i + player * this.stateSizeWords];
            }
        }
    }

    private void mpc_matrix_mul(int[] output, int outputOffset, int[] state, int stateOffset, int[] matrix, int matrixOffset, int players) {
        for (int player = 0; player < players; ++player) {
            this.matrix_mul_offset(output, outputOffset + player * this.stateSizeWords, state, stateOffset + player * this.stateSizeWords, matrix, matrixOffset);
        }
    }

    private void mpc_xor_constant(int[] state, int stateOffset, int[] in, int inOffset, int len) {
        for (int i = 0; i < len; ++i) {
            state[i + stateOffset] = state[i + stateOffset] ^ in[i + inOffset];
        }
    }

    private boolean createRandomTape(byte[] seed, int seedOffset, byte[] salt, int roundNumber, int playerNumber, byte[] tape, int tapeLen) {
        if (tapeLen < this.digestSizeBytes) {
            return false;
        }
        this.digest.update((byte)2);
        this.digest.update(seed, seedOffset, this.seedSizeBytes);
        this.digest.doFinal(tape, 0, this.digestSizeBytes);
        this.digest.update(tape, 0, this.digestSizeBytes);
        this.digest.update(salt, 0, 32);
        this.digest.update(Pack.intToLittleEndian(roundNumber), 0, 2);
        this.digest.update(Pack.intToLittleEndian(playerNumber), 0, 2);
        this.digest.update(Pack.intToLittleEndian(tapeLen), 0, 2);
        this.digest.doFinal(tape, 0, tapeLen);
        return true;
    }

    private byte[] computeSeeds(int[] privateKey, int[] publicKey, int[] plaintext, byte[] message) {
        byte[] allSeeds = new byte[this.seedSizeBytes * (this.numMPCParties * this.numMPCRounds) + 32];
        this.digest.update(Pack.intToLittleEndian(privateKey), 0, this.stateSizeBytes);
        this.digest.update(message, 0, message.length);
        this.digest.update(Pack.intToLittleEndian(publicKey), 0, this.stateSizeBytes);
        this.digest.update(Pack.intToLittleEndian(plaintext), 0, this.stateSizeBytes);
        this.digest.update(Pack.intToLittleEndian(this.stateSizeBits), 0, 2);
        this.digest.doFinal(allSeeds, 0, this.seedSizeBytes * (this.numMPCParties * this.numMPCRounds) + 32);
        return allSeeds;
    }

    private boolean sign_picnic3(int[] privateKey, int[] pubKey, int[] plaintext, byte[] message, Signature2 sig) {
        byte[] saltAndRoot = new byte[32 + this.seedSizeBytes];
        this.computeSaltAndRootSeed(saltAndRoot, privateKey, pubKey, plaintext, message);
        byte[] root = Arrays.copyOfRange(saltAndRoot, 32, saltAndRoot.length);
        sig.salt = Arrays.copyOfRange(saltAndRoot, 0, 32);
        Tree iSeedsTree = new Tree(this, this.numMPCRounds, this.seedSizeBytes);
        iSeedsTree.generateSeeds(root, sig.salt, 0);
        byte[][] iSeeds = iSeedsTree.getLeaves();
        int iSeedsOffset = iSeedsTree.getLeavesOffset();
        Tape[] tapes = new Tape[this.numMPCRounds];
        Tree[] seeds = new Tree[this.numMPCRounds];
        for (int t = 0; t < this.numMPCRounds; ++t) {
            tapes[t] = new Tape(this);
            seeds[t] = new Tree(this, this.numMPCParties, this.seedSizeBytes);
            seeds[t].generateSeeds(iSeeds[t + iSeedsOffset], sig.salt, t);
            this.createRandomTapes(tapes[t], seeds[t].getLeaves(), seeds[t].getLeavesOffset(), sig.salt, t);
        }
        byte[][] inputs = new byte[this.numMPCRounds][this.stateSizeWords * 4];
        byte[] auxBits = new byte[176];
        for (int t = 0; t < this.numMPCRounds; ++t) {
            tapes[t].computeAuxTape(inputs[t]);
        }
        byte[][][] C = new byte[this.numMPCRounds][this.numMPCParties][this.digestSizeBytes];
        for (int t = 0; t < this.numMPCRounds; ++t) {
            for (int j = 0; j < this.numMPCParties - 1; ++j) {
                this.commit(C[t][j], seeds[t].getLeaf(j), null, sig.salt, t, j);
            }
            int last = this.numMPCParties - 1;
            this.getAuxBits(auxBits, tapes[t]);
            this.commit(C[t][last], seeds[t].getLeaf(last), auxBits, sig.salt, t, last);
        }
        Msg[] msgs = new Msg[this.numMPCRounds];
        int[] tmp_shares = new int[this.stateSizeBits];
        for (int t = 0; t < this.numMPCRounds; ++t) {
            msgs[t] = new Msg(this);
            int[] maskedKey = Pack.littleEndianToInt(inputs[t], 0, this.stateSizeWords);
            this.xor_array(maskedKey, maskedKey, privateKey, 0, this.stateSizeWords);
            int rv = this.simulateOnline(maskedKey, tapes[t], tmp_shares, msgs[t], plaintext, pubKey);
            if (rv != 0) {
                LOG.fine("MPC simulation failed, aborting signature");
                return false;
            }
            Pack.intToLittleEndian(maskedKey, inputs[t], 0);
        }
        byte[][] Ch = new byte[this.numMPCRounds][this.digestSizeBytes];
        byte[][] Cv = new byte[this.numMPCRounds][this.digestSizeBytes];
        for (int t = 0; t < this.numMPCRounds; ++t) {
            this.commit_h(Ch[t], C[t]);
            this.commit_v(Cv[t], inputs[t], msgs[t]);
        }
        Tree treeCv = new Tree(this, this.numMPCRounds, this.digestSizeBytes);
        treeCv.buildMerkleTree(Cv, sig.salt);
        sig.challengeC = new int[this.numOpenedRounds];
        sig.challengeP = new int[this.numOpenedRounds];
        sig.challengeHash = new byte[this.digestSizeBytes];
        this.HCP(sig.challengeHash, sig.challengeC, sig.challengeP, Ch, treeCv.nodes[0], sig.salt, pubKey, plaintext, message);
        int missingLeavesSize = this.numMPCRounds - this.numOpenedRounds;
        int[] missingLeaves = this.getMissingLeavesList(sig.challengeC);
        int[] cvInfoLen = new int[1];
        sig.cvInfo = treeCv.openMerkleTree(missingLeaves, missingLeavesSize, cvInfoLen);
        sig.cvInfoLen = cvInfoLen[0];
        sig.iSeedInfo = new byte[this.numMPCRounds * this.seedSizeBytes];
        sig.iSeedInfoLen = iSeedsTree.revealSeeds(sig.challengeC, this.numOpenedRounds, sig.iSeedInfo, this.numMPCRounds * this.seedSizeBytes);
        sig.proofs = new Signature2.Proof2[this.numMPCRounds];
        for (int t = 0; t < this.numMPCRounds; ++t) {
            if (!this.contains(sig.challengeC, this.numOpenedRounds, t)) continue;
            sig.proofs[t] = new Signature2.Proof2(this);
            int P_index = PicnicEngine.indexOf(sig.challengeC, this.numOpenedRounds, t);
            int[] hideList = new int[]{sig.challengeP[P_index]};
            sig.proofs[t].seedInfo = new byte[this.numMPCParties * this.seedSizeBytes];
            sig.proofs[t].seedInfoLen = seeds[t].revealSeeds(hideList, 1, sig.proofs[t].seedInfo, this.numMPCParties * this.seedSizeBytes);
            int last = this.numMPCParties - 1;
            if (sig.challengeP[P_index] != last) {
                this.getAuxBits(sig.proofs[t].aux, tapes[t]);
            }
            System.arraycopy(inputs[t], 0, sig.proofs[t].input, 0, this.stateSizeBytes);
            System.arraycopy(msgs[t].msgs[sig.challengeP[P_index]], 0, sig.proofs[t].msgs, 0, this.andSizeBytes);
            System.arraycopy(C[t][sig.challengeP[P_index]], 0, sig.proofs[t].C, 0, this.digestSizeBytes);
        }
        return true;
    }

    static int indexOf(int[] list, int len, int value) {
        for (int i = 0; i < len; ++i) {
            if (list[i] != value) continue;
            return i;
        }
        return -1;
    }

    private int[] getMissingLeavesList(int[] challengeC) {
        int missingLeavesSize = this.numMPCRounds - this.numOpenedRounds;
        int[] missingLeaves = new int[missingLeavesSize];
        int pos = 0;
        for (int i = 0; i < this.numMPCRounds; ++i) {
            if (this.contains(challengeC, this.numOpenedRounds, i)) continue;
            missingLeaves[pos] = i;
            ++pos;
        }
        return missingLeaves;
    }

    private void HCP(byte[] challengeHash, int[] challengeC, int[] challengeP, byte[][] Ch, byte[] hCv, byte[] salt, int[] pubKey, int[] plaintext, byte[] message) {
        for (int t = 0; t < this.numMPCRounds; ++t) {
            this.digest.update(Ch[t], 0, this.digestSizeBytes);
        }
        this.digest.update(hCv, 0, this.digestSizeBytes);
        this.digest.update(salt, 0, 32);
        this.digest.update(Pack.intToLittleEndian(pubKey), 0, this.stateSizeBytes);
        this.digest.update(Pack.intToLittleEndian(plaintext), 0, this.stateSizeBytes);
        this.digest.update(message, 0, message.length);
        this.digest.doFinal(challengeHash, 0, this.digestSizeBytes);
        if (challengeC != null && challengeP != null) {
            this.expandChallengeHash(challengeHash, challengeC, challengeP);
        }
    }

    static int bitsToChunks(int chunkLenBits, byte[] input, int inputLen, int[] chunks) {
        if (chunkLenBits > inputLen * 8) {
            return 0;
        }
        int chunkCount = inputLen * 8 / chunkLenBits;
        for (int i = 0; i < chunkCount; ++i) {
            chunks[i] = 0;
            for (int j = 0; j < chunkLenBits; ++j) {
                int n = i;
                chunks[n] = chunks[n] + (Utils.getBit(input, i * chunkLenBits + j) << j);
            }
        }
        return chunkCount;
    }

    static int appendUnique(int[] list, int value, int position) {
        if (position == 0) {
            list[position] = value;
            return position + 1;
        }
        for (int i = 0; i < position; ++i) {
            if (list[i] != value) continue;
            return position;
        }
        list[position] = value;
        return position + 1;
    }

    private void expandChallengeHash(byte[] challengeHash, int[] challengeC, int[] challengeP) {
        int bitsPerChunkC = Utils.ceil_log2(this.numMPCRounds);
        int bitsPerChunkP = Utils.ceil_log2(this.numMPCParties);
        int[] chunks = new int[this.digestSizeBytes * 8 / Math.min(bitsPerChunkC, bitsPerChunkP)];
        byte[] h = new byte[64];
        System.arraycopy(challengeHash, 0, h, 0, this.digestSizeBytes);
        int countC = 0;
        while (countC < this.numOpenedRounds) {
            int numChunks = PicnicEngine.bitsToChunks(bitsPerChunkC, h, this.digestSizeBytes, chunks);
            for (int i = 0; i < numChunks; ++i) {
                if (chunks[i] < this.numMPCRounds) {
                    countC = PicnicEngine.appendUnique(challengeC, chunks[i], countC);
                }
                if (countC == this.numOpenedRounds) break;
            }
            this.digest.update((byte)1);
            this.digest.update(h, 0, this.digestSizeBytes);
            this.digest.doFinal(h, 0, this.digestSizeBytes);
        }
        int countP = 0;
        while (countP < this.numOpenedRounds) {
            int numChunks = PicnicEngine.bitsToChunks(bitsPerChunkP, h, this.digestSizeBytes, chunks);
            for (int i = 0; i < numChunks; ++i) {
                if (chunks[i] < this.numMPCParties) {
                    challengeP[countP] = chunks[i];
                    ++countP;
                }
                if (countP == this.numOpenedRounds) break;
            }
            this.digest.update((byte)1);
            this.digest.update(h, 0, this.digestSizeBytes);
            this.digest.doFinal(h, 0, this.digestSizeBytes);
        }
    }

    private void commit_h(byte[] digest_arr, byte[][] C) {
        for (int i = 0; i < this.numMPCParties; ++i) {
            this.digest.update(C[i], 0, this.digestSizeBytes);
        }
        this.digest.doFinal(digest_arr, 0, this.digestSizeBytes);
    }

    private void commit_v(byte[] digest_arr, byte[] input, Msg msg) {
        this.digest.update(input, 0, this.stateSizeBytes);
        for (int i = 0; i < this.numMPCParties; ++i) {
            int msgs_size = Utils.numBytes(msg.pos);
            this.digest.update(msg.msgs[i], 0, msgs_size);
        }
        this.digest.doFinal(digest_arr, 0, this.digestSizeBytes);
    }

    private int simulateOnline(int[] maskedKey, Tape tape, int[] tmp_shares, Msg msg, int[] plaintext, int[] pubKey) {
        int ret = 0;
        int[] roundKey = new int[16];
        int[] state = new int[16];
        KMatricesWithPointer current = LowmcConstants.KMatrix(this, 0);
        this.matrix_mul(roundKey, maskedKey, current.getData(), current.getMatrixPointer());
        this.xor_array(state, roundKey, plaintext, 0, this.stateSizeWords);
        for (int r = 1; r <= this.numRounds; ++r) {
            this.tapesToWords(tmp_shares, tape);
            this.mpc_sbox(state, tmp_shares, tape, msg);
            current = LowmcConstants.LMatrix(this, r - 1);
            this.matrix_mul(state, state, current.getData(), current.getMatrixPointer());
            current = LowmcConstants.RConstant(this, r - 1);
            this.xor_array(state, state, current.getData(), current.getMatrixPointer(), this.stateSizeWords);
            current = LowmcConstants.KMatrix(this, r);
            this.matrix_mul(roundKey, maskedKey, current.getData(), current.getMatrixPointer());
            this.xor_array(state, roundKey, state, 0, this.stateSizeWords);
        }
        if (!PicnicEngine.subarrayEquals(state, pubKey, this.stateSizeWords)) {
            ret = -1;
        }
        return ret;
    }

    private void createRandomTapes(Tape tape, byte[][] seeds, int seedsOffset, byte[] salt, int t) {
        int tapeSizeBytes = 2 * this.andSizeBytes;
        for (int i = 0; i < this.numMPCParties; ++i) {
            this.digest.update(seeds[i + seedsOffset], 0, this.seedSizeBytes);
            this.digest.update(salt, 0, 32);
            this.digest.update(Pack.intToLittleEndian(t), 0, 2);
            this.digest.update(Pack.intToLittleEndian(i), 0, 2);
            this.digest.doFinal(tape.tapes[i], 0, tapeSizeBytes);
        }
    }

    private static boolean subarrayEquals(byte[] a, byte[] b, int length) {
        if (a.length < length || b.length < length) {
            return false;
        }
        for (int i = 0; i < length; ++i) {
            if (a[i] == b[i]) continue;
            return false;
        }
        return true;
    }

    private static boolean subarrayEquals(int[] a, int[] b, int length) {
        if (a.length < length || b.length < length) {
            return false;
        }
        for (int i = 0; i < length; ++i) {
            if (a[i] == b[i]) continue;
            return false;
        }
        return true;
    }

    static int extend(int bit) {
        return ~(bit - 1);
    }

    private void wordToMsgs(int w, Msg msg) {
        for (int i = 0; i < this.numMPCParties; ++i) {
            byte w_i = Utils.getBit(Pack.intToLittleEndian(w), i);
            Utils.setBit(msg.msgs[i], msg.pos, (byte)(w_i & 0xFF));
        }
        ++msg.pos;
    }

    private int mpc_AND(int a, int b, int mask_a, int mask_b, Tape tape, Msg msg) {
        int and_helper = tape.tapesToWord();
        int s_shares = PicnicEngine.extend(a) & mask_b ^ PicnicEngine.extend(b) & mask_a ^ and_helper;
        byte[] temp = Pack.intToLittleEndian(s_shares);
        if (msg.unopened >= 0) {
            byte unopenedPartyBit = Utils.getBit(msg.msgs[msg.unopened], msg.pos);
            Utils.setBit(temp, msg.unopened, (byte)(unopenedPartyBit & 0xFF));
            s_shares = Pack.littleEndianToInt(temp, 0);
        }
        this.wordToMsgs(s_shares, msg);
        return Utils.parity16(s_shares) ^ a & b;
    }

    private void mpc_sbox(int[] state, int[] state_masks, Tape tape, Msg msg) {
        for (int i = 0; i < this.numSboxes * 3; i += 3) {
            int a = Utils.getBitFromWordArray(state, i + 2);
            int mask_a = state_masks[i + 2];
            int b = Utils.getBitFromWordArray(state, i + 1);
            int mask_b = state_masks[i + 1];
            int c = Utils.getBitFromWordArray(state, i);
            int mask_c = state_masks[i];
            int ab = this.mpc_AND(a, b, mask_a, mask_b, tape, msg);
            int bc = this.mpc_AND(b, c, mask_b, mask_c, tape, msg);
            int ca = this.mpc_AND(c, a, mask_c, mask_a, tape, msg);
            int d = a ^ bc;
            int e = a ^ b ^ ca;
            int f = a ^ b ^ c ^ ab;
            Utils.setBitInWordArray(state, i + 2, d);
            Utils.setBitInWordArray(state, i + 1, e);
            Utils.setBitInWordArray(state, i, f);
        }
    }

    protected void aux_mpc_sbox(int[] in, int[] out, Tape tape) {
        for (int i = 0; i < this.numSboxes * 3; i += 3) {
            int a = Utils.getBitFromWordArray(in, i + 2);
            int b = Utils.getBitFromWordArray(in, i + 1);
            int c = Utils.getBitFromWordArray(in, i);
            int d = Utils.getBitFromWordArray(out, i + 2);
            int e = Utils.getBitFromWordArray(out, i + 1);
            int f = Utils.getBitFromWordArray(out, i);
            int fresh_output_mask_ab = f ^ a ^ b ^ c;
            int fresh_output_mask_bc = d ^ a;
            int fresh_output_mask_ca = e ^ a ^ b;
            this.aux_mpc_AND(a, b, fresh_output_mask_ab, tape);
            this.aux_mpc_AND(b, c, fresh_output_mask_bc, tape);
            this.aux_mpc_AND(c, a, fresh_output_mask_ca, tape);
        }
    }

    private void aux_mpc_AND(int mask_a, int mask_b, int fresh_output_mask, Tape tape) {
        int lastParty = this.numMPCParties - 1;
        int and_helper = tape.tapesToWord();
        and_helper = Utils.parity16(and_helper) ^ Utils.getBit(tape.tapes[lastParty], tape.pos - 1);
        int aux_bit = mask_a & mask_b ^ and_helper ^ fresh_output_mask;
        Utils.setBit(tape.tapes[lastParty], tape.pos - 1, (byte)(aux_bit & 0xFF));
    }

    private boolean contains(int[] list, int len, int value) {
        for (int i = 0; i < len; ++i) {
            if (list[i] != value) continue;
            return true;
        }
        return false;
    }

    private void tapesToWords(int[] shares, Tape tape) {
        for (int w = 0; w < this.stateSizeBits; ++w) {
            shares[w] = tape.tapesToWord();
        }
    }

    private void getAuxBits(byte[] output, Tape tape) {
        int last = this.numMPCParties - 1;
        int pos = 0;
        int n = this.stateSizeBits;
        for (int j = 0; j < this.numRounds; ++j) {
            for (int i = 0; i < n; ++i) {
                Utils.setBit(output, pos++, Utils.getBit(tape.tapes[last], n + n * 2 * j + i));
            }
        }
    }

    private void commit(byte[] digest_arr, byte[] seed, byte[] aux, byte[] salt, int t, int j) {
        this.digest.update(seed, 0, this.seedSizeBytes);
        if (aux != null) {
            this.digest.update(aux, 0, this.andSizeBytes);
        }
        this.digest.update(salt, 0, 32);
        this.digest.update(Pack.intToLittleEndian(t), 0, 2);
        this.digest.update(Pack.intToLittleEndian(j), 0, 2);
        this.digest.doFinal(digest_arr, 0, this.digestSizeBytes);
    }

    private void computeSaltAndRootSeed(byte[] saltAndRoot, int[] privateKey, int[] pubKey, int[] plaintext, byte[] message) {
        byte[] privatekey_bytes = new byte[32];
        byte[] pubkey_bytes = new byte[32];
        byte[] plaintext_bytes = new byte[32];
        Pack.intToLittleEndian(privateKey, privatekey_bytes, 0);
        Pack.intToLittleEndian(pubKey, pubkey_bytes, 0);
        Pack.intToLittleEndian(plaintext, plaintext_bytes, 0);
        privatekey_bytes = Arrays.copyOfRange(privatekey_bytes, 0, this.stateSizeBytes);
        pubkey_bytes = Arrays.copyOfRange(pubkey_bytes, 0, this.stateSizeBytes);
        plaintext_bytes = Arrays.copyOfRange(plaintext_bytes, 0, this.stateSizeBytes);
        this.digest.update(privatekey_bytes, 0, this.stateSizeBytes);
        this.digest.update(message, 0, message.length);
        this.digest.update(pubkey_bytes, 0, this.stateSizeBytes);
        this.digest.update(plaintext_bytes, 0, this.stateSizeBytes);
        this.digest.update(Pack.shortToLittleEndian((short)(this.stateSizeBits & 0xFFFF)), 0, 2);
        this.digest.doFinal(saltAndRoot, 0, saltAndRoot.length);
    }

    static boolean is_picnic3(int params) {
        return params == 7 || params == 8 || params == 9;
    }

    public void crypto_sign_keypair(byte[] pk, byte[] sk, SecureRandom random) {
        byte[] plaintext_bytes = new byte[32];
        byte[] ciphertext_bytes = new byte[32];
        byte[] data_bytes = new byte[32];
        this.picnic_keygen(plaintext_bytes, ciphertext_bytes, data_bytes, random);
        this.picnic_write_public_key(ciphertext_bytes, plaintext_bytes, pk);
        this.picnic_write_private_key(data_bytes, ciphertext_bytes, plaintext_bytes, sk);
    }

    private int picnic_write_private_key(byte[] data, byte[] ciphertext, byte[] plaintext, byte[] buf) {
        int bytesRequired = 1 + 3 * this.stateSizeBytes;
        if (buf.length < bytesRequired) {
            LOG.fine("Failed writing private key!");
            return -1;
        }
        buf[0] = (byte)this.parameters;
        System.arraycopy(data, 0, buf, 1, this.stateSizeBytes);
        System.arraycopy(ciphertext, 0, buf, 1 + this.stateSizeBytes, this.stateSizeBytes);
        System.arraycopy(plaintext, 0, buf, 1 + 2 * this.stateSizeBytes, this.stateSizeBytes);
        return bytesRequired;
    }

    private int picnic_write_public_key(byte[] ciphertext, byte[] plaintext, byte[] buf) {
        int bytesRequired = 1 + 2 * this.stateSizeBytes;
        if (buf.length < bytesRequired) {
            LOG.fine("Failed writing public key!");
            return -1;
        }
        buf[0] = (byte)this.parameters;
        System.arraycopy(ciphertext, 0, buf, 1, this.stateSizeBytes);
        System.arraycopy(plaintext, 0, buf, 1 + this.stateSizeBytes, this.stateSizeBytes);
        return bytesRequired;
    }

    private void picnic_keygen(byte[] plaintext_bytes, byte[] ciphertext_bytes, byte[] data_bytes, SecureRandom random) {
        int i;
        int[] data = new int[data_bytes.length / 4];
        int[] plaintext = new int[plaintext_bytes.length / 4];
        int[] ciphertext = new int[ciphertext_bytes.length / 4];
        byte[] temp = new byte[this.stateSizeBytes];
        random.nextBytes(temp);
        this.zeroTrailingBits(temp, this.stateSizeBits);
        System.arraycopy(temp, 0, data_bytes, 0, temp.length);
        for (i = 0; i < data.length; ++i) {
            data[i] = Pack.littleEndianToInt(data_bytes, i * 4);
        }
        random.nextBytes(temp);
        this.zeroTrailingBits(temp, this.stateSizeBits);
        System.arraycopy(temp, 0, plaintext_bytes, 0, temp.length);
        for (i = 0; i < plaintext.length; ++i) {
            plaintext[i] = Pack.littleEndianToInt(plaintext_bytes, i * 4);
        }
        this.LowMCEnc(plaintext, ciphertext, data);
        Pack.intToLittleEndian(data, data_bytes, 0);
        Pack.intToLittleEndian(plaintext, plaintext_bytes, 0);
        Pack.intToLittleEndian(ciphertext, ciphertext_bytes, 0);
    }

    private void LowMCEnc(int[] plaintext, int[] output, int[] key) {
        int[] roundKey = new int[16];
        if (plaintext != output) {
            System.arraycopy(plaintext, 0, output, 0, this.stateSizeWords);
        }
        KMatricesWithPointer current = LowmcConstants.KMatrix(this, 0);
        this.matrix_mul(roundKey, key, current.getData(), current.getMatrixPointer());
        this.xor_array(output, output, roundKey, 0, this.stateSizeWords);
        for (int r = 1; r <= this.numRounds; ++r) {
            current = LowmcConstants.KMatrix(this, r);
            this.matrix_mul(roundKey, key, current.getData(), current.getMatrixPointer());
            this.substitution(output);
            current = LowmcConstants.LMatrix(this, r - 1);
            this.matrix_mul(output, output, current.getData(), current.getMatrixPointer());
            current = LowmcConstants.RConstant(this, r - 1);
            this.xor_array(output, output, current.getData(), current.getMatrixPointer(), this.stateSizeWords);
            this.xor_array(output, output, roundKey, 0, this.stateSizeWords);
        }
    }

    private void substitution(int[] state) {
        for (int i = 0; i < this.numSboxes * 3; i += 3) {
            int a = Utils.getBitFromWordArray(state, i + 2);
            int b = Utils.getBitFromWordArray(state, i + 1);
            int c = Utils.getBitFromWordArray(state, i);
            Utils.setBitInWordArray(state, i + 2, a ^ b & c);
            Utils.setBitInWordArray(state, i + 1, a ^ b ^ a & c);
            Utils.setBitInWordArray(state, i, a ^ b ^ c ^ a & b);
        }
    }

    private void xor_three(int[] output, int[] in1, int[] in2, int[] in3, int lenBytes) {
        int wholeWords = this.stateSizeWords;
        for (int i = 0; i < wholeWords; ++i) {
            output[i] = in1[i] ^ in2[i] ^ in3[i];
        }
    }

    protected void xor_array(int[] out, int[] in1, int[] in2, int in2_offset, int length) {
        for (int i = 0; i < length; ++i) {
            out[i] = in1[i] ^ in2[i + in2_offset];
        }
    }

    protected void matrix_mul(int[] output, int[] state, int[] matrix, int matrixOffset) {
        this.matrix_mul_offset(output, 0, state, 0, matrix, matrixOffset);
    }

    protected void matrix_mul_offset(int[] output, int outputOffset, int[] state, int stateOffset, int[] matrix, int matrixOffset) {
        int[] temp = new int[16];
        temp[this.stateSizeWords - 1] = 0;
        int wholeWords = this.stateSizeBits / 32;
        for (int i = 0; i < this.stateSizeBits; ++i) {
            int index;
            int j;
            int prod = 0;
            for (j = 0; j < wholeWords; ++j) {
                index = i * this.stateSizeWords + j;
                prod ^= state[j + stateOffset] & matrix[matrixOffset + index];
            }
            for (j = wholeWords * 32; j < this.stateSizeBits; ++j) {
                index = i * this.stateSizeWords * 32 + j;
                int bit = Utils.getBitFromWordArray(state, j + stateOffset * 32) & Utils.getBitFromWordArray(matrix, matrixOffset * 32 + index);
                prod ^= bit;
            }
            Utils.setBit(temp, i, Utils.parity32(prod));
        }
        System.arraycopy(temp, 0, output, outputOffset, this.stateSizeWords);
    }

    private void zeroTrailingBits(byte[] data, int bitLength) {
        int byteLength = Utils.numBytes(bitLength);
        for (int i = bitLength; i < byteLength * 8; ++i) {
            Utils.setBit(data, i, (byte)0);
        }
    }
}

