/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jcajce.provider.drbg;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.SecureRandomSpi;
import java.security.Security;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.bouncycastle.crypto.digests.SHA512Digest;
import org.bouncycastle.crypto.macs.HMac;
import org.bouncycastle.crypto.prng.EntropySource;
import org.bouncycastle.crypto.prng.EntropySourceProvider;
import org.bouncycastle.crypto.prng.SP800SecureRandom;
import org.bouncycastle.crypto.prng.SP800SecureRandomBuilder;
import org.bouncycastle.jcajce.provider.config.ConfigurableProvider;
import org.bouncycastle.jcajce.provider.symmetric.util.ClassUtil;
import org.bouncycastle.jcajce.provider.util.AsymmetricAlgorithmProvider;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.Pack;
import org.bouncycastle.util.Properties;
import org.bouncycastle.util.Strings;

public class DRBG {
    private static final String PREFIX = DRBG.class.getName();
    private static final String[][] initialEntropySourceNames = new String[][]{{"sun.security.provider.Sun", "sun.security.provider.SecureRandom"}, {"org.apache.harmony.security.provider.crypto.CryptoProvider", "org.apache.harmony.security.provider.crypto.SHA1PRNG_SecureRandomImpl"}, {"com.android.org.conscrypt.OpenSSLProvider", "com.android.org.conscrypt.OpenSSLRandom"}, {"org.conscrypt.OpenSSLProvider", "org.conscrypt.OpenSSLRandom"}};
    private static EntropyDaemon entropyDaemon = null;
    private static Thread entropyThread = null;

    private static final Object[] findSource() {
        for (int t = 0; t < initialEntropySourceNames.length; ++t) {
            String[] pair = initialEntropySourceNames[t];
            try {
                Object[] r = new Object[]{Class.forName(pair[0]).newInstance(), Class.forName(pair[1]).newInstance()};
                return r;
            }
            catch (Throwable ex) {
                continue;
            }
        }
        return null;
    }

    private static SecureRandom createBaseRandom(boolean isPredictionResistant) {
        if (Properties.getPropertyValue("org.bouncycastle.drbg.entropysource") != null) {
            EntropySourceProvider entropyProvider = DRBG.createEntropySource();
            EntropySource initSource = entropyProvider.get(128);
            byte[] personalisationString = isPredictionResistant ? DRBG.generateDefaultPersonalizationString(initSource.getEntropy()) : DRBG.generateNonceIVPersonalizationString(initSource.getEntropy());
            return new SP800SecureRandomBuilder(entropyProvider).setPersonalizationString(personalisationString).buildHash(new SHA512Digest(), initSource.getEntropy(), isPredictionResistant);
        }
        HybridEntropySource source = new HybridEntropySource(entropyDaemon, 256);
        byte[] personalisationString = isPredictionResistant ? DRBG.generateDefaultPersonalizationString(source.getEntropy()) : DRBG.generateNonceIVPersonalizationString(source.getEntropy());
        return new SP800SecureRandomBuilder(new EntropySourceProvider(){

            @Override
            public EntropySource get(int bitsRequired) {
                return new HybridEntropySource(entropyDaemon, bitsRequired);
            }
        }).setPersonalizationString(personalisationString).buildHash(new SHA512Digest(), source.getEntropy(), isPredictionResistant);
    }

    private static EntropySourceProvider createInitialEntropySource() {
        boolean hasGetInstanceStrong = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                try {
                    Class<SecureRandom> def = SecureRandom.class;
                    return def.getMethod("getInstanceStrong", new Class[0]) != null;
                }
                catch (Exception e) {
                    return false;
                }
            }
        });
        if (hasGetInstanceStrong) {
            SecureRandom strong = AccessController.doPrivileged(new PrivilegedAction<SecureRandom>(){

                @Override
                public SecureRandom run() {
                    try {
                        return (SecureRandom)SecureRandom.class.getMethod("getInstanceStrong", new Class[0]).invoke(null, new Object[0]);
                    }
                    catch (Exception e) {
                        return new CoreSecureRandom(DRBG.findSource());
                    }
                }
            });
            return new IncrementalEntropySourceProvider(strong, true);
        }
        return new IncrementalEntropySourceProvider(new CoreSecureRandom(DRBG.findSource()), true);
    }

    private static EntropySourceProvider createCoreEntropySourceProvider() {
        if (Security.getProperty("securerandom.source") == null) {
            return DRBG.createInitialEntropySource();
        }
        try {
            String source = Security.getProperty("securerandom.source");
            return new URLSeededEntropySourceProvider(new URL(source));
        }
        catch (Exception e) {
            return DRBG.createInitialEntropySource();
        }
    }

    private static EntropySourceProvider createEntropySource() {
        final String sourceClass = Properties.getPropertyValue("org.bouncycastle.drbg.entropysource");
        return AccessController.doPrivileged(new PrivilegedAction<EntropySourceProvider>(){

            @Override
            public EntropySourceProvider run() {
                try {
                    Class clazz = ClassUtil.loadClass(DRBG.class, sourceClass);
                    return (EntropySourceProvider)clazz.newInstance();
                }
                catch (Exception e) {
                    throw new IllegalStateException("entropy source " + sourceClass + " not created: " + e.getMessage(), e);
                }
            }
        });
    }

    private static byte[] generateDefaultPersonalizationString(byte[] seed) {
        return Arrays.concatenate(Strings.toByteArray("Default"), seed, Pack.longToBigEndian(Thread.currentThread().getId()), Pack.longToBigEndian(System.currentTimeMillis()));
    }

    private static byte[] generateNonceIVPersonalizationString(byte[] seed) {
        return Arrays.concatenate(Strings.toByteArray("Nonce"), seed, Pack.longToLittleEndian(Thread.currentThread().getId()), Pack.longToLittleEndian(System.currentTimeMillis()));
    }

    private static long getPause() {
        String pauseSetting = Properties.getPropertyValue("org.bouncycastle.drbg.gather_pause_secs");
        if (pauseSetting != null) {
            try {
                return Long.parseLong(pauseSetting) * 1000L;
            }
            catch (Exception e) {
                return 5000L;
            }
        }
        return 5000L;
    }

    private static void sleep(long ms) {
        try {
            Thread.sleep(ms);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    static /* synthetic */ SecureRandom access$200(boolean x0) {
        return DRBG.createBaseRandom(x0);
    }

    static {
        entropyDaemon = new EntropyDaemon();
        entropyThread = new Thread((Runnable)entropyDaemon, "BC Entropy Daemon");
        entropyThread.setDaemon(true);
        entropyThread.start();
    }

    private static class CoreSecureRandom
    extends SecureRandom {
        CoreSecureRandom(Object[] initialEntropySourceAndSpi) {
            super((SecureRandomSpi)initialEntropySourceAndSpi[1], (Provider)initialEntropySourceAndSpi[0]);
        }
    }

    public static class Default
    extends SecureRandomSpi {
        private static final SecureRandom random = DRBG.access$200(true);

        @Override
        protected void engineSetSeed(byte[] bytes) {
            random.setSeed(bytes);
        }

        @Override
        protected void engineNextBytes(byte[] bytes) {
            random.nextBytes(bytes);
        }

        @Override
        protected byte[] engineGenerateSeed(int numBytes) {
            return random.generateSeed(numBytes);
        }
    }

    private static class EntropyDaemon
    implements Runnable {
        private final ConcurrentLinkedDeque<Runnable> tasks = new ConcurrentLinkedDeque();

        private EntropyDaemon() {
        }

        void addTask(Runnable task) {
            this.tasks.add(task);
        }

        @Override
        public void run() {
            while (true) {
                Runnable task;
                if ((task = this.tasks.pollFirst()) != null) {
                    try {
                        task.run();
                    }
                    catch (Throwable throwable) {}
                    continue;
                }
                try {
                    Thread.sleep(5000L);
                    continue;
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    continue;
                }
                break;
            }
        }
    }

    private static class HybridEntropySource
    implements EntropySource {
        private final AtomicBoolean seedAvailable = new AtomicBoolean(false);
        private final AtomicInteger samples = new AtomicInteger(0);
        private final SP800SecureRandom drbg;
        private final SignallingEntropySource entropySource;
        private final int bytesRequired;
        private final byte[] additionalInput = Pack.longToBigEndian(System.currentTimeMillis());

        HybridEntropySource(EntropyDaemon entropyDaemon, int bitsRequired) {
            EntropySourceProvider entropyProvider = DRBG.createCoreEntropySourceProvider();
            this.bytesRequired = (bitsRequired + 7) / 8;
            this.entropySource = new SignallingEntropySource(entropyDaemon, this.seedAvailable, entropyProvider, 256);
            this.drbg = new SP800SecureRandomBuilder(new EntropySourceProvider(){

                @Override
                public EntropySource get(int bitsRequired) {
                    return entropySource;
                }
            }).setPersonalizationString(Strings.toByteArray("Bouncy Castle Hybrid Entropy Source")).buildHMAC(new HMac(new SHA512Digest()), this.entropySource.getEntropy(), false);
        }

        @Override
        public boolean isPredictionResistant() {
            return true;
        }

        @Override
        public byte[] getEntropy() {
            byte[] entropy = new byte[this.bytesRequired];
            if (this.samples.getAndIncrement() > 20) {
                if (this.seedAvailable.getAndSet(false)) {
                    this.samples.set(0);
                    this.drbg.reseed(this.additionalInput);
                } else {
                    this.entropySource.schedule();
                }
            }
            this.drbg.nextBytes(entropy);
            return entropy;
        }

        @Override
        public int entropySize() {
            return this.bytesRequired * 8;
        }

        private class SignallingEntropySource
        implements IncrementalEntropySource {
            private final EntropyDaemon entropyDaemon;
            private final AtomicBoolean seedAvailable;
            private final IncrementalEntropySource entropySource;
            private final int byteLength;
            private final AtomicReference entropy = new AtomicReference();
            private final AtomicBoolean scheduled = new AtomicBoolean(false);
            private final long pause;

            SignallingEntropySource(EntropyDaemon entropyDaemon, AtomicBoolean seedAvailable, EntropySourceProvider baseRandom, int bitsRequired) {
                this.entropyDaemon = entropyDaemon;
                this.seedAvailable = seedAvailable;
                this.entropySource = (IncrementalEntropySource)baseRandom.get(bitsRequired);
                this.byteLength = (bitsRequired + 7) / 8;
                this.pause = DRBG.getPause();
            }

            @Override
            public boolean isPredictionResistant() {
                return true;
            }

            @Override
            public byte[] getEntropy() {
                return this.getEntropy(0L);
            }

            @Override
            public byte[] getEntropy(long pause) {
                byte[] seed = this.entropy.getAndSet(null);
                if (seed == null || seed.length != this.byteLength) {
                    seed = this.entropySource.getEntropy(pause);
                } else {
                    this.scheduled.set(false);
                }
                this.schedule();
                return seed;
            }

            void schedule() {
                if (!this.scheduled.getAndSet(true)) {
                    this.entropyDaemon.addTask(new EntropyGatherer(this.entropySource));
                }
            }

            @Override
            public int entropySize() {
                return this.byteLength * 8;
            }

            private class EntropyGatherer
            implements Runnable {
                private final IncrementalEntropySource baseRandom;

                EntropyGatherer(IncrementalEntropySource baseRandom) {
                    this.baseRandom = baseRandom;
                }

                @Override
                public void run() {
                    SignallingEntropySource.this.entropy.set(this.baseRandom.getEntropy(SignallingEntropySource.this.pause));
                    SignallingEntropySource.this.seedAvailable.set(true);
                }
            }
        }
    }

    private static interface IncrementalEntropySource
    extends EntropySource {
        public byte[] getEntropy(long var1);
    }

    private static class IncrementalEntropySourceProvider
    implements EntropySourceProvider {
        private final SecureRandom random;
        private final boolean predictionResistant;

        public IncrementalEntropySourceProvider(SecureRandom random, boolean isPredictionResistant) {
            this.random = random;
            this.predictionResistant = isPredictionResistant;
        }

        @Override
        public EntropySource get(final int bitsRequired) {
            return new IncrementalEntropySource(){
                final int numBytes;
                {
                    this.numBytes = (bitsRequired + 7) / 8;
                }

                @Override
                public boolean isPredictionResistant() {
                    return predictionResistant;
                }

                @Override
                public byte[] getEntropy() {
                    return this.getEntropy(0L);
                }

                @Override
                public byte[] getEntropy(long pause) {
                    byte[] rn;
                    byte[] seed = new byte[this.numBytes];
                    for (int i = 0; i < this.numBytes / 8; ++i) {
                        DRBG.sleep(pause);
                        rn = random.generateSeed(8);
                        System.arraycopy(rn, 0, seed, i * 8, rn.length);
                    }
                    int extra = this.numBytes - this.numBytes / 8 * 8;
                    if (extra != 0) {
                        DRBG.sleep(pause);
                        rn = random.generateSeed(extra);
                        System.arraycopy(rn, 0, seed, seed.length - rn.length, rn.length);
                    }
                    return seed;
                }

                @Override
                public int entropySize() {
                    return bitsRequired;
                }
            };
        }
    }

    public static class Mappings
    extends AsymmetricAlgorithmProvider {
        @Override
        public void configure(ConfigurableProvider provider) {
            provider.addAlgorithm("SecureRandom.DEFAULT", PREFIX + "$Default");
            provider.addAlgorithm("SecureRandom.NONCEANDIV", PREFIX + "$NonceAndIV");
        }
    }

    public static class NonceAndIV
    extends SecureRandomSpi {
        private static final SecureRandom random = DRBG.access$200(false);

        @Override
        protected void engineSetSeed(byte[] bytes) {
            random.setSeed(bytes);
        }

        @Override
        protected void engineNextBytes(byte[] bytes) {
            random.nextBytes(bytes);
        }

        @Override
        protected byte[] engineGenerateSeed(int numBytes) {
            return random.generateSeed(numBytes);
        }
    }

    private static class URLSeededEntropySourceProvider
    implements EntropySourceProvider {
        private final InputStream seedStream;

        URLSeededEntropySourceProvider(final URL url) {
            this.seedStream = AccessController.doPrivileged(new PrivilegedAction<InputStream>(){

                @Override
                public InputStream run() {
                    try {
                        return url.openStream();
                    }
                    catch (IOException e) {
                        throw new IllegalStateException("unable to open random source");
                    }
                }
            });
        }

        private int privilegedRead(final byte[] data, final int off, final int len) {
            return AccessController.doPrivileged(new PrivilegedAction<Integer>(){

                @Override
                public Integer run() {
                    try {
                        return seedStream.read(data, off, len);
                    }
                    catch (IOException e) {
                        throw new InternalError("unable to read random source");
                    }
                }
            });
        }

        @Override
        public EntropySource get(final int bitsRequired) {
            return new IncrementalEntropySource(){
                private final int numBytes;
                {
                    this.numBytes = (bitsRequired + 7) / 8;
                }

                @Override
                public boolean isPredictionResistant() {
                    return true;
                }

                @Override
                public byte[] getEntropy() {
                    return this.getEntropy(0L);
                }

                @Override
                public byte[] getEntropy(long pause) {
                    int off;
                    int len;
                    byte[] data = new byte[this.numBytes];
                    for (off = 0; off != data.length && (len = this.privilegedRead(data, off, data.length - off)) > -1; off += len) {
                        DRBG.sleep(pause);
                    }
                    if (off != data.length) {
                        throw new InternalError("unable to fully read random source");
                    }
                    return data;
                }

                @Override
                public int entropySize() {
                    return bitsRequired;
                }
            };
        }
    }
}

