/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.crypto.hqc;

import org.bouncycastle.crypto.EncapsulatedSecretExtractor;
import org.bouncycastle.pqc.crypto.hqc.HQCEngine;
import org.bouncycastle.pqc.crypto.hqc.HQCKeyParameters;
import org.bouncycastle.pqc.crypto.hqc.HQCParameters;
import org.bouncycastle.pqc.crypto.hqc.HQCPrivateKeyParameters;
import org.bouncycastle.util.Arrays;

public class HQCKEMExtractor
implements EncapsulatedSecretExtractor {
    private HQCEngine engine;
    private HQCKeyParameters key;

    public HQCKEMExtractor(HQCPrivateKeyParameters privParams) {
        this.key = privParams;
        this.initCipher(this.key.getParameters());
    }

    private void initCipher(HQCParameters param) {
        this.engine = param.getEngine();
    }

    public byte[] extractSecret(byte[] encapsulation) {
        byte[] session_key = new byte[this.engine.getSessionKeySize()];
        HQCPrivateKeyParameters secretKey = (HQCPrivateKeyParameters)this.key;
        byte[] sk = secretKey.getPrivateKey();
        this.engine.decaps(session_key, encapsulation, sk);
        return Arrays.copyOfRange(session_key, 0, this.key.getParameters().getK());
    }

    public int getEncapsulationLength() {
        return this.key.getParameters().getN_BYTES() + this.key.getParameters().getN1N2_BYTES() + 64 + 16;
    }
}

