/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.crypto.crystals.dilithium;

import org.bouncycastle.crypto.digests.SHAKEDigest;
import org.bouncycastle.crypto.engines.AESEngine;
import org.bouncycastle.crypto.modes.CTRModeCipher;
import org.bouncycastle.crypto.modes.SICBlockCipher;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.ParametersWithIV;

abstract class Symmetric {
    final int stream128BlockBytes;
    final int stream256BlockBytes;

    Symmetric(int stream128, int stream256) {
        this.stream128BlockBytes = stream128;
        this.stream256BlockBytes = stream256;
    }

    abstract void stream128init(byte[] var1, short var2);

    abstract void stream256init(byte[] var1, short var2);

    abstract void stream128squeezeBlocks(byte[] var1, int var2, int var3);

    abstract void stream256squeezeBlocks(byte[] var1, int var2, int var3);

    static class AesSymmetric
    extends Symmetric {
        private final CTRModeCipher cipher = SICBlockCipher.newInstance(AESEngine.newInstance());

        AesSymmetric() {
            super(64, 64);
        }

        private void aes128(byte[] out, int offset, int size) {
            byte[] buf = new byte[size];
            this.cipher.processBytes(buf, 0, size, out, offset);
        }

        private void streamInit(byte[] key, short nonce) {
            byte[] expnonce = new byte[12];
            expnonce[0] = (byte)nonce;
            expnonce[1] = (byte)(nonce >> 8);
            ParametersWithIV kp = new ParametersWithIV(new KeyParameter(key, 0, 32), expnonce);
            this.cipher.init(true, kp);
        }

        void stream128init(byte[] seed, short nonce) {
            this.streamInit(seed, nonce);
        }

        void stream256init(byte[] seed, short nonce) {
            this.streamInit(seed, nonce);
        }

        void stream128squeezeBlocks(byte[] output, int offset, int size) {
            this.aes128(output, offset, size);
        }

        void stream256squeezeBlocks(byte[] output, int offset, int size) {
            this.aes128(output, offset, size);
        }
    }

    static class ShakeSymmetric
    extends Symmetric {
        private final SHAKEDigest digest128 = new SHAKEDigest(128);
        private final SHAKEDigest digest256 = new SHAKEDigest(256);

        ShakeSymmetric() {
            super(168, 136);
        }

        private void streamInit(SHAKEDigest digest, byte[] seed, short nonce) {
            digest.reset();
            byte[] temp = new byte[]{(byte)nonce, (byte)(nonce >> 8)};
            digest.update(seed, 0, seed.length);
            digest.update(temp, 0, temp.length);
        }

        void stream128init(byte[] seed, short nonce) {
            this.streamInit(this.digest128, seed, nonce);
        }

        void stream256init(byte[] seed, short nonce) {
            this.streamInit(this.digest256, seed, nonce);
        }

        void stream128squeezeBlocks(byte[] output, int offset, int size) {
            this.digest128.doOutput(output, offset, size);
        }

        void stream256squeezeBlocks(byte[] output, int offset, int size) {
            this.digest256.doOutput(output, offset, size);
        }
    }
}

