/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.crypto.xmss;

import java.io.IOException;
import org.bouncycastle.pqc.crypto.xmss.XMSSKeyParameters;
import org.bouncycastle.pqc.crypto.xmss.XMSSParameters;
import org.bouncycastle.pqc.crypto.xmss.XMSSStoreableObjectInterface;
import org.bouncycastle.pqc.crypto.xmss.XMSSUtil;
import org.bouncycastle.util.Encodable;
import org.bouncycastle.util.Pack;

public final class XMSSPublicKeyParameters
extends XMSSKeyParameters
implements XMSSStoreableObjectInterface,
Encodable {
    private final XMSSParameters params;
    private final int oid;
    private final byte[] root;
    private final byte[] publicSeed;

    /*
     * Enabled aggressive block sorting
     */
    private XMSSPublicKeyParameters(Builder builder) {
        super(false, builder.params.getTreeDigest());
        this.params = builder.params;
        if (this.params == null) {
            throw new NullPointerException("params == null");
        }
        int n = this.params.getTreeDigestSize();
        byte[] publicKey = builder.publicKey;
        if (publicKey != null) {
            int oidSize = 4;
            int rootSize = n;
            int publicSeedSize = n;
            int position = 0;
            if (publicKey.length == rootSize + publicSeedSize) {
                this.oid = 0;
                this.root = XMSSUtil.extractBytesAtOffset(publicKey, position, rootSize);
                this.publicSeed = XMSSUtil.extractBytesAtOffset(publicKey, position += rootSize, publicSeedSize);
                return;
            }
            if (publicKey.length == oidSize + rootSize + publicSeedSize) {
                this.oid = Pack.bigEndianToInt(publicKey, 0);
                this.root = XMSSUtil.extractBytesAtOffset(publicKey, position += oidSize, rootSize);
                this.publicSeed = XMSSUtil.extractBytesAtOffset(publicKey, position += rootSize, publicSeedSize);
                return;
            }
            System.err.println(publicKey.length + " " + (oidSize + rootSize + publicSeedSize));
            throw new IllegalArgumentException("public key has wrong size");
        }
        this.oid = this.params.getOid() != null ? this.params.getOid().getOid() : 0;
        byte[] tmpRoot = builder.root;
        if (tmpRoot != null) {
            if (tmpRoot.length != n) {
                throw new IllegalArgumentException("length of root must be equal to length of digest");
            }
            this.root = tmpRoot;
        } else {
            this.root = new byte[n];
        }
        byte[] tmpPublicSeed = builder.publicSeed;
        if (tmpPublicSeed == null) {
            this.publicSeed = new byte[n];
            return;
        }
        if (tmpPublicSeed.length != n) {
            throw new IllegalArgumentException("length of publicSeed must be equal to length of digest");
        }
        this.publicSeed = tmpPublicSeed;
    }

    public byte[] getEncoded() throws IOException {
        return this.toByteArray();
    }

    public byte[] toByteArray() {
        byte[] out;
        int n = this.params.getTreeDigestSize();
        int oidSize = 4;
        int rootSize = n;
        int publicSeedSize = n;
        int position = 0;
        if (this.oid != 0) {
            out = new byte[oidSize + rootSize + publicSeedSize];
            Pack.intToBigEndian(this.oid, out, position);
            position += oidSize;
        } else {
            out = new byte[rootSize + publicSeedSize];
        }
        XMSSUtil.copyBytesAtOffset(out, this.root, position);
        XMSSUtil.copyBytesAtOffset(out, this.publicSeed, position += rootSize);
        return out;
    }

    public byte[] getRoot() {
        return XMSSUtil.cloneArray(this.root);
    }

    public byte[] getPublicSeed() {
        return XMSSUtil.cloneArray(this.publicSeed);
    }

    public XMSSParameters getParameters() {
        return this.params;
    }

    public static class Builder {
        private final XMSSParameters params;
        private byte[] root = null;
        private byte[] publicSeed = null;
        private byte[] publicKey = null;

        public Builder(XMSSParameters params) {
            this.params = params;
        }

        public Builder withRoot(byte[] val) {
            this.root = XMSSUtil.cloneArray(val);
            return this;
        }

        public Builder withPublicSeed(byte[] val) {
            this.publicSeed = XMSSUtil.cloneArray(val);
            return this;
        }

        public Builder withPublicKey(byte[] val) {
            this.publicKey = XMSSUtil.cloneArray(val);
            return this;
        }

        public XMSSPublicKeyParameters build() {
            return new XMSSPublicKeyParameters(this);
        }
    }
}

