/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.crypto.xmss;

import java.io.IOException;
import java.security.SecureRandom;
import java.text.ParseException;
import java.util.Map;
import org.bouncycastle.pqc.crypto.xmss.BDS;
import org.bouncycastle.pqc.crypto.xmss.KeyedHashFunctions;
import org.bouncycastle.pqc.crypto.xmss.OTSHashAddress;
import org.bouncycastle.pqc.crypto.xmss.WOTSPlusSignature;
import org.bouncycastle.pqc.crypto.xmss.XMSS;
import org.bouncycastle.pqc.crypto.xmss.XMSSMTParameters;
import org.bouncycastle.pqc.crypto.xmss.XMSSMTPrivateKeyParameters;
import org.bouncycastle.pqc.crypto.xmss.XMSSMTPublicKeyParameters;
import org.bouncycastle.pqc.crypto.xmss.XMSSMTSignature;
import org.bouncycastle.pqc.crypto.xmss.XMSSNode;
import org.bouncycastle.pqc.crypto.xmss.XMSSPrivateKeyParameters;
import org.bouncycastle.pqc.crypto.xmss.XMSSPublicKeyParameters;
import org.bouncycastle.pqc.crypto.xmss.XMSSReducedSignature;
import org.bouncycastle.pqc.crypto.xmss.XMSSUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class XMSSMT {
    private XMSSMTParameters params;
    private XMSS xmss;
    private SecureRandom prng;
    private KeyedHashFunctions khf;
    private XMSSMTPrivateKeyParameters privateKey;
    private XMSSMTPublicKeyParameters publicKey;

    public XMSSMT(XMSSMTParameters params) {
        if (params == null) {
            throw new NullPointerException("params == null");
        }
        this.params = params;
        this.xmss = params.getXMSS();
        this.prng = params.getXMSS().getParams().getPRNG();
        this.khf = this.xmss.getKhf();
        try {
            this.privateKey = new XMSSMTPrivateKeyParameters.Builder(params).build();
            this.publicKey = new XMSSMTPublicKeyParameters.Builder(params).build();
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void generateKeys() {
        this.privateKey = this.generatePrivateKey();
        XMSSPrivateKeyParameters xmssPrivateKey = null;
        XMSSPublicKeyParameters xmssPublicKey = null;
        try {
            xmssPrivateKey = new XMSSPrivateKeyParameters.Builder(this.xmss.getParams()).withSecretKeySeed(this.privateKey.getSecretKeySeed()).withSecretKeyPRF(this.privateKey.getSecretKeyPRF()).withPublicSeed(this.privateKey.getPublicSeed()).withBDSState(new BDS(this.xmss)).build();
            xmssPublicKey = new XMSSPublicKeyParameters.Builder(this.xmss.getParams()).withPublicSeed(this.getPublicSeed()).build();
        }
        catch (ParseException ex) {
            ex.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            this.xmss.importState(xmssPrivateKey.toByteArray(), xmssPublicKey.toByteArray());
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        int rootLayerIndex = this.params.getLayers() - 1;
        OTSHashAddress otsHashAddress = (OTSHashAddress)((OTSHashAddress.Builder)new OTSHashAddress.Builder().withLayerAddress(rootLayerIndex)).build();
        BDS bdsRoot = new BDS(this.xmss);
        XMSSNode root = bdsRoot.initialize(otsHashAddress);
        this.getBDSState().put(rootLayerIndex, bdsRoot);
        this.xmss.setRoot(root.getValue());
        try {
            this.privateKey = new XMSSMTPrivateKeyParameters.Builder(this.params).withSecretKeySeed(this.privateKey.getSecretKeySeed()).withSecretKeyPRF(this.privateKey.getSecretKeyPRF()).withPublicSeed(this.privateKey.getPublicSeed()).withRoot(this.xmss.getRoot()).withBDSState(this.privateKey.getBDSState()).build();
            this.publicKey = new XMSSMTPublicKeyParameters.Builder(this.params).withRoot(root.getValue()).withPublicSeed(this.getPublicSeed()).build();
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private XMSSMTPrivateKeyParameters generatePrivateKey() {
        int n = this.params.getDigestSize();
        byte[] secretKeySeed = new byte[n];
        this.prng.nextBytes(secretKeySeed);
        byte[] secretKeyPRF = new byte[n];
        this.prng.nextBytes(secretKeyPRF);
        byte[] publicSeed = new byte[n];
        this.prng.nextBytes(publicSeed);
        XMSSMTPrivateKeyParameters privateKey = null;
        try {
            privateKey = new XMSSMTPrivateKeyParameters.Builder(this.params).withSecretKeySeed(secretKeySeed).withSecretKeyPRF(secretKeyPRF).withPublicSeed(publicSeed).withBDSState(this.privateKey.getBDSState()).build();
        }
        catch (ParseException ex) {
            ex.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return privateKey;
    }

    public void importState(byte[] privateKey, byte[] publicKey) throws ParseException, ClassNotFoundException, IOException {
        if (privateKey == null) {
            throw new NullPointerException("privateKey == null");
        }
        if (publicKey == null) {
            throw new NullPointerException("publicKey == null");
        }
        XMSSMTPrivateKeyParameters xmssMTPrivateKey = new XMSSMTPrivateKeyParameters.Builder(this.params).withPrivateKey(privateKey, this.xmss).build();
        XMSSMTPublicKeyParameters xmssMTPublicKey = new XMSSMTPublicKeyParameters.Builder(this.params).withPublicKey(publicKey).build();
        if (!XMSSUtil.compareByteArray(xmssMTPrivateKey.getRoot(), xmssMTPublicKey.getRoot())) {
            throw new IllegalStateException("root of private key and public key do not match");
        }
        if (!XMSSUtil.compareByteArray(xmssMTPrivateKey.getPublicSeed(), xmssMTPublicKey.getPublicSeed())) {
            throw new IllegalStateException("public seed of private key and public key do not match");
        }
        XMSSPrivateKeyParameters xmssPrivateKey = new XMSSPrivateKeyParameters.Builder(this.xmss.getParams()).withSecretKeySeed(xmssMTPrivateKey.getSecretKeySeed()).withSecretKeyPRF(xmssMTPrivateKey.getSecretKeyPRF()).withPublicSeed(xmssMTPrivateKey.getPublicSeed()).withRoot(xmssMTPrivateKey.getRoot()).withBDSState(new BDS(this.xmss)).build();
        XMSSPublicKeyParameters xmssPublicKey = new XMSSPublicKeyParameters.Builder(this.xmss.getParams()).withRoot(xmssMTPrivateKey.getRoot()).withPublicSeed(this.getPublicSeed()).build();
        this.xmss.importState(xmssPrivateKey.toByteArray(), xmssPublicKey.toByteArray());
        this.privateKey = xmssMTPrivateKey;
        this.publicKey = xmssMTPublicKey;
    }

    public byte[] sign(byte[] message) {
        if (message == null) {
            throw new NullPointerException("message == null");
        }
        if (this.getBDSState().isEmpty()) {
            throw new IllegalStateException("not initialized");
        }
        long globalIndex = this.getIndex();
        int totalHeight = this.params.getHeight();
        int xmssHeight = this.xmss.getParams().getHeight();
        if (!XMSSUtil.isIndexValid(totalHeight, globalIndex)) {
            throw new IllegalArgumentException("index out of bounds");
        }
        byte[] random = this.khf.PRF(this.privateKey.getSecretKeyPRF(), XMSSUtil.toBytesBigEndian(globalIndex, 32));
        byte[] concatenated = XMSSUtil.concat(random, this.privateKey.getRoot(), XMSSUtil.toBytesBigEndian(globalIndex, this.params.getDigestSize()));
        byte[] messageDigest = this.khf.HMsg(concatenated, message);
        XMSSMTSignature signature = null;
        try {
            signature = new XMSSMTSignature.Builder(this.params).withIndex(globalIndex).withRandom(random).build();
        }
        catch (ParseException ex) {
            ex.printStackTrace();
        }
        long indexTree = XMSSUtil.getTreeIndex(globalIndex, xmssHeight);
        int indexLeaf = XMSSUtil.getLeafIndex(globalIndex, xmssHeight);
        this.xmss.setIndex(indexLeaf);
        this.xmss.setPublicSeed(this.getPublicSeed());
        OTSHashAddress otsHashAddress = (OTSHashAddress)((OTSHashAddress.Builder)new OTSHashAddress.Builder().withTreeAddress(indexTree)).withOTSAddress(indexLeaf).build();
        WOTSPlusSignature wotsPlusSignature = this.xmss.wotsSign(messageDigest, otsHashAddress);
        if (this.getBDSState().get(0) == null || indexLeaf == 0) {
            this.getBDSState().put(0, new BDS(this.xmss));
            this.getBDSState().get(0).initialize(otsHashAddress);
        }
        XMSSReducedSignature reducedSignature = null;
        try {
            reducedSignature = new XMSSReducedSignature.Builder(this.xmss.getParams()).withWOTSPlusSignature(wotsPlusSignature).withAuthPath(this.getBDSState().get(0).getAuthenticationPath()).build();
        }
        catch (ParseException ex) {
            ex.printStackTrace();
        }
        signature.getReducedSignatures().add(reducedSignature);
        if (indexLeaf < (1 << xmssHeight) - 1) {
            this.getBDSState().get(0).nextAuthenticationPath(otsHashAddress);
        }
        for (int layer = 1; layer < this.params.getLayers(); ++layer) {
            XMSSNode root = this.getBDSState().get(layer - 1).getRoot();
            indexLeaf = XMSSUtil.getLeafIndex(indexTree, xmssHeight);
            indexTree = XMSSUtil.getTreeIndex(indexTree, xmssHeight);
            this.xmss.setIndex(indexLeaf);
            otsHashAddress = (OTSHashAddress)((OTSHashAddress.Builder)((OTSHashAddress.Builder)new OTSHashAddress.Builder().withLayerAddress(layer)).withTreeAddress(indexTree)).withOTSAddress(indexLeaf).build();
            wotsPlusSignature = this.xmss.wotsSign(root.getValue(), otsHashAddress);
            if (this.getBDSState().get(layer) == null || XMSSUtil.isNewBDSInitNeeded(globalIndex, xmssHeight, layer)) {
                this.getBDSState().put(layer, new BDS(this.xmss));
                this.getBDSState().get(layer).initialize(otsHashAddress);
            }
            try {
                reducedSignature = new XMSSReducedSignature.Builder(this.xmss.getParams()).withWOTSPlusSignature(wotsPlusSignature).withAuthPath(this.getBDSState().get(layer).getAuthenticationPath()).build();
            }
            catch (ParseException ex) {
                ex.printStackTrace();
            }
            signature.getReducedSignatures().add(reducedSignature);
            if (indexLeaf >= (1 << xmssHeight) - 1 || !XMSSUtil.isNewAuthenticationPathNeeded(globalIndex, xmssHeight, layer)) continue;
            this.getBDSState().get(layer).nextAuthenticationPath(otsHashAddress);
        }
        try {
            this.privateKey = new XMSSMTPrivateKeyParameters.Builder(this.params).withIndex(globalIndex + 1L).withSecretKeySeed(this.privateKey.getSecretKeySeed()).withSecretKeyPRF(this.privateKey.getSecretKeyPRF()).withPublicSeed(this.privateKey.getPublicSeed()).withRoot(this.privateKey.getRoot()).withBDSState(this.privateKey.getBDSState()).build();
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return signature.toByteArray();
    }

    public boolean verifySignature(byte[] message, byte[] signature, byte[] publicKey) throws ParseException {
        if (message == null) {
            throw new NullPointerException("message == null");
        }
        if (signature == null) {
            throw new NullPointerException("signature == null");
        }
        if (publicKey == null) {
            throw new NullPointerException("publicKey == null");
        }
        XMSSMTSignature sig = new XMSSMTSignature.Builder(this.params).withSignature(signature).build();
        XMSSMTPublicKeyParameters pubKey = new XMSSMTPublicKeyParameters.Builder(this.params).withPublicKey(publicKey).build();
        byte[] concatenated = XMSSUtil.concat(sig.getRandom(), pubKey.getRoot(), XMSSUtil.toBytesBigEndian(sig.getIndex(), this.params.getDigestSize()));
        byte[] messageDigest = this.khf.HMsg(concatenated, message);
        long globalIndex = sig.getIndex();
        int xmssHeight = this.xmss.getParams().getHeight();
        long indexTree = XMSSUtil.getTreeIndex(globalIndex, xmssHeight);
        int indexLeaf = XMSSUtil.getLeafIndex(globalIndex, xmssHeight);
        this.xmss.setIndex(indexLeaf);
        this.xmss.setPublicSeed(pubKey.getPublicSeed());
        OTSHashAddress otsHashAddress = (OTSHashAddress)((OTSHashAddress.Builder)new OTSHashAddress.Builder().withTreeAddress(indexTree)).withOTSAddress(indexLeaf).build();
        XMSSReducedSignature xmssMTSignature = sig.getReducedSignatures().get(0);
        XMSSNode rootNode = this.xmss.getRootNodeFromSignature(messageDigest, xmssMTSignature, otsHashAddress);
        for (int layer = 1; layer < this.params.getLayers(); ++layer) {
            xmssMTSignature = sig.getReducedSignatures().get(layer);
            indexLeaf = XMSSUtil.getLeafIndex(indexTree, xmssHeight);
            indexTree = XMSSUtil.getTreeIndex(indexTree, xmssHeight);
            this.xmss.setIndex(indexLeaf);
            otsHashAddress = (OTSHashAddress)((OTSHashAddress.Builder)((OTSHashAddress.Builder)new OTSHashAddress.Builder().withLayerAddress(layer)).withTreeAddress(indexTree)).withOTSAddress(indexLeaf).build();
            rootNode = this.xmss.getRootNodeFromSignature(rootNode.getValue(), xmssMTSignature, otsHashAddress);
        }
        return XMSSUtil.compareByteArray(rootNode.getValue(), pubKey.getRoot());
    }

    public byte[] exportPrivateKey() {
        return this.privateKey.toByteArray();
    }

    public byte[] exportPublicKey() {
        return this.publicKey.toByteArray();
    }

    public XMSSMTParameters getParams() {
        return this.params;
    }

    public long getIndex() {
        return this.privateKey.getIndex();
    }

    public byte[] getPublicSeed() {
        return this.privateKey.getPublicSeed();
    }

    protected Map<Integer, BDS> getBDSState() {
        return this.privateKey.getBDSState();
    }

    protected XMSS getXMSS() {
        return this.xmss;
    }
}

