/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.crypto.xmss;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.TreeMap;
import org.bouncycastle.pqc.crypto.xmss.HashTreeAddress;
import org.bouncycastle.pqc.crypto.xmss.LTreeAddress;
import org.bouncycastle.pqc.crypto.xmss.OTSHashAddress;
import org.bouncycastle.pqc.crypto.xmss.WOTSPlus;
import org.bouncycastle.pqc.crypto.xmss.WOTSPlusPublicKeyParameters;
import org.bouncycastle.pqc.crypto.xmss.XMSS;
import org.bouncycastle.pqc.crypto.xmss.XMSSNode;
import org.bouncycastle.pqc.crypto.xmss.XMSSUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class BDS
implements Serializable {
    private static final long serialVersionUID = 1L;
    private transient XMSS xmss;
    private transient WOTSPlus wotsPlus;
    private final int treeHeight;
    private int k;
    private XMSSNode root;
    private List<XMSSNode> authenticationPath;
    private Map<Integer, LinkedList<XMSSNode>> retain;
    private Stack<XMSSNode> stack;
    private List<TreeHash> treeHashInstances;
    private Map<Integer, XMSSNode> keep;
    private int index;

    protected BDS(XMSS xmss) {
        if (xmss == null) {
            throw new NullPointerException("xmss == null");
        }
        this.xmss = xmss;
        this.wotsPlus = xmss.getWOTSPlus();
        this.treeHeight = xmss.getParams().getHeight();
        this.k = xmss.getParams().getK();
        if (this.k > this.treeHeight || this.k < 2 || (this.treeHeight - this.k) % 2 != 0) {
            throw new IllegalArgumentException("illegal value for BDS parameter k");
        }
        this.authenticationPath = new ArrayList<XMSSNode>();
        this.retain = new TreeMap<Integer, LinkedList<XMSSNode>>();
        this.stack = new Stack();
        this.initializeTreeHashInstances();
        this.keep = new TreeMap<Integer, XMSSNode>();
        this.index = 0;
    }

    private void initializeTreeHashInstances() {
        this.treeHashInstances = new ArrayList<TreeHash>();
        for (int height = 0; height < this.treeHeight - this.k; ++height) {
            this.treeHashInstances.add(new TreeHash(height));
        }
    }

    protected XMSSNode initialize(OTSHashAddress otsHashAddress) {
        if (otsHashAddress == null) {
            throw new NullPointerException("otsHashAddress == null");
        }
        LTreeAddress lTreeAddress = (LTreeAddress)((LTreeAddress.Builder)((LTreeAddress.Builder)new LTreeAddress.Builder().withLayerAddress(otsHashAddress.getLayerAddress())).withTreeAddress(otsHashAddress.getTreeAddress())).build();
        HashTreeAddress hashTreeAddress = (HashTreeAddress)((HashTreeAddress.Builder)((HashTreeAddress.Builder)new HashTreeAddress.Builder().withLayerAddress(otsHashAddress.getLayerAddress())).withTreeAddress(otsHashAddress.getTreeAddress())).build();
        for (int indexLeaf = 0; indexLeaf < 1 << this.treeHeight; ++indexLeaf) {
            otsHashAddress = (OTSHashAddress)((OTSHashAddress.Builder)((OTSHashAddress.Builder)((OTSHashAddress.Builder)new OTSHashAddress.Builder().withLayerAddress(otsHashAddress.getLayerAddress())).withTreeAddress(otsHashAddress.getTreeAddress())).withOTSAddress(indexLeaf).withChainAddress(otsHashAddress.getChainAddress()).withHashAddress(otsHashAddress.getHashAddress()).withKeyAndMask(otsHashAddress.getKeyAndMask())).build();
            this.wotsPlus.importKeys(this.xmss.getWOTSPlusSecretKey(otsHashAddress), this.xmss.getPublicSeed());
            WOTSPlusPublicKeyParameters wotsPlusPublicKey = this.wotsPlus.getPublicKey(otsHashAddress);
            lTreeAddress = (LTreeAddress)((LTreeAddress.Builder)((LTreeAddress.Builder)((LTreeAddress.Builder)new LTreeAddress.Builder().withLayerAddress(lTreeAddress.getLayerAddress())).withTreeAddress(lTreeAddress.getTreeAddress())).withLTreeAddress(indexLeaf).withTreeHeight(lTreeAddress.getTreeHeight()).withTreeIndex(lTreeAddress.getTreeIndex()).withKeyAndMask(lTreeAddress.getKeyAndMask())).build();
            XMSSNode node = this.xmss.lTree(wotsPlusPublicKey, lTreeAddress);
            hashTreeAddress = (HashTreeAddress)((HashTreeAddress.Builder)((HashTreeAddress.Builder)((HashTreeAddress.Builder)new HashTreeAddress.Builder().withLayerAddress(hashTreeAddress.getLayerAddress())).withTreeAddress(hashTreeAddress.getTreeAddress())).withTreeIndex(indexLeaf).withKeyAndMask(hashTreeAddress.getKeyAndMask())).build();
            while (!this.stack.isEmpty() && this.stack.peek().getHeight() == node.getHeight()) {
                int indexOnHeight = (int)Math.floor(indexLeaf / (1 << node.getHeight()));
                if (indexOnHeight == 1) {
                    this.authenticationPath.add(node.clone());
                }
                if (indexOnHeight == 3 && node.getHeight() < this.treeHeight - this.k) {
                    this.treeHashInstances.get(node.getHeight()).setNode(node.clone());
                }
                if (indexOnHeight >= 3 && (indexOnHeight & 1) == 1 && node.getHeight() >= this.treeHeight - this.k && node.getHeight() <= this.treeHeight - 2) {
                    if (this.retain.get(node.getHeight()) == null) {
                        LinkedList<XMSSNode> queue = new LinkedList<XMSSNode>();
                        queue.add(node.clone());
                        this.retain.put(node.getHeight(), queue);
                    } else {
                        this.retain.get(node.getHeight()).add(node.clone());
                    }
                }
                hashTreeAddress = (HashTreeAddress)((HashTreeAddress.Builder)((HashTreeAddress.Builder)((HashTreeAddress.Builder)new HashTreeAddress.Builder().withLayerAddress(hashTreeAddress.getLayerAddress())).withTreeAddress(hashTreeAddress.getTreeAddress())).withTreeHeight(hashTreeAddress.getTreeHeight()).withTreeIndex((hashTreeAddress.getTreeIndex() - 1) / 2).withKeyAndMask(hashTreeAddress.getKeyAndMask())).build();
                node = this.xmss.randomizeHash(this.stack.pop(), node, hashTreeAddress);
                node = new XMSSNode(node.getHeight() + 1, node.getValue());
                hashTreeAddress = (HashTreeAddress)((HashTreeAddress.Builder)((HashTreeAddress.Builder)((HashTreeAddress.Builder)new HashTreeAddress.Builder().withLayerAddress(hashTreeAddress.getLayerAddress())).withTreeAddress(hashTreeAddress.getTreeAddress())).withTreeHeight(hashTreeAddress.getTreeHeight() + 1).withTreeIndex(hashTreeAddress.getTreeIndex()).withKeyAndMask(hashTreeAddress.getKeyAndMask())).build();
            }
            this.stack.push(node);
        }
        this.root = this.stack.pop();
        return this.root.clone();
    }

    protected void nextAuthenticationPath(OTSHashAddress otsHashAddress) {
        if (otsHashAddress == null) {
            throw new NullPointerException("otsHashAddress == null");
        }
        if (this.index > (1 << this.treeHeight) - 2) {
            throw new IllegalStateException("index out of bounds");
        }
        LTreeAddress lTreeAddress = (LTreeAddress)((LTreeAddress.Builder)((LTreeAddress.Builder)new LTreeAddress.Builder().withLayerAddress(otsHashAddress.getLayerAddress())).withTreeAddress(otsHashAddress.getTreeAddress())).build();
        HashTreeAddress hashTreeAddress = (HashTreeAddress)((HashTreeAddress.Builder)((HashTreeAddress.Builder)new HashTreeAddress.Builder().withLayerAddress(otsHashAddress.getLayerAddress())).withTreeAddress(otsHashAddress.getTreeAddress())).build();
        int tau = XMSSUtil.calculateTau(this.index, this.treeHeight);
        if ((this.index >> tau + 1 & 1) == 0 && tau < this.treeHeight - 1) {
            this.keep.put(tau, this.authenticationPath.get(tau).clone());
        }
        if (tau == 0) {
            otsHashAddress = (OTSHashAddress)((OTSHashAddress.Builder)((OTSHashAddress.Builder)((OTSHashAddress.Builder)new OTSHashAddress.Builder().withLayerAddress(otsHashAddress.getLayerAddress())).withTreeAddress(otsHashAddress.getTreeAddress())).withOTSAddress(this.index).withChainAddress(otsHashAddress.getChainAddress()).withHashAddress(otsHashAddress.getHashAddress()).withKeyAndMask(otsHashAddress.getKeyAndMask())).build();
            this.wotsPlus.importKeys(this.xmss.getWOTSPlusSecretKey(otsHashAddress), this.xmss.getPublicSeed());
            WOTSPlusPublicKeyParameters wotsPlusPublicKey = this.wotsPlus.getPublicKey(otsHashAddress);
            lTreeAddress = (LTreeAddress)((LTreeAddress.Builder)((LTreeAddress.Builder)((LTreeAddress.Builder)new LTreeAddress.Builder().withLayerAddress(lTreeAddress.getLayerAddress())).withTreeAddress(lTreeAddress.getTreeAddress())).withLTreeAddress(this.index).withTreeHeight(lTreeAddress.getTreeHeight()).withTreeIndex(lTreeAddress.getTreeIndex()).withKeyAndMask(lTreeAddress.getKeyAndMask())).build();
            XMSSNode node = this.xmss.lTree(wotsPlusPublicKey, lTreeAddress);
            this.authenticationPath.set(0, node);
        } else {
            hashTreeAddress = (HashTreeAddress)((HashTreeAddress.Builder)((HashTreeAddress.Builder)((HashTreeAddress.Builder)new HashTreeAddress.Builder().withLayerAddress(hashTreeAddress.getLayerAddress())).withTreeAddress(hashTreeAddress.getTreeAddress())).withTreeHeight(tau - 1).withTreeIndex(this.index >> tau).withKeyAndMask(hashTreeAddress.getKeyAndMask())).build();
            XMSSNode node = this.xmss.randomizeHash(this.authenticationPath.get(tau - 1), this.keep.get(tau - 1), hashTreeAddress);
            node = new XMSSNode(node.getHeight() + 1, node.getValue());
            this.authenticationPath.set(tau, node);
            this.keep.remove(tau - 1);
            for (int height = 0; height < tau; ++height) {
                if (height < this.treeHeight - this.k) {
                    this.authenticationPath.set(height, this.treeHashInstances.get(height).tailNode.clone());
                    continue;
                }
                this.authenticationPath.set(height, this.retain.get(height).removeFirst());
            }
            int minHeight = Math.min(tau, this.treeHeight - this.k);
            for (int height = 0; height < minHeight; ++height) {
                int startIndex = this.index + 1 + 3 * (1 << height);
                if (startIndex >= 1 << this.treeHeight) continue;
                this.treeHashInstances.get(height).initialize(startIndex);
            }
        }
        for (int i = 0; i < this.treeHeight - this.k >> 1; ++i) {
            TreeHash treeHash = this.getTreeHashInstanceForUpdate();
            if (treeHash == null) continue;
            treeHash.update(otsHashAddress);
        }
        ++this.index;
    }

    private TreeHash getTreeHashInstanceForUpdate() {
        TreeHash ret = null;
        for (TreeHash treeHash : this.treeHashInstances) {
            if (treeHash.isFinished() || !treeHash.isInitialized()) continue;
            if (ret == null) {
                ret = treeHash;
                continue;
            }
            if (treeHash.getHeight() < ret.getHeight()) {
                ret = treeHash;
                continue;
            }
            if (treeHash.getHeight() != ret.getHeight() || treeHash.getIndexLeaf() >= ret.getIndexLeaf()) continue;
            ret = treeHash;
        }
        return ret;
    }

    protected void validate() {
        if (this.treeHeight != this.xmss.getParams().getHeight()) {
            throw new IllegalStateException("wrong height");
        }
        if (this.authenticationPath == null) {
            throw new IllegalStateException("authenticationPath == null");
        }
        if (this.retain == null) {
            throw new IllegalStateException("retain == null");
        }
        if (this.stack == null) {
            throw new IllegalStateException("stack == null");
        }
        if (this.treeHashInstances == null) {
            throw new IllegalStateException("treeHashInstances == null");
        }
        if (this.keep == null) {
            throw new IllegalStateException("keep == null");
        }
        if (!XMSSUtil.isIndexValid(this.treeHeight, this.index)) {
            throw new IllegalStateException("index in BDS state out of bounds");
        }
    }

    protected int getTreeHeight() {
        return this.treeHeight;
    }

    protected XMSSNode getRoot() {
        return this.root.clone();
    }

    protected List<XMSSNode> getAuthenticationPath() {
        ArrayList<XMSSNode> authenticationPath = new ArrayList<XMSSNode>();
        for (XMSSNode node : this.authenticationPath) {
            authenticationPath.add(node.clone());
        }
        return authenticationPath;
    }

    protected void setXMSS(XMSS xmss) {
        this.xmss = xmss;
        this.wotsPlus = xmss.getWOTSPlus();
    }

    protected int getIndex() {
        return this.index;
    }

    private final class TreeHash
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private XMSSNode tailNode;
        private final int initialHeight;
        private int height;
        private int nextIndex;
        private boolean initialized;
        private boolean finished;

        private TreeHash(int initialHeight) {
            this.initialHeight = initialHeight;
            this.initialized = false;
            this.finished = false;
        }

        private void initialize(int nextIndex) {
            this.tailNode = null;
            this.height = this.initialHeight;
            this.nextIndex = nextIndex;
            this.initialized = true;
            this.finished = false;
        }

        private void update(OTSHashAddress otsHashAddress) {
            if (otsHashAddress == null) {
                throw new NullPointerException("otsHashAddress == null");
            }
            if (this.finished || !this.initialized) {
                throw new IllegalStateException("finished or not initialized");
            }
            otsHashAddress = (OTSHashAddress)((OTSHashAddress.Builder)((OTSHashAddress.Builder)((OTSHashAddress.Builder)new OTSHashAddress.Builder().withLayerAddress(otsHashAddress.getLayerAddress())).withTreeAddress(otsHashAddress.getTreeAddress())).withOTSAddress(this.nextIndex).withChainAddress(otsHashAddress.getChainAddress()).withHashAddress(otsHashAddress.getHashAddress()).withKeyAndMask(otsHashAddress.getKeyAndMask())).build();
            LTreeAddress lTreeAddress = (LTreeAddress)((LTreeAddress.Builder)((LTreeAddress.Builder)new LTreeAddress.Builder().withLayerAddress(otsHashAddress.getLayerAddress())).withTreeAddress(otsHashAddress.getTreeAddress())).withLTreeAddress(this.nextIndex).build();
            HashTreeAddress hashTreeAddress = (HashTreeAddress)((HashTreeAddress.Builder)((HashTreeAddress.Builder)new HashTreeAddress.Builder().withLayerAddress(otsHashAddress.getLayerAddress())).withTreeAddress(otsHashAddress.getTreeAddress())).withTreeIndex(this.nextIndex).build();
            BDS.this.wotsPlus.importKeys(BDS.this.xmss.getWOTSPlusSecretKey(otsHashAddress), BDS.this.xmss.getPublicSeed());
            WOTSPlusPublicKeyParameters wotsPlusPublicKey = BDS.this.wotsPlus.getPublicKey(otsHashAddress);
            XMSSNode node = BDS.this.xmss.lTree(wotsPlusPublicKey, lTreeAddress);
            while (!BDS.this.stack.isEmpty() && ((XMSSNode)BDS.this.stack.peek()).getHeight() == node.getHeight() && ((XMSSNode)BDS.this.stack.peek()).getHeight() != this.initialHeight) {
                hashTreeAddress = (HashTreeAddress)((HashTreeAddress.Builder)((HashTreeAddress.Builder)((HashTreeAddress.Builder)new HashTreeAddress.Builder().withLayerAddress(hashTreeAddress.getLayerAddress())).withTreeAddress(hashTreeAddress.getTreeAddress())).withTreeHeight(hashTreeAddress.getTreeHeight()).withTreeIndex((hashTreeAddress.getTreeIndex() - 1) / 2).withKeyAndMask(hashTreeAddress.getKeyAndMask())).build();
                node = BDS.this.xmss.randomizeHash((XMSSNode)BDS.this.stack.pop(), node, hashTreeAddress);
                node = new XMSSNode(node.getHeight() + 1, node.getValue());
                hashTreeAddress = (HashTreeAddress)((HashTreeAddress.Builder)((HashTreeAddress.Builder)((HashTreeAddress.Builder)new HashTreeAddress.Builder().withLayerAddress(hashTreeAddress.getLayerAddress())).withTreeAddress(hashTreeAddress.getTreeAddress())).withTreeHeight(hashTreeAddress.getTreeHeight() + 1).withTreeIndex(hashTreeAddress.getTreeIndex()).withKeyAndMask(hashTreeAddress.getKeyAndMask())).build();
            }
            if (this.tailNode == null) {
                this.tailNode = node;
            } else if (this.tailNode.getHeight() == node.getHeight()) {
                hashTreeAddress = (HashTreeAddress)((HashTreeAddress.Builder)((HashTreeAddress.Builder)((HashTreeAddress.Builder)new HashTreeAddress.Builder().withLayerAddress(hashTreeAddress.getLayerAddress())).withTreeAddress(hashTreeAddress.getTreeAddress())).withTreeHeight(hashTreeAddress.getTreeHeight()).withTreeIndex((hashTreeAddress.getTreeIndex() - 1) / 2).withKeyAndMask(hashTreeAddress.getKeyAndMask())).build();
                node = BDS.this.xmss.randomizeHash(this.tailNode, node, hashTreeAddress);
                this.tailNode = node = new XMSSNode(this.tailNode.getHeight() + 1, node.getValue());
                hashTreeAddress = (HashTreeAddress)((HashTreeAddress.Builder)((HashTreeAddress.Builder)((HashTreeAddress.Builder)new HashTreeAddress.Builder().withLayerAddress(hashTreeAddress.getLayerAddress())).withTreeAddress(hashTreeAddress.getTreeAddress())).withTreeHeight(hashTreeAddress.getTreeHeight() + 1).withTreeIndex(hashTreeAddress.getTreeIndex()).withKeyAndMask(hashTreeAddress.getKeyAndMask())).build();
            } else {
                BDS.this.stack.push(node);
            }
            if (this.tailNode.getHeight() == this.initialHeight) {
                this.finished = true;
            } else {
                this.height = node.getHeight();
                ++this.nextIndex;
            }
        }

        private int getHeight() {
            if (!this.initialized || this.finished) {
                return Integer.MAX_VALUE;
            }
            return this.height;
        }

        private int getIndexLeaf() {
            return this.nextIndex;
        }

        private void setNode(XMSSNode node) {
            this.tailNode = node;
            this.height = node.getHeight();
            if (this.height == this.initialHeight) {
                this.finished = true;
            }
        }

        private boolean isFinished() {
            return this.finished;
        }

        private boolean isInitialized() {
            return this.initialized;
        }
    }
}

