/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.math.ec.custom.sec;

import java.math.BigInteger;
import java.util.Random;
import org.bouncycastle.math.ec.ECConstants;
import org.bouncycastle.math.ec.ECCurve;
import org.bouncycastle.math.ec.ECFieldElement;
import org.bouncycastle.math.ec.ECPoint;
import org.bouncycastle.math.ec.custom.sec.SecT113FieldElement;
import org.bouncycastle.math.ec.custom.sec.SecT113R1Point;
import org.bouncycastle.util.encoders.Hex;

public class SecT113R1Curve
extends ECCurve.AbstractF2m {
    private static final int SecT113R1_DEFAULT_COORDS = 6;
    protected SecT113R1Point infinity = new SecT113R1Point(this, null, null);

    public SecT113R1Curve() {
        super(113, 9, 0, 0);
        this.a = this.fromBigInteger(new BigInteger(1, Hex.decode("003088250CA6E7C7FE649CE85820F7")));
        this.b = this.fromBigInteger(new BigInteger(1, Hex.decode("00E8BEE4D3E2260744188BE0E9C723")));
        this.order = new BigInteger(1, Hex.decode("0100000000000000D9CCEC8A39E56F"));
        this.cofactor = BigInteger.valueOf(2L);
        this.coord = 6;
    }

    protected ECCurve cloneCurve() {
        return new SecT113R1Curve();
    }

    public boolean supportsCoordinateSystem(int coord) {
        switch (coord) {
            case 6: {
                return true;
            }
        }
        return false;
    }

    public int getFieldSize() {
        return 113;
    }

    public ECFieldElement fromBigInteger(BigInteger x) {
        return new SecT113FieldElement(x);
    }

    protected ECPoint createRawPoint(ECFieldElement x, ECFieldElement y, boolean withCompression) {
        return new SecT113R1Point((ECCurve)this, x, y, withCompression);
    }

    protected ECPoint createRawPoint(ECFieldElement x, ECFieldElement y, ECFieldElement[] zs, boolean withCompression) {
        return new SecT113R1Point(this, x, y, zs, withCompression);
    }

    public ECPoint getInfinity() {
        return this.infinity;
    }

    public boolean isKoblitz() {
        return false;
    }

    protected ECPoint decompressPoint(int yTilde, BigInteger X1) {
        ECFieldElement x = this.fromBigInteger(X1);
        ECFieldElement y = null;
        if (x.isZero()) {
            y = this.b.sqrt();
        } else {
            ECFieldElement beta = x.square().invert().multiply(this.b).add(this.a).add(x);
            ECFieldElement z = this.solveQuadraticEquation(beta);
            if (z != null) {
                if (z.testBitZero() != (yTilde == 1)) {
                    z = z.addOne();
                }
                switch (this.getCoordinateSystem()) {
                    case 5: 
                    case 6: {
                        y = z.add(x);
                        break;
                    }
                    default: {
                        y = z.multiply(x);
                    }
                }
            }
        }
        if (y == null) {
            throw new IllegalArgumentException("Invalid point compression");
        }
        return this.createRawPoint(x, y, true);
    }

    private ECFieldElement solveQuadraticEquation(ECFieldElement beta) {
        if (beta.isZero()) {
            return beta;
        }
        ECFieldElement zeroElement = this.fromBigInteger(ECConstants.ZERO);
        ECFieldElement z = null;
        ECFieldElement gamma = null;
        Random rand = new Random();
        do {
            ECFieldElement t = this.fromBigInteger(new BigInteger(113, rand));
            z = zeroElement;
            ECFieldElement w = beta;
            for (int i = 1; i < 113; ++i) {
                ECFieldElement w2 = w.square();
                z = z.square().add(w2.multiply(t));
                w = w2.add(beta);
            }
            if (w.isZero()) continue;
            return null;
        } while ((gamma = z.square().add(z)).isZero());
        return z;
    }

    public int getM() {
        return 113;
    }

    public boolean isTrinomial() {
        return true;
    }

    public int getK1() {
        return 9;
    }

    public int getK2() {
        return 0;
    }

    public int getK3() {
        return 0;
    }
}

