/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.crypto.hqc;

import java.security.SecureRandom;
import org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import org.bouncycastle.crypto.AsymmetricCipherKeyPairGenerator;
import org.bouncycastle.crypto.KeyGenerationParameters;
import org.bouncycastle.pqc.crypto.hqc.HQCEngine;
import org.bouncycastle.pqc.crypto.hqc.HQCKeyGenerationParameters;
import org.bouncycastle.pqc.crypto.hqc.HQCPrivateKeyParameters;
import org.bouncycastle.pqc.crypto.hqc.HQCPublicKeyParameters;

public class HQCKeyPairGenerator
implements AsymmetricCipherKeyPairGenerator {
    private HQCKeyGenerationParameters hqcKeyGenerationParameters;
    private SecureRandom random;

    public void init(KeyGenerationParameters params) {
        this.hqcKeyGenerationParameters = (HQCKeyGenerationParameters)params;
        this.random = params.getRandom();
    }

    private AsymmetricCipherKeyPair genKeyPair() {
        HQCEngine engine = this.hqcKeyGenerationParameters.getParameters().getEngine();
        byte[] pk = new byte[this.hqcKeyGenerationParameters.getParameters().getPublicKeyBytes()];
        byte[] sk = new byte[this.hqcKeyGenerationParameters.getParameters().getSecretKeyBytes()];
        engine.genKeyPair(pk, sk, this.random);
        HQCPublicKeyParameters publicKey = new HQCPublicKeyParameters(this.hqcKeyGenerationParameters.getParameters(), pk);
        HQCPrivateKeyParameters privateKey = new HQCPrivateKeyParameters(this.hqcKeyGenerationParameters.getParameters(), sk);
        return new AsymmetricCipherKeyPair(publicKey, privateKey);
    }

    public AsymmetricCipherKeyPair generateKeyPair() {
        return this.genKeyPair();
    }
}

