/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jcajce.provider.asymmetric.util;

import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.PrivateKey;
import java.security.ProviderException;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.SignatureException;
import java.security.SignatureSpi;
import java.security.spec.AlgorithmParameterSpec;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.crypto.params.ParametersWithContext;
import org.bouncycastle.crypto.params.ParametersWithRandom;
import org.bouncycastle.jcajce.spec.ContextParameterSpec;
import org.bouncycastle.jcajce.util.BCJcaJceHelper;
import org.bouncycastle.jcajce.util.JcaJceHelper;
import org.bouncycastle.jcajce.util.SpecUtil;
import org.bouncycastle.util.Exceptions;

public abstract class BaseDeterministicOrRandomSignature
extends SignatureSpi {
    private final JcaJceHelper helper = new BCJcaJceHelper();
    private final AlgorithmParameterSpec originalSpec = ContextParameterSpec.EMPTY_CONTEXT_SPEC;
    protected AlgorithmParameters engineParams;
    protected ContextParameterSpec paramSpec;
    protected AsymmetricKeyParameter keyParams;
    protected boolean isInitState = true;

    protected BaseDeterministicOrRandomSignature(String name) {
    }

    protected final void engineInitVerify(PublicKey publicKey) throws InvalidKeyException {
        this.verifyInit(publicKey);
        this.paramSpec = ContextParameterSpec.EMPTY_CONTEXT_SPEC;
        this.isInitState = true;
        this.reInit();
    }

    protected abstract void verifyInit(PublicKey var1) throws InvalidKeyException;

    protected final void engineInitSign(PrivateKey privateKey) throws InvalidKeyException {
        this.signInit(privateKey, null);
        this.paramSpec = ContextParameterSpec.EMPTY_CONTEXT_SPEC;
        this.isInitState = true;
        this.reInit();
    }

    protected final void engineInitSign(PrivateKey privateKey, SecureRandom random) throws InvalidKeyException {
        this.signInit(privateKey, random);
        this.paramSpec = ContextParameterSpec.EMPTY_CONTEXT_SPEC;
        this.isInitState = true;
        this.reInit();
    }

    protected abstract void signInit(PrivateKey var1, SecureRandom var2) throws InvalidKeyException;

    protected final void engineUpdate(byte b) throws SignatureException {
        this.isInitState = false;
        this.updateEngine(b);
    }

    protected abstract void updateEngine(byte var1) throws SignatureException;

    protected final void engineUpdate(byte[] b, int off, int len) throws SignatureException {
        this.isInitState = false;
        this.updateEngine(b, off, len);
    }

    protected abstract void updateEngine(byte[] var1, int var2, int var3) throws SignatureException;

    protected void engineSetParameter(AlgorithmParameterSpec params) throws InvalidAlgorithmParameterException {
        if (params == null) {
            if (this.originalSpec != null) {
                params = this.originalSpec;
            } else {
                return;
            }
        }
        if (!this.isInitState) {
            throw new ProviderException("cannot call setParameter in the middle of update");
        }
        if (params instanceof ContextParameterSpec) {
            this.paramSpec = (ContextParameterSpec)params;
            this.reInit();
        } else {
            byte[] context = SpecUtil.getContextFrom(params);
            if (context != null) {
                this.paramSpec = new ContextParameterSpec(context);
                this.reInit();
            } else {
                throw new InvalidAlgorithmParameterException("unknown AlgorithmParameterSpec in signature");
            }
        }
    }

    private void reInit() {
        CipherParameters param = this.keyParams;
        if (this.keyParams.isPrivate()) {
            if (this.appRandom != null) {
                param = new ParametersWithRandom(param, this.appRandom);
            }
            if (this.paramSpec != null) {
                param = new ParametersWithContext(param, this.paramSpec.getContext());
            }
            this.reInitialize(true, param);
        } else {
            if (this.paramSpec != null) {
                param = new ParametersWithContext(param, this.paramSpec.getContext());
            }
            this.reInitialize(false, param);
        }
    }

    protected abstract void reInitialize(boolean var1, CipherParameters var2);

    protected final AlgorithmParameters engineGetParameters() {
        if (this.engineParams == null && this.paramSpec != null && this.paramSpec != ContextParameterSpec.EMPTY_CONTEXT_SPEC) {
            try {
                this.engineParams = this.helper.createAlgorithmParameters("CONTEXT");
                this.engineParams.init(this.paramSpec);
            }
            catch (Exception e) {
                throw Exceptions.illegalStateException(e.toString(), e);
            }
        }
        return this.engineParams;
    }

    protected final void engineSetParameter(String param, Object value) {
        throw new UnsupportedOperationException("SetParameter unsupported");
    }

    protected final Object engineGetParameter(String param) {
        throw new UnsupportedOperationException("GetParameter unsupported");
    }
}

