/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.params;

import java.math.BigInteger;
import java.security.SecureRandom;
import org.bouncycastle.asn1.x9.X9ECParameters;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.KeyGenerationParameters;
import org.bouncycastle.math.ec.ECPoint;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.BigIntegers;

public class ECCSIKeyGenerationParameters
extends KeyGenerationParameters {
    private final BigInteger q;
    private final ECPoint G;
    private final Digest digest;
    private final byte[] id;
    private final BigInteger ksak;
    private final ECPoint kpak;
    private final int n;

    public ECCSIKeyGenerationParameters(SecureRandom random, X9ECParameters params, Digest digest, byte[] id) {
        super(random, params.getCurve().getA().bitLength());
        this.q = params.getCurve().getOrder();
        this.G = params.getG();
        this.digest = digest;
        this.id = Arrays.clone(id);
        this.n = params.getCurve().getA().bitLength();
        this.ksak = BigIntegers.createRandomBigInteger(this.n, random).mod(this.q);
        this.kpak = this.G.multiply(this.ksak).normalize();
    }

    public byte[] getId() {
        return Arrays.clone(this.id);
    }

    public ECPoint getKPAK() {
        return this.kpak;
    }

    public BigInteger computeSSK(BigInteger hs_v) {
        return this.ksak.add(hs_v).mod(this.q);
    }

    public BigInteger getQ() {
        return this.q;
    }

    public ECPoint getG() {
        return this.G;
    }

    public Digest getDigest() {
        return this.digest;
    }

    public int getN() {
        return this.n;
    }
}

