/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.digests;

import org.bouncycastle.crypto.CryptoServicePurpose;
import org.bouncycastle.crypto.SavableDigest;
import org.bouncycastle.crypto.digests.KeccakDigest;
import org.bouncycastle.util.Memoable;

public class SHA3Digest
extends KeccakDigest
implements SavableDigest {
    private static int checkBitLength(int bitLength) {
        switch (bitLength) {
            case 224: 
            case 256: 
            case 384: 
            case 512: {
                return bitLength;
            }
        }
        throw new IllegalArgumentException("'bitLength' " + bitLength + " not supported for SHA-3");
    }

    public SHA3Digest() {
        this(256, CryptoServicePurpose.ANY);
    }

    public SHA3Digest(CryptoServicePurpose purpose) {
        this(256, purpose);
    }

    public SHA3Digest(int bitLength) {
        super(SHA3Digest.checkBitLength(bitLength), CryptoServicePurpose.ANY);
    }

    public SHA3Digest(int bitLength, CryptoServicePurpose purpose) {
        super(SHA3Digest.checkBitLength(bitLength), purpose);
    }

    public SHA3Digest(byte[] encodedState) {
        super(encodedState);
    }

    public SHA3Digest(SHA3Digest source) {
        super(source);
    }

    public String getAlgorithmName() {
        return "SHA3-" + this.fixedOutputLength;
    }

    public int doFinal(byte[] out, int outOff) {
        this.absorbBits(2, 2);
        return super.doFinal(out, outOff);
    }

    protected int doFinal(byte[] out, int outOff, byte partialByte, int partialBits) {
        if (partialBits < 0 || partialBits > 7) {
            throw new IllegalArgumentException("'partialBits' must be in the range [0,7]");
        }
        int finalInput = partialByte & (1 << partialBits) - 1 | 2 << partialBits;
        int finalBits = partialBits + 2;
        if (finalBits >= 8) {
            this.absorb((byte)finalInput);
            finalBits -= 8;
            finalInput >>>= 8;
        }
        return super.doFinal(out, outOff, (byte)finalInput, finalBits);
    }

    public byte[] getEncodedState() {
        byte[] encState = new byte[this.state.length * 8 + this.dataQueue.length + 12 + 2];
        super.getEncodedState(encState);
        return encState;
    }

    public Memoable copy() {
        return new SHA3Digest(this);
    }

    public void reset(Memoable other) {
        SHA3Digest d = (SHA3Digest)other;
        this.copyIn(d);
    }
}

