/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto;

import org.bouncycastle.crypto.CharToByteConverter;
import org.bouncycastle.crypto.PBEParametersGenerator;

public final class PasswordConverter {
    public static final CharToByteConverter ASCII = new CharToByteConverter(){

        public String getType() {
            return "ASCII";
        }

        public byte[] convert(char[] password) {
            return PBEParametersGenerator.PKCS5PasswordToBytes(password);
        }
    };
    public static final CharToByteConverter UTF8 = new CharToByteConverter(){

        public String getType() {
            return "UTF8";
        }

        public byte[] convert(char[] password) {
            return PBEParametersGenerator.PKCS5PasswordToUTF8Bytes(password);
        }
    };
    public static final CharToByteConverter PKCS12 = new CharToByteConverter(){

        public String getType() {
            return "PKCS12";
        }

        public byte[] convert(char[] password) {
            return PBEParametersGenerator.PKCS12PasswordToBytes(password);
        }
    };
}

