/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.crypto.snova;

import java.security.SecureRandom;
import org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import org.bouncycastle.crypto.AsymmetricCipherKeyPairGenerator;
import org.bouncycastle.crypto.KeyGenerationParameters;
import org.bouncycastle.pqc.crypto.snova.GF16Utils;
import org.bouncycastle.pqc.crypto.snova.SnovaEngine;
import org.bouncycastle.pqc.crypto.snova.SnovaKeyElements;
import org.bouncycastle.pqc.crypto.snova.SnovaKeyGenerationParameters;
import org.bouncycastle.pqc.crypto.snova.SnovaParameters;
import org.bouncycastle.pqc.crypto.snova.SnovaPrivateKeyParameters;
import org.bouncycastle.pqc.crypto.snova.SnovaPublicKeyParameters;
import org.bouncycastle.util.Arrays;

public class SnovaKeyPairGenerator
implements AsymmetricCipherKeyPairGenerator {
    private SnovaEngine engine;
    private static final int seedLength = 48;
    static final int publicSeedLength = 16;
    static final int privateSeedLength = 32;
    private SnovaParameters params;
    private SecureRandom random;
    private boolean initialized;

    public void init(KeyGenerationParameters param) {
        SnovaKeyGenerationParameters snovaParams = (SnovaKeyGenerationParameters)param;
        this.params = snovaParams.getParameters();
        this.random = snovaParams.getRandom();
        this.initialized = true;
        this.engine = new SnovaEngine(this.params);
    }

    public AsymmetricCipherKeyPair generateKeyPair() {
        if (!this.initialized) {
            throw new IllegalStateException("SNOVA key pair generator not initialized");
        }
        byte[] seedPair = new byte[48];
        this.random.nextBytes(seedPair);
        byte[] pk = new byte[this.params.getPublicKeyLength()];
        byte[] sk = new byte[this.params.getPrivateKeyLength()];
        byte[] ptPublicKeySeed = Arrays.copyOfRange(seedPair, 0, 16);
        byte[] ptPrivateKeySeed = Arrays.copyOfRange(seedPair, 16, seedPair.length);
        SnovaKeyElements keyElements = new SnovaKeyElements(this.params);
        System.arraycopy(ptPublicKeySeed, 0, pk, 0, ptPublicKeySeed.length);
        this.engine.genMap1T12Map2(keyElements, ptPublicKeySeed, ptPrivateKeySeed);
        this.engine.genP22(pk, ptPublicKeySeed.length, keyElements.T12, keyElements.map1.p21, keyElements.map2.f12);
        System.arraycopy(ptPublicKeySeed, 0, pk, 0, ptPublicKeySeed.length);
        if (this.params.isSkIsSeed()) {
            sk = seedPair;
        } else {
            int o = this.params.getO();
            int lsq = this.params.getLsq();
            int v = this.params.getV();
            int length = o * this.params.getAlpha() * lsq * 4 + v * o * lsq + (o * v * v + o * v * o + o * o * v) * lsq;
            byte[] input = new byte[length];
            int inOff = 0;
            inOff = SnovaKeyElements.copy3d(keyElements.map1.aAlpha, input, inOff);
            inOff = SnovaKeyElements.copy3d(keyElements.map1.bAlpha, input, inOff);
            inOff = SnovaKeyElements.copy3d(keyElements.map1.qAlpha1, input, inOff);
            inOff = SnovaKeyElements.copy3d(keyElements.map1.qAlpha2, input, inOff);
            inOff = SnovaKeyElements.copy3d(keyElements.T12, input, inOff);
            inOff = SnovaKeyElements.copy4d(keyElements.map2.f11, input, inOff);
            inOff = SnovaKeyElements.copy4d(keyElements.map2.f12, input, inOff);
            SnovaKeyElements.copy4d(keyElements.map2.f21, input, inOff);
            GF16Utils.encodeMergeInHalf(input, length, sk);
            System.arraycopy(seedPair, 0, sk, sk.length - 48, 48);
        }
        return new AsymmetricCipherKeyPair(new SnovaPublicKeyParameters(this.params, pk), new SnovaPrivateKeyParameters(this.params, sk));
    }
}

