/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.crypto.snova;

import org.bouncycastle.util.GF16;

class GF16Utils {
    private static final int GF16_MASK = 585;

    GF16Utils() {
    }

    static void encodeMergeInHalf(byte[] m, int mlen, byte[] menc) {
        int half = mlen + 1 >>> 1;
        int i = 0;
        while (i < mlen / 2) {
            menc[i] = (byte)(m[i] | m[half] << 4);
            ++i;
            ++half;
        }
        if ((mlen & 1) == 1) {
            menc[i] = m[i];
        }
    }

    static void decodeMergeInHalf(byte[] byteArray, byte[] gf16Array, int nGf16) {
        int half = nGf16 + 1 >>> 1;
        for (int i = 0; i < half; ++i) {
            gf16Array[i] = (byte)(byteArray[i] & 0xF);
            gf16Array[i + half] = (byte)(byteArray[i] >>> 4 & 0xF);
        }
    }

    static void gf16mTranMulMul(byte[] sign, int signOff, byte[] a, byte[] b, byte[] q1, byte[] q2, byte[] tmp, byte[] left, byte[] right, int rank) {
        int i = 0;
        int leftOff = 0;
        int dOff = 0;
        while (i < rank) {
            int j;
            for (j = 0; j < rank; ++j) {
                byte result = 0;
                int k = 0;
                int aOff = signOff + j;
                int bOff = i;
                while (k < rank) {
                    result = (byte)(result ^ GF16.mul(sign[aOff], q1[bOff]));
                    ++k;
                    aOff += rank;
                    bOff += rank;
                }
                tmp[j] = result;
            }
            j = 0;
            int jxl = 0;
            while (j < rank) {
                byte result = 0;
                for (int k = 0; k < rank; ++k) {
                    result = (byte)(result ^ GF16.mul(a[jxl + k], tmp[k]));
                }
                left[i + jxl] = result;
                ++j;
                jxl += rank;
            }
            for (j = 0; j < rank; ++j) {
                tmp[j] = GF16.innerProduct(q2, leftOff, sign, signOff + j, rank);
            }
            for (j = 0; j < rank; ++j) {
                right[dOff++] = GF16.innerProduct(tmp, 0, b, j, rank);
            }
            ++i;
            leftOff += rank;
        }
    }

    static void gf16mMulMul(byte[] a, byte[] b, byte[] c, byte[] tmp, byte[] d, int rank) {
        int i = 0;
        int leftOff = 0;
        int dOff = 0;
        while (i < rank) {
            int j;
            for (j = 0; j < rank; ++j) {
                tmp[j] = GF16.innerProduct(a, leftOff, b, j, rank);
            }
            for (j = 0; j < rank; ++j) {
                d[dOff++] = GF16.innerProduct(tmp, 0, c, j, rank);
            }
            ++i;
            leftOff += rank;
        }
    }

    static void gf16mMul(byte[] a, byte[] b, byte[] c, int rank) {
        int i = 0;
        int aOff = 0;
        int cOff = 0;
        while (i < rank) {
            for (int j = 0; j < rank; ++j) {
                c[cOff++] = GF16.innerProduct(a, aOff, b, j, rank);
            }
            ++i;
            aOff += rank;
        }
    }

    static void gf16mMulMulTo(byte[] a, byte[] b, byte[] c, byte[] tmp, byte[] d, int rank) {
        int i = 0;
        int leftOff = 0;
        int dOff = 0;
        while (i < rank) {
            int j;
            for (j = 0; j < rank; ++j) {
                tmp[j] = GF16.innerProduct(a, leftOff, b, j, rank);
            }
            for (j = 0; j < rank; ++j) {
                int n = dOff++;
                d[n] = (byte)(d[n] ^ GF16.innerProduct(tmp, 0, c, j, rank));
            }
            ++i;
            leftOff += rank;
        }
    }

    static void gf16mMulTo(byte[] a, byte[] b, byte[] c, int rank) {
        int i = 0;
        int aOff = 0;
        int cOff = 0;
        while (i < rank) {
            for (int j = 0; j < rank; ++j) {
                int n = cOff++;
                c[n] = (byte)(c[n] ^ GF16.innerProduct(a, aOff, b, j, rank));
            }
            ++i;
            aOff += rank;
        }
    }

    static void gf16mMulToTo(byte[] a, byte[] b, byte[] c, byte[] d, byte[] e, int rank) {
        int i = 0;
        int leftOff = 0;
        int outOff = 0;
        while (i < rank) {
            for (int j = 0; j < rank; ++j) {
                int n = outOff;
                d[n] = (byte)(d[n] ^ GF16.innerProduct(a, leftOff, b, j, rank));
                int n2 = outOff++;
                e[n2] = (byte)(e[n2] ^ GF16.innerProduct(b, leftOff, c, j, rank));
            }
            ++i;
            leftOff += rank;
        }
    }

    static void gf16mMulTo(byte[] a, byte[] b, byte[] c, int cOff, int rank) {
        int i = 0;
        int aOff = 0;
        while (i < rank) {
            for (int j = 0; j < rank; ++j) {
                int n = cOff++;
                c[n] = (byte)(c[n] ^ GF16.innerProduct(a, aOff, b, j, rank));
            }
            ++i;
            aOff += rank;
        }
    }

    static void gf16mMulTo(byte[] a, byte[] b, byte[] c, byte[] d, byte[] e, int eOff, int rank) {
        int i = 0;
        int leftOff = 0;
        while (i < rank) {
            for (int j = 0; j < rank; ++j) {
                int n = eOff++;
                e[n] = (byte)(e[n] ^ (GF16.innerProduct(a, leftOff, b, j, rank) ^ GF16.innerProduct(c, leftOff, d, j, rank)));
            }
            ++i;
            leftOff += rank;
        }
    }

    static void gf16mMulTo(byte[] a, byte[] b, int bOff, byte[] c, int cOff, int rank) {
        int i = 0;
        int aOff = 0;
        while (i < rank) {
            for (int j = 0; j < rank; ++j) {
                int n = cOff++;
                c[n] = (byte)(c[n] ^ GF16.innerProduct(a, aOff, b, bOff + j, rank));
            }
            ++i;
            aOff += rank;
        }
    }

    static int gf16FromNibble(int idx) {
        int middle = idx | idx << 4;
        return middle & 0x41 | middle << 2 & 0x208;
    }

    static int ctGF16IsNotZero(byte val) {
        int v = val & 0xFF;
        return (v | v >>> 1 | v >>> 2 | v >>> 3) & 1;
    }

    private static int gf16Reduce(int idx) {
        int res = idx & 0x49249249;
        int upper = idx >>> 12;
        res ^= upper ^ upper << 3;
        upper = res >>> 12;
        res ^= upper ^ upper << 3;
        upper = res >>> 12;
        return (res ^= upper ^ upper << 3) & 0x249;
    }

    static byte gf16ToNibble(int val) {
        int res = GF16Utils.gf16Reduce(val);
        res |= res >>> 4;
        return (byte)(res & 5 | res >>> 2 & 0xA);
    }
}

