/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.crypto.mldsa;

import java.security.SecureRandom;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.CryptoException;
import org.bouncycastle.crypto.DataLengthException;
import org.bouncycastle.crypto.Signer;
import org.bouncycastle.crypto.digests.SHAKEDigest;
import org.bouncycastle.crypto.params.ParametersWithContext;
import org.bouncycastle.crypto.params.ParametersWithRandom;
import org.bouncycastle.pqc.crypto.mldsa.MLDSAEngine;
import org.bouncycastle.pqc.crypto.mldsa.MLDSAParameters;
import org.bouncycastle.pqc.crypto.mldsa.MLDSAPrivateKeyParameters;
import org.bouncycastle.pqc.crypto.mldsa.MLDSAPublicKeyParameters;

public class MLDSASigner
implements Signer {
    private static final byte[] EMPTY_CONTEXT = new byte[0];
    private MLDSAPublicKeyParameters pubKey;
    private MLDSAPrivateKeyParameters privKey;
    private SecureRandom random;
    private MLDSAEngine engine;
    private SHAKEDigest msgDigest;

    public void init(boolean forSigning, CipherParameters param) {
        MLDSAParameters parameters;
        byte[] ctx = EMPTY_CONTEXT;
        if (param instanceof ParametersWithContext) {
            ParametersWithContext withContext = (ParametersWithContext)param;
            ctx = withContext.getContext();
            param = withContext.getParameters();
            if (ctx.length > 255) {
                throw new IllegalArgumentException("context too long");
            }
        }
        if (forSigning) {
            this.pubKey = null;
            if (param instanceof ParametersWithRandom) {
                ParametersWithRandom withRandom = (ParametersWithRandom)param;
                this.privKey = (MLDSAPrivateKeyParameters)withRandom.getParameters();
                this.random = withRandom.getRandom();
            } else {
                this.privKey = (MLDSAPrivateKeyParameters)param;
                this.random = null;
            }
            parameters = this.privKey.getParameters();
            this.engine = parameters.getEngine(this.random);
            this.engine.initSign(this.privKey.tr, false, ctx);
        } else {
            this.pubKey = (MLDSAPublicKeyParameters)param;
            this.privKey = null;
            this.random = null;
            parameters = this.pubKey.getParameters();
            this.engine = parameters.getEngine(null);
            this.engine.initVerify(this.pubKey.rho, this.pubKey.t1, false, ctx);
        }
        if (parameters.isPreHash()) {
            throw new IllegalArgumentException("\"pure\" ml-dsa must use non pre-hash parameters");
        }
        this.reset();
    }

    public void update(byte b) {
        this.msgDigest.update(b);
    }

    public void update(byte[] in, int off, int len) {
        this.msgDigest.update(in, off, len);
    }

    public byte[] generateMu() throws CryptoException, DataLengthException {
        byte[] mu = this.engine.generateMu(this.msgDigest);
        this.reset();
        return mu;
    }

    public byte[] generateMuSignature(byte[] mu) throws CryptoException, DataLengthException {
        if (mu.length != 64) {
            throw new DataLengthException("mu value must be 64 bytes");
        }
        byte[] rnd = new byte[32];
        if (this.random != null) {
            this.random.nextBytes(rnd);
        }
        this.msgDigest.reset();
        byte[] sig = this.engine.generateSignature(mu, this.msgDigest, this.privKey.rho, this.privKey.k, this.privKey.t0, this.privKey.s1, this.privKey.s2, rnd);
        this.reset();
        return sig;
    }

    public byte[] generateSignature() throws CryptoException, DataLengthException {
        byte[] rnd = new byte[32];
        if (this.random != null) {
            this.random.nextBytes(rnd);
        }
        byte[] mu = this.engine.generateMu(this.msgDigest);
        byte[] sig = this.engine.generateSignature(mu, this.msgDigest, this.privKey.rho, this.privKey.k, this.privKey.t0, this.privKey.s1, this.privKey.s2, rnd);
        this.reset();
        return sig;
    }

    public boolean verifyMu(byte[] mu) {
        if (mu.length != 64) {
            throw new DataLengthException("mu value must be 64 bytes");
        }
        boolean isTrue = this.engine.verifyInternalMu(mu);
        this.reset();
        return isTrue;
    }

    public boolean verifySignature(byte[] signature) {
        boolean isTrue = this.engine.verifyInternal(signature, signature.length, this.msgDigest, this.pubKey.rho, this.pubKey.t1);
        this.reset();
        return isTrue;
    }

    public boolean verifyMuSignature(byte[] mu, byte[] signature) {
        if (mu.length != 64) {
            throw new DataLengthException("mu value must be 64 bytes");
        }
        this.msgDigest.reset();
        boolean isTrue = this.engine.verifyInternalMuSignature(mu, signature, signature.length, this.msgDigest, this.pubKey.rho, this.pubKey.t1);
        this.reset();
        return isTrue;
    }

    public void reset() {
        this.msgDigest = this.engine.getShake256Digest();
    }

    protected byte[] internalGenerateSignature(byte[] message, byte[] random) {
        MLDSAEngine engine = this.privKey.getParameters().getEngine(this.random);
        engine.initSign(this.privKey.tr, false, null);
        return engine.signInternal(message, message.length, this.privKey.rho, this.privKey.k, this.privKey.t0, this.privKey.s1, this.privKey.s2, random);
    }

    protected boolean internalVerifySignature(byte[] message, byte[] signature) {
        MLDSAEngine engine = this.pubKey.getParameters().getEngine(this.random);
        engine.initVerify(this.pubKey.rho, this.pubKey.t1, false, null);
        SHAKEDigest msgDigest = engine.getShake256Digest();
        msgDigest.update(message, 0, message.length);
        return engine.verifyInternal(signature, signature.length, msgDigest, this.pubKey.rho, this.pubKey.t1);
    }
}

