/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.util;

import org.bouncycastle.math.raw.Bits;

public class Integers {
    public static final int BYTES = 4;
    public static final int SIZE = 32;
    private static final byte[] DEBRUIJN_TZ = new byte[]{31, 0, 27, 1, 28, 13, 23, 2, 29, 21, 19, 14, 24, 16, 3, 7, 30, 26, 12, 22, 20, 18, 15, 6, 25, 11, 17, 5, 10, 4, 9, 8};

    public static int bitCount(int i) {
        i -= i >>> 1 & 0x55555555;
        i = (i & 0x33333333) + (i >>> 2 & 0x33333333);
        i = i + (i >>> 4) & 0xF0F0F0F;
        i += i >>> 8;
        i += i >>> 16;
        return i &= 0x3F;
    }

    public static int highestOneBit(int i) {
        i |= i >> 1;
        i |= i >> 2;
        i |= i >> 4;
        i |= i >> 8;
        i |= i >> 16;
        return i - (i >>> 1);
    }

    public static int lowestOneBit(int i) {
        return i & -i;
    }

    public static int numberOfLeadingZeros(int i) {
        if (i <= 0) {
            return ~i >>> 26 & 0x20;
        }
        int n = 1;
        if (0 == i >>> 16) {
            n += 16;
            i <<= 16;
        }
        if (0 == i >>> 24) {
            n += 8;
            i <<= 8;
        }
        if (0 == i >>> 28) {
            n += 4;
            i <<= 4;
        }
        if (0 == i >>> 30) {
            n += 2;
            i <<= 2;
        }
        return n -= i >>> 31;
    }

    public static int numberOfTrailingZeros(int i) {
        byte n = DEBRUIJN_TZ[(i & -i) * 251226722 >>> 27];
        int m = (i & 0xFFFF | i >>> 16) - 1 >> 31;
        return n - m;
    }

    public static int reverse(int i) {
        i = Bits.bitPermuteStepSimple(i, 0x55555555, 1);
        i = Bits.bitPermuteStepSimple(i, 0x33333333, 2);
        i = Bits.bitPermuteStepSimple(i, 0xF0F0F0F, 4);
        return Integers.reverseBytes(i);
    }

    public static int reverseBytes(int i) {
        return Integers.rotateLeft(i & 0xFF00FF00, 8) | Integers.rotateLeft(i & 0xFF00FF, 24);
    }

    public static int rotateLeft(int i, int distance) {
        return i << distance | i >>> -distance;
    }

    public static int rotateRight(int i, int distance) {
        return i >>> distance | i << -distance;
    }

    public static Integer valueOf(int value) {
        return new Integer(value);
    }
}

