/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.crypto.falcon;

import org.bouncycastle.pqc.crypto.falcon.SHAKE256;

class FalconCommon {
    static final int[] l2bound = new int[]{0, 101498, 208714, 428865, 892039, 1852696, 3842630, 7959734, 16468416, 34034726, 70265242};

    FalconCommon() {
    }

    void hash_to_point_vartime(SHAKE256 sc, short[] srcx, int x, int logn) {
        int n = 1 << logn;
        while (n > 0) {
            byte[] buf = new byte[2];
            sc.inner_shake256_extract(buf, 0, 2);
            int w = (buf[0] & 0xFF) << 8 | buf[1] & 0xFF;
            if (w >= 61445) continue;
            while (w >= 12289) {
                w -= 12289;
            }
            srcx[x++] = (short)w;
            --n;
        }
    }

    void hash_to_point_ct(SHAKE256 sc, short[] srcx, int x, int logn, short[] srctmp, int tmp) {
        int u;
        short[] overtab = new short[]{0, 65, 67, 71, 77, 86, 100, 122, 154, 205, 287};
        short[] tt2 = new short[63];
        int n = 1 << logn;
        int n2 = n << 1;
        int over = overtab[logn];
        int m = n + over;
        int tt1 = tmp;
        for (u = 0; u < m; ++u) {
            byte[] buf = new byte[2];
            sc.inner_shake256_extract(buf, 0, buf.length);
            int w = (buf[0] & 0xFF) << 8 | buf[1] & 0xFF;
            int wr = w - (0x6002 & (w - 24578 >>> 31) - 1);
            wr -= 0x6002 & (wr - 24578 >>> 31) - 1;
            wr -= 0x3001 & (wr - 12289 >>> 31) - 1;
            wr |= (w - 61445 >>> 31) - 1;
            if (u < n) {
                srcx[x + u] = (short)wr;
                continue;
            }
            if (u < n2) {
                srctmp[tt1 + u - n] = (short)wr;
                continue;
            }
            tt2[u - n2] = (short)wr;
        }
        for (int p = 1; p <= over; p <<= 1) {
            int v = 0;
            for (u = 0; u < m; ++u) {
                short dv;
                int d;
                int dp;
                short sv;
                int s;
                int sp;
                if (u < n) {
                    sp = 1;
                    s = x + u;
                    sv = srcx[s];
                } else if (u < n2) {
                    sp = 2;
                    s = tt1 + u - n;
                    sv = srctmp[s];
                } else {
                    sp = 3;
                    s = u - n2;
                    sv = tt2[s];
                }
                int j = u - v;
                int mk = (sv >>> 15) - 1;
                v -= mk;
                if (u < p) continue;
                if (u - p < n) {
                    dp = 1;
                    d = x + u - p;
                    dv = srcx[d];
                } else if (u - p < n2) {
                    dp = 2;
                    d = tt1 + (u - p) - n;
                    dv = srctmp[d];
                } else {
                    dp = 3;
                    d = u - p - n2;
                    dv = tt2[d];
                }
                mk &= -((j & p) + 511 >> 9);
                if (sp == 1) {
                    srcx[s] = (short)(sv ^ mk & (sv ^ dv));
                } else if (sp == 2) {
                    srctmp[s] = (short)(sv ^ mk & (sv ^ dv));
                } else {
                    tt2[s] = (short)(sv ^ mk & (sv ^ dv));
                }
                if (dp == 1) {
                    srcx[d] = (short)(dv ^ mk & (sv ^ dv));
                    continue;
                }
                if (dp == 2) {
                    srctmp[d] = (short)(dv ^ mk & (sv ^ dv));
                    continue;
                }
                tt2[d] = (short)(dv ^ mk & (sv ^ dv));
            }
        }
    }

    int is_short(short[] srcs1, int s1, short[] srcs2, int s2, int logn) {
        int n = 1 << logn;
        int s = 0;
        int ng = 0;
        for (int u = 0; u < n; ++u) {
            short z = srcs1[s1 + u];
            ng |= (s += z * z);
            z = srcs2[s2 + u];
            ng |= (s += z * z);
        }
        return ((long)(s |= -(ng >>> 31)) & 0xFFFFFFFFL) <= (long)l2bound[logn] ? 1 : 0;
    }

    int is_short_half(int sqn, short[] srcs2, int s2, int logn) {
        int n = 1 << logn;
        int ng = -(sqn >>> 31);
        for (int u = 0; u < n; ++u) {
            short z = srcs2[s2 + u];
            ng |= (sqn += z * z);
        }
        return ((long)(sqn |= -(ng >>> 31)) & 0xFFFFFFFFL) <= (long)l2bound[logn] ? 1 : 0;
    }
}

