/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.digests;

import org.bouncycastle.crypto.digests.AsconBaseDigest;
import org.bouncycastle.util.Pack;

public class AsconHash256
extends AsconBaseDigest {
    public AsconHash256() {
        this.reset();
    }

    protected long pad(int i) {
        return 1L << (i << 3);
    }

    protected long loadBytes(byte[] bytes, int inOff) {
        return Pack.littleEndianToLong(bytes, inOff);
    }

    protected long loadBytes(byte[] bytes, int inOff, int n) {
        return Pack.littleEndianToLong(bytes, inOff, n);
    }

    protected void setBytes(long w, byte[] bytes, int inOff) {
        Pack.longToLittleEndian(w, bytes, inOff);
    }

    protected void setBytes(long w, byte[] bytes, int inOff, int n) {
        Pack.longToLittleEndian(w, bytes, inOff, n);
    }

    public String getAlgorithmName() {
        return "Ascon-Hash256";
    }

    public void reset() {
        super.reset();
        this.x0 = -7269279749984954751L;
        this.x1 = 5459383224871899602L;
        this.x2 = -5880230600644446182L;
        this.x3 = 4359436768738168243L;
        this.x4 = 1899470422303676269L;
    }
}

