/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.jcajce.provider.dilithium;

import java.io.ByteArrayOutputStream;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.SignatureException;
import java.security.spec.AlgorithmParameterSpec;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.crypto.params.ParametersWithRandom;
import org.bouncycastle.pqc.crypto.crystals.dilithium.DilithiumParameters;
import org.bouncycastle.pqc.crypto.crystals.dilithium.DilithiumPrivateKeyParameters;
import org.bouncycastle.pqc.crypto.crystals.dilithium.DilithiumSigner;
import org.bouncycastle.pqc.jcajce.provider.dilithium.BCDilithiumPrivateKey;
import org.bouncycastle.pqc.jcajce.provider.dilithium.BCDilithiumPublicKey;
import org.bouncycastle.util.Strings;

public class SignatureSpi
extends Signature {
    private ByteArrayOutputStream bOut = new ByteArrayOutputStream();
    private DilithiumSigner signer;
    private SecureRandom random;
    private DilithiumParameters parameters;

    protected SignatureSpi(DilithiumSigner signer) {
        super("Dilithium");
        this.signer = signer;
        this.parameters = null;
    }

    protected SignatureSpi(DilithiumSigner signer, DilithiumParameters parameters) {
        super(Strings.toUpperCase(parameters.getName()));
        this.signer = signer;
        this.parameters = parameters;
    }

    protected void engineInitVerify(PublicKey publicKey) throws InvalidKeyException {
        String canonicalAlg;
        if (!(publicKey instanceof BCDilithiumPublicKey)) {
            try {
                publicKey = new BCDilithiumPublicKey(SubjectPublicKeyInfo.getInstance(publicKey.getEncoded()));
            }
            catch (Exception e) {
                throw new InvalidKeyException("unknown public key passed to Dilithium: " + e.getMessage());
            }
        }
        BCDilithiumPublicKey key = (BCDilithiumPublicKey)publicKey;
        if (this.parameters != null && !(canonicalAlg = Strings.toUpperCase(this.parameters.getName())).equals(key.getAlgorithm())) {
            throw new InvalidKeyException("signature configured for " + canonicalAlg);
        }
        this.signer.init(false, key.getKeyParams());
    }

    protected void engineInitSign(PrivateKey privateKey, SecureRandom random) throws InvalidKeyException {
        this.random = random;
        this.engineInitSign(privateKey);
    }

    protected void engineInitSign(PrivateKey privateKey) throws InvalidKeyException {
        if (privateKey instanceof BCDilithiumPrivateKey) {
            String canonicalAlg;
            BCDilithiumPrivateKey key = (BCDilithiumPrivateKey)privateKey;
            DilithiumPrivateKeyParameters param = key.getKeyParams();
            if (this.parameters != null && !(canonicalAlg = Strings.toUpperCase(this.parameters.getName())).equals(key.getAlgorithm())) {
                throw new InvalidKeyException("signature configured for " + canonicalAlg);
            }
            if (this.random != null) {
                this.signer.init(true, new ParametersWithRandom(param, this.random));
            } else {
                this.signer.init(true, param);
            }
        } else {
            throw new InvalidKeyException("unknown private key passed to Dilithium");
        }
    }

    protected void engineUpdate(byte b) throws SignatureException {
        this.bOut.write(b);
    }

    protected void engineUpdate(byte[] b, int off, int len) throws SignatureException {
        this.bOut.write(b, off, len);
    }

    protected byte[] engineSign() throws SignatureException {
        try {
            byte[] message = this.bOut.toByteArray();
            this.bOut.reset();
            return this.signer.generateSignature(message);
        }
        catch (Exception e) {
            throw new SignatureException(e.toString());
        }
    }

    protected boolean engineVerify(byte[] sigBytes) throws SignatureException {
        byte[] message = this.bOut.toByteArray();
        this.bOut.reset();
        return this.signer.verifySignature(message, sigBytes);
    }

    protected void engineSetParameter(AlgorithmParameterSpec params) {
        throw new UnsupportedOperationException("engineSetParameter unsupported");
    }

    protected void engineSetParameter(String param, Object value) {
        throw new UnsupportedOperationException("engineSetParameter unsupported");
    }

    protected Object engineGetParameter(String param) {
        throw new UnsupportedOperationException("engineSetParameter unsupported");
    }

    public static class Base5
    extends SignatureSpi {
        public Base5() throws NoSuchAlgorithmException {
            super(new DilithiumSigner(), DilithiumParameters.dilithium5);
        }
    }

    public static class Base3
    extends SignatureSpi {
        public Base3() {
            super(new DilithiumSigner(), DilithiumParameters.dilithium3);
        }
    }

    public static class Base2
    extends SignatureSpi {
        public Base2() {
            super(new DilithiumSigner(), DilithiumParameters.dilithium2);
        }
    }

    public static class Base
    extends SignatureSpi {
        public Base() {
            super(new DilithiumSigner());
        }
    }
}

